/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.dialogs.ConfigurationAddViewsDialog;
import org.eclipse.epf.authoring.ui.filters.AllFilter;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.CategorizedProcessesItemProvider;
import org.eclipse.epf.library.edit.itemsfilter.ContentCategoriesGroupItemProvider;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.itemsfilter.ProcessesItemProvider;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.ui.PlatformUI;

public class ContributionSelection {
    private HashSet filterElementList = new HashSet();

    public boolean checkProcessPkg(Object obj) {
        List list = new ArrayList();
        if (obj instanceof ProcessPackage) {
            if (this.filterElementList.contains(obj)) {
                return true;
            }
            if (obj instanceof ProcessComponent) {
                if (this.filterElementList.contains(((ProcessComponent)obj).getProcess())) {
                    return true;
                }
                list = ((ProcessComponent)obj).getProcess().getBreakdownElements();
            } else {
                list = ((ProcessPackage)obj).getChildPackages();
            }
        }
        for (Object child : list) {
            if (child instanceof ProcessComponent && this.checkProcessPkg(child)) {
                return true;
            }
            if (!(child instanceof BreakdownElement) || !this.filterElementList.contains(child)) continue;
            return true;
        }
        return false;
    }

    public boolean checkProcessElements(Object obj) {
        List list = ((Process)obj).getBreakdownElements();
        for (Object child : list) {
            if (!(child instanceof BreakdownElement) || !this.filterElementList.contains((BreakdownElement)child)) continue;
            return true;
        }
        return false;
    }

    public boolean anyCategorizedElementAccepted(CustomCategory obj, HashSet list) {
        if (list.contains(obj)) {
            return true;
        }
        List elements = obj.getCategorizedElements();
        for (Object object : elements) {
            if (!(object instanceof CustomCategory)) continue;
            if (list.contains(object)) {
                return true;
            }
            this.anyCategorizedElementAccepted((CustomCategory)object, list);
        }
        return false;
    }

    public Object getSelectedContributor(VariabilityElement element) {
        this.filterElementList = new HashSet();
        MethodConfiguration config = LibraryService.getInstance().getCurrentMethodConfiguration();
        List contributors = ConfigurationHelper.getContributors((VariabilityElement)element, (MethodConfiguration)config);
        if (contributors != null && !contributors.isEmpty()) {
            ArrayList<VariabilityElement> elementList = new ArrayList<VariabilityElement>();
            elementList.add(element);
            elementList.addAll(contributors);
            this.filterElementList.addAll(elementList);
            for (Object e : elementList) {
                List groupings = null;
                if (e instanceof Discipline) {
                    groupings = AssociationHelper.getDisciplineGroups((Discipline)((Discipline)e));
                }
                if (e instanceof RoleSet) {
                    groupings = AssociationHelper.getRoleSetGroups((RoleSet)((RoleSet)e));
                }
                if (groupings == null || groupings.isEmpty()) continue;
                this.filterElementList.addAll(groupings);
            }
            ContributionFilter filter = new ContributionFilter();
            String[] stringArray = new String[]{FilterConstants.CONFIG_CONTENT_ELEMENT};
            ConfigurationAddViewsDialog dlg = new ConfigurationAddViewsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            dlg.setFilter((IFilter)filter);
            dlg.setTitle(FilterConstants.CONFIG_CONTENT_ELEMENT);
            dlg.setViewerSelectionSingle(true);
            dlg.setTypes(stringArray);
            dlg.setInput(UmaUtil.getMethodLibrary((EObject)element));
            dlg.setContentProvider((IStructuredContentProvider)new AdapterFactoryContentProvider(TngAdapterFactory.INSTANCE.getItemsFilter_AdapterFactory((IFilter)filter)), TngAdapterFactory.INSTANCE.getItemsFilter_ComposedAdapterFactory());
            dlg.setBlockOnOpen(true);
            String title = MessageFormat.format(AuthoringUIResources.ContributionSelection_filterdialog_title, element.getName());
            dlg.setTitle(title);
            dlg.setBlockOnOpen(true);
            dlg.open();
            ArrayList result = dlg.getSelectedItems();
            if (result == null || result.isEmpty()) {
                return null;
            }
            return result.get(0);
        }
        return element;
    }

    private class ContributionFilter
    extends AllFilter {
        private ContributionFilter() {
        }

        public boolean accept(Object obj) {
            Object contentElement = this.helper.getContentElement();
            if (contentElement != null && obj.equals(this.helper.getContentElement())) {
                return false;
            }
            if (this.helper.getAlreadySelectedList() != null && (obj instanceof ProcessComponent ? this.helper.getAlreadySelectedList().contains(((ProcessComponent)obj).getProcess()) : this.helper.getAlreadySelectedList().contains(obj))) {
                return false;
            }
            if (obj instanceof CustomCategory && TngUtil.isRootCustomCategory((CustomCategory)((CustomCategory)obj)) && ((CustomCategory)obj).getCategorizedElements().isEmpty()) {
                return false;
            }
            if (!this.helper.matchPattern(obj)) {
                return false;
            }
            if (obj instanceof MethodPlugin && obj instanceof MethodPlugin) {
                if (contentElement != null) {
                    return MethodElementUtil.getAllModels((Object)contentElement).contains(obj);
                }
                return true;
            }
            if (obj instanceof ContentPackage) {
                return true;
            }
            if (obj instanceof ContentCategoriesGroupItemProvider) {
                Collection list = ((ContentCategoriesGroupItemProvider)obj).getChildren(obj);
                return !list.isEmpty();
            }
            if (obj instanceof ProcessesItemProvider) {
                Collection list = ((ProcessesItemProvider)obj).getChildren(obj);
                Iterator ior = list.iterator();
                while (ior.hasNext()) {
                    Object object = ior.next();
                    if (!((CategorizedProcessesItemProvider)object).getChildren(object).isEmpty()) continue;
                    ior.remove();
                }
                return !list.isEmpty();
            }
            return this.childAccept(obj);
        }

        public boolean childAccept(Object obj) {
            if (obj instanceof CustomCategory) {
                return ContributionSelection.this.anyCategorizedElementAccepted((CustomCategory)obj, ContributionSelection.this.filterElementList);
            }
            if (obj instanceof ContentElement && ContributionSelection.this.filterElementList.contains(obj)) {
                return true;
            }
            if (obj instanceof Process && ContributionSelection.this.filterElementList.contains(obj)) {
                return true;
            }
            if (obj instanceof ProcessPackage) {
                return ContributionSelection.this.checkProcessPkg(obj);
            }
            if (obj instanceof Process) {
                return ContributionSelection.this.checkProcessElements(obj);
            }
            return false;
        }
    }
}

