/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.dialogs.BaseItemsFilterDialog;
import org.eclipse.epf.authoring.ui.dialogs.FilterSorter;
import org.eclipse.epf.authoring.ui.dialogs.FilterSorterForAll;
import org.eclipse.epf.authoring.ui.dialogs.PluginListDialog;
import org.eclipse.epf.authoring.ui.filters.AllFilter;
import org.eclipse.epf.authoring.ui.filters.DescriptorConfigurationFilter;
import org.eclipse.epf.authoring.ui.filters.ExProcessAuthoringConfigurator;
import org.eclipse.epf.authoring.ui.properties.AbstractSection;
import org.eclipse.epf.authoring.ui.util.AuthoringAccessibleListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.itemsfilter.FilterHelper;
import org.eclipse.epf.library.edit.itemsfilter.ICategoryFilter;
import org.eclipse.epf.library.edit.itemsfilter.IFilter;
import org.eclipse.epf.library.edit.itemsfilter.IProcessFilter;
import org.eclipse.epf.library.edit.meta.TypeDefUtil;
import org.eclipse.epf.library.edit.navigator.MethodPluginItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.ProcessScopeUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.util.ModifiedTypeMeta;
import org.eclipse.epf.uma.util.Scope;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class ItemsFilterDialog
extends BaseItemsFilterDialog
implements ISelectionChangedListener,
IDoubleClickListener {
    protected Button okButton;
    protected Button cancelButton;
    protected Text ctrl_pattern;
    protected Text ctrl_brief_desc;
    private String pattern;
    private String filterTypeStr;
    protected Combo filterType;
    private String dialogTitle;
    private String tabStr;
    private Object contentElement;
    private ArrayList selectedList = new ArrayList();
    private boolean viewerSelectionSingle = false;
    private String viewerLabel = null;
    private ProcessScopeUtil processUtil = ProcessScopeUtil.getInstance();
    private Combo selectCombo;
    private final String[] selectComboItems = new String[]{AuthoringUIResources.FilterDialog_Process_Scope_Grp_referencedPluginsBtn, AuthoringUIResources.FilterDialog_Process_Scope_Grp_selectedPluginsBtn, AuthoringUIResources.FilterDialog_Process_Scope_Grp_libBtn, AuthoringUIResources.FilterDialog_Process_Scope_Grp_configBtn};
    private Button viewBtn;
    private boolean enableProcessScope = false;
    private AbstractSection section;
    private Process configFreeProcess;
    private List selectedMethodPlugins = new ArrayList();
    private String PLUGIN_LIST_SECTION = ".Plugin_List_Section";
    private String PLUGIN_LIST_KEY = "Plugin_List_Key";
    private TreeViewer treeViewer;
    protected IStructuredContentProvider contentProvider;
    protected ILabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public String getText(Object object) {
            MethodPluginItemProvider methodPluginItemProvider;
            if (object instanceof VariabilityElement) {
                return TngUtil.getLabel((VariabilityElement)((VariabilityElement)object), (String)"", (boolean)true);
            }
            if (object instanceof MethodPlugin && (methodPluginItemProvider = (MethodPluginItemProvider)TngUtil.getAdapter((EObject)((MethodPlugin)object), MethodPluginItemProvider.class)) != null) {
                return methodPluginItemProvider.getFullName(object);
            }
            return super.getText(object);
        }

        public String getColumnText(Object object, int index) {
            return this.getText(object);
        }

        public Image getColumnImage(Object object, int index) {
            return super.getImage(object);
        }
    };
    private AdapterFactory adapterFactory;
    private ComposedAdapterFactory composedAdapterFactory;
    private List alreadySelectedList = new ArrayList();
    private org.eclipse.epf.library.edit.IFilter filter;
    Pattern regexPattern;
    protected FilterHelper helper;
    private String STORE_EXPANDED_LEVEL_ID = ".LEVEL_ID";
    private String PATTERN_ID = ".Pattern";
    private String TYPE_ID = ".Type";
    private String DIALOG_NAME;
    private Button expandButton;
    private Button collapseButton;
    private Object input;
    private String[] types;
    public long delay = 800L;
    private UpdateTreeJob treeJob = new UpdateTreeJob(AuthoringUIResources.ItemsFilterDialog_UpdateTreeJob_name);

    public ItemsFilterDialog(Shell parentShell, Object contentElement, String tabStr, List alreadyExists) {
        super(parentShell);
        this.contentElement = contentElement;
        this.tabStr = tabStr;
        this.filter = null;
        this.alreadySelectedList = alreadyExists;
        this.helper = new FilterHelper(contentElement, tabStr, null, null, this.alreadySelectedList);
        this.initProviderForTabs();
    }

    public ItemsFilterDialog(Shell parentShell, org.eclipse.epf.library.edit.IFilter filter, String tabStr, List alreadyExists, Object input) {
        this(parentShell, filter, null, tabStr, alreadyExists);
        this.input = input;
    }

    public ItemsFilterDialog(Shell parentShell, org.eclipse.epf.library.edit.IFilter filter, Object contentElement, String tabStr) {
        super(parentShell);
        this.filter = filter;
        this.tabStr = tabStr;
        this.helper = new FilterHelper(contentElement, tabStr, null, null, null);
        this.initProviderForTabs();
    }

    public ItemsFilterDialog(Shell parentShell, org.eclipse.epf.library.edit.IFilter filter, Object contentElement, String tabStr, List alreadyExists) {
        super(parentShell);
        this.filter = filter;
        this.tabStr = tabStr;
        this.alreadySelectedList = alreadyExists;
        this.helper = new FilterHelper(contentElement, tabStr, null, null, alreadyExists);
        this.contentElement = contentElement;
        this.initProviderForTabs();
    }

    public ItemsFilterDialog(Shell parentShell) {
        super(parentShell);
        this.helper = new FilterHelper(null, null, null, null, null);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.saveValues();
        }
        super.buttonPressed(buttonId);
        if (this.composedAdapterFactory != null) {
            this.composedAdapterFactory.dispose();
        }
    }

    protected void cancelPressed() {
        if (this.treeJob != null) {
            this.treeJob.cancel();
        }
        super.cancelPressed();
        if (this.composedAdapterFactory != null) {
            this.composedAdapterFactory.dispose();
        }
    }

    protected void okPressed() {
        if (this.treeJob != null) {
            this.treeJob.cancel();
        }
        super.okPressed();
    }

    public void setTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.dialogTitle == null) {
            this.dialogTitle = this.tabStr;
        }
        shell.setText(String.valueOf(AuthoringUIResources.FilterDialog_title) + this.dialogTitle);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setFont(parent.getFont());
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 3;
        Label typeLabel = new Label(composite, 0);
        typeLabel.setText(AuthoringUIResources.FilterDialog_Type_text);
        GridData gD1 = new GridData(1);
        typeLabel.setLayoutData((Object)gD1);
        this.filterType = new Combo(composite, 12);
        gD1 = new GridData(768);
        gD1.horizontalSpan = 2;
        this.filterType.setLayoutData((Object)gD1);
        if (this.types == null) {
            this.fillFilterTypeCombo();
            if (this.helper != null) {
                this.helper.setFilterTypeStr(this.filterTypeStr);
            }
        } else {
            this.filterType.setItems(this.types);
            if (this.helper != null) {
                this.filterTypeStr = this.filterType.getItem(0);
                this.helper.setFilterTypeStr(this.filterTypeStr);
                if (this.tabStr == null) {
                    this.tabStr = this.filterTypeStr;
                    this.helper.setTabStr(this.tabStr);
                }
            }
        }
        this.filterType.select(0);
        if (this.supportProcessScope(this.contentElement)) {
            this.createSelectionScope(composite);
        }
        Label ctrl_patternLabel = new Label(composite, 0);
        ctrl_patternLabel.setText(AuthoringUIResources.FilterDialog_Pattern_text);
        GridData gD = new GridData();
        gD.horizontalSpan = 3;
        ctrl_patternLabel.setLayoutData((Object)gD);
        this.ctrl_pattern = new Text(composite, 2048);
        GridData gD12 = new GridData(256);
        gD12.horizontalSpan = 3;
        this.ctrl_pattern.setLayoutData((Object)gD12);
        this.ctrl_pattern.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(String.valueOf(AuthoringUIResources.FilterDialog_Pattern_text) + AuthoringUIResources.FilterDialog_Pattern_description));
        Label ctrl_patternLabel1 = new Label(composite, 64);
        ctrl_patternLabel1.setText(AuthoringUIResources.FilterDialog_Pattern_description);
        GridData gD2 = new GridData(-1, -1, false, false, 3, 1);
        gD2.widthHint = 500;
        ctrl_patternLabel1.setLayoutData((Object)gD2);
        Composite buttonsComposite = new Composite(composite, 0);
        GridData gd2 = new GridData(896);
        gd2.horizontalSpan = 3;
        buttonsComposite.setLayoutData((Object)gd2);
        GridLayout buttonsLayout = new GridLayout();
        buttonsLayout.numColumns = 2;
        buttonsLayout.marginRight = 0;
        buttonsComposite.setLayout((Layout)buttonsLayout);
        this.expandButton = new Button(buttonsComposite, 524288);
        this.expandButton.setImage(AuthoringUIPlugin.getDefault().getSharedImage("expandall.gif"));
        this.expandButton.setToolTipText(AuthoringUIResources.FilterDialog_ExpandAll);
        this.expandButton.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIResources.FilterDialog_ExpandAll));
        this.collapseButton = new Button(buttonsComposite, 8);
        this.collapseButton.setImage(AuthoringUIPlugin.getDefault().getSharedImage("collapseall.gif"));
        this.collapseButton.setToolTipText(AuthoringUIResources.FilterDialog_CollapseAll);
        this.collapseButton.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIResources.FilterDialog_CollapseAll));
        this.createLine(composite, 3);
        this.createViewerLabel(composite);
        this.createViewer(composite);
        this.restoreLastSettings();
        new Label(composite, 0).setText(AuthoringUIResources.FilterDialog_BriefDescription);
        this.ctrl_brief_desc = new Text(composite, 2634);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.heightHint = 60;
        this.ctrl_brief_desc.setLayoutData((Object)gd);
        this.createLine(composite, 3);
        this.addListener();
        if (this.supportProcessScope(this.contentElement)) {
            this.selectCombo.select(0);
            this.updateBtnStatus();
            this.updateFilterDialog();
        }
        return composite;
    }

    private void createViewer(Composite parent) {
        this.treeViewer = this.viewerSelectionSingle ? new TreeViewer(parent, 2820) : new TreeViewer(parent, 2818);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setInput(this.getInput());
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.treeViewer.getTree().setFont(parent.getFont());
        if (this.tabStr.equalsIgnoreCase(FilterConstants.ALL_ELEMENTS)) {
            this.treeViewer.setSorter((ViewerSorter)new FilterSorterForAll());
        } else {
            this.treeViewer.setSorter((ViewerSorter)new FilterSorter());
        }
        GridData spec = new GridData(1808);
        spec.heightHint = 300;
        spec.horizontalSpan = 3;
        this.treeViewer.getControl().setLayoutData((Object)spec);
    }

    private Object getInput() {
        if (this.input != null) {
            return this.input;
        }
        if (this.contentElement != null) {
            Process process;
            if (this.contentElement instanceof Process && (process = (Process)this.contentElement).eContainer() instanceof ProcessComponent) {
                if (!(this.tabStr.equals(FilterConstants.GUIDANCE) || this.tabStr.equals(FilterConstants.ROADMAP) || this.tabStr.equals(FilterConstants.SUPPORTING_MATERIALS))) {
                    return process.eContainer();
                }
                return process;
            }
            return UmaUtil.getMethodLibrary((EObject)((EObject)this.contentElement));
        }
        return LibraryService.getInstance().getCurrentMethodLibrary();
    }

    private void createLine(Composite parent, int ncol) {
        Label line = new Label(parent, 259);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = ncol;
        line.setLayoutData((Object)gridData);
    }

    private void createViewerLabel(Composite parent) {
        if (this.viewerLabel != null) {
            Label label = new Label(parent, 0);
            label.setText(this.viewerLabel);
        }
    }

    public void setViewerSelectionSingle(boolean single) {
        this.viewerSelectionSingle = single;
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object element = s.getFirstElement();
        if ((element = LibraryUtil.unwrap((Object)element)) instanceof ContentElement || element instanceof Process || element instanceof ProcessComponent || element instanceof BreakdownElement || element instanceof ProcessPackage) {
            this.selectedList.add(element);
        }
        this.saveLastSettings();
        this.close();
        if (this.composedAdapterFactory != null) {
            this.composedAdapterFactory.dispose();
        }
    }

    protected IDialogSettings getDialogSettings() {
        DialogSettings dialogSettings = (DialogSettings)AuthoringUIPlugin.getDefault().getDialogSettings();
        DialogSettings section = (DialogSettings)dialogSettings.getSection(String.valueOf(this.DIALOG_NAME) + this.STORE_EXPANDED_LEVEL_ID);
        if (section == null) {
            section = (DialogSettings)dialogSettings.addNewSection(String.valueOf(this.DIALOG_NAME) + this.STORE_EXPANDED_LEVEL_ID);
        }
        return section;
    }

    protected void restoreLastSettings() {
        List elements;
        this.DIALOG_NAME = this.tabStr;
        DialogSettings dialogSettings = (DialogSettings)this.getDialogSettings();
        String temp = dialogSettings.get(String.valueOf(this.DIALOG_NAME) + this.PATTERN_ID);
        ModifiedTypeMeta mdtMeta = null;
        if (this.helper != null) {
            Object ce = this.helper.getContentElement();
            mdtMeta = TypeDefUtil.getMdtMeta((MethodElement)((MethodElement)ce));
        }
        if (temp != null && temp.length() > 0 && mdtMeta == null) {
            this.pattern = dialogSettings.get(String.valueOf(this.DIALOG_NAME) + this.PATTERN_ID);
            this.filterTypeStr = dialogSettings.get(String.valueOf(this.DIALOG_NAME) + this.TYPE_ID);
            this.filterType.setText(this.filterTypeStr);
            this.regexPattern = this.getRegEx(this.pattern);
            this.ctrl_pattern.setText(this.pattern);
            if (this.helper != null) {
                this.helper.setPattern(this.pattern);
                this.helper.setRegexPattern(this.regexPattern);
                this.helper.setFilterTypeStr(this.filterTypeStr);
            }
            this.initProviderForTabs();
        }
        if ((elements = (List)FilterConstants.hashMap.get(String.valueOf(this.DIALOG_NAME) + this.STORE_EXPANDED_LEVEL_ID)) == null || elements.isEmpty()) {
            this.treeViewer.expandAll();
            return;
        }
        if (elements != null && !elements.isEmpty()) {
            try {
                this.treeViewer.setExpandedElements(elements.toArray());
                this.treeViewer.refresh();
            }
            catch (Exception exception) {
                this.treeViewer.expandAll();
            }
        }
    }

    public void traverseTree(TreeItem[] items, List list) {
        int i = 0;
        while (i < items.length) {
            TreeItem[] itemsx = items[i].getItems();
            if (itemsx.length > 1) {
                list.add(items[i].getData());
                this.traverseTree(itemsx, list);
            } else {
                list.add(items[i].getData());
            }
            ++i;
        }
    }

    protected void saveValues() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (selection.size() > 0) {
            Object[] objectArr = selection.toArray();
            int i = 0;
            while (i < objectArr.length) {
                Object obj = LibraryUtil.unwrap((Object)objectArr[i]);
                if (obj instanceof ContentElement || obj instanceof Process || obj instanceof ProcessComponent || obj instanceof BreakdownElement || obj instanceof ProcessPackage) {
                    this.selectedList.add(obj);
                }
                ++i;
            }
        }
        this.saveLastSettings();
    }

    public void saveLastSettings() {
        IDialogSettings settings = this.getDialogSettings();
        this.DIALOG_NAME = this.tabStr;
        Object[] expandedElements = this.treeViewer.getExpandedElements();
        ArrayList<Object> expandList = new ArrayList<Object>();
        int i = 0;
        while (i < expandedElements.length) {
            Object obj = expandedElements[i];
            if (obj instanceof NamedElement) {
                expandList.add(expandedElements[i]);
            }
            ++i;
        }
        settings.put(String.valueOf(this.DIALOG_NAME) + this.PATTERN_ID, this.pattern);
        settings.put(String.valueOf(this.DIALOG_NAME) + this.TYPE_ID, this.filterTypeStr);
        FilterConstants.hashMap.put(String.valueOf(this.DIALOG_NAME) + this.STORE_EXPANDED_LEVEL_ID, expandList);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateSelection(event);
        this.updateButtons();
    }

    protected void updateButtons() {
    }

    public Object getParentObject(Object contentElement) {
        return MethodElementUtil.getMethodModel((Object)contentElement);
    }

    protected void updateSelection(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        Object selected = sel.getFirstElement();
        if (selected instanceof BreakdownElementWrapperItemProvider || selected instanceof BreakdownElementItemProvider) {
            Object unwrap = TngUtil.unwrap((Object)selected);
            this.setBriefDescription(unwrap);
        } else {
            this.setBriefDescription(selected);
        }
    }

    private void setBriefDescription(Object element) {
        String desc;
        if (element instanceof MethodElement && (desc = ((MethodElement)element).getBriefDescription()) != null) {
            this.ctrl_brief_desc.setText(desc);
        }
    }

    public void fillFilterTypeCombo() {
        if (this.filter instanceof ConfigurationFilter) {
            String[] str = new String[]{this.tabStr};
            this.filterType.setItems(str);
            this.filterTypeStr = str[0];
        } else if (FilterConstants.ONLY_CONTENT_ELEMENTS.equals(this.tabStr)) {
            String space = "-";
            String[] str = new String[27];
            int i = 0;
            str[i++] = FilterConstants.ALL_ELEMENTS;
            str[i++] = FilterConstants.CONTENT_PACKAGES;
            str[i++] = String.valueOf(space) + FilterConstants.ROLES;
            str[i++] = String.valueOf(space) + FilterConstants.TASKS;
            str[i++] = String.valueOf(space) + FilterConstants.WORKPRODUCTS;
            str[i++] = String.valueOf(space) + FilterConstants.UDTs;
            str[i++] = String.valueOf(space) + FilterConstants.GUIDANCE;
            str[i++] = "--" + FilterConstants.CHECKLISTS;
            str[i++] = "--" + FilterConstants.CONCEPTS;
            str[i++] = "--" + FilterConstants.ESTIMATE_CONSIDERATIONS;
            str[i++] = "--" + FilterConstants.EXAMPLES;
            str[i++] = "--" + FilterConstants.GUIDELINES;
            str[i++] = "--" + FilterConstants.PRACTICES;
            str[i++] = "--" + FilterConstants.REPORTS;
            str[i++] = "--" + FilterConstants.REUSABLE_ASSETS;
            str[i++] = "--" + FilterConstants.ROADMAP;
            str[i++] = "--" + FilterConstants.SUPPORTING_MATERIALS;
            str[i++] = "--" + FilterConstants.TEMPLATES;
            str[i++] = "--" + FilterConstants.TERM_DEFINITIONS;
            str[i++] = "--" + FilterConstants.TOOL_MENTORS;
            str[i++] = "--" + FilterConstants.WHITE_PAPERS;
            str[i++] = FilterConstants.DISCIPLINES;
            str[i++] = FilterConstants.ROLESETS;
            str[i++] = FilterConstants.WORKPRODUCTTYPES;
            str[i++] = FilterConstants.DOMAINS;
            str[i++] = FilterConstants.TOOLS;
            str[i++] = FilterConstants.CUSTOM_CATEGORIES;
            this.filterType.setItems(str);
            this.filterTypeStr = str[0];
        } else if (FilterConstants.categoryStrs.contains(this.tabStr)) {
            String[] str = new String[]{this.tabStr, FilterConstants.METHO_PLUGINS};
            this.filterType.setItems(str);
            this.filterTypeStr = str[0];
        } else if (FilterConstants.CUSTOM_CATEGORIES.equalsIgnoreCase(this.tabStr)) {
            String[] str = new String[]{this.tabStr, FilterConstants.METHO_PLUGINS};
            this.filterType.setItems(str);
            this.filterTypeStr = str[0];
        } else if (FilterConstants.breakdownElements.contains(this.tabStr)) {
            String[] str = new String[]{this.tabStr};
            this.filterType.setItems(str);
            this.filterTypeStr = str[0];
        } else if (FilterConstants.contentElementStrs.contains(this.tabStr)) {
            String[] str = new String[]{this.tabStr, FilterConstants.CONTENT_PACKAGES, FilterConstants.METHO_PLUGINS};
            this.filterType.setItems(str);
            this.filterTypeStr = str[0];
        } else if (FilterConstants.ALL_ELEMENTS.equals(this.tabStr)) {
            String space = "-";
            String[] str = new String[29];
            int i = 0;
            if (this.filter instanceof AllFilter) {
                int sz;
                AllFilter allFilter = (AllFilter)this.filter;
                int n = sz = allFilter.getSelectedTypeStrings() == null ? 0 : allFilter.getSelectedTypeStrings().size();
                if (sz != 0) {
                    str = new String[sz];
                    for (String typeString : allFilter.getSelectedTypeStrings()) {
                        str[i++] = typeString;
                    }
                    this.filterType.setItems(str);
                    this.filterTypeStr = str[0];
                    return;
                }
            }
            str[i++] = FilterConstants.ALL_ELEMENTS;
            str[i++] = FilterConstants.CONTENT_PACKAGES;
            str[i++] = String.valueOf(space) + FilterConstants.ROLES;
            str[i++] = String.valueOf(space) + FilterConstants.TASKS;
            str[i++] = String.valueOf(space) + FilterConstants.WORKPRODUCTS;
            str[i++] = String.valueOf(space) + FilterConstants.UDTs;
            str[i++] = String.valueOf(space) + FilterConstants.GUIDANCE;
            str[i++] = "--" + FilterConstants.CHECKLISTS;
            str[i++] = "--" + FilterConstants.CONCEPTS;
            str[i++] = "--" + FilterConstants.ESTIMATE_CONSIDERATIONS;
            str[i++] = "--" + FilterConstants.EXAMPLES;
            str[i++] = "--" + FilterConstants.GUIDELINES;
            str[i++] = "--" + FilterConstants.PRACTICES;
            str[i++] = "--" + FilterConstants.REPORTS;
            str[i++] = "--" + FilterConstants.REUSABLE_ASSETS;
            str[i++] = "--" + FilterConstants.ROADMAP;
            str[i++] = "--" + FilterConstants.SUPPORTING_MATERIALS;
            str[i++] = "--" + FilterConstants.TEMPLATES;
            str[i++] = "--" + FilterConstants.TERM_DEFINITIONS;
            str[i++] = "--" + FilterConstants.TOOL_MENTORS;
            str[i++] = "--" + FilterConstants.WHITE_PAPERS;
            str[i++] = FilterConstants.DISCIPLINES;
            str[i++] = FilterConstants.ROLESETS;
            str[i++] = FilterConstants.WORKPRODUCTTYPES;
            str[i++] = FilterConstants.DOMAINS;
            str[i++] = FilterConstants.TOOLS;
            str[i++] = FilterConstants.CUSTOM_CATEGORIES;
            str[i++] = FilterConstants.PROCESSES;
            str[i++] = FilterConstants.METHO_PLUGINS;
            this.filterType.setItems(str);
            this.filterTypeStr = str[0];
        } else if (FilterConstants.CONFIG_CONTENT_ELEMENT.equals(this.tabStr)) {
            String[] str = new String[]{this.tabStr};
            this.filterType.setItems(str);
            this.filterTypeStr = str[0];
        } else {
            String[] str = new String[]{this.tabStr};
            this.filterType.setItems(str);
            this.filterTypeStr = str[0];
        }
    }

    public void addListener() {
        this.ctrl_pattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ItemsFilterDialog.this.treeJob.getState() == 0) {
                    ItemsFilterDialog.this.treeJob.schedule(ItemsFilterDialog.this.delay);
                } else if (ItemsFilterDialog.this.treeJob.getState() == 2 || ItemsFilterDialog.this.treeJob.getState() == 1) {
                    ItemsFilterDialog.this.treeJob.cancel();
                    ItemsFilterDialog.this.treeJob.schedule(ItemsFilterDialog.this.delay);
                }
            }
        });
        this.filterType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ItemsFilterDialog.this.filterType.getSelectionIndex() > -1) {
                    ItemsFilterDialog.this.filterTypeStr = ItemsFilterDialog.this.filterType.getItem(ItemsFilterDialog.this.filterType.getSelectionIndex());
                }
                ItemsFilterDialog.this.filterTypeStr.trim();
                if (ItemsFilterDialog.this.helper != null) {
                    ItemsFilterDialog.this.helper.setPattern(ItemsFilterDialog.this.pattern);
                    ItemsFilterDialog.this.helper.setRegexPattern(ItemsFilterDialog.this.regexPattern);
                    ItemsFilterDialog.this.helper.setFilterTypeStr(ItemsFilterDialog.this.filterTypeStr);
                    ItemsFilterDialog.this.helper.setTabStr(ItemsFilterDialog.this.filterTypeStr);
                }
                ItemsFilterDialog.this.refreshTreeViewer();
            }

            public void widgetDefaultSelected(SelectionEvent selectionevent) {
            }
        });
        this.expandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemsFilterDialog.this.expandOrCollapse(true);
            }
        });
        this.collapseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemsFilterDialog.this.expandOrCollapse(false);
            }
        });
        if (this.supportProcessScope(this.contentElement)) {
            this.selectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ItemsFilterDialog.this.updateBtnStatus();
                    ItemsFilterDialog.this.updateFilterDialog();
                }
            });
            this.viewBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int index = ItemsFilterDialog.this.selectCombo.getSelectionIndex();
                    if (index == 0) {
                        ItemsFilterDialog.this.showPluginListDialog(true);
                    }
                    if (index == 1) {
                        ItemsFilterDialog.this.showPluginListDialog(false);
                    }
                }
            });
        }
    }

    public ArrayList getSelectedItems() {
        return this.selectedList;
    }

    private void initProviderForTabs() {
        if (this.filter != null) {
            if (this.filter instanceof IFilter) {
                if (this.filter instanceof ICategoryFilter) {
                    this.helper.setContentCategoryTabStr(this.tabStr);
                }
                ((IFilter)this.filter).setHelper(this.helper);
            } else if (this.filter instanceof DescriptorConfigurationFilter) {
                ((DescriptorConfigurationFilter)this.filter).setHelper(this.helper);
            } else if (this.filter instanceof ExProcessAuthoringConfigurator) {
                ((ExProcessAuthoringConfigurator)this.filter).setHelper(this.helper);
            }
        }
        if (this.filter instanceof IProcessFilter) {
            if (this.tabStr.equalsIgnoreCase(FilterConstants.WORK_PRODUCT_DESCRIPTORS)) {
                this.adapterFactory = TngAdapterFactory.INSTANCE.getPBSFilter_AdapterFactory(this.filter);
                this.contentProvider = new AdapterFactoryContentProvider(this.adapterFactory);
                this.composedAdapterFactory = TngAdapterFactory.INSTANCE.getPBSFilter_ComposedAdapterFactory();
                this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory()){

                    public String getColumnText(Object object, int index) {
                        return super.getText(object);
                    }

                    public Image getColumnImage(Object object, int index) {
                        return super.getImage(object);
                    }
                };
            } else if (this.tabStr.equalsIgnoreCase(FilterConstants.ROLE_DESCRIPTORS)) {
                this.adapterFactory = TngAdapterFactory.INSTANCE.getOBSFilter_AdapterFactory(this.filter);
                this.contentProvider = new AdapterFactoryContentProvider(this.adapterFactory);
                this.composedAdapterFactory = TngAdapterFactory.INSTANCE.getOBSFilter_ComposedAdapterFactory();
                this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory()){

                    public String getColumnText(Object object, int index) {
                        return super.getText(object);
                    }

                    public Image getColumnImage(Object object, int index) {
                        return super.getImage(object);
                    }
                };
            }
        } else {
            this.adapterFactory = TngAdapterFactory.INSTANCE.getItemsFilter_AdapterFactory(this.filter);
            this.contentProvider = new AdapterFactoryContentProvider(this.adapterFactory);
            this.composedAdapterFactory = TngAdapterFactory.INSTANCE.getItemsFilter_ComposedAdapterFactory();
        }
    }

    public void setExistingElements(List list) {
        this.alreadySelectedList = list;
        if (this.helper != null) {
            this.helper.setAlreadySelectedList(list);
        }
    }

    public FilterHelper getHelper() {
        return this.helper;
    }

    public String[] getFilterTypeArray() {
        return null;
    }

    public void setContentProvider(IStructuredContentProvider contentProvider, ComposedAdapterFactory composedAdapterFactory) {
        this.contentProvider = contentProvider;
        this.composedAdapterFactory = composedAdapterFactory;
    }

    public void setTypes(String[] str) {
        this.types = str;
    }

    public void setFilter(org.eclipse.epf.library.edit.IFilter filter) {
        this.filter = filter;
        if (this.helper != null) {
            if (this.filter instanceof IFilter) {
                ((IFilter)this.filter).setHelper(this.helper);
            } else if (this.filter instanceof DescriptorConfigurationFilter) {
                ((DescriptorConfigurationFilter)this.filter).setHelper(this.helper);
            }
        }
    }

    public void setInput(Object input) {
        if (input != null) {
            this.input = input;
        }
    }

    public void setViewerLabel(String viewerLabel) {
        this.viewerLabel = viewerLabel;
    }

    public void refreshTreeViewer() {
        try {
            this.treeViewer.getTree().clearAll(true);
            this.treeViewer.getTree().setVisible(false);
            this.treeViewer.refresh();
            this.treeViewer.expandAll();
            this.treeViewer.getTree().setVisible(true);
        }
        catch (Exception e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    public void expandOrCollapse(boolean expand) {
        this.treeViewer.getTree().setVisible(false);
        if (expand) {
            this.treeViewer.expandAll();
        } else {
            this.treeViewer.collapseAll();
        }
        this.treeViewer.getTree().setVisible(true);
    }

    private Pattern getRegEx(String pattern) {
        try {
            return PatternConstructor.createPattern((String)pattern, (boolean)false, (boolean)false);
        }
        catch (Exception exception) {
            return PatternConstructor.createPattern((String)"*", (boolean)false, (boolean)false);
        }
    }

    private void createSelectionScope(Composite parent) {
        Label selectLabel = new Label(parent, 0);
        selectLabel.setText(AuthoringUIResources.FilterDialog_Process_Scope_Grp);
        this.selectCombo = new Combo(parent, 8);
        this.selectCombo.setLayoutData((Object)new GridData(768));
        this.selectCombo.setItems(this.selectComboItems);
        this.viewBtn = new Button(parent, 8);
        this.viewBtn.setText(AuthoringUIResources.FilterDialog_Process_Scope_Grp_viewBtn);
        this.viewBtn.setEnabled(false);
    }

    private boolean supportProcessScope(Object inputElement) {
        Process process;
        boolean result = false;
        if (this.enableProcessScope && inputElement instanceof BreakdownElement && (result = this.processUtil.isConfigFree(process = this.getProcess((BreakdownElement)inputElement)))) {
            this.configFreeProcess = process;
        }
        return result;
    }

    private Process getProcess(BreakdownElement element) {
        ComposedAdapterFactory aFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        ItemProviderAdapter adapter = (ItemProviderAdapter)aFactory.adapt((Notifier)element, ITreeItemContentProvider.class);
        Object obj = ProcessUtil.getRootProcess((AdapterFactory)aFactory, (ItemProviderAdapter)adapter, (Object)element);
        return (Process)obj;
    }

    private void updateBtnStatus() {
        int index = this.selectCombo.getSelectionIndex();
        if (index == 0 || index == 1) {
            this.viewBtn.setEnabled(true);
        } else {
            this.viewBtn.setEnabled(false);
        }
    }

    private void updateFilterDialog() {
        int index = this.selectCombo.getSelectionIndex();
        if (index == 0) {
            this.processUtil.setElemementSelectionScopeType(1);
        }
        if (index == 1) {
            this.processUtil.setElemementSelectionScopeType(3);
            this.restoreDialogSettingsForPluginList();
            Scope pluginScope = this.processUtil.getPluginScope();
            pluginScope.clearAll();
            for (Object plugin : this.selectedMethodPlugins) {
                pluginScope.addPlugin((MethodPlugin)plugin);
            }
        }
        if (index == 2) {
            this.processUtil.setElemementSelectionScopeType(2);
        }
        if (index == 3) {
            this.processUtil.setElemementSelectionScopeType(0);
        }
        this.updateFilter();
        this.initProviderForTabs();
        this.refreshTreeViewer();
    }

    public void setEnableProcessScope(boolean enableProcessScope) {
        this.enableProcessScope = enableProcessScope;
    }

    public void setSection(AbstractSection section) {
        this.section = section;
    }

    private void updateFilter() {
        if (this.section != null && this.filter instanceof DescriptorConfigurationFilter) {
            ((DescriptorConfigurationFilter)this.filter).setMethodConfiguration(this.section.getConfiguration());
        }
    }

    private void showPluginListDialog(boolean readOnly) {
        List referencedMethodPlugins = this.processUtil.getScope(this.configFreeProcess).getMethodPluginSelection();
        PluginListDialog dialog = null;
        if (readOnly) {
            dialog = new PluginListDialog(this.getShell(), true, referencedMethodPlugins);
            dialog.open();
        } else {
            dialog = new PluginListDialog(this.getShell(), false, this.selectedMethodPlugins);
            if (dialog.open() == 0) {
                List plugins = dialog.getResults();
                Scope pluginScope = this.processUtil.getPluginScope();
                pluginScope.clearAll();
                this.selectedMethodPlugins.clear();
                for (Object obj : plugins) {
                    if (!(obj instanceof MethodPlugin)) continue;
                    pluginScope.addPlugin((MethodPlugin)obj);
                    this.selectedMethodPlugins.add(obj);
                }
                this.refreshTreeViewer();
                this.saveDialogSettingsForPluginList();
            }
        }
    }

    private IDialogSettings getDialogSettingsForPluginList() {
        String processId;
        IDialogSettings dialogSettings = AuthoringUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(String.valueOf(processId = this.configFreeProcess.getGuid()) + this.PLUGIN_LIST_SECTION);
        if (section == null) {
            section = dialogSettings.addNewSection(String.valueOf(processId) + this.PLUGIN_LIST_SECTION);
        }
        return section;
    }

    private void saveDialogSettingsForPluginList() {
        IDialogSettings settings = this.getDialogSettingsForPluginList();
        String[] pluginId = new String[this.selectedMethodPlugins.size()];
        int i = 0;
        while (i < this.selectedMethodPlugins.size()) {
            pluginId[i] = ((MethodPlugin)this.selectedMethodPlugins.get(i)).getGuid();
            ++i;
        }
        settings.put(this.PLUGIN_LIST_KEY, pluginId);
    }

    private void restoreDialogSettingsForPluginList() {
        IDialogSettings settings = this.getDialogSettingsForPluginList();
        String[] pluginId = settings.getArray(this.PLUGIN_LIST_KEY);
        MethodLibrary lib = LibraryEditUtil.getInstance().getCurrentMethodLibrary();
        if (lib != null) {
            List allMethodPluginsInLibrary = lib.getMethodPlugins();
            if (pluginId != null) {
                this.selectedMethodPlugins.clear();
                block0: for (Object plugin : allMethodPluginsInLibrary) {
                    String tempId = ((MethodPlugin)plugin).getGuid();
                    String[] stringArray = pluginId;
                    int n = pluginId.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id = stringArray[n2];
                        if (tempId.equals(id)) {
                            this.selectedMethodPlugins.add(plugin);
                            continue block0;
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    private class UpdateTreeJob
    extends Job {
        public UpdateTreeJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (ItemsFilterDialog.this.treeViewer == null || ItemsFilterDialog.this.treeViewer.getControl() == null || ItemsFilterDialog.this.treeViewer.getControl().isDisposed()) {
                        return;
                    }
                    ItemsFilterDialog.this.treeViewer.getTree().clearAll(true);
                    if (((UpdateTreeJob)UpdateTreeJob.this).ItemsFilterDialog.this.ctrl_pattern.getText() != null && ((UpdateTreeJob)UpdateTreeJob.this).ItemsFilterDialog.this.ctrl_pattern.getText().trim().length() > 0) {
                        ItemsFilterDialog.this.pattern = ((UpdateTreeJob)UpdateTreeJob.this).ItemsFilterDialog.this.ctrl_pattern.getText().trim();
                    } else {
                        ItemsFilterDialog.this.pattern = "*";
                    }
                    ((UpdateTreeJob)UpdateTreeJob.this).ItemsFilterDialog.this.regexPattern = ItemsFilterDialog.this.getRegEx(ItemsFilterDialog.this.pattern);
                    if (((UpdateTreeJob)UpdateTreeJob.this).ItemsFilterDialog.this.helper != null) {
                        ((UpdateTreeJob)UpdateTreeJob.this).ItemsFilterDialog.this.helper.setPattern(ItemsFilterDialog.this.pattern);
                        ((UpdateTreeJob)UpdateTreeJob.this).ItemsFilterDialog.this.helper.setRegexPattern(((UpdateTreeJob)UpdateTreeJob.this).ItemsFilterDialog.this.regexPattern);
                        ((UpdateTreeJob)UpdateTreeJob.this).ItemsFilterDialog.this.helper.setFilterTypeStr(ItemsFilterDialog.this.filterTypeStr);
                        ((UpdateTreeJob)UpdateTreeJob.this).ItemsFilterDialog.this.helper.setTabStr(ItemsFilterDialog.this.filterTypeStr);
                    }
                    ItemsFilterDialog.this.refreshTreeViewer();
                }
            });
            return Status.OK_STATUS;
        }
    }
}

