/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.dialogs.StateEditDialog;
import org.eclipse.epf.authoring.ui.forms.WorkProductStatesPage;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.util.MethodElementPropUtil;
import org.eclipse.epf.library.edit.util.MethodPluginPropUtil;
import org.eclipse.epf.uma.Constraint;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ManageStateDialog
extends Dialog {
    private TableViewer statesViewer;
    private IStructuredContentProvider statesViewerContentProvider;
    private ITableLabelProvider statesViewerLabelProvider;
    private Text des;
    private Button addBtn;
    private Button deleteBtn;
    private Button modifyBtn;
    private Button closeBtn;
    private Shell shell;
    private MethodPlugin activePlugin;
    private IActionManager actionMgr;
    private WorkProductStatesPage page;

    public ManageStateDialog(Shell shell, MethodPlugin activePlugin, IActionManager actionMgr, WorkProductStatesPage page) {
        super(shell);
        this.shell = shell;
        this.activePlugin = activePlugin;
        this.actionMgr = actionMgr;
        this.page = page;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(AuthoringUIResources.ManageStateDialog_title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        Composite viewComp = new Composite(composite, 0);
        viewComp.setLayoutData((Object)new GridData(1808));
        viewComp.setLayout((Layout)new GridLayout());
        Label stateLabel = new Label(viewComp, 0);
        stateLabel.setText(AuthoringUIResources.ManageStateDialog_label_state);
        this.statesViewer = new TableViewer(viewComp, 2048);
        GridData gd = new GridData(1808);
        gd.widthHint = 250;
        gd.heightHint = 200;
        this.statesViewer.getTable().setLayoutData((Object)gd);
        this.initProviders();
        this.statesViewer.setContentProvider((IContentProvider)this.statesViewerContentProvider);
        this.statesViewer.setLabelProvider((IBaseLabelProvider)this.statesViewerLabelProvider);
        this.statesViewer.setComparator((ViewerComparator)new StateViewerComparator());
        this.statesViewer.setInput(new Object());
        Label desLabel = new Label(viewComp, 0);
        desLabel.setText(AuthoringUIResources.ManageStateDialog_label_des);
        this.des = new Text(viewComp, 2626);
        GridData gd2 = new GridData(1808);
        gd2.heightHint = 100;
        this.des.setLayoutData((Object)gd2);
        this.des.setEditable(false);
        this.des.setBackground(Display.getCurrent().getSystemColor(1));
        Composite btnComp = new Composite(composite, 0);
        btnComp.setLayoutData((Object)new GridData(1808));
        btnComp.setLayout((Layout)new GridLayout());
        new Label(btnComp, 0);
        this.addBtn = new Button(btnComp, 8);
        this.addBtn.setText(AuthoringUIResources.ManageStateDialog_addBtn_label);
        this.addBtn.setLayoutData((Object)new GridData(768));
        this.deleteBtn = new Button(btnComp, 8);
        this.deleteBtn.setText(AuthoringUIResources.ManageStateDialog_deleteBtn_label);
        this.deleteBtn.setLayoutData((Object)new GridData(768));
        this.deleteBtn.setEnabled(false);
        this.modifyBtn = new Button(btnComp, 8);
        this.modifyBtn.setText(AuthoringUIResources.ManageStateDialog_modifyBtn_label);
        this.modifyBtn.setLayoutData((Object)new GridData(768));
        this.modifyBtn.setEnabled(false);
        this.closeBtn = new Button(btnComp, 0);
        this.closeBtn.setText(AuthoringUIResources.ManageStateDialog_closeBtn_label);
        this.closeBtn.setLayoutData((Object)new GridData(768));
        this.addListeners();
        this.updateControls();
        return composite;
    }

    private void initProviders() {
        this.statesViewerContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                List allLocalStates = MethodPluginPropUtil.getMethodPluginPropUtil((IActionManager)ManageStateDialog.this.actionMgr).getWorkProductStatesInPlugin(ManageStateDialog.this.activePlugin);
                return allLocalStates.toArray();
            }
        };
        this.statesViewerLabelProvider = new StatesLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
    }

    private void addListeners() {
        this.statesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ManageStateDialog.this.updateControls();
            }
        });
        this.addBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Constraint state;
                StateEditDialog dialog = new StateEditDialog(ManageStateDialog.this.shell, true, null, null);
                if (dialog.open() == 0 && (state = MethodPluginPropUtil.getMethodPluginPropUtil((IActionManager)ManageStateDialog.this.actionMgr).getWorkProductState(ManageStateDialog.this.activePlugin, dialog.getStateName(), true)) != null) {
                    UmaPackage up = UmaPackage.eINSTANCE;
                    ManageStateDialog.this.actionMgr.doAction(1, (EObject)state, (EStructuralFeature)up.getMethodElement_BriefDescription(), (Object)dialog.getStateDes(), -1);
                }
                ManageStateDialog.this.updateControls();
            }
        });
        this.deleteBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ManageStateDialog.this.statesViewer.getSelection();
                if (selection.size() > 0) {
                    Constraint state = (Constraint)selection.getFirstElement();
                    if (!ManageStateDialog.this.getConfirm(state)) {
                        return;
                    }
                    MethodPluginPropUtil.getMethodPluginPropUtil((IActionManager)ManageStateDialog.this.actionMgr).removeWorkProductState(ManageStateDialog.this.activePlugin, state.getBody());
                }
                ManageStateDialog.this.updateControls();
            }
        });
        this.modifyBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ManageStateDialog.this.statesViewer.getSelection();
                if (selection.size() > 0) {
                    Constraint state = (Constraint)selection.getFirstElement();
                    if (!ManageStateDialog.this.getConfirm(state)) {
                        return;
                    }
                    String oldStateName = state.getBody();
                    String oldStateDes = state.getBriefDescription();
                    StateEditDialog dialog = new StateEditDialog(ManageStateDialog.this.shell, false, oldStateName, oldStateDes);
                    if (dialog.open() == 0) {
                        UmaPackage up = UmaPackage.eINSTANCE;
                        String newStateName = dialog.getStateName();
                        String newStateDes = dialog.getStateDes();
                        if (!newStateName.equals(oldStateName)) {
                            ManageStateDialog.this.actionMgr.doAction(1, (EObject)state, (EStructuralFeature)up.getConstraint_Body(), (Object)newStateName, -1);
                        }
                        if (!newStateDes.equals(oldStateDes)) {
                            ManageStateDialog.this.actionMgr.doAction(1, (EObject)state, (EStructuralFeature)up.getMethodElement_BriefDescription(), (Object)newStateDes, -1);
                        }
                    }
                }
                ManageStateDialog.this.updateControls();
            }
        });
        this.closeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageStateDialog.this.buttonPressed(1);
            }
        });
    }

    private boolean getConfirm(Constraint state) {
        List wps = MethodElementPropUtil.getMethodElementPropUtil().getAssignedToWorkProducts(state);
        if (wps.size() == 0) {
            return true;
        }
        StringBuffer names = new StringBuffer();
        for (WorkProduct wp : wps) {
            names.append(wp.getName());
            names.append(",");
        }
        String namesList = names.substring(0, names.length() - 1);
        String msg = AuthoringUIResources.bind((String)AuthoringUIResources.ManageStateDialog_warn_msg, (Object[])new Object[]{state.getBody(), namesList});
        return MessageDialog.openConfirm((Shell)this.shell, (String)AuthoringUIResources.ManageStateDialog_warn_title, (String)msg);
    }

    private void updateControls() {
        IStructuredSelection selection = (IStructuredSelection)this.statesViewer.getSelection();
        if (selection.size() > 0) {
            Constraint state = (Constraint)selection.getFirstElement();
            this.des.setText(state.getBriefDescription());
            this.deleteBtn.setEnabled(true);
            this.modifyBtn.setEnabled(true);
        } else {
            this.des.setText("");
            this.deleteBtn.setEnabled(false);
            this.modifyBtn.setEnabled(false);
        }
        this.statesViewer.refresh();
        this.page.updateControls();
    }

    public class StateViewerComparator
    extends ViewerComparator {
        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof Constraint && e2 instanceof Constraint) {
                String name1 = ((Constraint)e1).getBody();
                String name2 = ((Constraint)e2).getBody();
                return this.getComparator().compare(name1, name2);
            }
            return 0;
        }
    }

    private class StatesLabelProvider
    extends AdapterFactoryLabelProvider
    implements ITableFontProvider {
        private FontRegistry registry;
        private Font systemFont;

        public StatesLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
            this.registry = new FontRegistry();
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Constraint) {
                return ((Constraint)element).getBody();
            }
            return null;
        }

        public Font getFont(Object element, int columnIndex) {
            if (this.systemFont == null) {
                this.systemFont = Display.getCurrent().getSystemFont();
            }
            if (element instanceof Constraint) {
                return this.registry.getBold(this.systemFont.getFontData()[0].getName());
            }
            return this.systemFont;
        }
    }
}

