/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class PluginListDialog
extends Dialog {
    private Shell shell;
    private boolean readOnly;
    private List methodPlugins;
    private List changedMethodPlugins = new ArrayList();
    private TreeViewer viewer;
    private ComposedAdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.createLibraryComposedAdapterFactory();
    private ITreeContentProvider pluginsContentProvider = new PluginListContentProvider();
    private AdapterFactoryLabelProvider pluginsLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
    private Button addBtn;
    private Button removeBtn;

    public PluginListDialog(Shell shell, boolean readOnly, List methodPlugins) {
        super(shell);
        this.shell = shell;
        this.readOnly = readOnly;
        this.methodPlugins = methodPlugins;
        this.changedMethodPlugins.addAll(methodPlugins);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(AuthoringUIResources.PluginListDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        Composite viewComp = new Composite(composite, 0);
        viewComp.setLayoutData((Object)new GridData(1808));
        viewComp.setLayout((Layout)new GridLayout());
        this.viewer = new TreeViewer(viewComp, 2818);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.pluginsLabelProvider);
        this.viewer.setContentProvider((IContentProvider)this.pluginsContentProvider);
        GridData viewerGd = new GridData(1808);
        viewerGd.heightHint = 250;
        viewerGd.widthHint = 200;
        this.viewer.getTree().setLayoutData((Object)viewerGd);
        Composite btnComp = new Composite(composite, 0);
        btnComp.setLayoutData((Object)new GridData(1808));
        btnComp.setLayout((Layout)new GridLayout());
        this.addBtn = new Button(btnComp, 8);
        this.addBtn.setText(AuthoringUIResources.PluginListDialog_button_add);
        this.addBtn.setLayoutData((Object)new GridData(768));
        this.removeBtn = new Button(btnComp, 8);
        this.removeBtn.setText(AuthoringUIResources.PluginListDialog_button_remove);
        this.removeBtn.setLayoutData((Object)new GridData(768));
        this.addListener();
        this.updateControls();
        return composite;
    }

    protected void updateControls() {
        if (this.readOnly) {
            this.addBtn.setEnabled(false);
            this.removeBtn.setEnabled(false);
            this.viewer.setInput((Object)this.methodPlugins);
        } else {
            this.viewer.setInput((Object)this.changedMethodPlugins);
        }
        this.viewer.refresh();
    }

    protected void addListener() {
        this.addBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] objs;
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(PluginListDialog.this.shell, (ILabelProvider)PluginListDialog.this.pluginsLabelProvider);
                dialog.setElements(PluginListDialog.this.getInputToAddDialog().toArray());
                dialog.setMultipleSelection(true);
                dialog.setMessage(AuthoringUIResources.PluginListDialog_addDialogMsg);
                dialog.setTitle(AuthoringUIResources.PluginListDialog_addDialogTitle);
                dialog.setImage(null);
                if (dialog.open() == 1) {
                    return;
                }
                Object[] objectArray = objs = dialog.getResult();
                int n = objs.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    PluginListDialog.this.changedMethodPlugins.add(obj);
                    ++n2;
                }
                PluginListDialog.this.updateControls();
            }
        });
        this.removeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)PluginListDialog.this.viewer.getSelection();
                if (selection.size() > 0) {
                    PluginListDialog.this.changedMethodPlugins.removeAll(selection.toList());
                }
                PluginListDialog.this.updateControls();
            }
        });
    }

    protected List getInputToAddDialog() {
        ArrayList elements = new ArrayList();
        MethodLibrary lib = LibraryEditUtil.getInstance().getCurrentMethodLibrary();
        if (lib != null) {
            List allMethodPluginsInLibrary = lib.getMethodPlugins();
            for (Object element : allMethodPluginsInLibrary) {
                if (this.changedMethodPlugins.contains(element)) continue;
                elements.add(element);
            }
        }
        return elements;
    }

    public List getResults() {
        if (this.readOnly) {
            return this.methodPlugins;
        }
        return this.changedMethodPlugins;
    }

    private class PluginListContentProvider
    implements ITreeContentProvider {
        private PluginListContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

