/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.providers.VariabilityElementLabelProvider;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.MoveInSectionListCommand;
import org.eclipse.epf.library.edit.util.SectionList;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class SectionsOrderDialog
extends Dialog {
    private Composite baseComposite;
    private Button ctrl_up;
    private Button ctrl_down;
    private Table ctrl_steps;
    private TableViewer stepsTableViewer;
    private SectionList allSections;
    private IStructuredContentProvider stepsViewerContentProvider;
    private ILabelProvider stepsViewerLabelProvider;
    private ContentElement contentElement;
    private IActionManager actionManager;
    private String title;
    private String message;
    private String label;
    private ArrayList commands = new ArrayList();

    public SectionsOrderDialog(Shell parent, ContentElement contentElement, IActionManager actionManager, String title, String message, String label) {
        super(parent);
        this.contentElement = contentElement;
        this.actionManager = actionManager;
        this.title = title;
        this.message = message;
        this.label = label;
        this.allSections = null;
    }

    protected Control createDialogArea(Composite parent) {
        this.baseComposite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.baseComposite.setLayout((Layout)gridLayout);
        this.baseComposite.setLayoutData((Object)new GridData());
        this.createLabel(this.baseComposite, this.message, 4);
        this.createLabel(this.baseComposite, " ", 4);
        this.createLabel(this.baseComposite, " ", 1);
        this.createLabel(this.baseComposite, this.label, 3);
        this.createLabel(this.baseComposite, " ", 1);
        this.ctrl_steps = new Table(this.baseComposite, 2050);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 300;
        gridData.heightHint = 400;
        this.ctrl_steps.setLayoutData((Object)gridData);
        this.initProviders();
        this.stepsTableViewer = new TableViewer(this.ctrl_steps);
        this.stepsTableViewer.setContentProvider((IContentProvider)this.stepsViewerContentProvider);
        this.stepsTableViewer.setLabelProvider((IBaseLabelProvider)this.stepsViewerLabelProvider);
        Composite orderButtonPane = new Composite(this.baseComposite, 0);
        GridData gridData2 = new GridData(68);
        gridData2.horizontalSpan = 1;
        orderButtonPane.setLayoutData((Object)gridData2);
        orderButtonPane.setLayout((Layout)new GridLayout());
        this.ctrl_up = this.createButton(orderButtonPane, AuthoringUIText.UP_BUTTON_TEXT);
        this.ctrl_up.setLayoutData((Object)new GridData(768));
        this.ctrl_down = this.createButton(orderButtonPane, AuthoringUIText.DOWN_BUTTON_TEXT);
        this.ctrl_down.setLayoutData((Object)new GridData(768));
        this.ctrl_up.setEnabled(false);
        this.ctrl_down.setEnabled(false);
        this.createLabel(this.baseComposite, " ", 4);
        this.createLine(this.baseComposite, 4);
        super.getShell().setText(this.title);
        this.addListeners();
        this.loadData();
        return this.baseComposite;
    }

    private void createLine(Composite parent, int ncol) {
        Label line = new Label(parent, 259);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = ncol;
        line.setLayoutData((Object)gridData);
    }

    private Label createLabel(Composite parent, String text, int nCol) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = nCol;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0);
        button.setText(label);
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void initProviders() {
        this.stepsViewerContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                if (SectionsOrderDialog.this.allSections == null) {
                    SectionsOrderDialog.this.allSections = new SectionList(SectionsOrderDialog.this.contentElement, 2);
                }
                return SectionsOrderDialog.this.allSections.toArray();
            }
        };
        this.stepsViewerLabelProvider = new VariabilityElementLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public boolean isExternal(Object element) {
                return !SectionsOrderDialog.this.contentElement.getPresentation().getSections().contains(element);
            }
        };
    }

    public void addListeners() {
        this.stepsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)SectionsOrderDialog.this.stepsTableViewer.getSelection();
                if (selection.size() > 0 && !TngUtil.isLocked((EObject)SectionsOrderDialog.this.contentElement)) {
                    if (SectionsOrderDialog.this.stepsTableViewer.getTable().getSelectionIndex() > 0 && !TngUtil.isLocked((EObject)SectionsOrderDialog.this.contentElement) && selection.size() == 1) {
                        SectionsOrderDialog.this.ctrl_up.setEnabled(true);
                    } else {
                        SectionsOrderDialog.this.ctrl_up.setEnabled(false);
                    }
                    if (SectionsOrderDialog.this.stepsTableViewer.getTable().getSelectionIndex() < SectionsOrderDialog.this.stepsTableViewer.getTable().getItemCount() - 1 && !TngUtil.isLocked((EObject)SectionsOrderDialog.this.contentElement) && selection.size() == 1) {
                        SectionsOrderDialog.this.ctrl_down.setEnabled(true);
                    } else {
                        SectionsOrderDialog.this.ctrl_down.setEnabled(false);
                    }
                }
            }
        });
        this.ctrl_up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)SectionsOrderDialog.this.stepsTableViewer.getSelection();
                ArrayList moveUpItems = new ArrayList();
                moveUpItems.addAll(selection.toList());
                MoveInSectionListCommand cmd = new MoveInSectionListCommand(SectionsOrderDialog.this.contentElement, moveUpItems, SectionsOrderDialog.this.allSections, 1);
                SectionsOrderDialog.this.actionManager.execute((IResourceAwareCommand)cmd);
                SectionsOrderDialog.this.commands.add(cmd);
                SectionsOrderDialog.this.stepsTableViewer.refresh();
                if (SectionsOrderDialog.this.stepsTableViewer.getTable().getSelectionIndex() > 0 && !TngUtil.isLocked((EObject)SectionsOrderDialog.this.contentElement)) {
                    SectionsOrderDialog.this.ctrl_up.setEnabled(true);
                } else {
                    SectionsOrderDialog.this.ctrl_up.setEnabled(false);
                }
                if (SectionsOrderDialog.this.stepsTableViewer.getTable().getSelectionIndex() < SectionsOrderDialog.this.stepsTableViewer.getTable().getItemCount() - 1 && !TngUtil.isLocked((EObject)SectionsOrderDialog.this.contentElement)) {
                    SectionsOrderDialog.this.ctrl_down.setEnabled(true);
                } else {
                    SectionsOrderDialog.this.ctrl_down.setEnabled(false);
                }
            }
        });
        this.ctrl_down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)SectionsOrderDialog.this.stepsTableViewer.getSelection();
                ArrayList moveDownItems = new ArrayList();
                moveDownItems.addAll(selection.toList());
                MoveInSectionListCommand cmd = new MoveInSectionListCommand(SectionsOrderDialog.this.contentElement, moveDownItems, SectionsOrderDialog.this.allSections, 0);
                SectionsOrderDialog.this.actionManager.execute((IResourceAwareCommand)cmd);
                SectionsOrderDialog.this.commands.add(cmd);
                SectionsOrderDialog.this.stepsTableViewer.refresh();
                if (SectionsOrderDialog.this.stepsTableViewer.getTable().getSelectionIndex() > 0 && !TngUtil.isLocked((EObject)SectionsOrderDialog.this.contentElement)) {
                    SectionsOrderDialog.this.ctrl_up.setEnabled(true);
                } else {
                    SectionsOrderDialog.this.ctrl_up.setEnabled(false);
                }
                if (SectionsOrderDialog.this.stepsTableViewer.getTable().getSelectionIndex() < SectionsOrderDialog.this.stepsTableViewer.getTable().getItemCount() - 1 && !TngUtil.isLocked((EObject)SectionsOrderDialog.this.contentElement)) {
                    SectionsOrderDialog.this.ctrl_down.setEnabled(true);
                } else {
                    SectionsOrderDialog.this.ctrl_down.setEnabled(false);
                }
            }
        });
    }

    private void loadData() {
        this.stepsTableViewer.setInput((Object)this.contentElement);
    }

    protected void okPressed() {
        this.allSections.apply();
        super.okPressed();
    }

    protected void cancelPressed() {
        if (!this.commands.isEmpty()) {
            int i = this.commands.size() - 1;
            while (i > -1) {
                Object cmd = this.commands.get(i);
                if (cmd instanceof MoveInSectionListCommand) {
                    ((MoveInSectionListCommand)cmd).undo();
                }
                --i;
            }
        }
        super.cancelPressed();
    }
}

