/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class StateEditDialog
extends Dialog {
    private Text name;
    private Text des;
    private boolean create;
    private String stateName;
    private String stateDes;

    public StateEditDialog(Shell shell, boolean create, String stateName, String stateDes) {
        super(shell);
        this.create = create;
        this.stateName = stateName;
        this.stateDes = stateDes;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(AuthoringUIResources.StateEditDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(AuthoringUIResources.StateEditDialog_label_name);
        this.name = new Text(composite, 2052);
        this.name.setLayoutData((Object)new GridData(768));
        Label desLabel = new Label(composite, 0);
        desLabel.setText(AuthoringUIResources.StateEditDialog_label_des);
        desLabel.setLayoutData((Object)new GridData(2));
        this.des = new Text(composite, 2626);
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        gd.heightHint = 100;
        this.des.setLayoutData((Object)gd);
        this.loadData();
        this.addListeners();
        return composite;
    }

    protected Control createContents(Composite parent) {
        Control con = super.createContents(parent);
        this.updateControls();
        return con;
    }

    protected void okPressed() {
        this.stateName = this.name.getText();
        this.stateDes = this.des.getText();
        super.okPressed();
    }

    private void loadData() {
        if (!this.create) {
            this.name.setText(this.stateName);
            this.des.setText(this.stateDes);
        }
    }

    private void updateControls() {
        String nameValue = this.name.getText();
        Button okBtn = this.getButton(0);
        if (okBtn != null) {
            if (nameValue == null || nameValue.length() == 0) {
                okBtn.setEnabled(false);
            } else {
                okBtn.setEnabled(true);
            }
        }
    }

    private void addListeners() {
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StateEditDialog.this.updateControls();
            }
        });
        this.name.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.character == ',') {
                    e.doit = false;
                }
            }
        });
    }

    public String getStateName() {
        return this.stateName;
    }

    public String getStateDes() {
        return this.stateDes;
    }
}

