/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import org.eclipse.epf.authoring.ui.editors.AbstractDiagramEditor;
import org.eclipse.epf.authoring.ui.editors.BreakdownElementEditorInput;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.util.Scope;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class SwitchConfigDialog {
    private Shell shell;
    private IEditorPart part;

    public SwitchConfigDialog(Shell shell, IEditorPart part) {
        this.shell = shell;
        this.part = part;
    }

    public void execute() {
        Display display;
        Display display2 = display = this.shell != null ? this.shell.getDisplay() : null;
        if (display == null) {
            display = MsgBox.getDisplay();
        }
        if (display == null) {
            return;
        }
        display.asyncExec(new Runnable(){

            public void run() {
                Object obj = null;
                if (SwitchConfigDialog.this.part instanceof AbstractDiagramEditor) {
                    if (((AbstractDiagramEditor)SwitchConfigDialog.this.part).isDisposed()) {
                        return;
                    }
                    BreakdownElementEditorInput input = (BreakdownElementEditorInput)SwitchConfigDialog.this.part.getEditorInput();
                    if (input.getSuppression().getProcess() != null) {
                        obj = input.getSuppression().getProcess().eContainer();
                    }
                } else if (SwitchConfigDialog.this.part instanceof ProcessEditor) {
                    if (((ProcessEditor)SwitchConfigDialog.this.part).isDisposed()) {
                        return;
                    }
                    obj = EditorChooser.getInstance().getMethodEditorInput(SwitchConfigDialog.this.part);
                }
                if (obj != null && obj instanceof ProcessComponent) {
                    MethodConfiguration recommendedConfig = ((ProcessComponent)obj).getProcess().getDefaultContext();
                    if (recommendedConfig instanceof Scope || recommendedConfig == null) {
                        return;
                    }
                    String switchConfigPref = LibraryUIPreferences.getSwitchConfig();
                    if ("never".equals(switchConfigPref)) {
                        return;
                    }
                    if (LibraryService.getInstance().getCurrentMethodConfiguration() != recommendedConfig) {
                        String configName = recommendedConfig.getName();
                        if ("prompt".equals(switchConfigPref)) {
                            MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)SwitchConfigDialog.this.shell, (String)LibraryUIResources.switchConfigDialog_title, (String)LibraryUIResources.bind((String)LibraryUIResources.switchConfigDialog_text, (Object)configName), null, (boolean)false, (IPreferenceStore)LibraryUIPlugin.getDefault().getPreferenceStore(), (String)LibraryUIPreferences.getSwitchConfigPreferenceKey());
                            if (dialog.getReturnCode() == 2) {
                                MethodConfiguration config = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)configName);
                                LibraryService.getInstance().setCurrentMethodConfiguration(config);
                            } else {
                                LibraryService.getInstance().setCurrentMethodConfiguration(LibraryService.getInstance().getCurrentMethodConfiguration());
                            }
                        } else if ("always".equals(switchConfigPref)) {
                            MethodConfiguration config = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)configName);
                            LibraryService.getInstance().setCurrentMethodConfiguration(config);
                        }
                    }
                }
            }
        });
    }

    public static void run(Shell shell, IEditorPart part) {
        SwitchConfigDialog dialog = new SwitchConfigDialog(Display.getCurrent().getActiveShell(), part);
        dialog.execute();
    }
}

