/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dnd;

import java.util.Iterator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class LibraryViewerDragAdapter
extends ViewerDragAdapter {
    public LibraryViewerDragAdapter(Viewer viewer) {
        super(viewer);
    }

    public void dragStart(DragSourceEvent event) {
        super.dragStart(event);
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        event.doit = false;
        Iterator iter = selection.toList().iterator();
        while (iter.hasNext()) {
            Object selectedElement = TngUtil.unwrap(iter.next());
            if (!(selectedElement instanceof MethodElement) || selectedElement instanceof MethodConfiguration || selectedElement instanceof ContentPackage) continue;
            event.doit = true;
        }
    }

    public void dragSetData(DragSourceEvent event) {
        if (HTMLTransfer.getInstance().isSupportedType(event.dataType) || TextTransfer.getInstance().isSupportedType(event.dataType)) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            String links = "";
            Iterator iter = selection.toList().iterator();
            while (iter.hasNext()) {
                Object selectedElement = TngUtil.unwrap(iter.next());
                if (!(selectedElement instanceof MethodElement)) continue;
                String linkText = this.getHyperlink((MethodElement)selectedElement);
                if (Platform.getOS().equals("win32")) {
                    if (links.length() > 0) {
                        links = String.valueOf(links) + StrUtil.LINE_FEED;
                    }
                    links = String.valueOf(links) + linkText;
                    continue;
                }
                if (links.length() > 0) {
                    links = String.valueOf(links) + StrUtil.LINE_FEED;
                }
                links = String.valueOf(links) + linkText;
            }
            if (links.length() > 0) {
                event.data = links;
            }
        }
        super.dragSetData(event);
    }

    protected String getHyperlink(MethodElement dragElement) {
        IEditorInput editorInput;
        MethodElement dropElement = null;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor != null && (editorInput = activeEditor.getEditorInput()) instanceof MethodElementEditorInput) {
            dropElement = ((MethodElementEditorInput)editorInput).getMethodElement();
        }
        if (dragElement instanceof ProcessComponent) {
            dragElement = ((ProcessComponent)dragElement).getProcess();
        }
        String href = ResourceHelper.getUrl((MethodElement)dragElement, dropElement, (String)".html");
        String defaultLinkType = AuthoringUIPlugin.getDefault().getPreferenceStore().getString("libViewDNDDefaultLinkType");
        String text = "";
        text = "elementLinkWithType".equals(defaultLinkType) ? ResourceHelper.getElementLinkText((MethodElement)dragElement, (boolean)true) : ResourceHelper.getElementLinkText((MethodElement)dragElement, (boolean)false);
        return ResourceHelper.getElementLink((MethodElement)dragElement, (String)text, (String)("file://" + href), (String)defaultLinkType);
    }
}

