/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.authoring.gef.edit.ActivityDetailDiagramEditPart;
import org.eclipse.epf.authoring.gef.edit.ActivityDetailDiagramEditPartFactory;
import org.eclipse.epf.authoring.gef.edit.DiagramUpdateService;
import org.eclipse.epf.authoring.gef.edit.FreeTextNodeEditPart;
import org.eclipse.epf.authoring.gef.util.DiagramUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.editors.AbstractDiagramEditor;
import org.eclipse.epf.authoring.ui.editors.BreakdownElementEditorInput;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.RoleTaskComposite;
import org.eclipse.epf.diagram.model.TaskNode;
import org.eclipse.epf.diagram.model.WorkProductDescriptorNode;
import org.eclipse.epf.diagram.model.util.IAdapterFactoryFilter;
import org.eclipse.epf.library.configuration.ProcessConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PanningSelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;

public class ActivityDetailDiagramEditor
extends AbstractDiagramEditor {
    private static final String RESET_DIAGRAM_LAYOUT = "reset_diagram_layout";
    private CreationFactory roleNodeCreationFactory;
    private CreationFactory taskNodeCreationFactory;
    private CreationFactory wpdNodeCreationFactory;
    private boolean initialCleanUp = false;
    private BreakdownAdapterFactory factory = null;

    protected EditPartFactory createEditPartFactory() {
        return new ActivityDetailDiagramEditPartFactory();
    }

    protected EditPart createDiagramEditPart() {
        return new ActivityDetailDiagramEditPart(ModelFactory.eINSTANCE.createActivityDetailDiagram());
    }

    protected String getPartNamePrefix() {
        return DiagramUIResources.ActivityDetailDiagram_prefix;
    }

    protected PaletteContainer createControlGroup(PaletteRoot root) {
        this.initializeCreationFactories();
        PaletteGroup controlGroup = new PaletteGroup("Control Group");
        ArrayList<Object> entries = new ArrayList<Object>();
        PanningSelectionToolEntry tool = new PanningSelectionToolEntry(DiagramUIResources.AbstractDiagram_Select_text, DiagramUIResources.AbstractDiagram_Select_tooltip);
        tool.setSmallIcon(AuthoringUIPlugin.getDefault().getImageDescriptor("select_pal16.gif"));
        tool.setLargeIcon(AuthoringUIPlugin.getDefault().getImageDescriptor("select_pal24.gif"));
        entries.add(tool);
        root.setDefaultEntry((ToolEntry)tool);
        tool = new MarqueeToolEntry();
        tool.setSmallIcon(AuthoringUIPlugin.getDefault().getImageDescriptor("marq_pal16.gif"));
        tool.setLargeIcon(AuthoringUIPlugin.getDefault().getImageDescriptor("marq_pal24.gif"));
        entries.add(tool);
        CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry(DiagramUIResources.AbstractDiagram_FreeText_text, DiagramUIResources.AbstractDiagram_FreeText_tooltip, (Object)"free text", this.freeTxtNodeCreationFactory, AuthoringUIPlugin.getDefault().getImageDescriptor("freetext_pal16.gif"), AuthoringUIPlugin.getDefault().getImageDescriptor("freetext_pal24.gif"));
        entries.add(combined);
        controlGroup.addAll(entries);
        return controlGroup;
    }

    protected void initializeCreationFactories() {
        super.initializeCreationFactories();
        if (this.roleNodeCreationFactory == null) {
            this.roleNodeCreationFactory = new CreationFactory(){

                public Object getNewObject() {
                    RoleTaskComposite node = ModelFactory.eINSTANCE.createRoleTaskComposite();
                    Diagram diagram = (Diagram)ActivityDetailDiagramEditor.this.editPart.getModel();
                    node.setUMADiagram(diagram.getUMADiagram());
                    node.setObject((Object)UmaFactory.eINSTANCE.createRoleDescriptor());
                    return node;
                }

                public Object getObjectType() {
                    return "role descriptor template";
                }
            };
        }
        CreationFactory creationFactory = this.roleNodeCreationFactory;
        this.templateNameToCreationFactoryMap.put(creationFactory.getObjectType(), creationFactory);
        if (this.taskNodeCreationFactory == null) {
            this.taskNodeCreationFactory = new CreationFactory(){

                public Object getNewObject() {
                    TaskNode node = ModelFactory.eINSTANCE.createTaskNode();
                    Diagram diagram = (Diagram)ActivityDetailDiagramEditor.this.editPart.getModel();
                    node.setUMADiagram(diagram.getUMADiagram());
                    node.setObject((Object)UmaFactory.eINSTANCE.createTaskDescriptor());
                    return node;
                }

                public Object getObjectType() {
                    return "task descriptor template";
                }
            };
        }
        creationFactory = this.taskNodeCreationFactory;
        this.templateNameToCreationFactoryMap.put(creationFactory.getObjectType(), creationFactory);
        if (this.wpdNodeCreationFactory == null) {
            this.wpdNodeCreationFactory = new CreationFactory(){

                public Object getNewObject() {
                    WorkProductDescriptorNode node = ModelFactory.eINSTANCE.createWorkProductDescriptorNode();
                    Diagram diagram = (Diagram)ActivityDetailDiagramEditor.this.editPart.getModel();
                    node.setUMADiagram(diagram.getUMADiagram());
                    node.setObject((Object)UmaFactory.eINSTANCE.createWorkProductDescriptor());
                    return node;
                }

                public Object getObjectType() {
                    return "task descriptor template";
                }
            };
        }
        creationFactory = this.wpdNodeCreationFactory;
        this.templateNameToCreationFactoryMap.put(creationFactory.getObjectType(), creationFactory);
    }

    public void setFocus() {
        super.setFocus();
        this.getGraphicalViewer().getContents().refresh();
        if (!this.initialCleanUp) {
            this.cleanUpDiagram();
            this.initialCleanUp = true;
            if (TngUtil.isLocked((EObject)this.getMethodElementFromInput())) {
                this.getCommandStack().flush();
                this.firePropertyChange(257);
            }
        }
    }

    protected String getDiagramType() {
        return "ActivityDetail";
    }

    public void cleanUpDiagram() {
        DiagramUpdateService service = new DiagramUpdateService(this.getGraphicalViewer(), this.getEditDomain(), this.getActionRegistry());
        service.cleanUpDiagram();
    }

    protected void contributeToContextMenu(IMenuManager menu) {
        super.contributeToContextMenu(menu);
        boolean canModify = !this.isReadOnly();
        IAction action = this.getActionRegistry().getAction((Object)RESET_DIAGRAM_LAYOUT);
        if (action.isEnabled() && canModify) {
            menu.insertBefore("delete_actvity_detail_diagram", action);
        }
    }

    protected void createActions() {
        super.createActions();
        Action resetLayoutAction = new Action(DiagramUIResources.ActivityDetailDiagramEditor_ResetDiagramLayout_text){

            public void run() {
                ActivityDetailDiagramEditor.this.getActionRegistry().getAction((Object)"refresh").run();
                if (ActivityDetailDiagramEditor.this.getGraphicalViewer().getContents() instanceof ActivityDetailDiagramEditPart) {
                    ActivityDetailDiagramEditPart dep = (ActivityDetailDiagramEditPart)ActivityDetailDiagramEditor.this.getGraphicalViewer().getContents();
                    ArrayList local = new ArrayList();
                    if (dep.getChildren() != null && !dep.getChildren().isEmpty()) {
                        for (Object next : dep.getChildren()) {
                            if (next instanceof FreeTextNodeEditPart) continue;
                            local.add(next);
                        }
                    }
                    dep.getRecentlyAddedParts().addAll(local);
                    ActivityDetailDiagramEditor.this.cleanUpDiagram();
                }
            }

            public boolean isEnabled() {
                return ActivityDetailDiagramEditor.this.getGraphicalViewer().getSelectedEditParts().size() == 0;
            }

            public String getId() {
                return ActivityDetailDiagramEditor.RESET_DIAGRAM_LAYOUT;
            }
        };
        this.getActionRegistry().registerAction((IAction)resetLayoutAction);
    }

    public void dispose() {
        if (this.factory != null) {
            this.factory.clear();
        }
        super.dispose();
    }

    public class BreakdownAdapterFactory {
        public ConfigurableComposedAdapterFactory wbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createWBSComposedAdapterFactory();
        public ConfigurableComposedAdapterFactory tbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createTBSComposedAdapterFactory();
        public ConfigurableComposedAdapterFactory wpbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createWPBSComposedAdapterFactory();
        public ConfigurableComposedAdapterFactory cbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createProcessComposedAdapterFactory();

        public BreakdownAdapterFactory(MethodConfiguration methodConfig) {
            DiagramAdapterFactoryFilter configurator = new DiagramAdapterFactoryFilter(methodConfig, this);
            this.wbsAdapterFactory.setFilter((IFilter)configurator);
            this.tbsAdapterFactory.setFilter((IFilter)configurator);
            this.wpbsAdapterFactory.setFilter((IFilter)configurator);
            this.cbsAdapterFactory.setFilter((IFilter)configurator);
        }

        public void clear() {
            if (this.wbsAdapterFactory != null) {
                this.wbsAdapterFactory.dispose();
                this.wbsAdapterFactory = null;
            }
            if (this.tbsAdapterFactory != null) {
                this.tbsAdapterFactory.dispose();
                this.tbsAdapterFactory = null;
            }
            if (this.wpbsAdapterFactory != null) {
                this.wpbsAdapterFactory.dispose();
                this.wpbsAdapterFactory = null;
            }
            if (this.cbsAdapterFactory != null) {
                this.cbsAdapterFactory.dispose();
                this.cbsAdapterFactory = null;
            }
        }
    }

    public class DiagramAdapterFactoryFilter
    extends ProcessConfigurator
    implements IAdapterFactoryFilter {
        private BreakdownAdapterFactory factory;

        public DiagramAdapterFactoryFilter(MethodConfiguration methodConfig, BreakdownAdapterFactory factory) {
            super(methodConfig);
            this.factory = factory;
        }

        public AdapterFactory getWBSAdapterFactory() {
            return this.factory.wbsAdapterFactory;
        }

        public AdapterFactory getTBSAdapterFactory() {
            return this.factory.tbsAdapterFactory;
        }

        public AdapterFactory getWPBSAdapterFactory() {
            return this.factory.wpbsAdapterFactory;
        }

        public AdapterFactory getCBSAdapterFactory() {
            return this.factory.cbsAdapterFactory;
        }

        public boolean accept(Object obj) {
            return super.accept(obj);
        }
    }

    public static class EditorInput
    extends BreakdownElementEditorInput {
        public EditorInput(Object e, Suppression suppression) {
            super(e, suppression);
        }
    }
}

