/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class AttributeStyledTextBox
implements ModifyListener {
    protected TextViewer viewer;
    protected EObject object;
    protected EAttribute attribute;
    private boolean checkEditOnContainer;
    private IActionManager actionMgr;

    public static final AttributeStyledTextBox createAttributeTextBox(Composite parent, int styles, EObject object, EAttribute attr, boolean checkEditOnContainer, IActionManager actionMgr) {
        return new AttributeStyledTextBox(parent, styles, object, attr, checkEditOnContainer, actionMgr);
    }

    protected AttributeStyledTextBox(Composite parent, int styles, EObject object, EAttribute attr, boolean checkEditOnContainer, IActionManager actionMgr) {
        assert (attr != null && attr.getEAttributeType().getInstanceClass().isAssignableFrom(String.class));
        this.object = object;
        this.attribute = attr;
        this.checkEditOnContainer = checkEditOnContainer;
        this.actionMgr = actionMgr;
        this.viewer = this.createViewer(parent, styles);
        StyledText control = this.viewer.getTextWidget();
        control.setIndent(2);
        control.addModifyListener((ModifyListener)this);
    }

    protected TextViewer createViewer(Composite parent, int styles) {
        TextViewer viewer = new TextViewer(parent, styles);
        viewer.setDocument((IDocument)new Document(this.getAttribute()));
        return viewer;
    }

    public void setElement(EObject object) {
        if (object != this.object) {
            this.object = object;
            this.setAttribute();
        }
    }

    protected void setAttribute() {
        this.setText(this.getAttribute());
    }

    protected void setText(String text) {
        StyledText textCtrl = this.viewer.getTextWidget();
        textCtrl.removeModifyListener((ModifyListener)this);
        try {
            textCtrl.setText(text);
        }
        finally {
            textCtrl.addModifyListener((ModifyListener)this);
        }
    }

    protected String getAttribute() {
        Object val = this.object.eGet((EStructuralFeature)this.attribute);
        return val == null ? "" : val.toString();
    }

    public TextViewer getViewer() {
        return this.viewer;
    }

    public void modifyText(ModifyEvent e) {
        StyledText textCtrl = this.viewer.getTextWidget();
        Shell shell = textCtrl.getShell();
        IStatus status = TngUtil.checkEdit((EObject)this.object, (Object)shell);
        if (status.isOK() && this.checkEditOnContainer && this.object.eContainer() != null) {
            status = TngUtil.checkEdit((EObject)this.object.eContainer(), (Object)shell);
        }
        if (status.isOK()) {
            this.actionMgr.doAction(1, this.object, (EStructuralFeature)this.attribute, (Object)textCtrl.getText(), -1);
        } else {
            int offset = textCtrl.getCaretOffset();
            this.setAttribute();
            this.viewer.setEditable(true);
            try {
                textCtrl.setCaretOffset(offset);
            }
            catch (Exception exception) {}
        }
    }
}

