/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AttributeTextBox
implements ModifyListener {
    protected EObject object;
    protected EAttribute attribute;
    private boolean checkEditOnContainer;
    private IActionManager actionMgr;
    protected Text textCtrl;

    public static final AttributeTextBox createAttributeTextBox(Text textCtrl, EObject object, EAttribute attr, boolean checkEditOnContainer, IActionManager actionMgr) {
        return new AttributeTextBox(textCtrl, object, attr, checkEditOnContainer, actionMgr);
    }

    protected AttributeTextBox(Text text, EObject object, EAttribute attr, boolean checkEditOnContainer, IActionManager actionMgr) {
        assert (attr != null && attr.getEAttributeType().getInstanceClass().isAssignableFrom(String.class));
        this.object = object;
        this.attribute = attr;
        this.checkEditOnContainer = checkEditOnContainer;
        this.actionMgr = actionMgr;
        this.textCtrl = text;
        text.addModifyListener((ModifyListener)this);
    }

    public void setElement(EObject object) {
        if (object != this.object) {
            this.object = object;
            this.setAttribute();
        }
    }

    protected void setAttribute() {
        this.setText(this.getAttribute());
    }

    protected void setText(String text) {
        this.textCtrl.removeModifyListener((ModifyListener)this);
        try {
            this.textCtrl.setText(text);
        }
        finally {
            this.textCtrl.addModifyListener((ModifyListener)this);
        }
    }

    protected String getAttribute() {
        Object val = this.object != null ? this.object.eGet((EStructuralFeature)this.attribute) : null;
        return val == null ? "" : val.toString();
    }

    public Text getTextControl() {
        return this.textCtrl;
    }

    public void modifyText(ModifyEvent e) {
        if (this.object != null) {
            Shell shell = this.textCtrl.getShell();
            IStatus status = TngUtil.checkEdit((EObject)this.object, (Object)shell);
            if (status.isOK() && this.checkEditOnContainer && this.object.eContainer() != null) {
                status = TngUtil.checkEdit((EObject)this.object.eContainer(), (Object)shell);
            }
            if (status.isOK()) {
                this.actionMgr.doAction(1, this.object, (EStructuralFeature)this.attribute, (Object)this.textCtrl.getText(), -1);
            } else {
                this.setAttribute();
                this.textCtrl.setEditable(true);
            }
        }
    }
}

