/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.epf.authoring.ui.AuthoringPerspective;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.actions.LibraryValidateAction;
import org.eclipse.epf.authoring.ui.editors.AbstractBaseFormEditor;
import org.eclipse.epf.authoring.ui.editors.IEditorKeeper;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.editors.MethodRichTextEditor;
import org.eclipse.epf.authoring.ui.editors.PreviewPage;
import org.eclipse.epf.authoring.ui.forms.ContentPackageDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.IRefreshable;
import org.eclipse.epf.authoring.ui.internal.MethodElementEditorErrorTickUpdater;
import org.eclipse.epf.authoring.ui.providers.IMethodElementEditorPageProviderExtension;
import org.eclipse.epf.authoring.ui.providers.MethodElementEditorDefaultPageProvider;
import org.eclipse.epf.authoring.ui.providers.MethodElementLabelDecorator;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.util.LibraryValidationMarkerHelper;
import org.eclipse.epf.authoring.ui.views.ElementHTMLViewer;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.common.ui.util.PerspectiveUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.ActionManager;
import org.eclipse.epf.library.edit.command.FullyRevertibleCommandStack;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.meta.TypeDefUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.MethodElementPropUtil;
import org.eclipse.epf.library.edit.util.PropUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.persistence.ILibraryResource;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.persistence.synch.ISynchronizationHelper;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.library.xmi.XMILibraryUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.LibrarySchedulingRule;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.views.properties.PropertySheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodElementEditor
extends AbstractBaseFormEditor
implements IGotoMarker,
IEditingDomainProvider {
    public static final String EDITOR_ID = MethodElementEditor.class.getName();
    protected int preview_page_index = -1;
    protected ElementHTMLViewer previewer = null;
    protected MethodElement elementObj = null;
    protected AdapterFactoryEditingDomain editingDomain;
    protected IMethodRichText modifiedRichText = null;
    protected Adapter elementChangedListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            switch (msg.getFeatureID(MethodElement.class)) {
                case 0: {
                    MethodElementEditor.this.nameChanged();
                }
            }
            switch (msg.getFeatureID(DescribableElement.class)) {
                case 12: {
                    MethodElementEditor.this.iconChanged();
                }
            }
        }
    };
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection currentSelection = StructuredSelection.EMPTY;
    protected ActionManager actionMgr;
    private boolean dirty;
    private ILibraryPersister.FailSafeMethodLibraryPersister persister;
    private Collection<Object> widgetsToRestoreValue = new HashSet<Object>();
    private long changeTime = -1L;
    public Object widgetToCheck;
    private Object currentFeatureEditor;
    private EStructuralFeature currentEditedFeature;
    protected ArrayList<Resource> removedResources = new ArrayList();
    protected ArrayList<Resource> changedResources = new ArrayList();
    protected MethodElementEditorErrorTickUpdater fMethodElementEditorErrorTickUpdater = null;
    public static final String METHOD_PAGE_PROVIDERS_EXTENSION_NAME = "MethodElementEditorPageProviders";
    protected static List<IMethodElementEditorPageProviderExtension> allPageProviders;
    protected static IMethodElementEditorPageProviderExtension defaultPageProvider;
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            System.out.println("MethodElementEditor.resourceChanged(): event = " + event);
            if (MethodElementEditor.this.elementObj.eIsProxy()) {
                return;
            }
            IResourceDelta delta = event.getDelta();
            try {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected Map URIToUsedResourceMap;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;

                    ResourceDeltaVisitor() {
                        this.URIToUsedResourceMap = MethodElementEditor.this.getURIToUsedResourceMap();
                        this.changedResources = new ArrayList<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        Resource resource;
                        if (delta.getFlags() != 131072 && delta.getResource().getType() == 1 && (delta.getKind() & 6) != 0 && (resource = (Resource)this.URIToUsedResourceMap.get(URI.createFileURI((String)delta.getResource().getLocation().toString()))) != null) {
                            if ((delta.getKind() & 2) != 0) {
                                this.removedResources.add(resource);
                            } else {
                                this.changedResources.add(resource);
                            }
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                MethodElementEditor.this.removedResources.addAll(visitor.getRemovedResources());
                if (!visitor.getRemovedResources().isEmpty() && !MethodElementEditor.this.isDirty()) {
                    MethodElementEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MethodElementEditor.this.dispose();
                        }
                    });
                }
                MethodElementEditor.this.changedResources.addAll(visitor.getChangedResources());
            }
            catch (CoreException e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
    };
    private ActivationListener activationListener;
    private boolean checkFileChangedRequired = false;
    protected HashSet<Resource> lastUsedResources;
    private boolean disposed;
    protected HashMap<Resource, ResourceInfo> resourceInfoMap = new HashMap();
    private IFile elementFile;
    private boolean updateResourceInfosCalled = false;

    public MethodElementEditor() {
        this.createEditorErrorTickUpdater();
        this.createActionManager();
    }

    protected void iconChanged() {
        SafeUpdateController.asyncExec((Runnable)new Runnable(){

            public void run() {
                MethodElementEditor.this.setTitleImage();
            }
        });
    }

    protected void createEditorErrorTickUpdater() {
        this.fMethodElementEditorErrorTickUpdater = new MethodElementEditorErrorTickUpdater(this);
    }

    protected ActionManager newActionManager() {
        return new MeEditorActionManager();
    }

    protected void createActionManager() {
        this.actionMgr = this.newActionManager();
        this.actionMgr.getCommandStack().addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MethodElementEditor.this.firePropertyChange(257);
                    }
                });
            }
        });
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null) {
            manager.startListeningTo(this.actionMgr.getCommandStack());
        }
    }

    private void nameChanged() {
        SafeUpdateController.asyncExec((Runnable)new Runnable(){

            public void run() {
                MethodElementEditor.this.setPartName();
                if (MethodElementEditor.this.pages != null) {
                    for (Object page : MethodElementEditor.this.pages) {
                        if (!(page instanceof IRefreshable)) continue;
                        ((IRefreshable)page).refreshName(MethodElementEditor.this.elementObj.getName());
                    }
                }
            }
        });
    }

    public IActionManager getActionManager() {
        return this.actionMgr;
    }

    protected void setTitleImage() {
        Image titleImage = ExtendedImageRegistry.getInstance().getImage(TngUtil.getImage((Object)this.elementObj));
        this.setTitleImage(titleImage);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        if (input instanceof FileEditorInput) {
            this.elementFile = ((FileEditorInput)input).getFile();
            MethodElement element = PersistenceUtil.getMethodElement((IResource)this.elementFile, (ResourceSet)LibraryService.getInstance().getCurrentLibraryManager().getEditingDomain().getResourceSet());
            if (element != null) {
                input = new MethodElementEditorInput(element);
            }
        }
        this.setInput(input);
        site.setSelectionProvider((ISelectionProvider)new MultiPageSelectionProvider((MultiPageEditorPart)this));
        this.activationListener = new ActivationListener(site.getWorkbenchWindow().getPartService());
        this.setTitleImage();
        CommandStack commandStack = this.actionMgr.getCommandStack();
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory(), commandStack){

            public boolean isReadOnly(Resource resource) {
                if (MethodElementEditor.this.elementObj != null && TngUtil.isLocked((EObject)MethodElementEditor.this.elementObj)) {
                    return true;
                }
                return super.isReadOnly(resource);
            }
        };
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        MethodElementEditorInput methodElementInput = (MethodElementEditorInput)input;
        this.elementObj = methodElementInput.getMethodElement();
        this.setPartName();
        this.elementObj.eAdapters().add((Object)this.elementChangedListener);
        if (this.fMethodElementEditorErrorTickUpdater != null) {
            this.fMethodElementEditorErrorTickUpdater.updateEditorImage(this.elementObj);
        }
    }

    public MethodElement getMethodElement() {
        return this.elementObj;
    }

    public void updateResourceInfos(Collection<Resource> resources) {
        this.updateResourceInfosCalled = true;
        if (this.resourceInfoMap == null) {
            this.resourceInfoMap = new HashMap();
        }
        for (Resource resource : resources) {
            ResourceInfo info = this.resourceInfoMap.get(resource);
            if (info == null) {
                info = new ResourceInfo(resource);
                this.resourceInfoMap.put(resource, info);
                continue;
            }
            info.refresh();
        }
        this.checkFileChangedRequired = true;
    }

    public void ovewriteResources(Collection<Resource> resources) {
        for (Resource resource : resources) {
            ResourceInfo info = this.resourceInfoMap.get(resource);
            if (info == null) continue;
            info.overwrite = true;
        }
    }

    public void setResourceInfos(Collection<Resource> resources) {
        if (this.resourceInfoMap != null && !this.resourceInfoMap.isEmpty()) {
            this.resourceInfoMap.clear();
        }
        this.updateResourceInfos(resources);
    }

    private long getLoadStamp(Resource resource) {
        ResourceInfo info = this.resourceInfoMap.get(resource);
        return info != null ? info.loadStamp : -1L;
    }

    private boolean checkReloaded(Collection usedResources) {
        ResourceSet resourceSet = MethodElementEditor.getResourceSet(usedResources);
        boolean xmi = resourceSet instanceof ILibraryResourceSet && ((ILibraryResourceSet)resourceSet).getPersistenceType().equals("xmi");
        for (Resource resource : usedResources) {
            long currentStamp;
            long oldStamp;
            if (!(resource instanceof ILibraryResource) || (oldStamp = this.getLoadStamp(resource)) == (currentStamp = ((ILibraryResource)resource).getLoadStamp())) continue;
            if (xmi) {
                IResource wsRes = FileManager.getResourceForLocation((String)resource.getURI().toFileString());
                if (wsRes == null) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private static ResourceSet getResourceSet(Collection resources) {
        ResourceSet resourceSet = null;
        for (Resource resource : resources) {
            resourceSet = resource.getResourceSet();
            if (resourceSet != null) break;
        }
        return resourceSet;
    }

    private Collection<Resource> getOutOfSyncResources(Collection<Resource> usedResources) {
        ArrayList<Resource> outOfSyncResources = new ArrayList<Resource>();
        for (Resource resource : usedResources) {
            if (!this.isOutOfSync(resource)) continue;
            outOfSyncResources.add(resource);
        }
        return outOfSyncResources;
    }

    private boolean isOutOfSync(Resource resource) {
        IFile file;
        ResourceInfo info = this.resourceInfoMap.get(resource);
        if (!this.updateResourceInfosCalled && info == null && (file = WorkspaceSynchronizer.getFile((Resource)resource)) != null) {
            return !file.isSynchronized(0);
        }
        long stamp = ISynchronizationHelper.INSTANCE.getModificationStamp(resource);
        if (stamp != -1L) {
            if (info == null || info.modificationStamp != stamp) {
                if (ISynchronizationHelper.INSTANCE.isSynchronized(resource)) {
                    if (info == null) {
                        this.resourceInfoMap.put(resource, new ResourceInfo(resource));
                    } else {
                        info.modificationStamp = ISynchronizationHelper.INSTANCE.getModificationStamp(resource);
                    }
                    return false;
                }
                return true;
            }
            return false;
        }
        return !ISynchronizationHelper.INSTANCE.isSynchronized(resource);
    }

    private boolean checkFileChanged(Collection usedResources) {
        ResourceSet resourceSet = MethodElementEditor.getResourceSet(usedResources);
        if (resourceSet instanceof ILibraryResourceSet && ((ILibraryResourceSet)resourceSet).getPersistenceType().equals("xmi")) {
            for (Resource resource : usedResources) {
                if (!this.isOutOfSync(resource)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean promptReloadFiles(Collection<Resource> usedResources) {
        if (this.checkFileChanged(usedResources)) {
            return this.promptReloadFiles();
        }
        return false;
    }

    protected boolean promptReloadFiles() {
        String title = AuthoringUIResources.editor_error_activated_outofsync_title;
        String msg = AuthoringUIResources.editor_error_activated_outofsync_message;
        return AuthoringUIPlugin.getDefault().getMsgDialog().displayPrompt(title, msg);
    }

    private boolean handleFileChanged(final Collection<Resource> usedResources) {
        boolean ret = this.promptReloadFiles(usedResources);
        if (ret) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("", 10);
                    monitor.subTask(AuthoringUIResources.refresh_text);
                    monitor.worked(1);
                    try {
                        ArrayList<Resource> removedResources = new ArrayList<Resource>();
                        for (Resource resource : usedResources) {
                            if (new File(resource.getURI().toFileString()).exists()) continue;
                            removedResources.add(resource);
                        }
                        Collection changedResources = MethodElementEditor.this.resourceInfoMap != null ? MethodElementEditor.this.getOutOfSyncResources(usedResources) : ResourceUtil.getOutOfSyncResources((Collection)usedResources);
                        monitor.worked(2);
                        PersistenceUtil.unload(removedResources);
                        monitor.worked(2);
                        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
                        if (manager != null) {
                            Collection reloadedResources = manager.reloadResources(changedResources);
                            if (!reloadedResources.isEmpty()) {
                                RefreshJob.getInstance().getReloadedBeforeRefreshResources().addAll(reloadedResources);
                            }
                            if (!removedResources.isEmpty() || !reloadedResources.isEmpty()) {
                                MethodElementEditor.this.changedResources.addAll(reloadedResources);
                                MethodElementEditor.this.lastUsedResources.removeAll(removedResources);
                                MethodElementEditor.this.refresh(true);
                                MethodElementEditor.this.changedResources.clear();
                            }
                        }
                        monitor.worked(4);
                        for (Resource resource : changedResources) {
                            FileManager.getInstance().refresh(resource);
                        }
                        monitor.worked(1);
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                this.getSite().getWorkbenchWindow().getWorkbench().getProgressService().runInUI((IRunnableContext)new ProgressMonitorDialog(this.getSite().getShell()), runnable, (ISchedulingRule)new LibrarySchedulingRule(LibraryService.getInstance().getCurrentMethodLibrary()));
            }
            catch (Exception e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                String title = AuthoringUIResources.ProcessEditor_refreshErrorTitle;
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, e.toString(), (Throwable)e);
            }
        } else {
            this.checkFileChangedRequired = false;
        }
        return ret;
    }

    public void setPartName() {
        String partName = this.elementObj.getName();
        if (partName == null) {
            partName = "";
        }
        this.setPartName(partName);
    }

    protected static List<IMethodElementEditorPageProviderExtension> getAllPageProviders() {
        if (allPageProviders == null) {
            allPageProviders = ExtensionManager.getExtensions((String)AuthoringUIPlugin.getDefault().getId(), (String)METHOD_PAGE_PROVIDERS_EXTENSION_NAME, IMethodElementEditorPageProviderExtension.class);
        }
        return allPageProviders;
    }

    protected IMethodElementEditorPageProviderExtension getDefaultPageProvider() {
        if (defaultPageProvider == null) {
            defaultPageProvider = new MethodElementEditorDefaultPageProvider();
        }
        return defaultPageProvider;
    }

    @Override
    protected void addPages() {
        block12: {
            Map<Object, String> pageMap = this.getDefaultPageProvider().getPages(new LinkedHashMap<Object, String>(), this, this.elementObj);
            List<IMethodElementEditorPageProviderExtension> pageProviders = MethodElementEditor.getAllPageProviders();
            if (pageProviders != null && pageProviders.size() > 0) {
                for (IMethodElementEditorPageProviderExtension iMethodElementEditorPageProviderExtension : pageProviders) {
                    pageMap = iMethodElementEditorPageProviderExtension.getPages(pageMap, this, this.elementObj);
                }
            }
            try {
                for (Map.Entry entry : pageMap.entrySet()) {
                    Object page = entry.getKey();
                    String name = (String)entry.getValue();
                    int index = -1;
                    if (page instanceof Control) {
                        index = this.addPage((Control)page);
                    } else if (page instanceof IFormPage) {
                        index = this.addPage((IFormPage)page);
                    } else if (page instanceof IEditorPart) {
                        index = this.addPage((IEditorPart)page, this.getEditorInput());
                    }
                    if (name == null) continue;
                    this.setPageText(index, name);
                }
                this.setPartName(this.elementObj.getName());
                if (!(this.elementObj instanceof ContentPackage) && !(this.elementObj instanceof MethodPlugin)) {
                    this.createPreviewPage();
                }
            }
            catch (Throwable throwable) {
                AuthoringUIPlugin.getDefault().getLogger().logError(throwable);
                this.dispose();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (!(throwable instanceof Error)) break block12;
                throw (Error)throwable;
            }
        }
    }

    @Override
    public void dispose() {
        try {
            if (this.activationListener != null) {
                this.activationListener.dispose();
            }
            this.modifiedRichText = null;
            this.disposeEditorErrorTickUpdater();
            ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
            if (manager != null) {
                manager.stopListeningTo(this.actionMgr.getCommandStack());
            }
            if (this.isDirty()) {
                this.actionMgr.undoAll();
            }
            this.actionMgr.dispose();
            this.elementObj.eAdapters().remove((Object)this.elementChangedListener);
            if (this.resourceInfoMap != null) {
                this.resourceInfoMap.clear();
                this.resourceInfoMap = null;
            }
            if (this.changedResources != null) {
                this.changedResources.clear();
                this.changedResources = null;
            }
            if (this.selectionChangedListeners != null) {
                this.selectionChangedListeners.clear();
                this.selectionChangedListeners = null;
            }
            PerspectiveUtil.isActivePerspective((String)AuthoringPerspective.PERSPECTIVE_ID);
            if (this.lastUsedResources != null) {
                this.lastUsedResources.clear();
                this.lastUsedResources = null;
            }
        }
        finally {
            super.dispose();
            this.disposed = true;
        }
    }

    protected void disposeEditorErrorTickUpdater() {
        if (this.fMethodElementEditorErrorTickUpdater != null) {
            this.fMethodElementEditorErrorTickUpdater.dispose();
            this.fMethodElementEditorErrorTickUpdater = null;
        }
    }

    @Override
    public boolean isDirty() {
        if (this.dirty) {
            return true;
        }
        this.dirty = this.actionMgr.isSaveNeeded();
        return this.dirty;
    }

    public ILibraryPersister.FailSafeMethodLibraryPersister getPersister() {
        if (this.persister == null) {
            this.persister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
        }
        return this.persister;
    }

    protected Collection<Resource> getModifiedResources() {
        return this.actionMgr.getModifiedResources();
    }

    public void setModifiedRichText(IMethodRichText modifiedRichText) {
        this.modifiedRichText = modifiedRichText;
    }

    public void saveModifiedRichText(IMethodRichText richText) {
        if (richText != null && !richText.isDisposed() && richText.getModified()) {
            Object oldContent;
            EObject modalObject = richText.getModalObject();
            EStructuralFeature modalObjectFeature = richText.getModalObjectFeature();
            if (modalObject != null && modalObjectFeature != null && !this.mustRestoreValue(richText, oldContent = TypeDefUtil.getInstance().eGet(modalObject, modalObjectFeature))) {
                String newContent = richText.getText();
                richText.setInitialText(newContent);
                if (!newContent.equals(oldContent)) {
                    this.actionMgr.doAction(1, modalObject, modalObjectFeature, (Object)newContent, -1);
                }
            }
        }
    }

    public void saveModifiedRichText() {
        this.saveModifiedRichText(this.modifiedRichText);
    }

    protected LibraryValidateAction createValidateResourceAction() {
        return new LibraryValidateAction(false){

            protected void refreshViews() {
                LibraryView.getView().refreshViews();
            }
        };
    }

    public boolean validateResources(Collection modifiedResources) {
        ArrayList elements = new ArrayList();
        for (Resource resource : modifiedResources) {
            if (!(resource instanceof MultiFileXMIResourceImpl)) continue;
            elements.addAll(resource.getContents());
        }
        LibraryValidateAction validateAction = this.createValidateResourceAction();
        validateAction.updateSelection((IStructuredSelection)new StructuredSelection(elements));
        validateAction.run();
        return validateAction.isSuccessful();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void doSave(IProgressMonitor monitor) {
        block35: {
            if (MethodElementEditor.DEBUG) {
                System.out.println("MethodElementEditor.doSave: saving changes to method library");
            }
            this.saveModifiedRichText(this.modifiedRichText);
            this.getPersister();
            try {
                block36: {
                    modifiedResources = this.getModifiedResources();
                    resourcesToSave = new ArrayList<Resource>(modifiedResources);
                    resourcesToUpdateVersionInfo = new HashSet<Resource>();
                    if (!modifiedResources.isEmpty()) {
                        for (Resource resource : modifiedResources) {
                            me = PersistenceUtil.getMethodElement((Resource)resource);
                            if (me == null || (lib = UmaUtil.getMethodLibrary((EObject)me)) == null || (libResource = lib.eResource()) == null || modifiedResources.contains(libResource) || resourcesToUpdateVersionInfo.contains(libResource) || PersistenceUtil.checkToolVersion((Resource)libResource) == 0) continue;
                            resourcesToUpdateVersionInfo.add(libResource);
                        }
                        resourcesToSave.addAll(resourcesToUpdateVersionInfo);
                    }
                    if (!(status = UserInteractionHelper.checkModify(resourcesToSave, (Object)this.getSite().getShell())).isOK()) {
                        this.handleError(status);
                        return;
                    }
                    if (this.checkFileChanged(resourcesToSave)) {
                        title = LibraryEditResources.update_outofsynch_title;
                        msg = LibraryEditResources.update_outofsynch_msg;
                        if (!AuthoringUIPlugin.getDefault().getMsgDialog().displayPrompt(title, msg)) {
                            return;
                        }
                    }
                    if (!resourcesToUpdateVersionInfo.isEmpty()) {
                        for (Resource resource : resourcesToUpdateVersionInfo) {
                            resource.setModified(true);
                        }
                    }
                    if (this.isValidateResourcesBeforeSaveRequired()) {
                        if (!this.validateResources(modifiedResources)) {
                            return;
                        }
                    } else if (LibraryValidationMarkerHelper.INSTANCE.hasMarkers(this.elementObj)) {
                        LibraryValidationMarkerHelper.INSTANCE.deleteMarkers(this.elementObj);
                        view = LibraryView.getView();
                        if (view != null) {
                            MethodElementLabelDecorator.clearDecorationCache();
                            view.getViewer().refresh();
                        }
                    }
                    oldValue = this.persister.getSaveOptions().get("OVERWRITABLE_RESOURCES");
                    resourcesToAdjustLocation = null;
                    if (!PropUtil.getPropUtil().isEdited(this.elementObj)) {
                        PropUtil.getPropUtil((IActionManager)this.getActionManager()).setEdited(this.elementObj, true);
                    }
                    try {
                        this.persister.getSaveOptions().put("OVERWRITABLE_RESOURCES", this.getOverwritableResources());
                        for (Resource resource : resourcesToSave) {
                            try {
                                this.persister.save(resource);
                            }
                            catch (Exception e) {
                                title = AuthoringUIResources.editors_MethodElementEditor_saveErrorTitle;
                                msg = AuthoringUIResources.editors_MethodElementEditor_saveErrorMessage1;
                                reason = e.getMessage() == null ? AuthoringUIResources.editors_MethodElementEditor_saveErrorReason1 : e.getMessage();
                                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, msg, reason, (Throwable)e);
                                throw e;
                            }
                        }
                        try {
                            this.persister.commit();
                            this.dirty = false;
                            this.actionMgr.saveIsDone();
                            MethodElementPropUtil.getMethodElementPropUtil().notifyElemetSaved(this.elementObj);
                            this.changeTime = -1L;
                            resourcesToAdjustLocation = this.getResourceToAdjustLocation();
                            this.setResourceInfos(this.getUsedResources());
                        }
                        catch (Exception e) {
                            reason = e.getMessage();
                            if (StrUtil.isBlank((String)reason)) {
                                reason = AuthoringUIResources.editors_MethodElementEditor_saveErrorReason2;
                            }
                            details = new StringWriter();
                            e.printStackTrace(new PrintWriter(details));
                            title = AuthoringUIResources.editors_MethodElementEditor_saveErrorTitle;
                            message = AuthoringUIResources.editors_MethodElementEditor_saveErrorMessage2;
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, message, reason, details.toString(), (Throwable)e);
                            throw e;
                        }
                    }
                    finally {
                        this.persister.getSaveOptions().put("OVERWRITABLE_RESOURCES", oldValue);
                    }
                    if (resourcesToAdjustLocation == null || resourcesToAdjustLocation.isEmpty()) break block35;
                    try {
                        this.persister.adjustLocation(resourcesToAdjustLocation);
                        break block36;
                    }
                    catch (Exception e) {
                        title = AuthoringUIResources.editors_MethodElementEditor_renameErrorTitle;
                        template = AuthoringUIResources.editors_MethodElementEditor_renameErrorMessage1;
                        fileList = new StringBuffer();
                        ** for (resource : resourcesToAdjustLocation)
                    }
lbl-1000:
                    // 1 sources

                    {
                        obj = FileManager.toFileString((URI)resource.getURI());
                        if (obj == null) {
                            obj = resource;
                        }
                        fileList.append((Object)obj).append(", ");
                        continue;
                    }
lbl97:
                    // 1 sources

                    msg = MessageFormat.format(template, new Object[]{fileList});
                    reason = e.getMessage() == null ? AuthoringUIResources.editors_MethodElementEditor_saveErrorReason1 : e.getMessage();
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, msg, reason, (Throwable)e);
                    throw e;
                }
                try {
                    this.persister.commit();
                }
                catch (Exception e) {
                    reason = e.getMessage();
                    if (StrUtil.isBlank((String)reason)) {
                        reason = AuthoringUIResources.editors_MethodElementEditor_saveErrorReason2;
                    }
                    details = new StringWriter();
                    e.printStackTrace(new PrintWriter(details));
                    title = AuthoringUIResources.editors_MethodElementEditor_renameErrorTitle;
                    message = AuthoringUIResources.editors_MethodElementEditor_saveErrorMessage2;
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, message, reason, details.toString(), (Throwable)e);
                    throw e;
                }
                resourcesToAdjustLocation.clear();
            }
            catch (Exception e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                try {
                    this.persister.rollback();
                }
                catch (Exception ex) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)ex);
                    ViewHelper.reloadCurrentLibaryOnRollbackError(this.getSite().getShell());
                }
            }
        }
    }

    private Collection<Resource> getOverwritableResources() {
        if (this.resourceInfoMap == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (ResourceInfo info : this.resourceInfoMap.values()) {
            if (!info.overwrite) continue;
            resources.add(info.resource);
        }
        return resources;
    }

    private Collection<Resource> getResourceToAdjustLocation() {
        if (this.resourceInfoMap == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (ResourceInfo info : this.resourceInfoMap.values()) {
            if (!info.adjustLocation) continue;
            resources.add(info.resource);
        }
        return resources;
    }

    protected boolean isValidateResourcesBeforeSaveRequired() {
        return false;
    }

    protected void saveResource(Resource resource) {
        if (resource != null && resource.isModified()) {
            try {
                this.getPersister().save(resource);
            }
            catch (Exception e) {
                String title = AuthoringUIResources.editors_MethodElementEditor_saveErrorTitle;
                String template = AuthoringUIResources.editors_MethodElementEditor_saveErrorMessage1;
                String msg = MessageFormat.format(template, resource.getURI().toFileString());
                String reason = e.getMessage() == null ? AuthoringUIResources.editors_MethodElementEditor_saveErrorReason1 : e.getMessage();
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, msg, reason, (Throwable)e);
            }
        }
    }

    protected void createPreviewPage() {
        Composite parent = this.getContainer();
        Composite previewComposite = new Composite(parent, 0);
        previewComposite.setLayout((Layout)new GridLayout());
        PreviewPage page = new PreviewPage(previewComposite);
        this.previewer = page.getPreviewViewer();
        this.preview_page_index = this.addPage((Control)previewComposite);
        this.setPageText(this.preview_page_index, AuthoringUIResources.previewPage_title);
    }

    protected void pageChange(int newPageIndex) {
        IViewPart propertiesView;
        Object page;
        super.pageChange(newPageIndex);
        if (this.preview_page_index == newPageIndex && this.previewer != null) {
            this.previewer.showElementContent(this.elementObj);
        }
        if ((page = this.pages.get(newPageIndex)) instanceof MultiPageEditorPart && (propertiesView = this.getEditorSite().getPage().findView("org.eclipse.ui.views.PropertySheet")) instanceof PropertySheet) {
            ((PropertySheet)propertiesView).partActivated((IWorkbenchPart)this);
        }
    }

    public void setDirty() {
        this.dirty = true;
        this.firePropertyChange(257);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mustRestoreValue(Object control, Object value) {
        boolean restore;
        if (this.widgetToCheck == control) {
            return true;
        }
        Object editControl = control;
        if (editControl instanceof MethodRichTextEditor) {
            editControl = ((MethodRichTextEditor)control).getRichTextControl();
        }
        if (!(restore = this.widgetsToRestoreValue.contains(editControl))) {
            Collection<Object> collection = this.widgetsToRestoreValue;
            synchronized (collection) {
                restore = this.widgetsToRestoreValue.contains(editControl);
            }
        }
        if (restore) {
            if (editControl instanceof Text) {
                Text text = (Text)editControl;
                text.setText((String)value);
            } else if (editControl instanceof IMethodRichText) {
                IMethodRichText richText = (IMethodRichText)editControl;
                richText.setText((String)value);
            }
            this.widgetsToRestoreValue.remove(editControl);
        }
        return restore;
    }

    public ModifyListener createModifyListener(EObject eObj) {
        return this.createModifyListener(eObj, false);
    }

    public ModifyListener createModifyListener(EObject eObj, boolean checkContainer) {
        return new ModifyListener(eObj, checkContainer);
    }

    public void setCurrentFeatureEditor(Object control, EStructuralFeature feature) {
        this.currentFeatureEditor = control;
        this.currentEditedFeature = feature;
    }

    protected void monitorChange() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.core.resources.refreshProviders");
        if (point == null) {
            return;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            if (DEBUG) {
                System.out.println("extension: UID=" + extension.getUniqueIdentifier() + ", " + extension);
            }
            ++i;
        }
    }

    private Map<Resource, ResourceInfo> getResourceInfoMap() {
        if (this.resourceInfoMap == null) {
            this.resourceInfoMap = new HashMap();
        }
        return this.resourceInfoMap;
    }

    public void addResourceToAdjustLocation(Resource resource) {
        ResourceInfo info = this.getResourceInfoMap().get(resource);
        if (info == null) {
            info = new ResourceInfo(resource);
            this.getResourceInfoMap().put(resource, info);
        }
        info.adjustLocation = true;
    }

    protected List getUsedFeatures() {
        return this.elementObj.eClass().getEAllStructuralFeatures();
    }

    public Collection<Resource> getUsedResources() {
        HashSet<Resource> resources = new HashSet<Resource>();
        Resource resource = this.elementObj.eResource();
        if (resource != null) {
            resources.add(resource);
        }
        List allFeatures = this.getUsedFeatures();
        int i = allFeatures.size() - 1;
        while (i > -1) {
            EStructuralFeature feature = (EStructuralFeature)allFeatures.get(i);
            if (feature.isMany()) {
                List values = (List)this.elementObj.eGet(feature);
                int j = values.size() - 1;
                while (j > -1) {
                    EObject value = (EObject)values.get(j);
                    if (value.eResource() != null) {
                        resources.add(value.eResource());
                    }
                    --j;
                }
            } else {
                Object value = this.elementObj.eGet(feature);
                if (value instanceof EObject && (resource = ((EObject)value).eResource()) != null) {
                    resources.add(resource);
                }
            }
            --i;
        }
        this.lastUsedResources = resources;
        return resources;
    }

    private Map getURIToUsedResourceMap() {
        HashMap<URI, Resource> map = new HashMap<URI, Resource>();
        for (Resource resource : this.getUsedResources()) {
            map.put(resource.getURI(), resource);
        }
        return map;
    }

    protected void handleError(IStatus status) {
        AuthoringUIPlugin.getDefault().getMsgDialog().display(AuthoringUIResources.errorDialog_title, AuthoringUIResources.editDialog_msgCannotEdit, status);
    }

    protected void handleActivate(IWorkbenchPart part) {
        XMILibraryUtil.openMethodLibraryProject((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (IProgressMonitor)this.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor());
        if (this.checkFileChangedRequired) {
            Collection<Resource> usedResources = this.getUsedResources();
            this.handleFileChanged(usedResources);
        }
    }

    protected boolean handleDirtyConflict() {
        String title = AuthoringUIResources._UI_FileConflict_label;
        String msg = AuthoringUIResources._WARN_FileConflict;
        return AuthoringUIPlugin.getDefault().getMsgDialog().displayPrompt(title, msg);
    }

    protected void handleChangedResources() {
        if ((this.elementObj.eIsProxy() || !this.changedResources.isEmpty()) && this.isDirty()) {
            this.handleDirtyConflict();
        }
    }

    public boolean isInputValid() {
        if (this.elementObj != null && this.elementObj.eIsProxy()) {
            EObject e = RefreshJob.getInstance().resolve((EObject)this.elementObj);
            return e instanceof MethodElement && !e.eIsProxy() && UmaUtil.getMethodLibrary((EObject)e) == LibraryService.getInstance().getCurrentMethodLibrary();
        }
        return true;
    }

    protected void updatePages() {
        while (this.getPageCount() > 0) {
            this.removePage(0);
        }
        this.addPages();
    }

    protected IEditorInput createInput(MethodElement e) {
        return new MethodElementEditorInput(e);
    }

    public synchronized void refresh(final boolean force) {
        BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                HashSet<Resource> usedResources = MethodElementEditor.this.lastUsedResources;
                if (!(force || MethodElementEditor.this.elementObj.eIsProxy() || MethodElementEditor.this.checkReloaded(usedResources))) {
                    return;
                }
                int activePageIndex = MethodElementEditor.this.getActivePage();
                MethodElementEditor.this.modifiedRichText = null;
                if (MethodElementEditor.this.isDirty()) {
                    MethodElementEditor.this.actionMgr.undoAll();
                    MethodElementEditor.this.dirty = false;
                }
                if (MethodElementEditor.this.elementObj.eIsProxy()) {
                    MethodElementEditor.this.elementObj.eAdapters().remove((Object)MethodElementEditor.this.elementChangedListener);
                    EObject e = RefreshJob.getInstance().resolve((EObject)MethodElementEditor.this.elementObj);
                    if (e instanceof MethodElement && !e.eIsProxy() && UmaUtil.getMethodLibrary((EObject)e) == LibraryService.getInstance().getCurrentMethodLibrary()) {
                        MethodElementEditor.this.setInput(MethodElementEditor.this.createInput((MethodElement)e));
                    } else {
                        MethodElementEditor.this.close(false);
                        return;
                    }
                }
                MethodElementEditor.this.setResourceInfos(usedResources);
                MethodElementEditor.this.updatePages();
                if (activePageIndex != -1) {
                    MethodElementEditor.this.setActivePage(activePageIndex);
                }
                MethodElementEditor.this.firePropertyChange(257);
            }
        });
    }

    public void refresh() {
        this.refresh(RefreshJob.getInstance().getChangedResources());
    }

    protected void refresh(Collection<Resource> changedResources) {
        this.changedResources.addAll(changedResources);
        this.refresh(false);
        this.changedResources.clear();
    }

    public void refreshTitleImage() {
        if (this.fMethodElementEditorErrorTickUpdater != null) {
            this.fMethodElementEditorErrorTickUpdater.updateEditorImage(this.elementObj);
        }
    }

    public void updatedTitleImage(Image image) {
        this.setTitleImage(image);
    }

    public void gotoMarker(IMarker marker) {
        if (marker.getResource() == this.elementFile) {
            try {
                Object val = marker.getAttribute("guid");
                if (val instanceof String) {
                    String guid = (String)val;
                    MethodElement e = LibraryService.getInstance().getCurrentLibraryManager().getMethodElement(guid);
                    if (e != this.elementObj) {
                        this.close(false);
                        IEditorKeeper.REFERENCE.getEditorKeeper().openEditor(e);
                        return;
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        this.setActivePage(0);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setFocus() {
        super.setFocus();
        Object obj = this.getSelectedPage();
        if (obj instanceof ContentPackageDescriptionPage) {
            ContentPackageDescriptionPage page = (ContentPackageDescriptionPage)obj;
            page.updateSupportingCheckbox();
        }
    }

    class ActivationListener
    implements IPartListener,
    IWindowListener {
        private IWorkbenchPart fActivePart;
        private boolean fIsHandlingActivation = false;
        private IPartService fPartService;

        public ActivationListener(IPartService partService) {
            this.fPartService = partService;
            this.fPartService.addPartListener((IPartListener)this);
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        }

        public void dispose() {
            this.fPartService.removePartListener((IPartListener)this);
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
            this.fPartService = null;
        }

        public void partActivated(IWorkbenchPart part) {
            this.fActivePart = part;
            this.handleActivation();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            this.fActivePart = null;
        }

        public void partOpened(IWorkbenchPart part) {
            if (part == MethodElementEditor.this) {
                if (!MethodElementEditor.this.isInputValid()) {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(AuthoringUIResources.editors_MethodElementEditor_invalidEditorTitle, AuthoringUIResources.editors_MethodElementEditor_invalidEditorMsg);
                    MethodElementEditor.this.close(false);
                    return;
                }
                Collection<Resource> usedResources = MethodElementEditor.this.getUsedResources();
                if (ResourceUtil.hasOutOfSynch(usedResources)) {
                    MethodElementEditor.this.handleFileChanged(usedResources);
                    return;
                }
                MethodElementEditor.this.setResourceInfos(usedResources);
            }
        }

        private void handleActivation() {
            if (this.fIsHandlingActivation || MethodElementEditor.this.disposed) {
                return;
            }
            if (this.fActivePart == MethodElementEditor.this) {
                this.fIsHandlingActivation = true;
                try {
                    MethodElementEditor.this.handleActivate(this.fActivePart);
                }
                finally {
                    this.fIsHandlingActivation = false;
                }
            }
        }

        public void windowActivated(IWorkbenchWindow window) {
            if (window == MethodElementEditor.this.getEditorSite().getWorkbenchWindow()) {
                window.getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ActivationListener.this.handleActivation();
                    }
                });
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }

    public class MeEditorActionManager
    extends ActionManager {
        protected void registerExecutedCommand(Command command) {
        }

        protected FullyRevertibleCommandStack createCommandStack() {
            return new FullyRevertibleCommandStack(this){

                public boolean doExecute(Command command) {
                    boolean ret;
                    MeEditorActionManager.this.registerExecutedCommand(command);
                    if (command instanceof IResourceAwareCommand) {
                        IStatus status;
                        Collection modifiedResources = ((IResourceAwareCommand)command).getModifiedResources();
                        if (modifiedResources != null && !modifiedResources.isEmpty() && !(status = UserInteractionHelper.checkModify((Collection)modifiedResources, (Object)MethodElementEditor.this.getSite().getShell())).isOK()) {
                            MethodElementEditor.this.handleError(status);
                            return false;
                        }
                    } else {
                        IStatus status;
                        EObject owner = TngUtil.getOwner((Command)command);
                        if (owner != null && !(status = TngUtil.checkEdit((EObject)owner, (Object)MethodElementEditor.this.getSite().getShell())).isOK()) {
                            AuthoringUIPlugin.getDefault().getMsgDialog().display(AuthoringUIResources.errorDialog_title, AuthoringUIResources.editDialog_msgCannotEdit, status);
                            return false;
                        }
                    }
                    if (MethodElementEditor.this.changeTime == -1L) {
                        MethodElementEditor.this.changeTime = System.currentTimeMillis();
                    }
                    if (!(ret = super.doExecute(command)) && MethodElementEditor.this.changeTime != -1L) {
                        MethodElementEditor.this.changeTime = -1L;
                    }
                    return ret;
                }
            };
        }

        public boolean doAction(int actionType, EObject object, EStructuralFeature feature, Object value, int index) {
            final IStatus status = TngUtil.checkEdit((EObject)object, (Object)MethodElementEditor.this.getSite().getShell());
            if (status.isOK()) {
                return super.doAction(actionType, object, feature, value, index);
            }
            SafeUpdateController.syncExec((Runnable)new Runnable(){

                public void run() {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.editDialog_title, AuthoringUIResources.editDialog_msgCannotEdit, status);
                }
            });
            return false;
        }

        protected void save(Resource resource) {
            block8: {
                File file;
                if (MethodElementEditor.this.changedResources.contains(resource)) {
                    return;
                }
                boolean canSave = resource.getURI().isFile() ? (file = new File(resource.getURI().toFileString())).lastModified() > MethodElementEditor.this.changeTime : true;
                try {
                    if (!canSave) break block8;
                    ILibraryPersister.FailSafeMethodLibraryPersister persister = MethodElementEditor.this.getPersister();
                    try {
                        persister.save(resource);
                        persister.commit();
                    }
                    catch (Exception e) {
                        AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                        try {
                            persister.rollback();
                        }
                        catch (Exception exception) {
                            ViewHelper.reloadCurrentLibaryOnRollbackError(MethodElementEditor.this.getEditorSite().getShell());
                        }
                    }
                }
                finally {
                    MethodElementEditor.this.changeTime = -1L;
                }
            }
        }
    }

    public class ModifyListener
    implements org.eclipse.swt.events.ModifyListener {
        private EObject element;
        private boolean checkContainerResource;
        private boolean disabled = false;
        private boolean forNameOnly = false;

        public ModifyListener(EObject element, boolean checkContainer) {
            this.checkContainerResource = checkContainer;
            this.element = element;
        }

        public boolean isForNameOnly() {
            return this.forNameOnly;
        }

        public void setForNameOnly(boolean forNameOnly) {
            this.forNameOnly = forNameOnly;
        }

        private void restoreText(Object control, String txt) {
            boolean old = this.disabled;
            try {
                this.disabled = true;
                Object editControl = control;
                if (editControl instanceof MethodRichTextEditor) {
                    editControl = ((MethodRichTextEditor)control).getRichTextControl();
                }
                if (editControl instanceof Text) {
                    Text text = (Text)editControl;
                    text.setText(txt);
                } else if (editControl instanceof IMethodRichText) {
                    IMethodRichText richText = (IMethodRichText)editControl;
                    richText.setText(txt);
                }
            }
            finally {
                this.disabled = old;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean checkEdit(EObject element, Object control, boolean checkContainerResource) {
            if (MethodElementEditor.this.widgetToCheck == control) {
                return true;
            }
            MethodElementEditor.this.widgetToCheck = control;
            try {
                if (DEBUG) {
                    System.out.println("MethodElementEditor.checkEdit: enter, control=" + control);
                }
                IStatus status = null;
                if (MethodElementEditor.this.widgetsToRestoreValue.contains(control)) {
                    if (DEBUG) {
                        System.out.println("MethodElementEditor.checkEdit: widget found in widgetsToRestoreValue, exit");
                    }
                    return false;
                }
                Collection collection = MethodElementEditor.this.widgetsToRestoreValue;
                synchronized (collection) {
                    if (MethodElementEditor.this.widgetsToRestoreValue.contains(control)) {
                        if (!DEBUG) return false;
                        System.out.println("MethodElementEditor.checkEdit: widget found in widgetsToRestoreValue, exit");
                        return false;
                    }
                    status = TngUtil.checkEdit((EObject)element, (Object)MethodElementEditor.this.getSite().getShell());
                    if (status.isOK() && this.isForNameOnly() && element instanceof DescribableElement) {
                        ContentDescription presentation = ((DescribableElement)element).getPresentation();
                        status = TngUtil.checkEdit((EObject)presentation, (Object)MethodElementEditor.this.getSite().getShell());
                    }
                    if (!status.isOK()) {
                        if (control instanceof IRichText) {
                            ((IRichText)control).restoreText();
                        } else if (control == MethodElementEditor.this.currentFeatureEditor) {
                            this.restoreText(control, (String)element.eGet(MethodElementEditor.this.currentEditedFeature));
                        } else {
                            MethodElementEditor.this.widgetsToRestoreValue.add(control);
                            if (DEBUG) {
                                System.out.println("MethodElementEditor.checkEdit: added widget to widgetsToRestoreValue");
                            }
                        }
                    } else if (checkContainerResource && element.eContainer() != null && element.eContainer().eResource() != element.eResource() && !(status = TngUtil.checkEdit((EObject)element.eContainer(), (Object)MethodElementEditor.this.getSite().getShell())).isOK()) {
                        if (control instanceof IRichText) {
                            ((IRichText)control).restoreText();
                        } else if (control == MethodElementEditor.this.currentFeatureEditor) {
                            this.restoreText(control, (String)element.eGet(MethodElementEditor.this.currentEditedFeature));
                        } else {
                            MethodElementEditor.this.widgetsToRestoreValue.add(control);
                        }
                    }
                }
                if (status == null || status.isOK()) return true;
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.editDialog_title, AuthoringUIResources.editDialog_msgCannotEdit, status);
                return false;
            }
            finally {
                MethodElementEditor.this.widgetToCheck = null;
            }
        }

        public void modifyText(ModifyEvent e) {
            if (DEBUG) {
                System.out.println("MethodElementEditor.ModifyListener.modifyText: enter, disabled=" + this.disabled);
            }
            if (!this.disabled && this.element != null) {
                ContentDescription content;
                EObject containder;
                if (e.widget == null) {
                    return;
                }
                Object widget = e.widget;
                if (widget instanceof Browser && (widget = ((Browser)widget).getData("richText")) == null) {
                    widget = e.widget;
                }
                if (DEBUG) {
                    System.out.println("MethodElementEditor.ModifyListener.modifyText: widget=" + widget);
                }
                if (MethodElementEditor.this.widgetsToRestoreValue.contains(widget)) {
                    if (DEBUG) {
                        System.out.println("MethodElementEditor.ModifyListener.modifyText: widget found in widgetsToRestoreValue, exit");
                    }
                    return;
                }
                boolean checkParent = this.checkContainerResource;
                if (this.element instanceof ContentDescription && (containder = (content = (ContentDescription)this.element).eContainer()) instanceof DescribableElement) {
                    DescribableElement parent = (DescribableElement)containder;
                    if (!PropUtil.getPropUtil().isEdited((MethodElement)parent)) {
                        checkParent = true;
                    }
                }
                if (!this.checkEdit(this.element, widget, checkParent)) {
                    if (DEBUG) {
                        System.out.println("MethodElementEditor.ModifyListener.modifyText: checkEdit failed, exit");
                    }
                    return;
                }
                if (widget instanceof IMethodRichText) {
                    IMethodRichText richText = (IMethodRichText)widget;
                    MethodElementEditor.this.setModifiedRichText(richText);
                    if (DEBUG) {
                        System.out.println("MethodElementEditor.ModifyListener.modifyText: adding to modifiedRichTexts list");
                    }
                }
                if (DEBUG) {
                    System.out.println("MethodElementEditor.ModifyListener.modifyText: marking editor as dirty");
                }
                MethodElementEditor.this.setDirty();
            }
            if (DEBUG) {
                System.out.println("MethodElementEditor.ModifyListener.modifyText: exit");
            }
        }

        public void setElement(EObject element) {
            this.element = element;
        }

        public void setDisable(boolean disabled) {
            this.disabled = disabled;
        }
    }

    protected static class ResourceInfo {
        long modificationStamp;
        long loadStamp;
        boolean overwrite;
        boolean adjustLocation;
        private Resource resource;

        ResourceInfo(Resource resource) {
            this.resource = resource;
            this.refresh();
        }

        public void refresh() {
            this.modificationStamp = ISynchronizationHelper.INSTANCE.getModificationStamp(this.resource);
            this.loadStamp = this.resource instanceof ILibraryResource ? ((ILibraryResource)this.resource).getLoadStamp() : -1L;
        }
    }
}

