/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.authoring.ui.forms.BaseFormPage;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.richtext.MethodRichTextContext;
import org.eclipse.epf.authoring.ui.util.MethodRichTextMarkerHelper;
import org.eclipse.epf.common.IHTMLFormatter;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.layout.RichTextContentValidator;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.richtext.RichText;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class MethodRichText
extends RichText
implements IMethodRichText {
    private MethodElement methodElement;
    private ContentDescription contentDescription;
    private EObject modalObject;
    private EStructuralFeature modalObjectFeature;
    protected Resource resource;
    protected Label label;
    protected ControlDecoration controlDecoration;
    protected final Image errorFieldDecorationImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
    protected String fieldName = "";
    protected String fieldNameTrim;
    protected MethodRichTextMarkerHelper markerHelper;

    public MethodRichText(Composite parent, int style, String basePath) {
        super(parent, style, basePath);
    }

    public MethodRichText(MethodRichTextContext context) {
        this(context.getParent(), context.getStyle(), context.getBasePath());
    }

    public String tidyText(String text) {
        return ResourceHelper.validateRichTextContent((MethodElement)this.methodElement, (String)text, (IContentValidator)new RichTextContentValidator());
    }

    public void setMethodElement(MethodElement methodElement) {
        this.methodElement = methodElement;
        if (this.methodElement instanceof ProcessComponent) {
            this.methodElement = ((ProcessComponent)this.methodElement).getProcess();
        }
        if (this.methodElement instanceof DescribableElement) {
            this.contentDescription = ((DescribableElement)this.methodElement).getPresentation();
        } else if (this.methodElement instanceof ContentDescription) {
            this.contentDescription = (ContentDescription)this.methodElement;
        }
    }

    public MethodElement getMethodElement() {
        return this.methodElement;
    }

    public EObject getModalObject() {
        return this.modalObject;
    }

    public void setModalObject(EObject modalObject) {
        this.modalObject = modalObject;
    }

    public EStructuralFeature getModalObjectFeature() {
        return this.modalObjectFeature;
    }

    public void setModalObjectFeature(EStructuralFeature modalObjectFeature) {
        this.modalObjectFeature = modalObjectFeature;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setDecoratedFieldLabel(Label label) {
        this.label = label;
        if (label != null) {
            Object data = label.getData(BaseFormPage.LABEL_DECORATOR_KEY);
            if (data instanceof ControlDecoration) {
                this.controlDecoration = (ControlDecoration)data;
                this.controlDecoration.setImage(this.errorFieldDecorationImage);
                this.controlDecoration.hide();
            }
            this.updateFieldNameFromLabel(label);
        }
    }

    private boolean updateFieldNameFromLabel(Label label) {
        String fieldName;
        if (label != null && !this.fieldName.equals(fieldName = label.getText())) {
            this.fieldName = fieldName;
            int colonIndex = fieldName.indexOf(58);
            if (colonIndex == -1) {
                colonIndex = fieldName.length();
            }
            this.fieldNameTrim = fieldName.substring(0, colonIndex).trim();
            return true;
        }
        return false;
    }

    public void init(MethodElement element, Label label) {
        this.setMethodElement(element);
        this.setDecoratedFieldLabel(label);
        this.markerHelper = MethodRichTextMarkerHelper.INSTANCE;
    }

    protected String formatHTML(String text) {
        try {
            this.clearMarkers();
            String formattedText = this.htmlFormatter.formatHTML(text);
            if (this.htmlFormatter.getLastErrorStr() != null) {
                String errorString = this.htmlFormatter.getLastErrorStr();
                try {
                    this.createMarker(errorString);
                }
                catch (CoreException cex) {
                    this.logger.logError((Throwable)cex);
                }
            }
            return formattedText;
        }
        catch (UnsupportedEncodingException e) {
            this.logger.logError((Throwable)e);
            return text;
        }
    }

    protected void clearMarkers() {
        this.markerHelper.deleteMarkers(this.contentDescription, this.fieldNameTrim);
        this.setErrorDescription("");
        this.hideErrorDecoration();
        this.refreshDecorators();
    }

    protected void setErrorDescription(String text) {
        if (this.controlDecoration != null) {
            this.controlDecoration.setDescriptionText(text);
        }
    }

    protected void refreshDecorators() {
    }

    protected void createMarker(String fullErrMsg) throws CoreException {
        Matcher m;
        if (this.contentDescription.eContainer() instanceof DescribableElement && (m = IHTMLFormatter.jTidyErrorParser.matcher(fullErrMsg)).find()) {
            String location = m.group(1);
            String errorMsg = m.group(4);
            BasicDiagnostic diagnostics = new BasicDiagnostic("org.eclipse.epf.common.IHTMLFormatter", 0, "", new Object[]{this.contentDescription, this.fieldNameTrim});
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, location, 0, errorMsg, new Object[]{this.contentDescription, this.fieldNameTrim}));
            this.markerHelper.createMarkers((Diagnostic)diagnostics);
            this.setErrorDescription(errorMsg);
            this.showErrorDecoration();
            this.refreshDecorators();
        }
    }

    public void dispose() {
        super.dispose();
        this.clearMarkers();
        this.refreshDecorators();
    }

    public void showErrorDecoration() {
        if (this.controlDecoration != null) {
            this.controlDecoration.show();
        }
    }

    public void hideErrorDecoration() {
        if (this.controlDecoration != null) {
            this.controlDecoration.hide();
        }
    }

    public void setText(String text) {
        if (this.updateFieldNameFromLabel(this.label)) {
            this.hideErrorDecoration();
        }
        super.setText(text);
    }
}

