/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.actions.IWorkbenchPartAction;
import org.eclipse.epf.authoring.ui.actions.LibraryValidateAction;
import org.eclipse.epf.authoring.ui.dnd.EditingDomainTableTreeViewerDropAdapter;
import org.eclipse.epf.authoring.ui.editors.ActivityDetailDiagramEditor;
import org.eclipse.epf.authoring.ui.editors.ColumnDescriptor;
import org.eclipse.epf.authoring.ui.editors.GraphicalWPDependencyEditor;
import org.eclipse.epf.authoring.ui.editors.GraphicalWorkflowEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.editors.ProcessEditorInput;
import org.eclipse.epf.authoring.ui.forms.DeliveryProcessDescription;
import org.eclipse.epf.authoring.ui.forms.ProcessBreakdownStructureFormPage;
import org.eclipse.epf.authoring.ui.forms.ProcessDescription;
import org.eclipse.epf.authoring.ui.properties.EPFPropertySheetPage;
import org.eclipse.epf.authoring.ui.providers.IMethodElementEditorPageProviderExtension;
import org.eclipse.epf.authoring.ui.util.ProcessEditorUtil;
import org.eclipse.epf.authoring.ui.views.ProcessViewer;
import org.eclipse.epf.common.preferences.IPreferenceStoreWrapper;
import org.eclipse.epf.common.preferences.IPropertyChangeEventWrapper;
import org.eclipse.epf.common.preferences.IPropertyChangeListenerWrapper;
import org.eclipse.epf.diagram.core.part.AbstractDiagramEditor;
import org.eclipse.epf.diagram.core.part.DiagramEditorInput;
import org.eclipse.epf.diagram.core.part.DiagramEditorInputProxy;
import org.eclipse.epf.diagram.ui.service.DiagramEditorHelper;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.ProcessAuthoringConfigurator;
import org.eclipse.epf.library.edit.IAdapterFactoryProvider;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.ActionManager;
import org.eclipse.epf.library.edit.command.CommandStackChangedEvent;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.meta.TypeDefUtil;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.ActivityDropCommand;
import org.eclipse.epf.library.edit.realization.IRealizationManager;
import org.eclipse.epf.library.edit.ui.IActionTypeProvider;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.DescriptorPropUtil;
import org.eclipse.epf.library.edit.util.EditingDomainComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.ProcessScopeUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.prefs.PreferenceUtil;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.edit.domain.TraceableAdapterFactoryEditingDomain;
import org.eclipse.epf.uma.util.Scope;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessEditor
extends MethodElementEditor
implements IEditingDomainProvider,
IMenuListener,
ISelectionProvider,
IViewerProvider,
ITabbedPropertySheetPageContributor {
    public static final String EDITOR_ID = ProcessEditor.class.getName();
    public static final String WORKFLOW_EDITOR_ID = GraphicalWorkflowEditor.class.getName();
    public static final String ACTIVITY_DETAIL_DIAGRAM_EDITOR_ID = ActivityDetailDiagramEditor.class.getName();
    public static final String WPDEPENDENCY_EDITOR_ID = GraphicalWPDependencyEditor.class.getName();
    public static final ColumnDescriptor COL_DESC_NAME = new ColumnDescriptor("name", ProcessUtil.getColumnDisplayName((String)"name"), 3, 200, true, 1);
    public static final ColumnDescriptor COL_DESC_ID = new ColumnDescriptor("id", ProcessUtil.getColumnDisplayName((String)"id"), 0, 40, true, 0);
    public static final ColumnDescriptor COL_DESC_PREFIX = new ColumnDescriptor("prefix", ProcessUtil.getColumnDisplayName((String)"prefix"), 0, 80, true, 1);
    public static final ColumnDescriptor COL_DESC_MODEL_INFO = new ColumnDescriptor("model_info", ProcessUtil.getColumnDisplayName((String)"model_info"), 0, 120, true, 0);
    public static final ColumnDescriptor COL_DESC_TYPE = new ColumnDescriptor("type", ProcessUtil.getColumnDisplayName((String)"type"), 0, 80, true, 0);
    public static final ColumnDescriptor COL_DESC_PREDECESSORS = new ColumnDescriptor("predecessors", ProcessUtil.getColumnDisplayName((String)"predecessors"), 2, 100, true, 1);
    public static final ColumnDescriptor COL_DESC_IS_REPEATABLE = new ColumnDescriptor("is_repeatable", ProcessUtil.getColumnDisplayName((String)"is_repeatable"), 1, 60, true, 3);
    public static final ColumnDescriptor COL_DESC_IS_ONGOING = new ColumnDescriptor("is_ongoing", ProcessUtil.getColumnDisplayName((String)"is_ongoing"), 1, 60, true, 3);
    public static final ColumnDescriptor COL_DESC_IS_EVENT_DRIVEN = new ColumnDescriptor("is_event_driven", ProcessUtil.getColumnDisplayName((String)"is_event_driven"), 1, 60, true, 3);
    public static final ColumnDescriptor COL_DESC_TEAM = new ColumnDescriptor("teams", ProcessUtil.getColumnDisplayName((String)"teams"), 1, 100, true, 1);
    public static final ColumnDescriptor COL_DESC_ENTRY_STATE = new ColumnDescriptor("entry_state", ProcessUtil.getColumnDisplayName((String)"entry_state"), 1, 60, true, 1);
    public static final ColumnDescriptor COL_DESC_EXIT_STATE = new ColumnDescriptor("exit_state", ProcessUtil.getColumnDisplayName((String)"exit_state"), 1, 60, true, 1);
    public static final ColumnDescriptor COL_DESC_PRESENTATION_NAME = new ColumnDescriptor("presentation_name", ProcessUtil.getColumnDisplayName((String)"presentation_name"), 3, 200, true, 1);
    public static final ColumnDescriptor COL_DESC_DELIVERABLE = new ColumnDescriptor("deliverable", ProcessUtil.getColumnDisplayName((String)"deliverable"), 1, 100, true, 1);
    public static final ColumnDescriptor COL_DESC_IS_OPTIONAL = new ColumnDescriptor("is_optional", ProcessUtil.getColumnDisplayName((String)"is_optional"), 1, 60, true, 3);
    public static final ColumnDescriptor COL_DESC_IS_PLANNED = new ColumnDescriptor("is_planned", ProcessUtil.getColumnDisplayName((String)"is_planned"), 1, 60, true, 3);
    public static final ColumnDescriptor COL_DESC_HAS_MULTIPLE_OCCURRENCES = new ColumnDescriptor("has_multiple_occurrences", ProcessUtil.getColumnDisplayName((String)"has_multiple_occurrences"), 1, 60, true, 3);
    public static final String WBS_FORM_ID = "wbs";
    public static final String TA_FORM_ID = "tbs";
    public static final String WPBS_FORM_ID = "wpbs";
    public static final String CONSOLIDATED_FORM_ID = "consolidated";
    DiagramEditorHelper diagramEditorHelper = null;
    public static final List<ColumnDescriptor> DEFAULT_TBS_COLUMNS = Arrays.asList(COL_DESC_PRESENTATION_NAME, COL_DESC_MODEL_INFO, COL_DESC_TEAM, COL_DESC_TYPE, COL_DESC_IS_PLANNED, COL_DESC_HAS_MULTIPLE_OCCURRENCES, COL_DESC_IS_OPTIONAL);
    public static final List DEFAULT_WPBS_COLUMNS = Arrays.asList(COL_DESC_PRESENTATION_NAME, COL_DESC_MODEL_INFO, COL_DESC_ENTRY_STATE, COL_DESC_EXIT_STATE, COL_DESC_DELIVERABLE, COL_DESC_TYPE, COL_DESC_IS_PLANNED, COL_DESC_HAS_MULTIPLE_OCCURRENCES, COL_DESC_IS_OPTIONAL);
    public static final List<ColumnDescriptor> DEFAULT_WBS_COLUMNS = Arrays.asList(COL_DESC_PRESENTATION_NAME, COL_DESC_ID, COL_DESC_PREDECESSORS, COL_DESC_MODEL_INFO, COL_DESC_TYPE, COL_DESC_IS_PLANNED, COL_DESC_IS_REPEATABLE, COL_DESC_HAS_MULTIPLE_OCCURRENCES, COL_DESC_IS_ONGOING, COL_DESC_IS_EVENT_DRIVEN, COL_DESC_IS_OPTIONAL);
    public static final List<ColumnDescriptor> ALL_WBS_COLUMNS = new ArrayList<ColumnDescriptor>(DEFAULT_WBS_COLUMNS);
    public static final List<ColumnDescriptor> ALL_TBS_COLUMNS = new ArrayList<ColumnDescriptor>(DEFAULT_TBS_COLUMNS);
    public static final List<ColumnDescriptor> ALL_WPBS_COLUMNS = new ArrayList<ColumnDescriptor>(DEFAULT_WPBS_COLUMNS);
    public static final Map<String, ColumnDescriptor> idToColumnDescriptorMap = new HashMap<String, ColumnDescriptor>();
    protected static boolean addAdapterFactoryListeners;
    protected ComposedAdapterFactory adapterFactory;
    protected AdapterFactoryEditingDomain editingDomain;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection selectionChangedListeners = new ArrayList();
    protected ISelection viewSelection;
    protected ProcessComponent selectedProcessComponent;
    protected Process selectedProcess;
    protected Adapter processComponentListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            switch (msg.getFeatureID(ProcessComponent.class)) {
                case 0: {
                    String name = msg.getNewStringValue();
                    if (name == null) {
                        name = "";
                    }
                    ProcessEditor.this.setPartName(name);
                    if (ProcessEditor.this.pages == null) break;
                    for (Object page : ProcessEditor.this.pages) {
                        if (!(page instanceof ProcessDescription)) continue;
                        ((ProcessDescription)page).refreshElementName(name);
                    }
                    break;
                }
            }
        }
    };
    protected AdapterFactoryContentProvider propContentProvider;
    protected MethodConfiguration currentConfig;
    protected ILibraryChangeListener libraryListener = new ILibraryChangeListener(){

        public void libraryChanged(int option, Collection collection) {
            switch (option) {
                case 8: {
                    if (collection != null && collection.contains(ProcessEditor.this.currentConfig)) {
                        MethodConfiguration config = ProcessAuthoringConfigurator.INSTANCE.getMethodConfiguration();
                        try {
                            ProcessAuthoringConfigurator.INSTANCE.setMethodConfiguration(ProcessEditor.this.currentConfig);
                            ProcessEditor.this.refreshAll();
                        }
                        finally {
                            ProcessAuthoringConfigurator.INSTANCE.setMethodConfiguration(config);
                        }
                    }
                    this.synUpdate(collection);
                }
            }
        }

        private void synUpdate(Collection collection) {
            if (!ProcessUtil.isSynFree()) {
                return;
            }
            if (collection == null || collection.isEmpty()) {
                return;
            }
            for (Object obj : collection) {
                if (!(obj instanceof MethodElement)) continue;
                if (obj instanceof ContentDescription) {
                    obj = ((ContentDescription)obj).eContainer();
                }
                MethodElement element = (MethodElement)obj;
                if (obj instanceof Task || obj instanceof Role || obj instanceof WorkProduct || TypeDefUtil.hasLinkTypes((MethodElement)element)) {
                    if (ProcessEditor.this.changedElementSet == null) {
                        ProcessEditor.this.changedElementSet = new HashSet();
                    }
                    ProcessEditor.this.changedElementSet.add((MethodElement)obj);
                    continue;
                }
                if (!(obj instanceof TaskDescriptor)) continue;
                DescriptorPropUtil propUtil = DescriptorPropUtil.getDesciptorPropUtil();
                HashSet greenDescendents = new HashSet();
                propUtil.collectCustomizingDescendants((Descriptor)((TaskDescriptor)obj), greenDescendents);
                if (greenDescendents.isEmpty()) continue;
                if (ProcessEditor.this.changedElementSet == null) {
                    ProcessEditor.this.changedElementSet = new HashSet();
                }
                ProcessEditor.this.changedElementSet.addAll(greenDescendents);
            }
            ProcessEditor.this.updateAndRefreshProcessModel();
        }
    };
    protected ILibraryServiceListener libSvcListener = new ILibraryServiceListener(){

        public void configurationSet(MethodConfiguration config) {
            ProcessEditor.this.configChanged();
        }

        public void libraryClosed(MethodLibrary library) {
        }

        public void libraryCreated(MethodLibrary library) {
        }

        public void libraryOpened(MethodLibrary library) {
        }

        public void libraryReopened(MethodLibrary library) {
        }

        public void librarySet(MethodLibrary library) {
        }
    };
    protected ProcessBreakdownStructureFormPage WBSTab;
    protected ProcessBreakdownStructureFormPage OBSTab;
    protected ProcessBreakdownStructureFormPage PBSTab;
    protected ProcessBreakdownStructureFormPage procTab;
    protected Collection<ProcessBreakdownStructureFormPage> extensionTabs = null;
    protected ProcessBreakdownStructureFormPage[] bsPages;
    protected EPFPropertySheetPage propertySheetPage;
    public Collection resourcesToSave = new ArrayList();
    protected IPartListener partActivationListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof PropertySheet) {
                ProcessEditor.this.removePropertiesDropDownMenu(part);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part instanceof PropertySheet) {
                ProcessEditor.this.propertySheetPage = null;
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
            if (part instanceof PropertySheet) {
                ProcessEditor.this.removePropertiesDropDownMenu(part);
            }
        }
    };
    protected IPropertyChangeListenerWrapper prefStoreListener;
    protected Suppression suppression;
    protected boolean synchronizingSelection;
    protected boolean inputChanged;
    public static final IAdapterFactoryProvider adapterFactoryProvider;
    private ProcessAuthoringConfigurator scopeConfigurator;
    private Set<MethodElement> changedElementSet;

    static {
        ALL_WBS_COLUMNS.add(COL_DESC_PREFIX);
        ALL_TBS_COLUMNS.add(COL_DESC_PREFIX);
        ALL_WPBS_COLUMNS.add(COL_DESC_PREFIX);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_NAME.id, COL_DESC_NAME);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_ID.id, COL_DESC_ID);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_PREFIX.id, COL_DESC_PREFIX);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_MODEL_INFO.id, COL_DESC_MODEL_INFO);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_TYPE.id, COL_DESC_TYPE);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_PREDECESSORS.id, COL_DESC_PREDECESSORS);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_IS_REPEATABLE.id, COL_DESC_IS_REPEATABLE);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_IS_ONGOING.id, COL_DESC_IS_ONGOING);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_IS_EVENT_DRIVEN.id, COL_DESC_IS_EVENT_DRIVEN);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_TEAM.id, COL_DESC_TEAM);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_ENTRY_STATE.id, COL_DESC_ENTRY_STATE);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_EXIT_STATE.id, COL_DESC_EXIT_STATE);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_PRESENTATION_NAME.id, COL_DESC_PRESENTATION_NAME);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_DELIVERABLE.id, COL_DESC_DELIVERABLE);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_IS_OPTIONAL.id, COL_DESC_IS_OPTIONAL);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_IS_PLANNED.id, COL_DESC_IS_PLANNED);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_HAS_MULTIPLE_OCCURRENCES.id, COL_DESC_HAS_MULTIPLE_OCCURRENCES);
        ALL_WBS_COLUMNS.add(COL_DESC_NAME);
        ALL_TBS_COLUMNS.add(COL_DESC_NAME);
        ALL_WPBS_COLUMNS.add(COL_DESC_NAME);
        addAdapterFactoryListeners = false;
        adapterFactoryProvider = new IAdapterFactoryProvider(){

            public AdapterFactory getCBSAdapterFactory() {
                return TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory();
            }

            public AdapterFactory getTBSAdapterFactory() {
                return TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
            }

            public AdapterFactory getWBSAdapterFactory() {
                return TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
            }

            public AdapterFactory getWPBSAdapterFactory() {
                return TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
            }
        };
    }

    @Override
    protected boolean isValidateResourcesBeforeSaveRequired() {
        return true;
    }

    @Override
    protected LibraryValidateAction createValidateResourceAction() {
        LibraryValidateAction validateAction = super.createValidateResourceAction();
        validateAction.putContextData("CTX_ADAPTER_FACTORY_PROVIDER", adapterFactoryProvider);
        return validateAction;
    }

    protected void inputChanged(Object newInput) {
        this.inputChanged = false;
        if (!(newInput instanceof MethodElementEditorInput)) {
            return;
        }
        MethodElementEditorInput methodElementInput = (MethodElementEditorInput)newInput;
        MethodElement obj = methodElementInput.getMethodElement();
        if (obj instanceof ProcessComponent) {
            this.selectedProcessComponent = (ProcessComponent)obj;
            this.selectedProcess = this.getTopBreakdownElement(this.selectedProcessComponent);
            this.suppression = this.getSuppression(this.selectedProcess);
            if (this.WBSTab != null) {
                this.WBSTab.setProcess(this.selectedProcess);
            }
            if (this.OBSTab != null) {
                this.OBSTab.setProcess(this.selectedProcess);
            }
            if (this.PBSTab != null) {
                this.PBSTab.setProcess(this.selectedProcess);
            }
            if (this.procTab != null) {
                this.procTab.setProcess(this.selectedProcess);
            }
            if (this.extensionTabs != null) {
                for (ProcessBreakdownStructureFormPage extPage : this.extensionTabs) {
                    extPage.setProcess(this.selectedProcess);
                }
            }
        }
    }

    protected Process getTopBreakdownElement(ProcessComponent selectedProcessComponent) {
        return (Process)ProcessUtil.getTopBreakdownElement((ProcessComponent)selectedProcessComponent);
    }

    protected Suppression getSuppression(Process selectedProcess) {
        return Suppression.getSuppression((Process)selectedProcess);
    }

    protected Image getProcTitleImage() {
        ProcessComponent pc;
        Process proc;
        MethodElement obj;
        IEditorInput input = this.getEditorInput();
        if (input instanceof MethodElementEditorInput && (obj = ((MethodElementEditorInput)input).getMethodElement()) instanceof ProcessComponent && (proc = (pc = (ProcessComponent)obj).getProcess()) != null) {
            return ExtendedImageRegistry.getInstance().getImage(TngUtil.getImage((Object)proc));
        }
        return LibraryUIImages.IMG_PROCESS;
    }

    protected void removePropertiesDropDownMenu(IWorkbenchPart part) {
        if (part instanceof PropertySheet) {
            IViewSite view = ((PropertySheet)part).getViewSite();
            IMenuManager menuMgr = view.getActionBars().getMenuManager();
            menuMgr.removeAll();
            menuMgr.updateAll(true);
        }
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        site.setSelectionProvider((ISelectionProvider)this);
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(factories);
        CommandStack commandStack = this.actionMgr.getCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                boolean run = false;
                if (event instanceof CommandStackChangedEvent) {
                    switch (((CommandStackChangedEvent)event).getType()) {
                        case 2: 
                        case 4: {
                            run = true;
                        }
                    }
                } else {
                    run = true;
                }
                if (run) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            ProcessEditor.this.firePropertyChange(257);
                            Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                            if (mostRecentCommand != null) {
                                Object[] arr;
                                if (!(TngUtil.unwrap((Command)mostRecentCommand) instanceof SetCommand) && mostRecentCommand.getAffectedObjects().size() == 1) {
                                    ProcessEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                                }
                                if (mostRecentCommand instanceof CreateChildCommand && (this).ProcessEditor.this.currentViewer instanceof ProcessViewer && (arr = mostRecentCommand.getAffectedObjects().toArray()).length == 1) {
                                    ProcessViewer viewer = (ProcessViewer)(this).ProcessEditor.this.currentViewer;
                                    viewer.editElement(arr[0], 0);
                                }
                            }
                        }
                    });
                }
            }
        });
        this.editingDomain = new TraceableAdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, commandStack);
        LibraryService.getInstance().addListener(this.libSvcListener);
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null) {
            manager.addListener(this.libraryListener);
            manager.startListeningTo(this.actionMgr.getCommandStack());
            if (!addAdapterFactoryListeners) {
                addAdapterFactoryListeners = true;
                manager.startListeningTo(TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory());
                manager.startListeningTo(TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory());
                manager.startListeningTo(TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory());
            }
        }
        this.setPartFacade(input);
        MethodElementEditorInput methodElementInput = (MethodElementEditorInput)input;
        this.elementObj = methodElementInput.getMethodElement();
        if (this.elementObj instanceof ProcessComponent) {
            this.selectedProcessComponent = (ProcessComponent)this.elementObj;
            this.selectedProcess = this.selectedProcessComponent.getProcess();
        }
        if (this.selectedProcessComponent != null) {
            this.selectedProcessComponent.eAdapters().add((Object)this.processComponentListener);
        }
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.partActivationListener);
        if (this.prefStoreListener == null) {
            this.prefStoreListener = new IPropertyChangeListenerWrapper(){

                public void propertyChange(IPropertyChangeEventWrapper event) {
                    ProcessBreakdownStructureFormPage page = null;
                    if (event.getProperty().equals("org.eclipse.epf.library.edit.wbs_columns")) {
                        page = ProcessEditor.this.WBSTab;
                    } else if (event.getProperty().equals("org.eclipse.epf.library.edit.tbs_columns")) {
                        page = ProcessEditor.this.OBSTab;
                    } else if (event.getProperty().equals("org.eclipse.epf.library.edit.wpbs_columns")) {
                        page = ProcessEditor.this.PBSTab;
                    }
                    if (page != null) {
                        ColumnDescriptor[] cols = ProcessEditor.toColumnDescriptors(ProcessEditor.this.getPreferenceStore().getString(event.getProperty()));
                        page.updateColumns(cols);
                        if (page == ProcessEditor.this.WBSTab || page == ProcessEditor.this.OBSTab) {
                            EList list = ProcessEditor.toColumnDescriptorList(ProcessEditor.this.getPreferenceStore().getString("org.eclipse.epf.library.edit.wbs_columns"));
                            ColumnDescriptor[] teamColumnDescriptors = ProcessEditor.toColumnDescriptors(ProcessEditor.this.getPreferenceStore().getString("org.eclipse.epf.library.edit.tbs_columns"));
                            int i = 0;
                            while (i < teamColumnDescriptors.length) {
                                ColumnDescriptor colDesc = teamColumnDescriptors[i];
                                if (colDesc == COL_DESC_TEAM) {
                                    list.add(colDesc);
                                    break;
                                }
                                ++i;
                            }
                            ColumnDescriptor[] columns = new ColumnDescriptor[list.size()];
                            list.toArray(columns);
                            ProcessEditor.this.procTab.updateColumns(columns);
                        }
                    }
                }
            };
        }
        this.getPreferenceStore().addPropertyChangeListener(this.prefStoreListener);
        this.diagramEditorHelper = new DiagramEditorHelper();
    }

    protected void setPartFacade(IEditorInput input) {
        this.setPartName(input.getName());
        this.setTitleImage();
    }

    @Override
    protected void setTitleImage() {
        this.setTitleImage(this.getProcTitleImage());
    }

    public void setSelectionToViewer(Collection collection) {
        if (this.currentViewer != null && collection != null && !collection.isEmpty()) {
            this.currentViewer.setSelection((ISelection)new StructuredSelection(collection.toArray()), true);
        }
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    @Override
    public void dispose() {
        ILibraryManager manager;
        Scope scope;
        if (this.getSelectedProcess() != null && (scope = ProcessScopeUtil.getInstance().getScope(this.getSelectedProcess())) != null) {
            ProcessScopeUtil.getInstance().endProcessEdit(scope);
        }
        this.closeAllDiagramEditors();
        this.getPreferenceStore().removePropertyChangeListener(this.prefStoreListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if ((manager = LibraryService.getInstance().getCurrentLibraryManager()) != null) {
            manager.removeListener(this.libraryListener);
            manager.stopListeningTo(this.editingDomain.getCommandStack());
        }
        LibraryService.getInstance().removeListener(this.libSvcListener);
        if (this.selectedProcessComponent != null) {
            this.selectedProcessComponent.eAdapters().remove((Object)this.processComponentListener);
        }
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partActivationListener);
        boolean saveNeeded = this.isDirty();
        super.dispose();
        if (this.diagramEditorHelper != null) {
            this.diagramEditorHelper.dispose();
        }
        this.suppression.saveIsDone();
    }

    private void closeAllDiagramEditors() {
        IWorkbenchPage workbenchPage = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (workbenchPage == null) {
            return;
        }
        IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
        ArrayList<IEditorReference> diagramEditorRefs = new ArrayList<IEditorReference>();
        int i = 0;
        while (i < editorReferences.length) {
            MethodElement element;
            DiagramEditorInput diagramInput;
            IEditorReference reference = editorReferences[i];
            IEditorPart editor = reference.getEditor(true);
            IEditorInput input = editor.getEditorInput();
            if (input instanceof DiagramEditorInputProxy && (diagramInput = ((DiagramEditorInputProxy)input).getDiagramEditorInput()) != null && (element = diagramInput.getMethodElement()) instanceof BreakdownElement && this.selectedProcess == TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)element))) {
                diagramEditorRefs.add(reference);
            }
            ++i;
        }
        if (!diagramEditorRefs.isEmpty()) {
            IEditorReference[] refs = new IEditorReference[diagramEditorRefs.size()];
            diagramEditorRefs.toArray(refs);
            workbenchPage.closeEditors(refs, true);
        }
    }

    protected void addDescriptionPage() throws PartInitException {
        if (this.selectedProcess instanceof DeliveryProcess) {
            this.addPage(0, (IFormPage)new DeliveryProcessDescription(this));
        } else {
            this.addPage(0, (IFormPage)new ProcessDescription(this));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void addPages() {
        try {
            void var13_20;
            Scope scope;
            this.addDescriptionPage();
            PreferenceUtil.validatePreferences();
            IPreferenceStoreWrapper store = this.getPreferenceStore();
            ArrayList<ProcessBreakdownStructureFormPage> pages = new ArrayList<ProcessBreakdownStructureFormPage>();
            this.WBSTab = new ProcessBreakdownStructureFormPage(this, WBS_FORM_ID, AuthoringUIResources.ProcessEditor_WorkBreakdownStructure);
            ColumnDescriptor[] columnDescriptors = ProcessEditor.toColumnDescriptors(store.getString("org.eclipse.epf.library.edit.wbs_columns"));
            ComposedAdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
            this.currentConfig = LibraryService.getInstance().getCurrentMethodConfiguration();
            ProcessAuthoringConfigurator.INSTANCE.setMethodConfiguration(this.currentConfig);
            if (this.selectedProcess != null && this.selectedProcess.getDefaultContext() == null) {
                ProcessScopeUtil.getInstance().loadScope(this.selectedProcess);
            }
            if ((scope = ProcessScopeUtil.getInstance().getScope(this.selectedProcess)) != null) {
                ProcessScopeUtil.getInstance().beginProcessEdit(scope);
            }
            if (ProcessUtil.isSynFree()) {
                this.updateProcessModel();
            }
            if (adapterFactory instanceof ConfigurableComposedAdapterFactory) {
                ((ConfigurableComposedAdapterFactory)adapterFactory).setFilter((IFilter)this.getConfiguratorInstance());
            }
            this.WBSTab.setAdapterFactory((AdapterFactory)adapterFactory);
            this.WBSTab.setColumnDescriptors(columnDescriptors);
            int id = this.addPage(this.WBSTab.createControl(this.getContainer()));
            this.setPageText(id, this.WBSTab.getTitle());
            this.WBSTab.setTabIndex(id);
            StructuredViewer viewer = (StructuredViewer)this.WBSTab.getViewer();
            this.createContextMenuFor(viewer);
            pages.add(this.WBSTab);
            this.OBSTab = new ProcessBreakdownStructureFormPage(this, TA_FORM_ID, AuthoringUIResources.ProcessEditor_TeamAllocation);
            columnDescriptors = ProcessEditor.toColumnDescriptors(store.getString("org.eclipse.epf.library.edit.tbs_columns"));
            adapterFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
            if (adapterFactory instanceof ConfigurableComposedAdapterFactory) {
                ((ConfigurableComposedAdapterFactory)adapterFactory).setFilter((IFilter)this.getConfiguratorInstance());
            }
            this.OBSTab.setAdapterFactory((AdapterFactory)adapterFactory);
            this.OBSTab.setColumnDescriptors(columnDescriptors);
            id = this.addPage(this.OBSTab.createControl(this.getContainer()));
            this.setPageText(id, this.OBSTab.getTitle());
            this.OBSTab.setTabIndex(id);
            viewer = (StructuredViewer)this.OBSTab.getViewer();
            this.createContextMenuFor(viewer);
            pages.add(this.OBSTab);
            this.PBSTab = new ProcessBreakdownStructureFormPage(this, WPBS_FORM_ID, AuthoringUIResources.ProcessEditor_WorkProductUsage);
            columnDescriptors = ProcessEditor.toColumnDescriptors(store.getString("org.eclipse.epf.library.edit.wpbs_columns"));
            adapterFactory = TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
            if (adapterFactory instanceof ConfigurableComposedAdapterFactory) {
                ((ConfigurableComposedAdapterFactory)adapterFactory).setFilter((IFilter)this.getConfiguratorInstance());
            }
            this.PBSTab.setAdapterFactory((AdapterFactory)adapterFactory);
            this.PBSTab.setColumnDescriptors(columnDescriptors);
            id = this.addPage(this.PBSTab.createControl(this.getContainer()));
            this.setPageText(id, this.PBSTab.getTitle());
            this.PBSTab.setTabIndex(id);
            viewer = (StructuredViewer)this.PBSTab.getViewer();
            this.createContextMenuFor(viewer);
            pages.add(this.PBSTab);
            this.procTab = new ProcessBreakdownStructureFormPage(this, CONSOLIDATED_FORM_ID, AuthoringUIResources.ProcessEditor_ConsolidatedView);
            this.procTab.setReadOnly(true);
            adapterFactory = TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory();
            if (adapterFactory instanceof ConfigurableComposedAdapterFactory) {
                ((ConfigurableComposedAdapterFactory)adapterFactory).setFilter((IFilter)this.getConfiguratorInstance());
            }
            this.procTab.setAdapterFactory((AdapterFactory)adapterFactory);
            EList list = ProcessEditor.toColumnDescriptorList(store.getString("org.eclipse.epf.library.edit.wbs_columns"));
            ColumnDescriptor[] teamColumnDescriptors = ProcessEditor.toColumnDescriptors(store.getString("org.eclipse.epf.library.edit.tbs_columns"));
            int i = 0;
            while (i < teamColumnDescriptors.length) {
                ColumnDescriptor colDesc = teamColumnDescriptors[i];
                if (colDesc == COL_DESC_TEAM) {
                    list.add(colDesc);
                    break;
                }
                ++i;
            }
            ColumnDescriptor[] columns = new ColumnDescriptor[list.size()];
            list.toArray(columns);
            this.procTab.setColumnDescriptors(columns);
            id = this.addPage(this.procTab.createControl(this.getContainer()));
            this.setPageText(id, this.procTab.getTitle());
            this.procTab.setTabIndex(id);
            viewer = (StructuredViewer)this.procTab.getViewer();
            this.createContextMenuFor(viewer);
            pages.add(this.procTab);
            Map<Object, String> pageMap = new LinkedHashMap<Object, String>();
            List<IMethodElementEditorPageProviderExtension> pageProviders = ProcessEditor.getAllPageProviders();
            if (pageProviders != null && pageProviders.size() > 0) {
                for (IMethodElementEditorPageProviderExtension iMethodElementEditorPageProviderExtension : pageProviders) {
                    pageMap = iMethodElementEditorPageProviderExtension.getPages(pageMap, this, this.selectedProcess);
                }
            }
            if (!pageMap.isEmpty()) {
                this.extensionTabs = new ArrayList<ProcessBreakdownStructureFormPage>();
                for (Map.Entry entry : pageMap.entrySet()) {
                    Object page = entry.getKey();
                    String name = (String)entry.getValue();
                    int index = -1;
                    if (page instanceof Control) {
                        index = this.addPage((Control)page);
                    } else if (page instanceof IFormPage) {
                        if (page instanceof ProcessBreakdownStructureFormPage) {
                            ProcessBreakdownStructureFormPage extendedPage = (ProcessBreakdownStructureFormPage)page;
                            this.extensionTabs.add(extendedPage);
                            index = this.addPage(extendedPage.createControl(this.getContainer()));
                            this.setPageText(index, extendedPage.getTitle());
                            extendedPage.setTabIndex(index);
                            viewer = (StructuredViewer)extendedPage.getViewer();
                            this.createContextMenuFor(viewer);
                            pages.add(extendedPage);
                        }
                    } else if (page instanceof IEditorPart) {
                        index = this.addPage((IEditorPart)page, this.getEditorInput());
                    }
                    if (name == null) continue;
                    this.setPageText(index, name);
                }
            }
            this.bsPages = new ProcessBreakdownStructureFormPage[pages.size()];
            boolean bl = false;
            while (var13_20 < pages.size()) {
                this.bsPages[var13_20] = (ProcessBreakdownStructureFormPage)pages.get((int)var13_20);
                ++var13_20;
            }
            this.inputChanged(this.getEditorInput());
        }
        catch (PartInitException e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            e.printStackTrace();
        }
    }

    public void updateConfigFreeProcessModelAndRefresh() {
        this.updateProcessModel();
        this.refreshAll();
    }

    private void updateProcessModel() {
        if (!ProcessUtil.isSynFree()) {
            return;
        }
        Process proc = this.getSelectedProcess();
        IRealizationManager mgr = this.getConfiguratorInstance().getRealizationManager();
        if (mgr == null) {
            mgr = LibraryEditUtil.getInstance().getRealizationManager(proc.getDefaultContext());
        }
        if (proc != null && mgr != null) {
            if (ProcessScopeUtil.getInstance().isConfigFree(proc)) {
                ConfigurationHelper.getDelegate().setLoadForBrowsingNeeded(true);
            }
            mgr.updateProcessModel(proc);
        }
    }

    protected void setActivePage(int pageIndex) {
        Viewer viewer;
        Object selection;
        super.setActivePage(pageIndex);
        this.handlePageChange();
        if (pageIndex > 0 && this.bsPages.length <= pageIndex && ((selection = (viewer = this.bsPages[pageIndex].getViewer()).getSelection()) == null || selection.isEmpty())) {
            ISelection initialSelection = null;
            if (this.getEditorInput() instanceof ProcessEditorInput) {
                initialSelection = ((ProcessEditorInput)this.getEditorInput()).getInitialSelection();
            }
            selection = initialSelection == null ? new StructuredSelection((Object)this.selectedProcess) : initialSelection;
            viewer.setSelection(selection, true);
        }
    }

    public IFormPage setActivePage(String pageId) {
        Object page;
        int id = -1;
        Object activePage = null;
        int i = 0;
        while (i < this.pages.size()) {
            IFormPage fpage;
            page = this.pages.get(i);
            if (page instanceof IFormPage && (fpage = (IFormPage)page).getId().equals(pageId)) {
                id = i;
                activePage = fpage;
                break;
            }
            ++i;
        }
        if (id == -1) {
            i = 0;
            while (i < this.bsPages.length) {
                page = this.bsPages[i];
                if (page.getId().equals(pageId)) {
                    id = ((ProcessBreakdownStructureFormPage)page).getTabIndex();
                    activePage = page;
                    break;
                }
                ++i;
            }
        }
        if (id == -1 && this.extensionTabs != null) {
            for (ProcessBreakdownStructureFormPage extPage : this.extensionTabs) {
                extPage.setProcess(this.selectedProcess);
                if (!extPage.getId().equals(pageId)) continue;
                id = extPage.getTabIndex();
                activePage = extPage;
                break;
            }
        }
        if (activePage != null) {
            this.setActivePage(id);
            return activePage;
        }
        return null;
    }

    protected void handlePageChange() {
        int id = this.getActivePage();
        if (id != -1) {
            Object page = this.pages.get(id);
            if (page instanceof ProcessDescription) {
                ((ProcessDescription)page).setFormText();
            }
            if (this.WBSTab != null && id == this.WBSTab.getTabIndex()) {
                this.setCurrentViewer(this.WBSTab.getViewer());
            } else if (this.OBSTab != null && id == this.OBSTab.getTabIndex()) {
                this.setCurrentViewer(this.OBSTab.getViewer());
            } else if (this.PBSTab != null && id == this.PBSTab.getTabIndex()) {
                this.setCurrentViewer(this.PBSTab.getViewer());
            } else if (this.procTab != null && id == this.procTab.getTabIndex()) {
                this.setCurrentViewer(this.procTab.getViewer());
            } else if (this.extensionTabs != null) {
                for (ProcessBreakdownStructureFormPage extPage : this.extensionTabs) {
                    if (id != extPage.getTabIndex()) continue;
                    this.setCurrentViewer(extPage.getViewer());
                }
            } else {
                this.setCurrentViewer(null);
            }
            if (this.propertySheetPage != null) {
                this.propertySheetPage.refresh();
            }
        }
    }

    @Override
    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        this.handlePageChange();
    }

    public void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)viewer);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                ProcessEditor.this.setSelection((ISelection)sel);
            }
        });
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new ProcessEditorDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
        dndOperations = 3;
        transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
    }

    protected void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            IContentProvider contentProvider;
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        ProcessEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            if (this.currentViewer instanceof ProcessViewer && (contentProvider = ((ProcessViewer)this.currentViewer).getContentProvider()) instanceof AdapterFactoryContentProvider) {
                AdapterFactoryContentProvider adapterFactoryContentProvider = (AdapterFactoryContentProvider)contentProvider;
                AdapterFactory adapterFactory = adapterFactoryContentProvider.getAdapterFactory();
                if (adapterFactory instanceof EditingDomainComposedAdapterFactory) {
                    ((EditingDomainComposedAdapterFactory)adapterFactory).setEditingDomain((EditingDomain)this.editingDomain);
                } else {
                    this.editingDomain.setAdapterFactory(adapterFactory);
                }
                if (this.propContentProvider != null) {
                    this.propContentProvider.setAdapterFactory(adapterFactory);
                }
            }
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public static Activity getParentActivity(BreakdownElement e, AdapterFactory adapterFactory) {
        Activity act = UmaUtil.getParentActivity((BreakdownElement)e);
        if (act != null) {
            return act;
        }
        return null;
    }

    public static AdapterFactory getAdapterFactory(StructuredViewer viewer) {
        return ((AdapterFactoryContentProvider)viewer.getContentProvider()).getAdapterFactory();
    }

    public static void setSelectionToViewer(Viewer viewer, IStructuredSelection otherSel, boolean alternateSelection) {
        if (alternateSelection) {
            IStructuredSelection sel = (IStructuredSelection)viewer.getSelection();
            Object currentSelection = null;
            if (sel.size() == 1) {
                Activity act;
                currentSelection = sel.getFirstElement();
                if (currentSelection instanceof BreakdownElement && (act = ProcessEditor.getParentActivity((BreakdownElement)currentSelection, ProcessEditor.getAdapterFactory((StructuredViewer)viewer))) != otherSel.getFirstElement()) {
                    viewer.setSelection((ISelection)otherSel, true);
                }
            } else {
                viewer.setSelection((ISelection)otherSel, true);
            }
        } else {
            viewer.setSelection((ISelection)otherSel, true);
        }
    }

    public void setSelection(ISelection selection) {
        if (this.synchronizingSelection) {
            return;
        }
        this.viewSelection = selection;
        ArrayList listenerList = new ArrayList(this.selectionChangedListeners);
        int i = 0;
        while (i < listenerList.size()) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listenerList.get(i);
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
            ++i;
        }
        this.synchronizeSelection(selection, this.currentViewer);
    }

    protected boolean refreshOutOfSynch(ISelection selection) {
        if (this.currentViewer != null && selection instanceof IStructuredSelection) {
            boolean refreshRequired = false;
            IStructuredSelection sel = (IStructuredSelection)selection;
            HashSet<Resource> resources = new HashSet<Resource>();
            Iterator iter = sel.iterator();
            while (iter.hasNext()) {
                Resource resource;
                Object e = TngUtil.unwrap(iter.next());
                if (!(e instanceof EObject)) continue;
                EObject eObject = (EObject)e;
                if (eObject.eIsProxy()) {
                    eObject = RefreshJob.getInstance().resolve(eObject);
                    refreshRequired = true;
                }
                if ((resource = eObject.eResource()) == null) continue;
                resources.add(resource);
            }
            if (!resources.isEmpty()) {
                boolean ret;
                ArrayList removedResources = new ArrayList();
                ArrayList changedResources = new ArrayList();
                ResourceUtil.checkOutOfSynchResources(resources, removedResources, changedResources);
                if (!(removedResources.isEmpty() && changedResources.isEmpty() || !(ret = this.promptReloadFiles()))) {
                    ILibraryManager manager;
                    if (!removedResources.isEmpty()) {
                        PersistenceUtil.unload(removedResources);
                    }
                    Collection reloadedResources = null;
                    if (!changedResources.isEmpty() && (manager = LibraryService.getInstance().getCurrentLibraryManager()) != null) {
                        reloadedResources = manager.reloadResources(changedResources);
                    }
                    if (!removedResources.isEmpty() || reloadedResources != null) {
                        refreshRequired = true;
                    }
                    Iterator iter2 = changedResources.iterator();
                    while (iter2.hasNext()) {
                        FileManager.getInstance().refresh((Resource)iter2.next());
                    }
                }
            }
            if (refreshRequired) {
                this.currentViewer.refresh();
                return true;
            }
        }
        return false;
    }

    protected void synchronizeSelection(ISelection selection, Viewer currentViewer) {
        block42: {
            try {
                Viewer viewer;
                IStructuredSelection sel;
                this.synchronizingSelection = true;
                if (currentViewer == null || !(selection instanceof IStructuredSelection) || (sel = (IStructuredSelection)selection).size() != 1) break block42;
                Object selected = sel.getFirstElement();
                IStructuredSelection otherSel = null;
                boolean alternateSelection = false;
                ArrayList<Object> selectedPath = null;
                AdapterFactory adapterFactory = ProcessEditor.getAdapterFactory((StructuredViewer)currentViewer);
                if (selected instanceof BreakdownElementWrapperItemProvider) {
                    if (((BreakdownElementWrapperItemProvider)selected).isReadOnly()) {
                        if (adapterFactory != null) {
                            Object e = TngUtil.unwrap((Object)selected);
                            selectedPath = new ArrayList<Object>();
                            Object adapter = (ITreeItemContentProvider)selected;
                            while (true) {
                                selectedPath.add(0, e);
                                Object parent = adapter.getParent(e);
                                if (parent != null) {
                                    if (parent instanceof BreakdownElementWrapperItemProvider) {
                                        adapter = (ITreeItemContentProvider)parent;
                                        e = TngUtil.unwrap((Object)parent);
                                        continue;
                                    }
                                    adapter = (ITreeItemContentProvider)adapterFactory.adapt(parent, ITreeItemContentProvider.class);
                                    e = parent;
                                    continue;
                                }
                                break;
                            }
                        }
                    } else if (this.procTab.getViewer() == currentViewer) {
                        selected = TngUtil.unwrap((Object)selected);
                        selection = new StructuredSelection(selected);
                    } else if (this.extensionTabs != null) {
                        for (ProcessBreakdownStructureFormPage extPage : this.extensionTabs) {
                            if (extPage.getViewer() != currentViewer) continue;
                            selected = TngUtil.unwrap((Object)selected);
                            selection = new StructuredSelection(selected);
                        }
                    }
                }
                if (selected instanceof BreakdownElement) {
                    if (this.procTab.getViewer() != currentViewer) {
                        this.procTab.getViewer().setSelection(selection, false);
                    }
                    if (this.extensionTabs != null) {
                        for (ProcessBreakdownStructureFormPage extPage : this.extensionTabs) {
                            if (extPage.getViewer() == currentViewer) continue;
                            extPage.getViewer().setSelection(selection, false);
                        }
                    }
                    if (selected instanceof Activity || selected instanceof Milestone) {
                        otherSel = (IStructuredSelection)selection;
                    } else {
                        Activity act = ProcessEditor.getParentActivity((BreakdownElement)selected, adapterFactory);
                        if (act != null) {
                            otherSel = new StructuredSelection((Object)act);
                            alternateSelection = true;
                        }
                    }
                }
                if (otherSel != null) {
                    viewer = null;
                    if (this.WBSTab != null) {
                        viewer = this.WBSTab.getViewer();
                    }
                    if (viewer != null && viewer != currentViewer) {
                        if (selected instanceof WorkBreakdownElement) {
                            viewer.setSelection(selection, false);
                        } else {
                            ProcessEditor.setSelectionToViewer(viewer, otherSel, alternateSelection);
                        }
                    }
                    if (this.OBSTab != null) {
                        viewer = this.OBSTab.getViewer();
                    }
                    if (viewer != null && viewer != currentViewer) {
                        if (selected instanceof RoleDescriptor) {
                            viewer.setSelection(selection, false);
                        } else {
                            ProcessEditor.setSelectionToViewer(viewer, otherSel, alternateSelection);
                        }
                    }
                    if (this.PBSTab != null) {
                        viewer = this.PBSTab.getViewer();
                    }
                    if (viewer != null && viewer != currentViewer) {
                        if (selected instanceof WorkProductDescriptor) {
                            viewer.setSelection(selection, false);
                        } else {
                            ProcessEditor.setSelectionToViewer(viewer, otherSel, alternateSelection);
                        }
                    }
                } else if (selectedPath != null) {
                    viewer = null;
                    if (this.WBSTab != null && (viewer = this.WBSTab.getViewer()) != currentViewer) {
                        selection = new StructuredSelection(ProcessEditor.findSelection(selectedPath, this.WBSTab.getAdapterFactory()));
                        viewer.setSelection(selection, false);
                    }
                    if (this.OBSTab != null && (viewer = this.OBSTab.getViewer()) != currentViewer) {
                        selection = new StructuredSelection(ProcessEditor.findSelection(selectedPath, this.OBSTab.getAdapterFactory()));
                        viewer.setSelection(selection, false);
                    }
                    if (this.PBSTab != null && (viewer = this.PBSTab.getViewer()) != currentViewer) {
                        selection = new StructuredSelection(ProcessEditor.findSelection(selectedPath, this.PBSTab.getAdapterFactory()));
                        viewer.setSelection(selection, false);
                    }
                    if (this.procTab != null && (viewer = this.procTab.getViewer()) != currentViewer) {
                        selection = new StructuredSelection(ProcessEditor.findSelection(selectedPath, this.procTab.getAdapterFactory()));
                        viewer.setSelection(selection, false);
                    }
                    if (this.extensionTabs != null) {
                        for (ProcessBreakdownStructureFormPage extPage : this.extensionTabs) {
                            viewer = extPage.getViewer();
                            if (viewer == currentViewer) continue;
                            selection = new StructuredSelection(ProcessEditor.findSelection(selectedPath, extPage.getAdapterFactory()));
                            viewer.setSelection(selection, false);
                        }
                    }
                }
            }
            finally {
                this.synchronizingSelection = false;
            }
        }
    }

    public static Object findSelection(List selectedPath, AdapterFactory adapterFactory) {
        Object e;
        int size = selectedPath.size();
        if (size == 0) {
            return null;
        }
        Object selection = e = selectedPath.get(0);
        ITreeItemContentProvider adapter = (ITreeItemContentProvider)adapterFactory.adapt(e, ITreeItemContentProvider.class);
        Collection children = adapter.getChildren(e);
        int i = 1;
        block0: while (i < size) {
            e = selectedPath.get(i);
            for (Object child : children) {
                Object element = TngUtil.unwrap(child);
                if (element != e) continue;
                selection = child;
                adapter = (ITreeItemContentProvider)adapterFactory.adapt(child, ITreeItemContentProvider.class);
                children = adapter.getChildren(e);
                ++i;
                continue block0;
            }
        }
        return selection;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.viewSelection;
    }

    @Override
    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    public AdapterFactory getAdapterFactory() {
        IFormPage page = this.getActivePageInstance();
        if (page instanceof ProcessBreakdownStructureFormPage) {
            return ((ProcessBreakdownStructureFormPage)page).getAdapterFactory();
        }
        return null;
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        IAction[] actions;
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
        IFormPage activePage = this.getActivePageInstance();
        if (activePage instanceof ProcessBreakdownStructureFormPage && (actions = ((ProcessBreakdownStructureFormPage)activePage).getAdditionalActions()) != null && actions.length > 0) {
            menuManager.insertAfter("additions", (IContributionItem)new Separator());
            int i = 0;
            while (i < actions.length) {
                IAction action = actions[i];
                ISelection selection = this.getSelection();
                if (selection instanceof IStructuredSelection && action instanceof BaseSelectionListenerAction) {
                    ((BaseSelectionListenerAction)action).selectionChanged((IStructuredSelection)selection);
                }
                if (action instanceof IWorkbenchPartAction) {
                    ((IWorkbenchPartAction)action).setActiveWorkbenchPart((IWorkbenchPart)this);
                }
                menuManager.insertAfter("additions", action);
                ++i;
            }
        }
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = (EPFPropertySheetPage)this.createPropertySheetPage();
            if (this.currentViewer != null) {
                AdapterFactoryContentProvider contentProvider = (AdapterFactoryContentProvider)((ProcessViewer)this.currentViewer).getContentProvider();
                this.propContentProvider = new AdapterFactoryContentProvider(contentProvider.getAdapterFactory());
                this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)this.propContentProvider);
            }
        }
        return this.propertySheetPage;
    }

    protected TabbedPropertySheetPage createPropertySheetPage() {
        return new EPFPropertySheetPage(this);
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public static EList toColumnDescriptorList(String str) {
        BasicEList columnDescriptors = new BasicEList();
        StringTokenizer tokens = new StringTokenizer(str, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            ColumnDescriptor columnDescriptor = idToColumnDescriptorMap.get(token);
            if (columnDescriptor == null) continue;
            columnDescriptors.add((Object)columnDescriptor);
        }
        return columnDescriptors;
    }

    public static ColumnDescriptor[] toColumnDescriptors(String str) {
        EList list = ProcessEditor.toColumnDescriptorList(str);
        ColumnDescriptor[] columns = new ColumnDescriptor[list.size()];
        list.toArray(columns);
        return columns;
    }

    public int getCurrentPage() {
        return super.getCurrentPage();
    }

    public Suppression getSuppression() {
        return this.suppression;
    }

    protected void configChanged() {
        MethodConfiguration config = LibraryService.getInstance().getCurrentMethodConfiguration();
        if (config != this.currentConfig) {
            IWorkbenchPart activePart;
            boolean refresh;
            if (!this.isEditingConfigFreeProcess()) {
                this.updateProcessModel();
            }
            boolean bl = refresh = (activePart = this.getSite().getWorkbenchWindow().getPartService().getActivePart()) == this;
            if (!refresh && activePart instanceof AbstractDiagramEditor) {
                DiagramEditorInput input = ((DiagramEditorInputProxy)((IEditorPart)activePart).getEditorInput()).getDiagramEditorInput();
                boolean bl2 = refresh = input.getSuppression().getProcess() == this.selectedProcess;
            }
            if (refresh) {
                this.currentConfig = config;
                this.refreshAll();
            }
        }
    }

    @Override
    protected void setInput(IEditorInput input) {
        if (input != this.getEditorInput()) {
            this.inputChanged = true;
        }
        super.setInput(input);
    }

    @Override
    protected void updatePages() {
        Resource modelResource = this.selectedProcess.eResource();
        Resource contentResource = this.selectedProcess.getPresentation().eResource();
        if (this.inputChanged || this.changedResources.contains(modelResource) || contentResource != null && this.changedResources.contains(contentResource)) {
            this.removePage(0);
            try {
                this.addDescriptionPage();
            }
            catch (PartInitException e) {
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.ProcessEditor_refreshErrorTitle, AuthoringUIResources.ProcessEditor_refreshErrorMsg, (Throwable)e);
            }
        }
        if (this.inputChanged) {
            this.inputChanged(this.getEditorInput());
            if (this.propertySheetPage != null) {
                this.propertySheetPage.refresh();
            }
        } else {
            this.refreshAll();
        }
    }

    protected void refreshAll() {
        BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ProcessEditor.this.doRefreshAll(true);
            }
        });
    }

    public void doRefreshAll(boolean updateIDs) {
        this.updateIDs(updateIDs);
        if (this.WBSTab != null && this.WBSTab.getViewer() != null) {
            this.WBSTab.getViewer().refresh();
        }
        if (this.OBSTab != null && this.OBSTab.getViewer() != null) {
            this.OBSTab.getViewer().refresh();
        }
        if (this.PBSTab != null && this.PBSTab.getViewer() != null) {
            this.PBSTab.getViewer().refresh();
        }
        if (this.procTab != null && this.procTab.getViewer() != null) {
            this.procTab.getViewer().refresh();
        }
        if (this.extensionTabs != null) {
            for (ProcessBreakdownStructureFormPage extPage : this.extensionTabs) {
                extPage.getViewer().refresh();
            }
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.refresh();
        }
    }

    protected void updateIDs(boolean updateIDs) {
        if (updateIDs) {
            ComposedAdapterFactory adapterFactory = null;
            if (this.WBSTab != null) {
                adapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
                ProcessUtil.updateIDs((AdapterFactory)adapterFactory, (Process)this.selectedProcess);
                ProcessUtil.refreshPredeccessorLists((AdapterFactory)adapterFactory, (Process)this.selectedProcess);
            }
            if (this.procTab != null) {
                adapterFactory = TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory();
                ProcessUtil.updateIDs((AdapterFactory)adapterFactory, (Process)this.selectedProcess);
            }
        }
    }

    public void refreshAllProcessEditors() {
        IEditorReference[] editorReferences = this.getSite().getPage().getEditorReferences();
        int i = 0;
        while (i < editorReferences.length) {
            IEditorReference reference = editorReferences[i];
            IEditorPart editor = reference.getEditor(true);
            if (editor instanceof ProcessEditor) {
                ((ProcessEditor)editor).doRefreshAll(false);
            }
            ++i;
        }
    }

    public IFormPage getActivePageInstance() {
        int index = this.getActivePage();
        if (index == -1) {
            return null;
        }
        if (index == 0) {
            return super.getActivePageInstance();
        }
        return this.bsPages[index - 1];
    }

    protected Collection getModifiedResources() {
        Collection<Resource> modifiedResources = super.getModifiedResources();
        if (this.suppression.isSaveNeeded() && !modifiedResources.contains(this.selectedProcessComponent.eResource())) {
            modifiedResources.add(this.selectedProcessComponent.eResource());
        }
        modifiedResources.addAll(this.resourcesToSave);
        return modifiedResources;
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        this.suppression.saveToModel();
        super.doSave(monitor);
        this.suppression.saveIsDone();
        this.resourcesToSave.clear();
        this.firePropertyChange(257);
    }

    @Override
    public boolean isDirty() {
        if (this.suppression.isSaveNeeded()) {
            return true;
        }
        return super.isDirty();
    }

    public void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
    }

    @Override
    public Collection<Resource> getUsedResources() {
        MethodConfiguration config;
        HashSet<Resource> usedResources = new HashSet<Resource>();
        Resource resource = this.elementObj.eResource();
        if (resource != null) {
            usedResources.add(resource);
        }
        if ((resource = this.selectedProcess.getPresentation().eResource()) != null) {
            usedResources.add(resource);
        }
        if ((config = this.selectedProcess.getDefaultContext()) != null && (resource = config.eResource()) != null) {
            usedResources.add(resource);
        }
        AdapterFactory adapterFactory = this.getAdapterFactoryFromTab();
        AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator(adapterFactory, (Object)this.selectedProcess);
        while (iter.hasNext()) {
            Object obj = TngUtil.unwrap(iter.next());
            if (!(obj instanceof EObject) || (resource = ((EObject)obj).eResource()) == null) continue;
            usedResources.add(resource);
        }
        this.lastUsedResources = usedResources;
        return usedResources;
    }

    protected AdapterFactory getAdapterFactoryFromTab() {
        return this.WBSTab.getAdapterFactory();
    }

    public static boolean canReveal(Collection<?> selection, AdapterFactory adapterFactory, Suppression suppression) {
        return true;
    }

    public static boolean hasInherited(Collection selection) {
        for (Object element : selection) {
            if (!ProcessUtil.isInherited(element)) continue;
            return true;
        }
        return false;
    }

    protected IPreferenceStoreWrapper getPreferenceStore() {
        IPreferenceStoreWrapper store = LibraryPlugin.getDefault().getPreferenceStore();
        return store;
    }

    protected DiagramEditorHelper getDiagramEditorHelper() {
        if (this.diagramEditorHelper == null) {
            this.diagramEditorHelper = new DiagramEditorHelper();
            this.diagramEditorHelper.getDiagramManager(this.selectedProcess);
        }
        return this.diagramEditorHelper;
    }

    public int getActivePage() {
        return super.getActivePage();
    }

    @Override
    protected ActionManager newActionManager() {
        final ArrayList adCommands = new ArrayList();
        MethodElementEditor.MeEditorActionManager mgr = new MethodElementEditor.MeEditorActionManager(this){

            protected void registerExecutedCommand(Command command) {
                ActivityDropCommand adc;
                if (command instanceof ActivityDropCommand && (adc = (ActivityDropCommand)command).getResourceFileCopyHandler() != null) {
                    adCommands.add(adc);
                }
            }

            public void saveIsDone() {
                for (ActivityDropCommand adc : adCommands) {
                    adc.scanAndCopyResources();
                }
                adCommands.clear();
                super.saveIsDone();
            }

            public void undo() {
                adCommands.clear();
                super.undo();
            }

            public boolean execute(IResourceAwareCommand cmd) {
                boolean ret = super.execute(cmd);
                if (ret) {
                    ProcessEditorUtil.deSelectSynchronize(cmd);
                }
                return ret;
            }

            public boolean doAction(int actionType, EObject object, EStructuralFeature feature, Object value, int index) {
                boolean ret = super.doAction(actionType, object, feature, value, index);
                if (ret && object instanceof Descriptor) {
                    ProcessEditorUtil.deSelectSynchonize((Descriptor)object, feature.getFeatureID());
                }
                return ret;
            }
        };
        return mgr;
    }

    private ProcessAuthoringConfigurator getConfiguratorInstance() {
        if (this.selectedProcess != null && this.selectedProcess.getDefaultContext() instanceof Scope) {
            if (this.scopeConfigurator == null) {
                Scope scope = (Scope)this.selectedProcess.getDefaultContext();
                this.scopeConfigurator = new ProcessAuthoringConfigurator((MethodConfiguration)scope){

                    public IRealizationManager getRealizationManager() {
                        return LibraryEditUtil.getInstance().getDefaultRealizationManager();
                    }
                };
            }
            return this.scopeConfigurator;
        }
        return ProcessAuthoringConfigurator.INSTANCE;
    }

    private boolean isEditingConfigFreeProcess() {
        return this.getConfiguratorInstance() == this.scopeConfigurator;
    }

    public Process getSelectedProcess() {
        return this.selectedProcess;
    }

    public synchronized void updateAndRefreshProcessModel() {
        if (this.changedElementSet == null) {
            return;
        }
        if (this.getSite().getPage().getActiveEditor() != this) {
            return;
        }
        Set<MethodElement> elementSet = this.changedElementSet;
        this.changedElementSet = null;
        Process proc = this.getSelectedProcess();
        IRealizationManager mgr = this.getConfiguratorInstance().getRealizationManager();
        if (mgr == null) {
            mgr = LibraryEditUtil.getInstance().getRealizationManager(proc.getDefaultContext());
        }
        if (proc != null && mgr != null) {
            mgr.elementUpdateProcessModel(proc, elementSet);
        }
        this.refreshAll();
    }

    public void updateOnLinkedElementChange(BreakdownElement be) {
        if (!ProcessUtil.isSynFree()) {
            return;
        }
        if (this.changedElementSet == null) {
            this.changedElementSet = new HashSet<MethodElement>();
        }
        this.changedElementSet.add((MethodElement)be);
        this.updateAndRefreshProcessModel();
    }

    private class ProcessEditorDropAdapter
    extends EditingDomainTableTreeViewerDropAdapter {
        public ProcessEditorDropAdapter(EditingDomain domain, Viewer viewer) {
            super(domain, viewer);
        }

        protected Object getDropTarget(Widget item) {
            Object target = super.getDropTarget(item);
            if (target == null && ProcessEditor.this.selectedProcessComponent != null) {
                target = ProcessEditor.this.selectedProcessComponent.getProcess();
            }
            return target;
        }

        public void drop(DropTargetEvent event) {
            if (ProcessEditor.this.currentViewer instanceof IActionTypeProvider) {
                ((IActionTypeProvider)ProcessEditor.this.currentViewer).setInputData((Object)new Point(event.x, event.y));
            }
            super.drop(event);
        }
    }
}

