/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.epf.authoring.ui.filters.ExProcessAuthoringConfigurator;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.configuration.CategorizedProcessesItemProvider;
import org.eclipse.epf.library.edit.configuration.ProcessesItemProvider;
import org.eclipse.epf.library.edit.itemsfilter.FilterUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class ActivityVariabilityFilter
extends ExProcessAuthoringConfigurator {
    private Activity activity = null;
    private List treeList = new ArrayList();
    private List generalizers = new ArrayList();
    private List baseelements = new ArrayList();
    private List badelements = new ArrayList();

    public ActivityVariabilityFilter(MethodConfiguration config, TableViewer viewer, String tabName, Activity activity) {
        super(config, (Viewer)viewer);
        this.activity = activity;
        ComposedAdapterFactory adapter = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        FilterUtil.getSubTree((AdapterFactory)adapter, (Activity)activity, (List)this.treeList);
        FilterUtil.getGeneralizers((List)this.treeList, (List)this.generalizers);
        FilterUtil.getVariabilityBase((List)this.treeList, (List)this.baseelements);
        FilterUtil.getSubTree((AdapterFactory)adapter, (List)this.generalizers, (List)this.badelements);
        FilterUtil.getSubTree((AdapterFactory)adapter, (List)this.baseelements, (List)this.badelements);
    }

    public boolean accept(Object obj) {
        if (!super.accept(obj)) {
            return false;
        }
        return this.childAccept(obj);
    }

    public boolean childAccept(Object obj) {
        if (obj instanceof ProcessesItemProvider) {
            return true;
        }
        if (obj instanceof CategorizedProcessesItemProvider) {
            return true;
        }
        if (obj instanceof Activity || obj instanceof ProcessPackage) {
            if (obj instanceof Activity) {
                if (this.activity.equals((Activity)obj)) {
                    return false;
                }
                VariabilityElement e = ((Activity)obj).getVariabilityBasedOnElement();
                if (e != null && this.activity.equals(e)) {
                    return false;
                }
            }
            if (obj instanceof BreakdownElement) {
                Process srcProc = TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)obj));
                Process targetProc = TngUtil.getOwningProcess((BreakdownElement)this.activity);
                if (srcProc instanceof DeliveryProcess && targetProc instanceof CapabilityPattern) {
                    return false;
                }
            }
            return !(obj instanceof Activity) || !TngUtil.contains((Collection)this.generalizers, (Object)obj);
        }
        return false;
    }
}

