/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.filters;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.configuration.ConfigurationFilter;
import org.eclipse.epf.library.edit.itemsfilter.FilterHelper;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.jface.viewers.Viewer;

public class DescriptorConfigurationFilter
extends ConfigurationFilter {
    String filterStr;
    MethodConfiguration methodConfiguration;
    protected FilterHelper helper;
    protected Viewer viewer;

    public DescriptorConfigurationFilter(MethodConfiguration methodConfig, Viewer viewer, String filterStr) {
        super(methodConfig);
        this.viewer = viewer;
        this.filterStr = filterStr;
        this.methodConfiguration = methodConfig;
    }

    public void notifyChanged(final Notification msg) {
        if (this.viewer == null) {
            return;
        }
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                switch (msg.getEventType()) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        DescriptorConfigurationFilter.this.viewer.refresh();
                    }
                }
            }
        });
    }

    public boolean accept(Object obj) {
        if (obj instanceof MethodConfiguration) {
            if (this.methodConfiguration != null) {
                return this.methodConfiguration.equals(obj);
            }
            return false;
        }
        if (!super.accept(obj)) {
            return false;
        }
        if (this.helper != null) {
            if (this.helper.isShowPresentationName() ? !this.helper.matchPatternOnPresentationName(obj) : !this.helper.matchPattern(obj)) {
                return false;
            }
            if (!this.helper.isObjectInSelectedItems(obj)) {
                return false;
            }
        }
        return this.childAccept(obj);
    }

    public Collection getChildren(Object obj, EStructuralFeature childFeature) {
        Collection col = super.getChildren(obj, childFeature);
        if (col != null) {
            Iterator itor = col.iterator();
            while (itor.hasNext()) {
                Object element = itor.next();
                if (this.accept(element)) continue;
                itor.remove();
            }
        } else {
            col = Collections.EMPTY_LIST;
        }
        return col;
    }

    public boolean childAccept(Object obj) {
        return false;
    }

    public void setHelper(FilterHelper helper) {
        this.helper = helper;
    }

    public void setMethodConfiguration(MethodConfiguration config) {
        super.setMethodConfiguration(config);
        this.methodConfiguration = config;
    }
}

