/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.dialogs.ConfigurationAddViewsDialog;
import org.eclipse.epf.authoring.ui.dialogs.ConfigurationOrderDialog;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditor;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditorInput;
import org.eclipse.epf.authoring.ui.filters.ProcessViewFilter;
import org.eclipse.epf.authoring.ui.providers.ConfigurationLabelProvider;
import org.eclipse.epf.authoring.ui.views.ConfigurationViewFilter;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ConfigViewPage
extends FormPage {
    private MethodConfiguration config = null;
    private String formPrefix = AuthoringUIResources.configViewPage_configuration;
    private FormToolkit toolkit;
    private CTabFolder tabFolder;
    private CTabItem tabDefaultviewItem;
    private Button removeButton;
    private Button makeDefaultButton;
    private Button orderButton;
    private Object selectedItem = null;
    private IActionManager actionMgr = null;
    private Logger logger = null;

    public ConfigViewPage(FormEditor editor) {
        super(editor, AuthoringUIResources.configViewPage_configurationViews, AuthoringUIResources.configViewPage_views);
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        ConfigurationEditorInput configInput = (ConfigurationEditorInput)input;
        this.config = configInput.getConfiguration();
        this.actionMgr = ((ConfigurationEditor)this.getEditor()).getActionManager();
        this.logger = AuthoringUIPlugin.getDefault().getLogger();
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        form.setText(String.valueOf(this.formPrefix) + this.config.getName());
        this.toolkit = managedForm.getToolkit();
        form.getBody().setLayout((Layout)new GridLayout());
        Section viewSection = this.toolkit.createSection(form.getBody(), 450);
        GridData td = new GridData(1808);
        viewSection.setLayoutData((Object)td);
        viewSection.setText(AuthoringUIResources.configViewPage_configurationViewSectionTitle);
        viewSection.setDescription(AuthoringUIResources.configViewPage_configurationViewSectionMessage);
        viewSection.setLayout((Layout)new GridLayout());
        Composite parent = this.toolkit.createComposite((Composite)viewSection);
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout());
        viewSection.setClient((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent.getParent(), AuthoringUIHelpContexts.CONFIGURATION_EDITOR_ALL_CONTEXT);
        this.createButtonPane(parent);
        this.createTabPane(parent);
        this.toolkit.paintBordersFor(parent);
        this.loadData();
    }

    private void createTabPane(Composite parent) {
        this.tabFolder = new CTabFolder(parent, 0x800880);
        this.tabFolder.setLayout((Layout)new GridLayout());
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        Color selectedColor = this.toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        this.tabFolder.setSelectionBackground(new Color[]{selectedColor, this.toolkit.getColors().getBackground()}, new int[]{50});
        this.toolkit.paintBordersFor((Composite)this.tabFolder);
    }

    private void createButtonPane(Composite parent) {
        Composite buttonPane = this.toolkit.createComposite(parent);
        buttonPane.setLayoutData((Object)new GridData(768));
        buttonPane.setLayout((Layout)new GridLayout(4, false));
        Button addButton = this.toolkit.createButton(buttonPane, AuthoringUIResources.configViewPage_addViewButtonText, 0);
        GridData gridData = new GridData(1);
        addButton.setLayoutData((Object)gridData);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessViewFilter filter = new ProcessViewFilter(ConfigViewPage.this.config, null, FilterConstants.ALL_ELEMENTS);
                ConfigurationAddViewsDialog fd = new ConfigurationAddViewsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                fd.setTypes(ConfigViewPage.this.getTypes());
                fd.setTitle(AuthoringUIResources.ConfigProcessViewDialog_SelectCategories);
                fd.setInput(ConfigViewPage.this.config);
                fd.setFilter((IFilter)filter);
                fd.setExistingElements(ConfigViewPage.this.config.getProcessViews());
                fd.setContentProvider((IStructuredContentProvider)new AdapterFactoryContentProvider(TngAdapterFactory.INSTANCE.getItemsFilter_AdapterFactory((IFilter)filter)), TngAdapterFactory.INSTANCE.getItemsFilter_ComposedAdapterFactory());
                fd.setBlockOnOpen(true);
                fd.open();
                ArrayList views = fd.getSelectedItems();
                for (Object obj : views) {
                    if (!(obj instanceof ContentCategory)) continue;
                    if (ConfigViewPage.this.config.getProcessViews().contains((ContentCategory)obj)) {
                        String name = ((ContentCategory)obj).getName();
                        String title = AuthoringUIResources.configViewPageViewExistsDialog_title;
                        String message = AuthoringUIResources.bind((String)AuthoringUIResources.configViewPageViewExistsDialog_message, (Object)name);
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(title, message);
                        continue;
                    }
                    boolean status = ConfigViewPage.this.actionMgr.doAction(3, (EObject)ConfigViewPage.this.config, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodConfiguration_ProcessViews(), (Object)((ContentCategory)obj), -1);
                    if (!status) continue;
                    ConfigViewPage.this.addView((ContentCategory)obj);
                }
            }
        });
        this.removeButton = this.toolkit.createButton(buttonPane, AuthoringUIResources.configViewPage_removeViewButtonText, 0);
        gridData = new GridData(1);
        this.removeButton.setLayoutData((Object)gridData);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigViewPage.this.removeView();
            }
        });
        this.makeDefaultButton = this.toolkit.createButton(buttonPane, AuthoringUIResources.configViewPage_makeDefaultButtonText, 0);
        gridData = new GridData(1);
        this.makeDefaultButton.setLayoutData((Object)gridData);
        this.makeDefaultButton.setEnabled(false);
        this.makeDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigViewPage.this.makeDefaultView();
            }
        });
        this.orderButton = this.toolkit.createButton(buttonPane, AuthoringUIResources.orderButton_text, 0);
        gridData = new GridData(1);
        this.removeButton.setLayoutData((Object)gridData);
        this.orderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationOrderDialog dlg = new ConfigurationOrderDialog(Display.getCurrent().getActiveShell(), ConfigViewPage.this.config, ConfigViewPage.this.getActionManager());
                int ret = dlg.open();
                if (ret == 0) {
                    ConfigViewPage.this.refresh();
                }
            }
        });
        this.toolkit.paintBordersFor(buttonPane);
    }

    private void removeView() {
        Control[] tabList;
        String defaultText;
        int idx;
        CTabItem item = this.tabFolder.getSelection();
        if (item == null) {
            return;
        }
        String itemText = item.getText();
        String title = AuthoringUIResources.configViewPageRemoveViewDialog_title;
        String message = AuthoringUIResources.bind((String)AuthoringUIResources.configViewPageRemoveViewDialog_message, (Object)item.getText());
        boolean ret = AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(title, message);
        if (!ret) {
            return;
        }
        boolean removeDefault = false;
        if (this.tabDefaultviewItem != null && item == this.tabDefaultviewItem) {
            removeDefault = true;
        }
        List views = this.config.getProcessViews();
        if (removeDefault && (idx = itemText.lastIndexOf(defaultText = " " + AuthoringUIResources.processDescription_default)) > 0) {
            itemText = itemText.substring(0, idx);
        }
        for (ContentCategory category : views) {
            if (!category.getName().equals(itemText)) continue;
            this.actionMgr.doAction(4, (EObject)this.config, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodConfiguration_ProcessViews(), (Object)category, -1);
            ContentCategory defaultView = this.config.getDefaultView();
            if (defaultView != null && defaultView.equals(category)) {
                if (views.size() > 0) {
                    this.actionMgr.doAction(1, (EObject)this.config, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodConfiguration_DefaultView(), (Object)((ContentCategory)views.get(0)), -1);
                } else {
                    this.actionMgr.doAction(1, (EObject)this.config, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodConfiguration_DefaultView(), null, -1);
                }
            }
            item.dispose();
            break;
        }
        views = this.config.getProcessViews();
        if (views == null || views.size() <= 0) {
            this.removeButton.setEnabled(false);
            this.makeDefaultButton.setEnabled(false);
        }
        if (removeDefault && (tabList = this.tabFolder.getTabList()) != null && tabList.length > 0) {
            this.tabFolder.setSelection(0);
            this.makeDefaultView();
        }
    }

    private void addView(ContentCategory obj) {
        this.selectedItem = obj;
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        TreeViewer treeViewer = new TreeViewer(composite, 2816);
        treeViewer.getTree().setLayout((Layout)new GridLayout());
        treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        ConfigurationViewFilter configFilter = new ConfigurationViewFilter(this.config, (Viewer)treeViewer);
        AdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.getConfigurationView_AdapterFactory((IFilter)configFilter);
        AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider(adapterFactory){

            public Object[] getElements(Object object) {
                ITreeItemContentProvider itemProvider = (ITreeItemContentProvider)this.adapterFactory.adapt(ConfigViewPage.this.selectedItem, ITreeItemContentProvider.class);
                return itemProvider.getChildren(ConfigViewPage.this.selectedItem).toArray();
            }
        };
        treeViewer.setContentProvider((IContentProvider)contentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationLabelProvider(this.config, adapterFactory));
        try {
            treeViewer.setInput((Object)this.config);
        }
        catch (Exception ex) {
            this.logger.logError("Error creating treeviewer for config", (Throwable)ex);
        }
        CTabItem item = new CTabItem(this.tabFolder, 128);
        item.setText(obj.getName());
        item.setControl((Control)composite);
        this.removeButton.setEnabled(true);
        this.makeDefaultButton.setEnabled(true);
        this.toolkit.paintBordersFor(composite);
        this.tabFolder.setSelection(item);
    }

    private void makeDefaultView() {
        CTabItem item = this.tabFolder.getSelection();
        List views = this.config.getProcessViews();
        for (ContentCategory category : views) {
            if (!category.getName().equals(item.getText())) continue;
            this.clearDefaultViewIndicator();
            this.actionMgr.doAction(1, (EObject)this.config, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodConfiguration_DefaultView(), (Object)category, -1);
            this.setDefaultViewIndicator(item);
            break;
        }
    }

    private void loadData() {
        List views = this.config.getProcessViews();
        Iterator itor = views.iterator();
        while (itor.hasNext()) {
            this.addView((ContentCategory)itor.next());
        }
        ContentCategory defaultView = this.config.getDefaultView();
        int cnt = this.tabFolder.getItemCount();
        if (defaultView != null) {
            CTabItem[] items = this.tabFolder.getItems();
            int i = 0;
            while (i < items.length) {
                String name = items[i].getText();
                if (name.equals(defaultView.getName())) {
                    this.tabFolder.setSelection(items[i]);
                    this.setDefaultViewIndicator(items[i]);
                    break;
                }
                ++i;
            }
        } else if (cnt > 0) {
            this.tabFolder.setSelection(0);
        }
    }

    private void refresh() {
        ContentCategory defaultView = this.config.getDefaultView();
        String defaultViewName = "";
        if (defaultView != null) {
            defaultViewName = defaultView.getName();
            this.clearDefaultViewIndicator();
        }
        String selectedView = this.tabFolder.getSelection().getText();
        HashMap<String, Control> origViews = new HashMap<String, Control>();
        int i = 0;
        while (i < this.tabFolder.getItemCount()) {
            CTabItem item = this.tabFolder.getItem(i);
            origViews.put(item.getText(), item.getControl());
            ++i;
        }
        List views = this.config.getProcessViews();
        int index = 0;
        int selectedIndex = 0;
        Iterator itor = views.iterator();
        while (itor.hasNext() && index < this.tabFolder.getItemCount()) {
            String view = ((ContentCategory)itor.next()).getName();
            CTabItem item = this.tabFolder.getItem(index++);
            item.setText(view);
            item.setControl((Control)origViews.get(view));
            if (view.equals(defaultViewName)) {
                this.setDefaultViewIndicator(item);
            }
            if (!view.equals(selectedView)) continue;
            selectedIndex = index - 1;
        }
        this.tabFolder.setSelection(selectedIndex);
    }

    private void clearDefaultViewIndicator() {
        ContentCategory defaultView = this.config.getDefaultView();
        if (defaultView != null) {
            String defaultViewTabName = String.valueOf(defaultView.getName()) + " " + AuthoringUIResources.processDescription_default;
            CTabItem[] items = this.tabFolder.getItems();
            int i = 0;
            while (i < items.length) {
                String name = items[i].getText();
                if (name.equals(defaultViewTabName)) {
                    items[i].setText(defaultView.getName());
                }
                ++i;
            }
        }
    }

    private void setDefaultViewIndicator(CTabItem item) {
        this.tabDefaultviewItem = item;
        String name = String.valueOf(item.getText()) + " " + AuthoringUIResources.processDescription_default;
        item.setText(name);
    }

    private String[] getTypes() {
        String[] Categories = new String[]{FilterConstants.CUSTOM_CATEGORIES, FilterConstants.ALL_ELEMENTS, FilterConstants.DISCIPLINES, FilterConstants.DOMAINS, FilterConstants.ROLESETS, FilterConstants.WORKPRODUCTTYPES, FilterConstants.TOOLS};
        return Categories;
    }

    protected IActionManager getActionManager() {
        return this.actionMgr;
    }
}

