/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.forms.DescriptionFormPage;
import org.eclipse.epf.authoring.ui.forms.IRefreshable;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.util.MethodElementPropUtil;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentPackageDescriptionPage
extends DescriptionFormPage
implements IRefreshable {
    private static final String FORM_PREFIX = String.valueOf(LibraryUIText.TEXT_CONTENT_PACKAGE) + ": ";
    private CheckboxTableViewer ctrl_dependency;
    private ContentPackage contentPackage;
    protected Button supportingCheckbox;

    public ContentPackageDescriptionPage(FormEditor editor) {
        super(editor, AuthoringUIText.DESCRIPTION_PAGE_TITLE, AuthoringUIText.DESCRIPTION_PAGE_TITLE);
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.contentPackage = (ContentPackage)this.methodElement;
        this.detailSectionOn = false;
        this.fullDescOn = false;
        this.keyConsiderationOn = false;
        this.variabilitySectionOn = false;
        this.versionSectionOn = false;
    }

    @Override
    protected void createEditorContent(FormToolkit toolkit) {
        super.createEditorContent(toolkit);
        this.createDependencySection(toolkit);
        Display display = this.form.getBody().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    if (ContentPackageDescriptionPage.this.ctrl_name.isDisposed()) {
                        return;
                    }
                    if (ContentPackageDescriptionPage.this.isAutoGenName()) {
                        ContentPackageDescriptionPage.this.ctrl_presentation_name.setFocus();
                        ContentPackageDescriptionPage.this.ctrl_presentation_name.setSelection(0, ContentPackageDescriptionPage.this.ctrl_presentation_name.getText().length());
                    } else {
                        ContentPackageDescriptionPage.this.ctrl_name.setFocus();
                        ContentPackageDescriptionPage.this.ctrl_name.setSelection(0, ContentPackageDescriptionPage.this.ctrl_name.getText().length());
                    }
                }
            });
        }
    }

    private void createDependencySection(FormToolkit toolkit) {
        Section dependencySection = this.createSection(toolkit, this.sectionComposite, AuthoringUIText.DEPENDENCIES_SECTION_NAME, AuthoringUIText.DEPENDENCIES_SECTION_DESC);
        Composite dependencyComposite = this.createComposite(toolkit, dependencySection);
        Table ctrl_table = toolkit.createTable(dependencyComposite, 553);
        GridData gridData = new GridData(769);
        gridData.heightHint = 100;
        ctrl_table.setLayoutData((Object)gridData);
        this.ctrl_dependency = new CheckboxTableViewer(ctrl_table);
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ContentPackage) {
                    return TngUtil.getLabelWithPath((Object)((ContentPackage)element));
                }
                return element.toString();
            }
        };
        this.ctrl_dependency.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.ctrl_dependency.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ContentPackage) {
                    return ContentPackageDescriptionPage.this.getDependenciesPackages(ContentPackageDescriptionPage.this.contentPackage).toArray();
                }
                return Collections.EMPTY_LIST.toArray();
            }
        });
        this.ctrl_dependency.setSorter(new ViewerSorter());
        this.ctrl_dependency.setInput((Object)this.contentPackage);
        this.ctrl_dependency.setAllChecked(true);
        this.ctrl_dependency.setAllGrayed(true);
        toolkit.paintBordersFor(dependencyComposite);
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.form.addListener(26, new Listener(){

            public void handleEvent(Event e) {
                ContentPackageDescriptionPage.this.ctrl_dependency.refresh();
                ContentPackageDescriptionPage.this.ctrl_dependency.setAllChecked(true);
                ContentPackageDescriptionPage.this.ctrl_dependency.setAllGrayed(true);
            }
        });
        this.ctrl_dependency.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object obj = event.getSource();
                ((CheckboxTableViewer)obj).setAllChecked(true);
            }
        });
    }

    public Collection<ContentPackage> getDependenciesPackages(ContentPackage contentPackage) {
        ArrayList<ContentElement> elements = new ArrayList<ContentElement>();
        for (ContentElement contentElement : contentPackage.getContentElements()) {
            if (contentElement.getVariabilityBasedOnElement() != null) {
                elements.add((ContentElement)contentElement.getVariabilityBasedOnElement());
            }
            elements.addAll(MethodElementUtil.getSelectedGuidances((EObject)contentElement));
            boolean cfr_ignored_0 = contentElement instanceof Role;
            if (contentElement instanceof Task) {
                if (((Task)contentElement).getPerformedBy() != null) {
                    elements.addAll(((Task)contentElement).getPerformedBy());
                }
                if (((Task)contentElement).getAdditionallyPerformedBy() != null) {
                    elements.addAll(((Task)contentElement).getAdditionallyPerformedBy());
                }
                if (((Task)contentElement).getMandatoryInput() != null) {
                    elements.addAll(((Task)contentElement).getMandatoryInput());
                }
                if (((Task)contentElement).getOptionalInput() != null) {
                    elements.addAll(((Task)contentElement).getOptionalInput());
                }
                if (((Task)contentElement).getOutput() != null) {
                    elements.addAll(((Task)contentElement).getOutput());
                }
            }
            boolean cfr_ignored_1 = contentElement instanceof WorkProduct;
        }
        ArrayList<ContentPackage> cpList = new ArrayList<ContentPackage>();
        int i = 0;
        while (i < elements.size()) {
            EObject object = ((ContentElement)elements.get(i)).eContainer();
            if (object instanceof ContentPackage && !contentPackage.equals(object) && !cpList.contains((ContentPackage)object)) {
                cpList.add((ContentPackage)object);
            }
            ++i;
        }
        return cpList;
    }

    @Override
    protected Object getContentElement() {
        return this.contentPackage;
    }

    @Override
    public void loadSectionDescription() {
        this.generalSectionDescription = MessageFormat.format(AuthoringUIText.GENERAL_INFO_SECTION_DESC, LibraryUIText.getUITextLower((MethodElement)this.contentPackage));
    }

    @Override
    protected void refresh(boolean editable) {
        super.refresh(editable);
        if (this.supportingCheckbox != null) {
            this.supportingCheckbox.setEnabled(editable);
            EObject parent = this.contentPackage.eContainer();
            if (parent instanceof MethodPlugin && ((MethodPlugin)parent).isSupporting()) {
                this.supportingCheckbox.setEnabled(false);
            } else if (parent instanceof ContentPackage && MethodElementPropUtil.getMethodElementPropUtil().isSupporting((ContentPackage)parent)) {
                this.supportingCheckbox.setEnabled(false);
            }
        }
    }

    public void updateSupportingCheckbox() {
        boolean isSuporting;
        if (this.supportingCheckbox == null) {
            return;
        }
        MethodElementPropUtil propUtil = MethodElementPropUtil.getMethodElementPropUtil();
        boolean isSupporitng0 = propUtil.ancestorIsSupporting(this.contentPackage);
        boolean bl = isSuporting = isSupporitng0 || propUtil.isSupporting(this.contentPackage);
        if (this.supportingCheckbox.getSelection() != isSuporting) {
            this.supportingCheckbox.setSelection(isSuporting);
        }
        if (isSupporitng0) {
            this.supportingCheckbox.setEnabled(false);
        }
    }

    @Override
    protected void createGeneralSectionContent() {
        super.createGeneralSectionContent();
        this.supportingCheckbox = this.toolkit.createButton(this.generalComposite, AuthoringUIResources.contentPackageDescriptionPage_supportingPackageLabel, 32);
    }

    @Override
    protected void addGeneralSectionListeners() {
        super.addGeneralSectionListeners();
        this.supportingCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStatus status = TngUtil.checkEdit((EObject)ContentPackageDescriptionPage.this.contentPackage, (Object)ContentPackageDescriptionPage.this.getSite().getShell());
                if (!status.isOK()) {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.editDialog_title, AuthoringUIResources.editDialog_msgCannotEdit, status);
                    ContentPackageDescriptionPage.this.supportingCheckbox.setSelection(!ContentPackageDescriptionPage.this.supportingCheckbox.getSelection());
                    return;
                }
                MethodElementPropUtil propUtil = MethodElementPropUtil.getMethodElementPropUtil((IActionManager)ContentPackageDescriptionPage.this.actionMgr);
                propUtil.setSupporting(ContentPackageDescriptionPage.this.contentPackage, ContentPackageDescriptionPage.this.supportingCheckbox.getSelection());
                propUtil.updatePackageSupportingBits((Collection)ContentPackageDescriptionPage.this.contentPackage.getChildPackages(), ContentPackageDescriptionPage.this.supportingCheckbox.getSelection());
            }
        });
    }

    @Override
    protected void loadGeneralSectionData() {
        super.loadGeneralSectionData();
        boolean isSuporting = MethodElementPropUtil.getMethodElementPropUtil().isSupporting(this.contentPackage);
        this.supportingCheckbox.setSelection(isSuporting);
    }
}

