/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.actions.LibraryViewDeleteAction;
import org.eclipse.epf.authoring.ui.filters.AllFilter;
import org.eclipse.epf.authoring.ui.forms.AssociationFormPage;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.MethodElementSetPropertyCommand;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.util.CategorySortHelper;
import org.eclipse.epf.library.edit.util.ContentElementOrderList;
import org.eclipse.epf.library.edit.util.MethodElementPropertyHelper;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.library.util.LibraryManager;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.TermDefinition;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.MessageException;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.epf.uma.util.UserDefinedTypeMeta;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomCategoryAssignPage
extends AssociationFormPage {
    private static final String FORM_PAGE_ID = "customCategoryAssignPage";
    private CustomCategory category;
    private ContentElementOrderList allSteps;
    private Button includeCheckBox;
    private ComboViewer typeComboViewer;

    public CustomCategoryAssignPage(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIText.ASSIGN_PAGE_TITLE);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.ctrl_add.setText(AuthoringUIResources.assignAction_text);
        this.ctrl_remove.setText(AuthoringUIResources.unassignAction_text);
        this.createIncludeComposite();
    }

    private void createIncludeComposite() {
        CustomCategoryAssignPage.createCompositeForButtons(this.toolkit, this.aComposite);
        Composite composite = CustomCategoryAssignPage.createComposite(this.toolkit, this.aComposite, 1808, 1, 1, 2);
        this.includeCheckBox = this.toolkit.createButton(composite, AuthoringUIResources.CustomCategoryAssignPage_includeElementsOfType, 32);
        this.includeCheckBox.setLayoutData((Object)new GridData(1));
        Combo typeCombo = new Combo(composite, 0x80000C);
        typeCombo.setLayoutData((Object)new GridData(1));
        this.typeComboViewer = new ComboViewer(typeCombo);
        this.typeComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.typeComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof EClass) {
                    return TngUtil.getTypeText((EClass)((EClass)element));
                }
                if (element instanceof UserDefinedTypeMeta) {
                    return (String)((UserDefinedTypeMeta)element).getRteNameMap().get("typeName");
                }
                return super.getText(element);
            }
        });
        ArrayList allTypeValues = new ArrayList();
        allTypeValues.addAll(LibraryUtil.getIncludedElementTypes());
        allTypeValues.addAll(LibraryUtil.getAllUDTMetas());
        this.typeComboViewer.setInput((Object)allTypeValues.toArray());
        MethodElementProperty prop = MethodElementPropertyHelper.getProperty((MethodElement)this.category, (String)"include");
        if (prop != null) {
            this.includeCheckBox.setSelection(true);
            EClassifier item = null;
            EClassifier cls = UmaPackage.eINSTANCE.getEClassifier(prop.getValue());
            if (cls != null && cls instanceof EClass) {
                item = cls;
            } else if (cls == null) {
                item = LibraryUtil.getUDTMetaFromId((String)prop.getValue());
            }
            if (item != null) {
                this.typeComboViewer.setSelection((ISelection)new StructuredSelection((Object)item));
            }
        } else {
            typeCombo.setEnabled(false);
        }
        this.includeCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomCategoryAssignPage.this.typeComboViewer.getCombo().setEnabled(CustomCategoryAssignPage.this.includeCheckBox.getSelection());
                CustomCategoryAssignPage.this.updateInclude();
            }
        });
        this.typeComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (CustomCategoryAssignPage.this.includeCheckBox.getSelection()) {
                    CustomCategoryAssignPage.this.updateInclude();
                }
            }
        });
    }

    private void updateInclude() {
        if (this.includeCheckBox.getSelection()) {
            String type = null;
            IStructuredSelection selection = (IStructuredSelection)this.typeComboViewer.getSelection();
            if (selection.isEmpty()) {
                type = "";
            } else if (selection.getFirstElement() instanceof EClass) {
                type = ((EClass)selection.getFirstElement()).getName();
            } else if (selection.getFirstElement() instanceof UserDefinedTypeMeta) {
                type = (String)((UserDefinedTypeMeta)selection.getFirstElement()).getRteNameMap().get("typeId");
            }
            MethodElementSetPropertyCommand cmd = new MethodElementSetPropertyCommand((MethodElement)this.category, "include", type);
            this.getActionManager().execute((IResourceAwareCommand)cmd);
        } else {
            MethodElementProperty prop = MethodElementPropertyHelper.getProperty((MethodElement)this.category, (String)"include");
            if (prop != null) {
                this.getActionManager().doAction(4, (EObject)this.category, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_MethodElementProperty(), (Object)prop, -1);
            }
        }
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.category = (CustomCategory)this.contentElement;
        this.setUseCategory2(false);
        this.setUseCategory3(false);
        this.setAllowChange1(true);
        this.setIsUpAndDownButtonsRequired1(true);
    }

    @Override
    protected void initContentProviderSelected() {
        this.contentProviderSelected = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                if (CustomCategoryAssignPage.this.allSteps == null) {
                    CustomCategoryAssignPage.this.allSteps = CustomCategoryAssignPage.this.getProviderExtender().newContentElementOrderList((VariabilityElement)CustomCategoryAssignPage.this.contentElement, 1, CustomCategoryAssignPage.this.getOrderFeature(), 1);
                }
                if (CustomCategoryAssignPage.this.getProviderExtender().useContentProviderAPIs()) {
                    return CustomCategoryAssignPage.this.getProviderExtender().getElements(object, 1);
                }
                List returnList = CategorySortHelper.sortCategoryElements((MethodElement)CustomCategoryAssignPage.this.contentElement, (Object[])CustomCategoryAssignPage.this.allSteps.toArray());
                return returnList.toArray();
            }
        };
        this.viewer_selected.setContentProvider((IContentProvider)this.contentProviderSelected);
    }

    @Override
    protected void addItemsToModel1(ArrayList addItems) {
        CustomCategoryAssignPage.addItemsToModel1(addItems, this.category, this.usedCategories, this.getActionManager(), CustomCategoryAssignPage.getAncestors(this.category));
        if (!addItems.isEmpty()) {
            this.setDirty(true);
        }
    }

    public static void addItemsToModel1(ArrayList addItems, CustomCategory category, ArrayList usedCategories, IActionManager actionManager, List<Object> ancestors) {
        boolean ok = DependencyChecker.checkCircularForMovingVariabilityElement((VariabilityElement)category, (Collection)addItems);
        if (!ok) {
            String title = AuthoringUIResources.circular_dependency_error_title;
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, LibraryEditResources.circular_dependency_error_msg);
            return;
        }
        if (!addItems.isEmpty()) {
            for (MethodElement customCategory : addItems) {
                if (customCategory instanceof CustomCategory && TngUtil.isRootCustomCategory((CustomCategory)((CustomCategory)customCategory)) || ancestors.contains(customCategory)) continue;
                if (customCategory instanceof ProcessComponent) {
                    Process object = ((ProcessComponent)customCategory).getProcess();
                    LibraryManager.getInstance().addToCustomCategory(actionManager, category, (MethodElement)object, (List)usedCategories);
                    continue;
                }
                LibraryManager.getInstance().addToCustomCategory(actionManager, category, customCategory, (List)usedCategories);
            }
        }
    }

    @Override
    protected void removeItemsFromModel1(ArrayList rmItems) {
        CustomCategoryAssignPage.removeItemsFromModel1(rmItems, this.category, this.usedCategories, this.getActionManager(), CustomCategoryAssignPage.getAncestors(this.category));
        if (!rmItems.isEmpty()) {
            this.setDirty(true);
        }
    }

    public static void removeItemsFromModel1(ArrayList rmItems, CustomCategory category, ArrayList usedCategories, IActionManager actionManager, List<Object> ancestors) {
        if (!rmItems.isEmpty()) {
            ArrayList customCategoriesToDelete = new ArrayList();
            MethodPlugin currentPlugin = UmaUtil.getMethodPlugin((EObject)category);
            for (MethodElement e : rmItems) {
                if (e instanceof CustomCategory && TngUtil.isInPluginWithLessThanOneSuperCustomCategory((CustomCategory)((CustomCategory)e), (MethodPlugin)currentPlugin)) {
                    CustomCategory rootCC = TngUtil.getRootCustomCategory((MethodPlugin)currentPlugin);
                    if (rootCC == category) {
                        return;
                    }
                    LibraryManager.getInstance().addToCustomCategory(actionManager, rootCC, e, new ArrayList());
                }
                LibraryManager.getInstance().removeFromCustomCategory(actionManager, category, e, (List)usedCategories);
            }
            if (customCategoriesToDelete.size() > 0) {
                int i = 0;
                StringBuffer elementStr = new StringBuffer();
                Iterator it = customCategoriesToDelete.iterator();
                while (it.hasNext()) {
                    Object obj = TngUtil.unwrap(it.next());
                    if (!(obj instanceof MethodElement)) continue;
                    if (i > 0) {
                        elementStr.append(", ");
                    }
                    elementStr.append(((MethodElement)obj).getName());
                    ++i;
                }
                if (!AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(AuthoringUIResources.remove_text, NLS.bind((String)AuthoringUIResources.promptDeleteCustomCategoryBeforeRemoveLastRefToIt, (Object)elementStr))) {
                    return;
                }
                LibraryViewDeleteAction deleteAction = new LibraryViewDeleteAction(){

                    public void run() {
                        String title = AuthoringUIResources.actions_LibraryActionBarContributor_deleteErrorTitle;
                        this.confirm = false;
                        try {
                            super.run();
                        }
                        catch (MessageException e) {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, e.getMessage());
                        }
                        catch (Exception e) {
                            String details = TngUtil.toStackTraceString((Throwable)e);
                            String message = AuthoringUIResources.actions_LibraryActionBarContributor_deleteErrorMessage;
                            String reason = AuthoringUIResources.actions_LibraryActionBarContributor_deleteErrorReason;
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, message, reason, details, (Throwable)e);
                        }
                    }

                    protected void deleteFailed() {
                        String libDir = LibraryService.getInstance().getCurrentMethodLibraryLocation();
                        LibraryUIManager.getInstance().openLibrary(libDir);
                    }
                };
                deleteAction.setEditingDomain(LibraryView.getView().getEditingDomain());
                deleteAction.selectionChanged((IStructuredSelection)new StructuredSelection(customCategoriesToDelete));
                deleteAction.run();
            }
        }
    }

    public static List<Object> getAncestors(CustomCategory methodObject) {
        ArrayList<Object> ancestorList = new ArrayList<Object>();
        ArrayList<Object> objList = new ArrayList<Object>();
        objList.add(methodObject);
        CustomCategoryAssignPage.getAncestors(ancestorList, objList);
        return ancestorList;
    }

    private static List<Object> getAncestors(List<Object> ancestorList, List<Object> methodObjectList) {
        if (methodObjectList.isEmpty()) {
            return ancestorList;
        }
        ArrayList allParentCustCats = new ArrayList();
        for (CustomCategory customCategory : methodObjectList) {
            List parentList = AssociationHelper.getCustomCategories((DescribableElement)customCategory);
            allParentCustCats.addAll(parentList);
        }
        ancestorList.addAll(methodObjectList);
        ArrayList<Object> nextCheckList = new ArrayList<Object>();
        for (Object element : allParentCustCats) {
            if (ancestorList.contains(element)) continue;
            nextCheckList.add(element);
        }
        return CustomCategoryAssignPage.getAncestors(ancestorList, nextCheckList);
    }

    @Override
    protected Object getContentElement() {
        return this.category;
    }

    @Override
    protected String getTabString() {
        return FilterConstants.ALL_ELEMENTS;
    }

    @Override
    protected IFilter getFilter() {
        this.filter = new CustomCategoryAssignFilter();
        return this.filter;
    }

    @Override
    protected String getMultipleSelectDescription(int count) {
        return super.getMultipleSelectDescription(count, AuthoringUIResources.customCategoryAssignPage_multipleSelectDescription);
    }

    @Override
    protected String getSectionDescription() {
        return AuthoringUIResources.customCategoryAssignPage_sectionDescription;
    }

    @Override
    protected String getSectionName() {
        return AuthoringUIResources.customCategoryAssignPage_sectionName;
    }

    @Override
    protected String getSelectedLabel() {
        return AuthoringUIResources.customCategoryAssignPage_selectedLabel;
    }

    @Override
    protected String getSelectedLabel2() {
        return null;
    }

    @Override
    protected String getSelectedLabel3() {
        return null;
    }

    @Override
    protected EStructuralFeature getOrderFeature() {
        return UmaPackage.eINSTANCE.getCustomCategory_CategorizedElements();
    }

    @Override
    protected String[] getModelStructurePath() {
        return ModelStructure.DEFAULT.customCategoryPath;
    }

    @Override
    public ContentElementOrderList getContentElementOrderList() {
        return this.allSteps;
    }

    private class CustomCategoryAssignFilter
    extends AllFilter {
        private CustomCategoryAssignFilter() {
        }

        protected boolean childAccept(Object obj) {
            if (obj instanceof ProcessPackage) {
                return true;
            }
            if (obj instanceof Process) {
                return true;
            }
            if (obj instanceof Milestone) {
                return true;
            }
            if (obj instanceof Activity) {
                return true;
            }
            if (obj instanceof CustomCategory && TngUtil.isRootCustomCategory((CustomCategory)((CustomCategory)obj))) {
                return !((CustomCategory)obj).getCategorizedElements().isEmpty();
            }
            if (obj instanceof TermDefinition) {
                return false;
            }
            if (obj instanceof ContentElement) {
                return !this.getHelper().isContributor((ContentElement)obj);
            }
            return false;
        }
    }
}

