/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import com.ibm.icu.text.DateFormat;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIExtensionManager;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.filters.ContentFilter;
import org.eclipse.epf.authoring.ui.forms.BaseFormPage;
import org.eclipse.epf.authoring.ui.forms.IColumnProvider;
import org.eclipse.epf.authoring.ui.forms.IRefreshable;
import org.eclipse.epf.authoring.ui.forms.ISectionProvider;
import org.eclipse.epf.authoring.ui.preferences.AuthoringUIPreferences;
import org.eclipse.epf.authoring.ui.providers.ColumnElement;
import org.eclipse.epf.authoring.ui.providers.DescriptionPageColumnProvider;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichTextEditor;
import org.eclipse.epf.authoring.ui.util.EditorsContextHelper;
import org.eclipse.epf.authoring.ui.util.UIHelper;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.MethodPluginPropUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.library.ui.LibraryUIUtil;
import org.eclipse.epf.library.ui.actions.MethodElementDeleteAction;
import org.eclipse.epf.library.ui.util.ConvertGuidanceType;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.richtext.RichTextListener;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DescriptionFormPage
extends BaseFormPage
implements IRefreshable {
    public static final int BUTTON_WIDTH = 150;
    protected static final String NOT_APPLICABLE_TEXT = AuthoringUIResources.notApplicable_text;
    protected static final String CONTRIBUTES_TEXT = AuthoringUIResources.contributes_text;
    private static final String LOCAL_CONTRIBUTES_TEXT = AuthoringUIResources.localContributes_text;
    protected static final String EXTENDS_TEXT = AuthoringUIResources.extends_text;
    protected static final String REPLACES_TEXT = AuthoringUIResources.replaces_text;
    protected static final String LOCAL_REPLACES_TEXT = AuthoringUIResources.localReplaces_text;
    protected static final String EXTENDS_REPLACES_TEXT = AuthoringUIResources.extendsReplaces_text;
    protected static final ILabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngUtil.umaItemProviderAdapterFactory);
    protected Section formSection;
    protected Composite sectionComposite;
    private Composite mainComposite;
    protected Composite expandedComposite;
    protected Section generalSection;
    protected Section variabilitySection;
    protected Composite generalComposite;
    protected Composite variabilityComposite;
    protected Section versionSection;
    protected Composite versionComposite;
    protected Section iconSection;
    protected Composite iconComposite;
    private Canvas pane1;
    private Canvas pane3;
    protected Section detailSection;
    protected Composite detailComposite;
    protected Section notationSection;
    protected Composite notationComposite;
    protected Section tailoringSection;
    protected Composite tailoringComposite;
    protected Text ctrl_name;
    protected Text ctrl_presentation_name;
    protected Text ctrl_long_presentation_name;
    protected Label ctrl_type_label;
    protected Button ctrl_type_button;
    protected Text ctrl_brief_desc;
    protected IMethodRichText ctrl_full_desc;
    protected IMethodRichText ctrl_key;
    protected IMethodRichTextEditor ctrl_expanded;
    protected ComboViewer viewer_variability;
    protected Combo ctrl_variability;
    protected Label label_base;
    protected TableViewer base_viewer;
    protected Table ctrl_base;
    protected Button ctrl_base_button;
    private IMethodRichText activeControl;
    private Text ctrl_authors;
    protected Text ctrl_change_date;
    private Text ctrl_change_desc;
    private Text ctrl_version;
    protected Label label_copyright;
    protected TableViewer copyright_viewer;
    protected Table ctrl_copyright;
    private Button copyright_button;
    private Button copyright_button_deselect;
    protected ImageHyperlink expandDetailLink;
    protected Label expandDetailLabel;
    protected ImageHyperlink expandNotationLink;
    protected Label expandNotationLabel;
    protected ImageHyperlink expandTailoringLink;
    protected Label expandTailoringLabel;
    protected IMethodRichText ctrl_purpose;
    protected Text ctrl_external_id;
    private Image shapeImage;
    private Image nodeImage;
    protected Button ctrl_select_shapeIcon_button;
    protected Button ctrl_clear_shapeIcon_button;
    protected Button ctrl_select_nodeIcon_button;
    protected Button ctrl_clear_nodeIcon_button;
    protected Button ctrl_publish_categories_button;
    protected ImageHyperlink expandVersionLink;
    protected Label expandVersionLabel;
    protected ImageHyperlink expandLink;
    protected Label expandLabel;
    protected IStructuredContentProvider contentProviderVariability;
    protected IStructuredContentProvider contentProviderBase;
    private IColumnProvider columnProvider;
    protected List<ISectionProvider> sectionProviders;
    private boolean autoGenName = false;
    private DescriptionFormSectionExtender extender;
    protected ILabelProvider labelProviderVariability = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public String getText(Object object) {
            VariabilityType varObject = (VariabilityType)object;
            if (varObject == VariabilityType.NA) {
                return NOT_APPLICABLE_TEXT;
            }
            if (varObject == VariabilityType.CONTRIBUTES) {
                return CONTRIBUTES_TEXT;
            }
            if (varObject == VariabilityType.LOCAL_CONTRIBUTION) {
                return LOCAL_CONTRIBUTES_TEXT;
            }
            if (varObject == VariabilityType.EXTENDS) {
                return EXTENDS_TEXT;
            }
            if (varObject == VariabilityType.REPLACES) {
                return REPLACES_TEXT;
            }
            if (varObject == VariabilityType.LOCAL_REPLACEMENT) {
                return LOCAL_REPLACES_TEXT;
            }
            if (varObject == VariabilityType.EXTENDS_REPLACES) {
                return EXTENDS_REPLACES_TEXT;
            }
            return null;
        }
    };
    protected ILabelProvider labelProviderBase = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public String getColumnText(Object object, int columnIndex) {
            return TngUtil.getLabelWithPath((Object)object);
        }
    };
    protected IActionManager actionMgr;
    protected IStructuredContentProvider copyrightContentProvider;
    private ILabelProvider copyrightLabelProviderBase = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
    protected ModifyListener modelModifyListener;
    protected MethodElementEditor.ModifyListener nameModifyListener;
    protected ModifyListener contentModifyListener;
    protected FocusAdapter nameFocusListener = new FocusAdapter(){

        public void focusGained(FocusEvent e) {
            ((MethodElementEditor)DescriptionFormPage.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
        }

        public void focusLost(FocusEvent e) {
            String oldContent = DescriptionFormPage.this.methodElement.getName();
            String name = DescriptionFormPage.this.ctrl_name.getText().trim();
            if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(e.widget, DescriptionFormPage.this.methodElement.getName())) {
                return;
            }
            if (name.equals(DescriptionFormPage.this.methodElement.getName())) {
                return;
            }
            String msg = null;
            if (oldContent.indexOf("&") < 0 && name.indexOf("&") > -1) {
                msg = NLS.bind((String)LibraryEditResources.invalidElementNameError4_msg, (Object)name);
            } else {
                IValidator validator = DescriptionFormPage.this.getNameValidator();
                if (validator == null) {
                    validator = IValidatorFactory.INSTANCE.createNameValidator((NamedElement)DescriptionFormPage.this.methodElement, (AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
                }
                msg = validator.isValid(name);
            }
            if (msg == null && !name.equals(DescriptionFormPage.this.methodElement.getName()) && name.indexOf("&") > -1) {
                msg = NLS.bind((String)LibraryEditResources.invalidElementNameError4_msg, (Object)name);
            }
            if (msg == null) {
                name = StrUtil.makeValidFileName((String)DescriptionFormPage.this.ctrl_name.getText());
                DescriptionFormPage.this.ctrl_name.setText(name);
                if (!name.equals(DescriptionFormPage.this.methodElement.getName()) && !DescriptionFormPage.this.changeElementName(name)) {
                    return;
                }
            } else {
                if (msg.indexOf("&") >= 0) {
                    msg = msg.replace("&", "&&");
                }
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.renameError_title, msg);
                DescriptionFormPage.this.ctrl_name.setText(DescriptionFormPage.this.methodElement.getName());
                DescriptionFormPage.this.ctrl_name.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        (this).DescriptionFormPage.this.ctrl_name.setFocus();
                        (this).DescriptionFormPage.this.ctrl_name.selectAll();
                    }
                });
            }
        }
    };
    protected boolean descExpandFlag = false;
    protected boolean generalSectionExpandFlag = false;
    protected boolean detailSectionExpandFlag = false;
    protected boolean notationSectionExpandFlag = false;
    protected boolean tailoringSectionExpandFlag = false;
    protected boolean versionSectionExpandFlag = false;
    protected boolean elementSectionExpandFlag = false;
    protected boolean iconSectionExpandFlag = false;
    protected boolean fullDescOn = true;
    protected boolean keyConsiderationOn = true;
    protected boolean briefDescOn = true;
    protected boolean elementTypeOn = false;
    protected boolean contentFieldOn = false;
    protected boolean versionSectionOn = true;
    protected boolean anyAttributeModified = false;
    protected boolean generalSectionOn = true;
    protected boolean notationSectionOn = false;
    protected boolean detailSectionOn = true;
    protected boolean tailoringSectionOn = false;
    protected boolean variabilitySectionOn = true;
    protected boolean slotSectionOn = false;
    protected boolean purposeOn = false;
    protected boolean externalIdOn = false;
    protected boolean iconSectionOn = false;
    protected boolean publishCategoryOn = false;
    protected boolean publishPracticeOn = false;
    protected boolean publishPracticeOnForUDT = false;
    protected boolean longPresentationNameOn = false;
    protected static final int GENERAL_SECTION_ID = 1;
    protected static final int DETAIL_SECTION_ID = 2;
    protected static final int VERSION_SECTION_ID = 3;
    protected static final int NOTATION_SECTION_ID = 4;
    protected static final int TAILORING_SECTION_ID = 5;
    private int warningCount = 1;
    private int SECTIONS = 0;
    private static int SHAPEICON_WIDTH_MAX = 32;
    private static int SHAPEICON_HEIGHT_MAX = 32;
    private static int NODEICON_WIDTH_MAX = 16;
    private static int NODEICON_HEIGHT_MAX = 16;
    protected IFilter filter;
    private boolean disposed;
    public String generalSectionDescription;
    public String detailSectionDescription;
    public String tailoringSectionDescription;
    public String notationSectionDescription;
    public String variabilitySectionDescription;
    public String iconSectionDescription;
    public String versionSectionDescription;
    private Label nodeIconPath;
    private Label shapeIconPath;
    private String[] imageTypes = new String[]{"*.gif;*.jpg;*.png;*.ico;*.bmp"};
    private String[] imageNames = new String[]{"Image (gif, jpeg, png, ico, bmp)"};

    protected boolean changeElementName(String name) {
        Resource contentResource;
        Resource resource;
        boolean success = this.actionMgr.doAction(1, (EObject)this.methodElement, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)name, -1);
        if (!success) {
            return false;
        }
        if (this.methodElement instanceof MethodConfiguration && (resource = this.methodElement.eResource()) != null) {
            ((MethodElementEditor)this.getEditor()).addResourceToAdjustLocation(resource);
        }
        if (ContentDescriptionFactory.hasPresentation((MethodElement)this.methodElement) && (contentResource = this.contentElement.getPresentation().eResource()) != null) {
            ((MethodElementEditor)this.getEditor()).addResourceToAdjustLocation(contentResource);
        }
        this.setFormTextWithVariableInfo();
        this.ctrl_name.setText(name);
        return true;
    }

    protected IFilter getFilter() {
        return this.filter;
    }

    protected Object getContentElement() {
        return null;
    }

    protected void initContentProviderBase() {
        this.contentProviderBase = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                ArrayList<VariabilityElement> base_selected_list = new ArrayList<VariabilityElement>();
                if (DescriptionFormPage.this.contentElement.getVariabilityBasedOnElement() != null) {
                    base_selected_list.add(DescriptionFormPage.this.contentElement.getVariabilityBasedOnElement());
                }
                return base_selected_list.toArray();
            }

            public void notifyChanged(Notification notification) {
                switch (notification.getFeatureID(VariabilityElement.class)) {
                    case 10: {
                        super.notifyChanged(notification);
                    }
                }
            }
        };
        this.base_viewer.setContentProvider((IContentProvider)this.contentProviderBase);
    }

    public DescriptionFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
        this.extender = AuthoringUIExtensionManager.getInstance().createDescriptionFormSectionExtender(this);
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.init_();
    }

    protected void init_() {
        if (AuthoringUIPreferences.getEnableAutoNameGen() && AuthoringUIPreferences.getEnableAutoNameGen() && LibraryUtil.hasNameTrackPresentationNameMark((MethodElement)this.methodElement)) {
            this.setAutoGenName(true);
        }
        VariabilityType[] types = new VariabilityType[]{VariabilityType.NA, VariabilityType.CONTRIBUTES, VariabilityType.EXTENDS, VariabilityType.REPLACES, VariabilityType.EXTENDS_REPLACES};
        this.contentProviderVariability = new VariabilityTypeContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory(), types);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.createEditorContent(this.toolkit);
        this.setContextHelp();
        this.setFormTextWithVariableInfo();
        this.loadData();
        this.addListeners();
    }

    protected void setFormTextWithVariableInfo() {
        UIHelper.setFormText(this.form, this.methodElement);
    }

    public String getLabel(VariabilityElement object, String alternativeLabel, boolean preferBase) {
        String label = TngUtil.getLabel((Object)object, (String)alternativeLabel);
        if (preferBase && object.getVariabilityBasedOnElement() != null) {
            VariabilityType type = object.getVariabilityType();
            String variabilityTxt = null;
            if (type == VariabilityType.CONTRIBUTES) {
                variabilityTxt = AuthoringUIResources.contributes_to_text;
            } else if (type == VariabilityType.LOCAL_CONTRIBUTION) {
                variabilityTxt = AuthoringUIResources.localContributes_text;
            } else if (type == VariabilityType.EXTENDS) {
                variabilityTxt = AuthoringUIResources.extends_text;
            } else if (type == VariabilityType.REPLACES) {
                variabilityTxt = AuthoringUIResources.replaces_text;
            } else if (type == VariabilityType.LOCAL_REPLACEMENT) {
                variabilityTxt = AuthoringUIResources.localReplaces_text;
            } else if (type == VariabilityType.EXTENDS_REPLACES) {
                variabilityTxt = AuthoringUIResources.extendsReplaces_text;
            }
            if (variabilityTxt != null) {
                StringBuffer strBuf = new StringBuffer(label).append(" (").append(variabilityTxt).append(" '").append(TngUtil.getLabel((Object)object.getVariabilityBasedOnElement(), (String)alternativeLabel)).append("'");
                MethodPlugin basePlugin = UmaUtil.getMethodPlugin((EObject)object.getVariabilityBasedOnElement());
                if (basePlugin != null) {
                    strBuf.append(" in '").append(basePlugin.getName()).append("')");
                }
                label = strBuf.toString();
            }
        }
        return label;
    }

    protected void createEditorContent(FormToolkit toolkit) {
        this.createFormComposites(toolkit);
        this.loadSectionDescription();
        this.loadSectionProviders();
        if (this.generalSectionOn) {
            this.createGeneralSection(toolkit);
            toolkit.paintBordersFor(this.generalComposite);
            ++this.SECTIONS;
        }
        int i = 0;
        while (i < this.sectionProviders.size()) {
            try {
                ISectionProvider provider = this.sectionProviders.get(i);
                if (provider instanceof ISectionProvider) {
                    provider.createSection((MethodElementEditor)this.getEditor(), toolkit, this.sectionComposite);
                    ++this.SECTIONS;
                }
            }
            catch (Exception e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            }
            ++i;
        }
        if (this.slotSectionOn) {
            this.createSlotSection(toolkit);
            ++this.SECTIONS;
        }
        if (this.detailSectionOn) {
            this.createDetailSection(toolkit);
            ++this.SECTIONS;
        }
        if (this.notationSectionOn) {
            this.createNotationSection(toolkit);
            ++this.SECTIONS;
        }
        if (this.tailoringSectionOn) {
            this.createTailoringSection(toolkit);
            ++this.SECTIONS;
        }
        if (this.versionSectionOn) {
            this.createVersionSection(toolkit);
            this.createVersionSectionContent();
            toolkit.paintBordersFor(this.versionComposite);
            ++this.SECTIONS;
        }
        if (this.variabilitySectionOn) {
            this.createVariabilitySection(toolkit);
            toolkit.paintBordersFor(this.variabilityComposite);
            ++this.SECTIONS;
        }
        if (this.iconSectionOn) {
            this.createIconSection(toolkit);
            this.createIconSectionContent();
            ++this.SECTIONS;
        }
        if (this.expandedComposite != null) {
            toolkit.paintBordersFor(this.expandedComposite);
        }
    }

    protected List<ISectionProvider> loadSectionProviders() {
        if (this.sectionProviders == null) {
            this.sectionProviders = ExtensionManager.getExtensions((String)AuthoringUIPlugin.getDefault().getId(), (String)"descriptionPageSectionProvider", ISectionProvider.class);
        }
        return this.sectionProviders;
    }

    private void createFormComposites(FormToolkit toolkit) {
        this.formSection = toolkit.createSection(this.form.getBody(), 4096);
        TableWrapData td = new TableWrapData(256);
        this.formSection.setLayoutData((Object)td);
        this.formSection.setLayout((Layout)new TableWrapLayout());
        this.mainComposite = toolkit.createComposite((Composite)this.formSection, 0);
        td = new TableWrapData(256);
        this.mainComposite.setLayoutData((Object)td);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.mainComposite.setLayout((Layout)layout);
        this.formSection.setClient((Control)this.mainComposite);
        List columnProviders = DescriptionPageColumnProvider.getInstance().getColumnProviders();
        if (columnProviders == null || columnProviders.size() == 0) {
            this.createSectionComposite(this.mainComposite, 0, 100);
        } else {
            try {
                int i = 0;
                while (i < columnProviders.size()) {
                    ColumnElement column = (ColumnElement)columnProviders.get(i);
                    Object providerClass = column.getContributorClass();
                    int width = column.getWidth();
                    String alignment = column.getAlignment();
                    if (providerClass instanceof IColumnProvider) {
                        GridLayout layout2;
                        FormData data;
                        Composite columnComposite;
                        this.columnProvider = (IColumnProvider)providerClass;
                        if (alignment.equals("left")) {
                            this.createSectionComposite(this.mainComposite, width, 100);
                            columnComposite = this.columnProvider.setColumn((MethodElementEditor)this.getEditor(), toolkit, this.mainComposite);
                            data = new FormData();
                            data.top = new FormAttachment(0, 0);
                            data.left = new FormAttachment(0, 5);
                            data.bottom = new FormAttachment(100, -5);
                            data.right = new FormAttachment((Control)this.sectionComposite, 0);
                            columnComposite.setLayoutData((Object)data);
                            layout2 = new GridLayout();
                            layout2.marginHeight = 0;
                            columnComposite.setLayout((Layout)layout2);
                        }
                        if (alignment.equals("right")) {
                            this.createSectionComposite(this.mainComposite, 0, 100 - width);
                            columnComposite = this.columnProvider.setColumn((MethodElementEditor)this.getEditor(), toolkit, this.mainComposite);
                            data = new FormData();
                            data.top = new FormAttachment(0, 0);
                            data.left = new FormAttachment((Control)this.sectionComposite, 5);
                            data.bottom = new FormAttachment(100, -5);
                            data.right = new FormAttachment(100, 0);
                            columnComposite.setLayoutData((Object)data);
                            layout2 = new GridLayout();
                            layout2.marginHeight = 0;
                            columnComposite.setLayout((Layout)layout2);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        this.expandedComposite = toolkit.createComposite((Composite)this.formSection, 0);
        TableWrapData td2 = new TableWrapData(256);
        this.expandedComposite.setLayoutData((Object)td2);
        this.expandedComposite.setLayout((Layout)new GridLayout(2, false));
        this.expandedComposite.setVisible(false);
        this.expandLink = toolkit.createImageHyperlink(this.expandedComposite, 0);
        this.expandLink.setImage(AuthoringUIImages.IMG_EXPANDED);
        this.expandLink.setToolTipText(AuthoringUIResources.closeRTE);
        this.expandLink.setUnderlined(false);
        this.expandLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DescriptionFormPage.this.toggle(e);
            }
        });
        this.expandLabel = DescriptionFormPage.createDecoratedLabel(toolkit, this.expandedComposite, "");
    }

    private void createSectionComposite(Composite parent, int leftMargin, int rightMargin) {
        this.sectionComposite = this.toolkit.createComposite(parent, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(leftMargin, 0);
        data.bottom = new FormAttachment(100, -5);
        data.right = new FormAttachment(rightMargin, -5);
        this.sectionComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        this.sectionComposite.setLayout((Layout)layout);
    }

    protected void createGeneralSection(FormToolkit toolkit) {
        this.generalSection = this.createSection(toolkit, this.sectionComposite, AuthoringUIText.GENERAL_INFO_SECTION_NAME, this.getGeneralSectionDescription());
        this.generalComposite = this.createComposite(toolkit, this.generalSection);
        ((GridLayout)this.generalComposite.getLayout()).numColumns = 4;
        this.createGeneralSectionContent();
        this.extender.modifyGeneralSectionContent(toolkit, ((MethodElementEditor)this.getEditor()).getActionManager());
    }

    protected void createGeneralSectionContent() {
        this.ctrl_name = DescriptionFormPage.createTextEditWithLabel3(this.toolkit, this.generalComposite, AuthoringUIText.NAME_TEXT, -1, 4);
        this.ctrl_presentation_name = DescriptionFormPage.createTextEditWithLabel3(this.toolkit, this.generalComposite, AuthoringUIText.PRESENTATION_NAME_TEXT, -1, 4);
        if (this.longPresentationNameOn && AuthoringUIPreferences.getEnableUIFields()) {
            this.ctrl_long_presentation_name = DescriptionFormPage.createTextEditWithLabel3(this.toolkit, this.generalComposite, AuthoringUIText.LONG_PRESENTATION_NAME_TEXT, -1, 4);
        }
        if (this.elementTypeOn) {
            DescriptionFormPage.createLabel(this.toolkit, this.generalComposite, AuthoringUIText.TYPE_TEXT, 2);
            this.ctrl_type_label = DescriptionFormPage.createLabel(this.toolkit, this.generalComposite, "");
            GridData gridData = new GridData(1);
            gridData.horizontalSpan = 1;
            this.ctrl_type_label.setBackground(Display.getCurrent().getSystemColor(19));
            this.ctrl_type_label.setLayoutData((Object)gridData);
            if (this.methodElement instanceof Guidance) {
                this.ctrl_type_button = this.toolkit.createButton(this.generalComposite, AuthoringUIText.CHANGE_TYPE_BUTTON_TEXT, 8);
                gridData = new GridData(1);
                gridData.horizontalSpan = 1;
                this.ctrl_type_button.setLayoutData((Object)gridData);
                if (ConvertGuidanceType.getValidNewGuidanceTypes((Guidance)((Guidance)this.methodElement)) == null) {
                    this.ctrl_type_button.setVisible(false);
                }
            }
        }
        if (this.externalIdOn && AuthoringUIPreferences.getEnableUIFields()) {
            this.ctrl_external_id = DescriptionFormPage.createTextEditWithLabel3(this.toolkit, this.generalComposite, AuthoringUIText.EXTERNAL_ID_TEXT, -1, 4);
        }
        if (this.briefDescOn) {
            this.ctrl_brief_desc = DescriptionFormPage.createTextEditWithLabel3(this.toolkit, this.generalComposite, AuthoringUIText.BRIEF_DESCRIPTION_TEXT, 40, 18);
        }
        String publishButtonText = AuthoringUIText.PUBLISH_CATEGORIES_TEXT;
        if (!this.publishCategoryOn) {
            this.publishCategoryOn = this.publishPracticeOn;
            if (this.publishPracticeOn) {
                publishButtonText = AuthoringUIText.PUBLISH_PRACTICES_TEXT;
                if (this.publishPracticeOnForUDT) {
                    publishButtonText = AuthoringUIText.PUBLISH_PRACTICES_FOR_UDT_TEXT;
                }
            }
        }
        if (this.publishCategoryOn) {
            this.ctrl_publish_categories_button = this.toolkit.createButton(this.generalComposite, publishButtonText, 32);
            GridData data = new GridData();
            data.horizontalSpan = 3;
            this.ctrl_publish_categories_button.setLayoutData((Object)data);
        }
    }

    protected void createVariabilitySection(FormToolkit toolkit) {
        this.variabilitySection = this.createSection(toolkit, this.sectionComposite, AuthoringUIText.VARIABILITY_SECTION_NAME, this.getVariabilitySectionDescription());
        this.variabilityComposite = toolkit.createComposite((Composite)this.variabilitySection);
        GridData gridData = new GridData(769);
        gridData.horizontalSpan = 1;
        gridData.heightHint = 24;
        gridData.widthHint = 300;
        this.variabilityComposite.setLayoutData((Object)gridData);
        this.variabilityComposite.setLayout((Layout)new GridLayout(5, false));
        this.variabilitySection.setClient((Control)this.variabilityComposite);
        this.ctrl_variability = DescriptionFormPage.createComboWithLabel3(toolkit, this.variabilityComposite, AuthoringUIText.VARIABILITY_TYPE_TEXT);
        this.viewer_variability = new ComboViewer(this.ctrl_variability);
        gridData = new GridData(769);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 24;
        gridData.widthHint = 300;
        this.viewer_variability.getCombo().setLayoutData((Object)gridData);
        this.viewer_variability.setContentProvider((IContentProvider)this.contentProviderVariability);
        this.viewer_variability.setLabelProvider((IBaseLabelProvider)this.labelProviderVariability);
        this.viewer_variability.setInput((Object)this.methodElement);
        toolkit.createLabel(this.variabilityComposite, "", 0);
        this.label_base = DescriptionFormPage.createLabel(toolkit, this.variabilityComposite, AuthoringUIText.BASE_ELEMENT_TEXT, 2);
        this.ctrl_base = DescriptionFormPage.createTable(toolkit, this.variabilityComposite, 12, 769, 5, 300, 1, 2);
        gridData = new GridData(769);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 24;
        gridData.widthHint = 300;
        this.ctrl_base.setLayoutData((Object)gridData);
        this.base_viewer = new TableViewer(this.ctrl_base);
        this.initContentProviderBase();
        this.base_viewer.setLabelProvider((IBaseLabelProvider)this.labelProviderBase);
        this.base_viewer.setInput((Object)this.methodElement);
        Composite baseButtonPane = DescriptionFormPage.createComposite(toolkit, this.variabilityComposite, 258, 1, 1, 1);
        GridData gridData2 = new GridData(256);
        baseButtonPane.setLayoutData((Object)gridData2);
        this.ctrl_base_button = toolkit.createButton(baseButtonPane, AuthoringUIText.SELECT_BUTTON_TEXT, 64);
        gridData2 = new GridData(768);
        gridData2.widthHint = 150;
        this.ctrl_base_button.setLayoutData((Object)gridData2);
        Display display = this.form.getBody().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    if (DescriptionFormPage.this.ctrl_name.isDisposed()) {
                        return;
                    }
                    if (DescriptionFormPage.this.isAutoGenName()) {
                        DescriptionFormPage.this.ctrl_presentation_name.setFocus();
                        if (DescriptionFormPage.this.methodUnit != null && DescriptionFormPage.this.methodUnit.getChangeDate() == null) {
                            DescriptionFormPage.this.ctrl_presentation_name.setSelection(0, DescriptionFormPage.this.ctrl_presentation_name.getText().length());
                        }
                    } else {
                        DescriptionFormPage.this.ctrl_name.setFocus();
                        if (DescriptionFormPage.this.methodUnit != null && DescriptionFormPage.this.methodUnit.getChangeDate() == null) {
                            DescriptionFormPage.this.ctrl_name.setSelection(0, DescriptionFormPage.this.ctrl_name.getText().length());
                        }
                    }
                }
            });
        }
    }

    protected void refresh(boolean editable) {
        if (this.generalSectionOn) {
            this.ctrl_name.setEditable(editable);
            this.ctrl_presentation_name.setEditable(editable);
        }
        if (this.longPresentationNameOn && AuthoringUIPreferences.getEnableUIFields()) {
            this.ctrl_long_presentation_name.setEditable(editable);
        }
        if (this.briefDescOn) {
            this.ctrl_brief_desc.setEditable(editable);
        }
        if (this.purposeOn) {
            this.ctrl_purpose.setEditable(editable);
        }
        if (this.fullDescOn) {
            this.ctrl_full_desc.setEditable(editable);
        }
        if (this.keyConsiderationOn) {
            this.ctrl_key.setEditable(editable);
        }
        if (this.externalIdOn && AuthoringUIPreferences.getEnableUIFields()) {
            this.ctrl_external_id.setEditable(editable);
        }
        if (this.elementTypeOn) {
            this.ctrl_type_button.setEnabled(editable);
        }
        if (this.variabilitySectionOn) {
            this.ctrl_variability.setEnabled(editable);
            this.ctrl_base_button.setEnabled(editable);
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)this.methodElement);
            if (MethodPluginPropUtil.getMethodPluginPropUtil().isCustomizePlugin(plugin)) {
                this.ctrl_variability.setEnabled(false);
                this.ctrl_base_button.setEnabled(false);
            }
            if (((IStructuredSelection)this.viewer_variability.getSelection()).getFirstElement() == VariabilityType.NA) {
                this.ctrl_base_button.setEnabled(false);
            }
            if (((IStructuredSelection)this.viewer_variability.getSelection()).getFirstElement() == VariabilityType.CONTRIBUTES) {
                this.ctrl_presentation_name.setEditable(false);
                if (this.externalIdOn && AuthoringUIPreferences.getEnableUIFields()) {
                    this.ctrl_external_id.setEditable(false);
                }
            }
        }
        if (this.versionSectionOn) {
            this.ctrl_change_date.setEditable(false);
            this.ctrl_change_desc.setEditable(editable);
            this.ctrl_authors.setEditable(editable);
            this.ctrl_version.setEditable(editable);
            this.copyright_button.setEnabled(editable);
            this.setCopyrightButtonDeselect();
        }
        if (this.iconSectionOn) {
            this.ctrl_select_shapeIcon_button.setEnabled(editable);
            this.ctrl_clear_shapeIcon_button.setEnabled(editable && this.contentElement.getShapeicon() != null);
            this.ctrl_select_nodeIcon_button.setEnabled(editable);
            this.ctrl_clear_nodeIcon_button.setEnabled(editable && this.contentElement.getNodeicon() != null);
        }
        if (this.ctrl_expanded != null) {
            this.ctrl_expanded.setEditable(editable);
        }
        if (this.publishCategoryOn) {
            this.ctrl_publish_categories_button.setEnabled(editable);
        }
        if (editable) {
            this.refreshForContributor();
        }
        if (this.columnProvider != null) {
            this.columnProvider.refresh(editable);
        }
        int i = 0;
        while (i < this.sectionProviders.size()) {
            ISectionProvider provider = this.sectionProviders.get(i);
            if (provider != null && provider instanceof ISectionProvider) {
                provider.refresh(editable);
            }
            ++i;
        }
        if (this.extender != null) {
            this.extender.refresh(editable);
        }
    }

    protected void createDetailSection(FormToolkit toolkit) {
        this.detailSection = this.createSection(toolkit, this.sectionComposite, AuthoringUIText.DETAIL_SECTION_NAME, this.getDetailSectionDescription());
        this.detailComposite = this.createComposite(toolkit, this.detailSection);
        this.createDetailSectionContent();
        toolkit.paintBordersFor(this.detailComposite);
    }

    protected void createDetailSectionContent() {
        if (this.purposeOn) {
            this.ctrl_purpose = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIText.PURPOSE_TEXT, 40, 400, 2);
        }
        if (this.fullDescOn) {
            this.ctrl_full_desc = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIText.MAIN_DESCRIPTION_TEXT, 100, 400, 2);
        }
        if (this.keyConsiderationOn) {
            this.ctrl_key = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIText.KEY_CONSIDERATIONS_TEXT, 40, 400, 2);
        }
    }

    protected void createNotationSection(FormToolkit toolkit) {
        this.notationSection = this.createSection(toolkit, this.sectionComposite, AuthoringUIText.NOTATION_SECTION_NAME, this.getNotationSectionDescription());
        this.notationComposite = this.createComposite(toolkit, this.notationSection);
        this.createNotationSectionContent();
        toolkit.paintBordersFor(this.notationComposite);
    }

    protected void createNotationSectionContent() {
    }

    protected void createTailoringSection(FormToolkit toolkit) {
        this.tailoringSection = this.createSection(toolkit, this.sectionComposite, AuthoringUIText.TAILORING_SECTION_NAME, this.getTailoringSectionDescription());
        this.tailoringComposite = this.createComposite(toolkit, this.tailoringSection);
        this.createTailoringSectionContent();
        toolkit.paintBordersFor(this.tailoringComposite);
    }

    protected void createTailoringSectionContent() {
    }

    protected void createSlotSection(FormToolkit toolkit) {
    }

    protected void addListeners() {
        final MethodElementEditor editor = (MethodElementEditor)this.getEditor();
        this.modelModifyListener = editor.createModifyListener((EObject)this.methodElement);
        this.nameModifyListener = editor.createModifyListener((EObject)this.methodElement);
        this.nameModifyListener.setForNameOnly(true);
        this.contentModifyListener = editor.createModifyListener((EObject)this.methodUnit);
        this.actionMgr = editor.getActionManager();
        this.form.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                if (DescriptionFormPage.this.ctrl_expanded != null) {
                    ((GridData)DescriptionFormPage.this.ctrl_expanded.getLayoutData()).heightHint = DescriptionFormPage.this.getRichTextEditorHeight();
                    ((GridData)DescriptionFormPage.this.ctrl_expanded.getLayoutData()).widthHint = DescriptionFormPage.this.getRichTextEditorWidth();
                }
                DescriptionFormPage.this.formSection.layout(true, true);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.form.getParent().addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (DescriptionFormPage.this.disposed) {
                    return;
                }
                DescriptionFormPage.this.refresh(!TngUtil.isLocked((EObject)DescriptionFormPage.this.methodElement));
                DescriptionFormPage.this.setFormTextWithVariableInfo();
                if (DescriptionFormPage.this.variabilitySectionOn) {
                    DescriptionFormPage.this.base_viewer.refresh();
                }
                if (DescriptionFormPage.this.versionSectionOn) {
                    DescriptionFormPage.this.copyright_viewer.refresh();
                }
            }
        });
        if (this.generalSectionOn) {
            this.addGeneralSectionListeners();
        }
        if (this.detailSectionOn) {
            this.addDetailSectionListeners();
        }
        if (this.versionSectionOn) {
            this.addVersionSectionListeners();
        }
        if (this.iconSectionOn) {
            this.addIconSectionListeners();
        }
        if (this.variabilitySectionOn) {
            this.viewer_variability.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    boolean status;
                    IStructuredSelection selection = (IStructuredSelection)DescriptionFormPage.this.viewer_variability.getSelection();
                    if (DescriptionFormPage.this.contentElement.getVariabilityBasedOnElement() != null) {
                        status = editor.getActionManager().doAction(1, (EObject)DescriptionFormPage.this.methodElement, (EStructuralFeature)UmaPackage.eINSTANCE.getVariabilityElement_VariabilityType(), (Object)((VariabilityType)selection.getFirstElement()), -1);
                        if (!status) {
                            return;
                        }
                        if (selection.getFirstElement() == VariabilityType.CONTRIBUTES) {
                            DescriptionFormPage.this.updatePNameForContributor(true);
                        } else {
                            DescriptionFormPage.this.updatePNameForContributor(false);
                        }
                    }
                    if (selection.getFirstElement() == VariabilityType.NA) {
                        if (DescriptionFormPage.this.contentElement.getVariabilityBasedOnElement() != null && !(status = editor.getActionManager().doAction(1, (EObject)DescriptionFormPage.this.methodElement, (EStructuralFeature)UmaPackage.eINSTANCE.getVariabilityElement_VariabilityBasedOnElement(), null, -1))) {
                            return;
                        }
                        DescriptionFormPage.this.ctrl_base_button.setEnabled(false);
                        DescriptionFormPage.this.base_viewer.refresh();
                    } else {
                        ArrayList<VariabilityElement> selectionBaseList = new ArrayList<VariabilityElement>();
                        VariabilityElement base = DescriptionFormPage.this.contentElement.getVariabilityBasedOnElement();
                        selectionBaseList.add(base);
                        DescriptionFormPage.this.ctrl_base_button.setEnabled(true);
                        DescriptionFormPage.this.base_viewer.refresh();
                    }
                    DescriptionFormPage.this.setFormTextWithVariableInfo();
                    int i = 0;
                    while (i < DescriptionFormPage.this.sectionProviders.size()) {
                        ISectionProvider provider = DescriptionFormPage.this.sectionProviders.get(i);
                        if (provider != null && provider instanceof ISectionProvider) {
                            provider.refresh(false);
                        }
                        ++i;
                    }
                }
            });
            this.ctrl_base_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DescriptionFormPage.this.filter = DescriptionFormPage.this.getFilter();
                    if (DescriptionFormPage.this.filter != null) {
                        ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), DescriptionFormPage.this.filter, DescriptionFormPage.this.getContentElement(), LibraryUIText.getUIText((MethodElement)DescriptionFormPage.this.methodElement, (boolean)true));
                        fd.setViewerSelectionSingle(true);
                        fd.setBlockOnOpen(true);
                        fd.setTitle(LibraryUIText.getUIText((MethodElement)DescriptionFormPage.this.methodElement, (boolean)true));
                        fd.open();
                        fd.getSelectedItems();
                        if (fd.getSelectedItems().size() > 0) {
                            IStatus istatus = DependencyChecker.checkCircularDependencyAfterFilterSelection((VariabilityElement)DescriptionFormPage.this.contentElement, (VariabilityElement)((VariabilityElement)fd.getSelectedItems().get(0)));
                            if (!istatus.isOK()) {
                                String title = AuthoringUIResources.variability_error_title;
                                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, istatus.getMessage());
                                return;
                            }
                            boolean status = editor.getActionManager().doAction(1, (EObject)DescriptionFormPage.this.methodElement, (EStructuralFeature)UmaPackage.eINSTANCE.getVariabilityElement_VariabilityBasedOnElement(), (Object)((VariabilityElement)fd.getSelectedItems().get(0)), -1);
                            if (!status) {
                                return;
                            }
                            status = editor.getActionManager().doAction(1, (EObject)DescriptionFormPage.this.methodElement, (EStructuralFeature)UmaPackage.eINSTANCE.getVariabilityElement_VariabilityType(), (Object)((VariabilityType)((IStructuredSelection)DescriptionFormPage.this.viewer_variability.getSelection()).getFirstElement()), -1);
                            if (status) {
                                if ((VariabilityType)((IStructuredSelection)DescriptionFormPage.this.viewer_variability.getSelection()).getFirstElement() == VariabilityType.CONTRIBUTES) {
                                    DescriptionFormPage.this.updatePNameForContributor(true);
                                } else {
                                    DescriptionFormPage.this.updatePNameForContributor(false);
                                }
                            }
                        }
                    }
                    DescriptionFormPage.this.setFormTextWithVariableInfo();
                    int i = 0;
                    while (i < DescriptionFormPage.this.sectionProviders.size()) {
                        ISectionProvider provider = DescriptionFormPage.this.sectionProviders.get(i);
                        if (provider != null && provider instanceof ISectionProvider) {
                            provider.refresh(false);
                        }
                        ++i;
                    }
                    if (DescriptionFormPage.this.ctrl_base != null && !DescriptionFormPage.this.ctrl_base.isDisposed()) {
                        DescriptionFormPage.this.ctrl_base.redraw();
                    }
                    if (DescriptionFormPage.this.base_viewer != null && !DescriptionFormPage.this.base_viewer.getControl().isDisposed()) {
                        DescriptionFormPage.this.base_viewer.refresh();
                    }
                }
            });
        }
    }

    private void updatePNameForContributor(boolean update) {
        MethodElementEditor editor = (MethodElementEditor)this.getEditor();
        this.actionMgr = editor.getActionManager();
        if (this.contentElement.getVariabilityType() == VariabilityType.CONTRIBUTES) {
            this.actionMgr.doAction(1, (EObject)this.methodElement, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_PresentationName(), (Object)"", -1);
            this.ctrl_presentation_name.setText("");
            this.actionMgr.doAction(1, (EObject)this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_ExternalId(), (Object)"", -1);
            if (this.externalIdOn && AuthoringUIPreferences.getEnableUIFields()) {
                this.ctrl_external_id.setText("");
            }
        }
        this.refreshForContributor();
    }

    private void refreshForContributor() {
        boolean editable = true;
        if (this.generalSectionOn) {
            this.ctrl_presentation_name.setEditable(editable);
        }
        if (this.externalIdOn && AuthoringUIPreferences.getEnableUIFields()) {
            this.ctrl_external_id.setEditable(editable);
        }
        if (this.contentElement != null && this.contentElement.getVariabilityType() == VariabilityType.CONTRIBUTES) {
            if (this.contentElement.getPresentationName().equals("")) {
                this.ctrl_presentation_name.setEditable(false);
            }
            if (this.externalIdOn && AuthoringUIPreferences.getEnableUIFields() && this.contentElement.getPresentation().getExternalId().equals("")) {
                this.ctrl_external_id.setEditable(false);
            }
        }
    }

    protected ModifyListener newNameTackingPNameListener() {
        ModifyListener ret = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String name;
                if (DescriptionFormPage.this.isAutoGenName() && (name = DescriptionFormPage.this.generateName(DescriptionFormPage.this.ctrl_presentation_name.getText())).length() > 0) {
                    DescriptionFormPage.this.ctrl_name.setText(name);
                }
            }
        };
        return ret;
    }

    protected void addGeneralSectionListeners() {
        this.ctrl_name.addModifyListener((ModifyListener)this.nameModifyListener);
        this.ctrl_name.addFocusListener((FocusListener)this.nameFocusListener);
        this.ctrl_presentation_name.addModifyListener(this.modelModifyListener);
        this.ctrl_presentation_name.addModifyListener(this.newNameTackingPNameListener());
        this.ctrl_presentation_name.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                boolean success;
                String oldContent = DescriptionFormPage.this.methodElement.getPresentationName();
                if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                    return;
                }
                String newContent = StrUtil.getPlainText((String)DescriptionFormPage.this.ctrl_presentation_name.getText());
                if (!newContent.equals(oldContent) && (success = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.methodElement, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_PresentationName(), (Object)newContent, -1))) {
                    DescriptionFormPage.this.ctrl_presentation_name.setText(newContent);
                }
                if (DescriptionFormPage.this.ctrl_presentation_name.getSelectionCount() > 0) {
                    DescriptionFormPage.this.ctrl_presentation_name.clearSelection();
                }
                if (DescriptionFormPage.this.isAutoGenName()) {
                    DescriptionFormPage.this.changeElementName();
                }
            }

            public void focusGained(FocusEvent e) {
                ((MethodElementEditor)DescriptionFormPage.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_PresentationName());
                DescriptionFormPage.this.ctrl_presentation_name.selectAll();
            }
        });
        if (this.longPresentationNameOn && AuthoringUIPreferences.getEnableUIFields()) {
            this.ctrl_long_presentation_name.addModifyListener(this.modelModifyListener);
            this.ctrl_long_presentation_name.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    boolean success;
                    String oldContent = DescriptionFormPage.this.contentElement.getPresentation().getLongPresentationName();
                    if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(DescriptionFormPage.this.ctrl_long_presentation_name, oldContent)) {
                        return;
                    }
                    String newContent = StrUtil.getPlainText((String)DescriptionFormPage.this.ctrl_long_presentation_name.getText());
                    if (!newContent.equals(oldContent) && (success = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_LongPresentationName(), (Object)newContent, -1))) {
                        DescriptionFormPage.this.ctrl_long_presentation_name.setText(newContent);
                    }
                    if (DescriptionFormPage.this.ctrl_long_presentation_name.getSelectionCount() > 0) {
                        DescriptionFormPage.this.ctrl_long_presentation_name.clearSelection();
                    }
                }

                public void focusGained(FocusEvent e) {
                    DescriptionFormPage.this.ctrl_long_presentation_name.selectAll();
                    ((MethodElementEditor)DescriptionFormPage.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_LongPresentationName());
                }
            });
        }
        if (this.briefDescOn) {
            this.ctrl_brief_desc.addModifyListener(this.modelModifyListener);
            this.ctrl_brief_desc.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    ((MethodElementEditor)DescriptionFormPage.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription());
                }

                public void focusLost(FocusEvent e) {
                    boolean success;
                    String oldContent = DescriptionFormPage.this.methodElement.getBriefDescription();
                    if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                        return;
                    }
                    String newContent = DescriptionFormPage.this.ctrl_brief_desc.getText();
                    if (!newContent.equals(oldContent) && (success = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.methodElement, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription(), (Object)newContent, -1))) {
                        DescriptionFormPage.this.ctrl_brief_desc.setText(newContent);
                    }
                }
            });
        }
        if (this.elementTypeOn && this.methodElement instanceof Guidance) {
            this.ctrl_type_button.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    MethodElementEditor editor = (MethodElementEditor)DescriptionFormPage.this.getEditor();
                    if (editor.isDirty()) {
                        String title = AuthoringUIResources.descriptionTabGuidanceWarningDialog_title;
                        String message = AuthoringUIResources.descriptionTabGuidanceWarningDialog_message1;
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(title, message);
                    } else if (DescriptionFormPage.this.methodElement instanceof Guidance) {
                        MethodElementDeleteAction deleteAction = new MethodElementDeleteAction();
                        deleteAction.setEditingDomain(LibraryView.getView().getEditingDomain());
                        deleteAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)DescriptionFormPage.this.methodElement));
                        Command cmd = deleteAction.createCommand(Collections.singleton(DescriptionFormPage.this.methodElement));
                        if (cmd instanceof DeleteMethodElementCommand) {
                            Guidance newGuidance;
                            try {
                                newGuidance = ConvertGuidanceType.convertGuidance((Guidance)((Guidance)DescriptionFormPage.this.methodElement), null, (DeleteMethodElementCommand)((DeleteMethodElementCommand)cmd));
                            }
                            catch (Throwable throwable) {
                                try {
                                    cmd.dispose();
                                }
                                catch (Exception exception) {}
                                throw throwable;
                            }
                            try {
                                cmd.dispose();
                            }
                            catch (Exception exception) {}
                            if (newGuidance != null) {
                                EditorChooser.getInstance().closeEditor(DescriptionFormPage.this.methodElement);
                                EditorChooser.getInstance().openEditor(newGuidance);
                            }
                        }
                    } else if (editor.isDirty()) {
                        String title = AuthoringUIResources.descriptionTabGuidanceWarningDialog_title;
                        String message = AuthoringUIResources.descriptionTabGuidanceWarningDialog_message2;
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(title, message);
                    }
                }
            });
        }
        if (this.publishCategoryOn) {
            this.ctrl_publish_categories_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String val = new Boolean(DescriptionFormPage.this.ctrl_publish_categories_button.getSelection()).toString();
                    MethodElementProperty prop = TngUtil.getPublishCategoryProperty((MethodElement)DescriptionFormPage.this.methodElement);
                    if (prop == null) {
                        prop = UmaFactory.eINSTANCE.createMethodElementProperty();
                        prop.setName("PUBLISH_CATEGORY");
                        prop.setValue(val);
                        DescriptionFormPage.this.actionMgr.doAction(3, (EObject)DescriptionFormPage.this.methodElement, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_MethodElementProperty(), (Object)prop, -1);
                    } else {
                        DescriptionFormPage.this.actionMgr.doAction(1, (EObject)prop, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElementProperty_Value(), (Object)val, -1);
                    }
                }
            });
        }
        if (this.externalIdOn && AuthoringUIPreferences.getEnableUIFields()) {
            this.ctrl_external_id.addModifyListener(this.contentModifyListener);
            this.ctrl_external_id.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    ((MethodElementEditor)DescriptionFormPage.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_ExternalId());
                }

                public void focusLost(FocusEvent e) {
                    boolean success;
                    String oldContent = DescriptionFormPage.this.contentElement.getPresentation().getExternalId();
                    if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(DescriptionFormPage.this.ctrl_external_id, oldContent)) {
                        return;
                    }
                    String newContent = DescriptionFormPage.this.ctrl_external_id.getText();
                    if (!newContent.equals(oldContent) && (success = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_ExternalId(), (Object)newContent, -1)) && DescriptionFormPage.this.isVersionSectionOn()) {
                        DescriptionFormPage.this.updateChangeDate();
                    }
                }
            });
        }
    }

    protected IValidator getNameValidator() {
        return null;
    }

    protected void addDetailSectionListeners() {
        if (this.fullDescOn) {
            this.ctrl_full_desc.setModalObject((EObject)this.contentElement.getPresentation());
            this.ctrl_full_desc.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_MainDescription());
            this.ctrl_full_desc.addModifyListener(this.contentModifyListener);
            this.ctrl_full_desc.addListener(27, new Listener(){

                public void handleEvent(Event e) {
                    IMethodRichText control;
                    IMethodRichText iMethodRichText = control = DescriptionFormPage.this.descExpandFlag ? DescriptionFormPage.this.ctrl_expanded : DescriptionFormPage.this.ctrl_full_desc;
                    if (DescriptionFormPage.this.debug) {
                        System.out.println("DescriptionFormPage.ctrl_full_desc.deactivateListener: control=" + control);
                    }
                    if (!control.getModified()) {
                        if (DescriptionFormPage.this.debug) {
                            System.out.println("DescriptionFormPage.ctrl_full_desc.deactivateListener: content not modified, exit");
                        }
                        return;
                    }
                    String oldContent = DescriptionFormPage.this.contentElement.getPresentation().getMainDescription();
                    if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                        if (DescriptionFormPage.this.debug) {
                            System.out.println("DescriptionFormPage.ctrl_full_desc.deactivateListener: restored old content, exit");
                        }
                        return;
                    }
                    String newContent = control.getText();
                    if (!newContent.equals(oldContent)) {
                        if (DescriptionFormPage.this.debug) {
                            System.out.println("DescriptionFormPage.ctrl_full_desc.deactivateListener: saving modified content");
                        }
                        boolean success = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_MainDescription(), (Object)newContent, -1);
                        if (DescriptionFormPage.this.debug) {
                            System.out.println("DescriptionFormPage.ctrl_full_desc.deactivateListener: saved status=" + success);
                        }
                        if (success && DescriptionFormPage.this.isVersionSectionOn()) {
                            DescriptionFormPage.this.updateChangeDate();
                        }
                    }
                    if (DescriptionFormPage.this.debug) {
                        System.out.println("DescriptionFormPage.ctrl_full_desc.deactivateListener: exit");
                    }
                }
            });
        }
        if (this.keyConsiderationOn) {
            this.ctrl_key.setModalObject((EObject)this.contentElement.getPresentation());
            this.ctrl_key.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_KeyConsiderations());
            this.ctrl_key.addModifyListener(this.contentModifyListener);
            this.ctrl_key.addListener(27, new Listener(){

                public void handleEvent(Event e) {
                    IMethodRichText control;
                    IMethodRichText iMethodRichText = control = DescriptionFormPage.this.descExpandFlag ? DescriptionFormPage.this.ctrl_expanded : DescriptionFormPage.this.ctrl_key;
                    if (DescriptionFormPage.this.debug) {
                        System.out.println("DescriptionFormPage.ctrl_key.deactivateListener: control=" + control);
                    }
                    if (!control.getModified()) {
                        if (DescriptionFormPage.this.debug) {
                            System.out.println("DescriptionFormPage.ctrl_key.deactivateListener: content not modified, exit");
                        }
                        return;
                    }
                    String oldContent = DescriptionFormPage.this.contentElement.getPresentation().getKeyConsiderations();
                    if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                        if (DescriptionFormPage.this.debug) {
                            System.out.println("DescriptionFormPage.ctrl_key.deactivateListener: restored old content, exit");
                        }
                        return;
                    }
                    String newContent = control.getText();
                    if (!newContent.equals(oldContent)) {
                        boolean success = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_KeyConsiderations(), (Object)newContent, -1);
                        if (DescriptionFormPage.this.debug) {
                            System.out.println("DescriptionFormPage.ctrl_key.deactivateListener: saved status=" + success);
                        }
                        if (success && DescriptionFormPage.this.isVersionSectionOn()) {
                            DescriptionFormPage.this.updateChangeDate();
                        }
                    }
                    if (DescriptionFormPage.this.debug) {
                        System.out.println("DescriptionFormPage.ctrl_key.deactivateListener: exit");
                    }
                }
            });
        }
    }

    protected void loadData() {
        if (this.generalSectionOn) {
            this.loadGeneralSectionData();
        }
        if (this.detailSectionOn) {
            this.loadDetailSectionData();
        }
        if (this.notationSectionOn) {
            this.loadNotationSectionData();
        }
        if (this.tailoringSectionOn) {
            this.loadTailoringSectionData();
        }
        if (this.versionSectionOn) {
            this.loadVersionSectionData();
        }
        if (this.iconSectionOn) {
            this.loadIconSectionData();
        }
        if (this.variabilitySectionOn) {
            this.variabilitySectionData();
        }
        this.form.getBody().layout(true, true);
    }

    protected void loadGeneralSectionData() {
        MethodElementProperty prop;
        String name = this.methodElement.getName();
        String presentationName = this.methodElement.getPresentationName();
        this.ctrl_name.setText(name == null ? "" : name);
        this.ctrl_presentation_name.setText(presentationName == null ? "" : presentationName);
        if (this.longPresentationNameOn && AuthoringUIPreferences.getEnableUIFields()) {
            String longPresentName = this.contentElement.getPresentation().getLongPresentationName();
            this.ctrl_long_presentation_name.setText(longPresentName == null ? "" : longPresentName);
        }
        if (this.elementTypeOn) {
            String type = LibraryUIText.getUIText((MethodElement)this.methodElement);
            this.ctrl_type_label.setText(type == null ? "" : type);
        }
        if (this.briefDescOn) {
            String brief_desc = this.methodElement.getBriefDescription();
            this.ctrl_brief_desc.setText(brief_desc == null ? "" : brief_desc);
        }
        if (this.externalIdOn && AuthoringUIPreferences.getEnableUIFields() && this.contentElement != null) {
            String external_id = this.contentElement.getPresentation().getExternalId();
            this.ctrl_external_id.setText(external_id == null ? "" : external_id);
        }
        if (this.publishCategoryOn && (prop = TngUtil.getPublishCategoryProperty((MethodElement)this.methodElement)) != null) {
            String val = prop.getValue();
            this.ctrl_publish_categories_button.setSelection(new Boolean(val).booleanValue());
        }
    }

    protected void loadDetailSectionData() {
        if (this.fullDescOn) {
            String full_desc = this.contentElement.getPresentation().getMainDescription();
            this.ctrl_full_desc.setText(full_desc == null ? "" : full_desc);
        }
        if (this.keyConsiderationOn) {
            String keyConsiderations = this.contentElement.getPresentation().getKeyConsiderations();
            this.ctrl_key.setText(keyConsiderations == null ? "" : keyConsiderations);
        }
    }

    private void loadTailoringSectionData() {
    }

    private void loadNotationSectionData() {
    }

    private void variabilitySectionData() {
        VariabilityType variabilityType = this.contentElement.getVariabilityType();
        ArrayList<VariabilityType> selectionVariabilityList = new ArrayList<VariabilityType>();
        selectionVariabilityList.add(variabilityType);
        StructuredSelection newVariabilitySelection = new StructuredSelection(selectionVariabilityList);
        this.viewer_variability.setSelection((ISelection)newVariabilitySelection, true);
    }

    @Override
    protected void toggle(HyperlinkEvent e) {
        if (this.ctrl_expanded == null) {
            this.ctrl_expanded = this.createRichTextEditor(this.toolkit, this.expandedComposite, 578, 1808, this.getRichTextEditorHeight(), this.getRichTextEditorWidth(), 2, this.expandLabel);
            this.ctrl_expanded.addModifyListener(this.contentModifyListener);
        }
        if (this.descExpandFlag) {
            this.ctrl_expanded.collapse();
            this.expandedComposite.setVisible(false);
            this.mainComposite.setVisible(true);
            this.formSection.setClient((Control)this.mainComposite);
            this.enableSections(true);
            IMethodRichText richText = this.getActiveRichTextControl();
            richText.setText(this.ctrl_expanded.getText());
            richText.setFindReplaceAction(this.ctrl_expanded.getFindReplaceAction());
            Iterator i = richText.getListeners();
            while (i.hasNext()) {
                RichTextListener listener = (RichTextListener)i.next();
                this.ctrl_expanded.removeListener(listener.getEventType(), listener.getListener());
            }
            if (this.ctrl_expanded.getModified()) {
                ((MethodElementEditor)this.getEditor()).saveModifiedRichText(this.ctrl_expanded);
            }
            richText.setFocus();
            IEditorInput input = this.getEditorInput();
            if (input instanceof MethodElementEditorInput) {
                ((MethodElementEditorInput)input).setModalObject(null);
                ((MethodElementEditorInput)input).setModalObjectFeature(null);
            }
        } else {
            this.mainComposite.setVisible(false);
            this.expandedComposite.setVisible(true);
            this.formSection.setClient((Control)this.expandedComposite);
            this.enableSections(false);
            this.expandLabel.setText((String)((ImageHyperlink)e.getSource()).getData("Title"));
            IMethodRichText richText = (IMethodRichText)e.getHref();
            this.ctrl_expanded.setInitialText(richText.getText());
            this.ctrl_expanded.setModalObject(richText.getModalObject());
            this.ctrl_expanded.setModalObjectFeature(richText.getModalObjectFeature());
            this.ctrl_expanded.setFindReplaceAction(richText.getFindReplaceAction());
            Iterator i = richText.getListeners();
            while (i.hasNext()) {
                RichTextListener listener = (RichTextListener)i.next();
                this.ctrl_expanded.addListener(listener.getEventType(), listener.getListener());
            }
            boolean editable = !TngUtil.isLocked((EObject)this.methodElement);
            this.ctrl_expanded.setEditable(editable);
            if (editable) {
                this.ctrl_expanded.setFocus();
            }
            this.setActiveRichTextControl(richText);
            IEditorInput input = this.getEditorInput();
            if (input instanceof MethodElementEditorInput) {
                ((MethodElementEditorInput)input).setModalObject(richText.getModalObject());
                ((MethodElementEditorInput)input).setModalObjectFeature(richText.getModalObjectFeature());
            }
        }
        this.form.getBody().layout(true, true);
        this.descExpandFlag = !this.descExpandFlag;
    }

    private void setActiveRichTextControl(IMethodRichText ctrl) {
        this.activeControl = ctrl;
    }

    private IMethodRichText getActiveRichTextControl() {
        return this.activeControl;
    }

    public void setBriefDescOn(boolean briefDescOn) {
        this.briefDescOn = briefDescOn;
    }

    public void setExternalIDOn(boolean exteranlIDOn) {
        this.externalIdOn = exteranlIDOn;
    }

    public void setLongPresentationNameOn(boolean longPresentationNameOn) {
        this.longPresentationNameOn = longPresentationNameOn;
    }

    public void setFullDescOn(boolean fullDescOn) {
        this.fullDescOn = fullDescOn;
    }

    public void setKeyConsiderationOn(boolean keyConsiderationOn) {
        this.keyConsiderationOn = keyConsiderationOn;
    }

    public void setElementTypeOn(boolean elementTypeOn) {
        this.elementTypeOn = elementTypeOn;
    }

    public boolean isAnyAttributeModified() {
        return this.anyAttributeModified;
    }

    public void setAnyAttributeModified(boolean anyAttributeModified) {
        this.anyAttributeModified = anyAttributeModified;
    }

    public boolean isVersionSectionOn() {
        return this.versionSectionOn;
    }

    public void setVersionSectionOn(boolean versionSectionOn) {
        this.versionSectionOn = versionSectionOn;
    }

    private void createVersionSection(FormToolkit toolkit) {
        this.versionSection = toolkit.createSection(this.sectionComposite, 450);
        GridData td = new GridData(1808);
        this.versionSection.setLayoutData((Object)td);
        this.versionSection.setText(AuthoringUIText.VERSION_INFO_SECTION_NAME);
        this.versionSection.setDescription(this.getVersionSectionDescription());
        this.versionSection.setLayout((Layout)new GridLayout());
        this.versionComposite = toolkit.createComposite((Composite)this.versionSection);
        this.versionComposite.setLayoutData((Object)new GridData(768));
        this.versionComposite.setLayout((Layout)new GridLayout(5, false));
        this.versionSection.setClient((Control)this.versionComposite);
    }

    protected void createVersionSectionContent() {
        String fillText = this.methodUnit.getVersion() == null ? "" : this.methodUnit.getVersion();
        this.ctrl_version = DescriptionFormPage.createTextEditWithLabel4(this.toolkit, this.versionComposite, AuthoringUIText.VERSION_TEXT, -1, 4, fillText);
        fillText = this.methodUnit.getChangeDate() == null ? "" : DateFormat.getDateInstance((int)0).format(this.methodUnit.getChangeDate());
        this.ctrl_change_date = DescriptionFormPage.createTextEditWithLabel4(this.toolkit, this.versionComposite, AuthoringUIText.CHANGE_DATE_TEXT, -1, 4, fillText);
        this.ctrl_change_date.setEditable(false);
        this.ctrl_change_desc = DescriptionFormPage.createTextEditWithLabel5(this.toolkit, this.versionComposite, AuthoringUIText.CHANGE_DESCRIPTION_TEXT, 40, 2);
        this.ctrl_authors = DescriptionFormPage.createTextEditWithLabel5(this.toolkit, this.versionComposite, AuthoringUIText.AUTHORS_TEXT, 40, 2);
        this.label_copyright = DescriptionFormPage.createLabel(this.toolkit, this.versionComposite, AuthoringUIText.COPYRIGHT_TEXT, 2);
        this.ctrl_copyright = DescriptionFormPage.createTable(this.toolkit, this.versionComposite, 12, 1809, 5, 400, 1, 2);
        this.copyright_viewer = new TableViewer(this.ctrl_copyright);
        this.initContentProviderCopyright();
        this.copyright_viewer.setLabelProvider((IBaseLabelProvider)this.copyrightLabelProviderBase);
        this.copyright_viewer.setInput((Object)this.methodElement);
        Composite buttonpane = DescriptionFormPage.createComposite(this.toolkit, this.versionComposite, 128, 1, 1, 1);
        GridData gridData = new GridData(128);
        buttonpane.setLayoutData((Object)gridData);
        this.copyright_button = this.toolkit.createButton(buttonpane, AuthoringUIText.SELECT_BUTTON_TEXT, 64);
        gridData = new GridData(128);
        gridData.widthHint = 150;
        this.copyright_button.setLayoutData((Object)gridData);
        this.copyright_button_deselect = this.toolkit.createButton(buttonpane, AuthoringUIText.DESELECT_BUTTON_TEXT, 64);
        gridData = new GridData(128);
        gridData.widthHint = 150;
        this.copyright_button_deselect.setLayoutData((Object)gridData);
        this.setCopyrightButtonDeselect();
        this.toolkit.paintBordersFor(this.versionComposite);
    }

    private void initContentProviderCopyright() {
        this.copyrightContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                ArrayList<SupportingMaterial> list = new ArrayList<SupportingMaterial>();
                if (DescriptionFormPage.this.methodUnit.getCopyrightStatement() != null) {
                    list.add(DescriptionFormPage.this.methodUnit.getCopyrightStatement());
                }
                return list.toArray();
            }

            public void notifyChanged(Notification notification) {
            }
        };
        this.copyright_viewer.setContentProvider((IContentProvider)this.copyrightContentProvider);
    }

    protected void addVersionSectionListeners() {
        this.ctrl_version.addModifyListener(this.contentModifyListener);
        this.ctrl_version.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((MethodElementEditor)DescriptionFormPage.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_Version());
            }

            public void focusLost(FocusEvent e) {
                boolean status;
                String oldContent = DescriptionFormPage.this.methodUnit.getVersion();
                if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                    return;
                }
                String newContent = StrUtil.getPlainText((String)DescriptionFormPage.this.ctrl_version.getText());
                if (!newContent.equals(oldContent) && (status = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.methodUnit, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_Version(), (Object)newContent, -1))) {
                    DescriptionFormPage.this.updateChangeDate();
                }
            }
        });
        this.ctrl_authors.addModifyListener(this.contentModifyListener);
        this.ctrl_authors.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((MethodElementEditor)DescriptionFormPage.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_Authors());
            }

            public void focusLost(FocusEvent e) {
                boolean status;
                String oldContent = DescriptionFormPage.this.methodUnit.getAuthors();
                if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                    return;
                }
                String newContent = StrUtil.getPlainText((String)DescriptionFormPage.this.ctrl_authors.getText());
                if (!newContent.equals(oldContent) && (status = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.methodUnit, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_Authors(), (Object)newContent, -1))) {
                    DescriptionFormPage.this.updateChangeDate();
                }
            }
        });
        this.copyright_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean status;
                TableItem item;
                ContentFilter filter = new ContentFilter(){

                    protected boolean childAccept(Object obj) {
                        if (obj instanceof Guidance) {
                            return obj instanceof SupportingMaterial;
                        }
                        return false;
                    }
                };
                ArrayList<Object> alreadyExsting = new ArrayList<Object>();
                if (DescriptionFormPage.this.ctrl_copyright.getItemCount() > 0 && (item = DescriptionFormPage.this.ctrl_copyright.getItems()[0]).getData() != null) {
                    alreadyExsting.add(item.getData());
                }
                ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)filter, DescriptionFormPage.this.methodElement, FilterConstants.SUPPORTING_MATERIALS, alreadyExsting);
                fd.setViewerSelectionSingle(true);
                fd.setBlockOnOpen(true);
                fd.setTitle(FilterConstants.SUPPORTING_MATERIALS);
                fd.open();
                fd.getSelectedItems();
                if (fd.getSelectedItems().size() > 0 && !(status = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.methodUnit, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_CopyrightStatement(), (Object)((SupportingMaterial)fd.getSelectedItems().get(0)), -1))) {
                    return;
                }
                DescriptionFormPage.this.copyright_viewer.refresh();
                DescriptionFormPage.this.setCopyrightButtonDeselect();
            }
        });
        this.ctrl_change_desc.addModifyListener(this.contentModifyListener);
        this.ctrl_change_desc.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((MethodElementEditor)DescriptionFormPage.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_ChangeDescription());
            }

            public void focusLost(FocusEvent e) {
                boolean success;
                String oldContent = DescriptionFormPage.this.methodUnit.getChangeDescription();
                if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                    return;
                }
                String newContent = DescriptionFormPage.this.ctrl_change_desc.getText();
                if (!(newContent = newContent.replace(StrUtil.LINE_FEED, AuthoringUIResources.ChangeHistoryDialog_delimiter)).equals(oldContent) && (success = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.methodUnit, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_ChangeDescription(), (Object)newContent, -1))) {
                    DescriptionFormPage.this.updateChangeDate();
                }
            }
        });
        this.copyright_button_deselect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean status = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.methodUnit, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_CopyrightStatement(), null, -1);
                if (status) {
                    DescriptionFormPage.this.copyright_viewer.refresh();
                    DescriptionFormPage.this.setCopyrightButtonDeselect();
                }
            }
        });
    }

    protected void updateChangeDate() {
        Date currentDate;
        String newContent;
        Date changeDate = this.methodUnit.getChangeDate();
        DateFormat df = DateFormat.getDateInstance((int)0);
        String oldContent = "";
        if (changeDate != null) {
            oldContent = df.format(changeDate);
        }
        if (!(newContent = df.format(currentDate = new Date())).equals(oldContent)) {
            boolean status = this.actionMgr.doAction(1, (EObject)this.methodUnit, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_ChangeDate(), (Object)currentDate, -1);
            if (!status) {
                return;
            }
            this.ctrl_change_date.setText(newContent);
        }
    }

    protected void loadVersionSectionData() {
        this.ctrl_version.setText(this.methodUnit.getVersion() == null ? "" : this.methodUnit.getVersion());
        this.ctrl_authors.setText(this.methodUnit.getAuthors() == null ? "" : this.methodUnit.getAuthors());
        String changeDesc = this.methodUnit.getChangeDescription() == null ? "" : this.methodUnit.getChangeDescription();
        changeDesc = changeDesc.replace(AuthoringUIResources.ChangeHistoryDialog_delimiter, StrUtil.LINE_FEED);
        this.ctrl_change_desc.setText(changeDesc);
        this.ctrl_change_date.setText(this.methodUnit.getChangeDate() == null ? "" : DateFormat.getDateInstance((int)0).format(this.methodUnit.getChangeDate()));
    }

    @Override
    protected void toggle(HyperlinkEvent e, int id) {
        this.toggle(e);
    }

    public boolean isIconSectionOn() {
        return this.iconSectionOn;
    }

    public void setIconSectionOn(boolean iconSectionOn) {
        this.iconSectionOn = iconSectionOn;
    }

    protected void createIconSection(FormToolkit toolkit) {
        this.iconSection = toolkit.createSection(this.sectionComposite, 450);
        GridData td = new GridData(1808);
        this.iconSection.setLayoutData((Object)td);
        this.iconSection.setText(AuthoringUIText.ICON_SECTION_NAME);
        this.iconSection.setDescription(this.getIconSectionDescription());
        this.iconSection.setLayout((Layout)new GridLayout());
        this.iconComposite = toolkit.createComposite((Composite)this.iconSection);
        this.iconComposite.setLayoutData((Object)new GridData(768));
        this.iconComposite.setLayout((Layout)new GridLayout(3, true));
        this.iconSection.setClient((Control)this.iconComposite);
    }

    private void createIconSectionContent() {
        Composite shapeIconComposite = DescriptionFormPage.createComposite(this.toolkit, this.iconComposite, 1);
        shapeIconComposite.setLayoutData((Object)new GridData());
        shapeIconComposite.setLayout((Layout)new GridLayout(2, true));
        DescriptionFormPage.createLabelWithNoWrap(this.toolkit, shapeIconComposite, AuthoringUIResources.DescriptionFormPage_ShapeIconPreview_Label, 1, 2);
        this.pane1 = new Canvas(shapeIconComposite, 2048);
        GridData gridData = new GridData(1);
        gridData.heightHint = 60;
        gridData.widthHint = 60;
        gridData.verticalSpan = 1;
        gridData.horizontalSpan = 1;
        this.pane1.setLayoutData((Object)gridData);
        this.pane1.setBackground(ColorConstants.lightGray);
        Composite pane2 = DescriptionFormPage.createCompositeForButtons(this.toolkit, shapeIconComposite);
        this.ctrl_select_shapeIcon_button = this.toolkit.createButton(pane2, AuthoringUIResources.DescriptionFormPage_ShapeIconPreview_SelectButtonLabel, 0);
        this.ctrl_clear_shapeIcon_button = this.toolkit.createButton(pane2, AuthoringUIResources.DescriptionFormPage_ShapeIconPreview_ClearButtonLabel, 0);
        if (this.contentElement.getShapeicon() == null) {
            this.ctrl_clear_shapeIcon_button.setEnabled(false);
        } else {
            this.ctrl_clear_shapeIcon_button.setEnabled(true);
        }
        Composite nodeIconComposite = DescriptionFormPage.createComposite(this.toolkit, this.iconComposite, 1);
        nodeIconComposite.setLayoutData((Object)new GridData(768));
        nodeIconComposite.setLayout((Layout)new GridLayout(2, false));
        DescriptionFormPage.createLabelWithNoWrap(this.toolkit, nodeIconComposite, AuthoringUIResources.DescriptionFormPage_NodeIconPreview_Label, 1, 2);
        this.pane3 = new Canvas(nodeIconComposite, 2048);
        GridData gridData2 = new GridData(1);
        gridData2.heightHint = 40;
        gridData2.widthHint = 40;
        gridData2.verticalSpan = 1;
        gridData2.horizontalSpan = 1;
        this.pane3.setLayoutData((Object)gridData2);
        this.pane3.setBackground(ColorConstants.lightGray);
        Composite pane4 = DescriptionFormPage.createCompositeForButtons(this.toolkit, nodeIconComposite);
        this.ctrl_select_nodeIcon_button = this.toolkit.createButton(pane4, AuthoringUIResources.DescriptionFormPage_NodeIconPreview_SelectButtonLabel, 0);
        this.ctrl_clear_nodeIcon_button = this.toolkit.createButton(pane4, AuthoringUIResources.DescriptionFormPage_NodeIconPreview_ClearButtonLabel, 0);
        if (this.contentElement.getNodeicon() == null) {
            this.ctrl_clear_nodeIcon_button.setEnabled(false);
        } else {
            this.ctrl_clear_nodeIcon_button.setEnabled(true);
        }
        new Label(this.iconComposite, 0);
        this.shapeIconPath = DescriptionFormPage.createLabelWithNoWrap(this.toolkit, this.iconComposite, "", 1, 1);
        this.nodeIconPath = DescriptionFormPage.createLabelWithNoWrap(this.toolkit, this.iconComposite, "", 1, 2);
        this.toolkit.paintBordersFor((Composite)this.pane1);
        this.toolkit.paintBordersFor(pane2);
        this.toolkit.paintBordersFor((Composite)this.pane3);
        this.toolkit.paintBordersFor(pane4);
    }

    protected void addIconSectionListeners() {
        this.ctrl_select_shapeIcon_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filename;
                String imageFile;
                FileDialog fileChooser;
                URI shapeIconUri;
                block10: {
                    shapeIconUri = null;
                    fileChooser = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                    fileChooser.setText(AuthoringUIResources.DescriptionFormPage_IconFileChooserDialog_title);
                    fileChooser.setFilterExtensions(DescriptionFormPage.this.imageTypes);
                    fileChooser.setFilterNames(DescriptionFormPage.this.imageNames);
                    imageFile = null;
                    filename = null;
                    while (true) {
                        imageFile = fileChooser.open();
                        filename = fileChooser.getFileName();
                        if (imageFile == null) break;
                        if (!new File(imageFile).exists()) {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.forms_DescriptionFormPage_imageNotFoundDialog_title, MessageFormat.format(AuthoringUIResources.forms_DescriptionFormPage_imageNotFoundDialog_template, imageFile));
                            continue;
                        }
                        break block10;
                        break;
                    }
                    return;
                }
                if (imageFile != null && imageFile.length() > 0) {
                    try {
                        String url = DescriptionFormPage.this.copyResourceToLib(DescriptionFormPage.this.ctrl_select_shapeIcon_button.getShell(), filename, fileChooser.getFilterPath(), DescriptionFormPage.this.methodElement);
                        if (url != null) {
                            boolean status;
                            File file = new File(url);
                            shapeIconUri = new URI(NetUtil.encodeFileURL((String)FileUtil.getRelativePath((File)file, (File)new File(DescriptionFormPage.this.getPluginPath(DescriptionFormPage.this.methodElement)))));
                            if (shapeIconUri != null && !(status = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.methodElement, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_Shapeicon(), (Object)shapeIconUri, -1))) {
                                return;
                            }
                            DescriptionFormPage.this.shapeImage = new Image((Device)Display.getCurrent(), file.getAbsolutePath());
                            DescriptionFormPage.this.shapeIconPath.setText(NetUtil.decodedFileUrl((String)shapeIconUri.getPath()));
                        }
                    }
                    catch (Exception ex) {
                        shapeIconUri = null;
                        DescriptionFormPage.this.shapeImage = null;
                        AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)ex);
                        if (ex instanceof IOException) {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.err_copying_file_title, AuthoringUIResources.err_copying_file_error, AuthoringUIResources.err_copying_file_reason, ex.getMessage());
                        }
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.err_processing_file_title, AuthoringUIResources.err_processing_file_description, (Throwable)ex);
                    }
                }
                if (DescriptionFormPage.this.shapeImage != null) {
                    DescriptionFormPage.this.pane1.redraw();
                    DescriptionFormPage.this.ctrl_clear_shapeIcon_button.setEnabled(true);
                } else {
                    DescriptionFormPage.this.ctrl_clear_shapeIcon_button.setEnabled(false);
                }
            }
        });
        this.ctrl_clear_shapeIcon_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean status = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.methodElement, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_Shapeicon(), null, -1);
                if (!status) {
                    return;
                }
                DescriptionFormPage.this.pane1.redraw();
                DescriptionFormPage.this.ctrl_clear_shapeIcon_button.setEnabled(false);
                DescriptionFormPage.this.shapeIconPath.setText("");
            }
        });
        this.ctrl_select_nodeIcon_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filename;
                String imageFile;
                FileDialog fileChooser;
                URI nodeIconUri;
                block11: {
                    nodeIconUri = null;
                    fileChooser = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                    fileChooser.setText(AuthoringUIResources.DescriptionFormPage_IconFileChooserDialog_title);
                    fileChooser.setFilterExtensions(DescriptionFormPage.this.imageTypes);
                    fileChooser.setFilterNames(DescriptionFormPage.this.imageNames);
                    imageFile = null;
                    filename = null;
                    while (true) {
                        imageFile = fileChooser.open();
                        filename = fileChooser.getFileName();
                        if (imageFile == null) break;
                        if (new File(imageFile).exists()) {
                            ImageData imageData = new ImageData(imageFile);
                            if (imageData.width > NODEICON_WIDTH_MAX || imageData.height > NODEICON_HEIGHT_MAX) {
                                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.forms_DescriptionFormPage_imageTooBigDialog_title, MessageFormat.format(AuthoringUIResources.forms_DescriptionFormPage_imageTooBigDialog_template, imageFile, new Integer(NODEICON_WIDTH_MAX), new Integer(NODEICON_HEIGHT_MAX)));
                                continue;
                            }
                            break block11;
                        }
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.forms_DescriptionFormPage_imageNotFoundDialog_title, MessageFormat.format(AuthoringUIResources.forms_DescriptionFormPage_imageNotFoundDialog_template, imageFile));
                    }
                    return;
                }
                if (imageFile != null && imageFile.length() > 0) {
                    try {
                        String url = DescriptionFormPage.this.copyResourceToLib(DescriptionFormPage.this.ctrl_select_nodeIcon_button.getShell(), filename, fileChooser.getFilterPath(), DescriptionFormPage.this.methodElement);
                        if (url != null) {
                            boolean status;
                            File file = new File(url);
                            nodeIconUri = new URI(NetUtil.encodeFileURL((String)FileUtil.getRelativePath((File)file, (File)new File(DescriptionFormPage.this.getPluginPath(DescriptionFormPage.this.methodElement)))));
                            if (nodeIconUri != null && !(status = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.methodElement, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_Nodeicon(), (Object)nodeIconUri, -1))) {
                                return;
                            }
                            DescriptionFormPage.this.nodeImage = new Image((Device)Display.getCurrent(), file.getAbsolutePath());
                            DescriptionFormPage.this.nodeIconPath.setText(NetUtil.decodedFileUrl((String)nodeIconUri.getPath()));
                        }
                    }
                    catch (Exception ex) {
                        nodeIconUri = null;
                        DescriptionFormPage.this.nodeImage = null;
                        AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)ex);
                        if (ex instanceof IOException) {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.err_copying_file_title, AuthoringUIResources.err_copying_file_error, AuthoringUIResources.err_copying_file_reason, ex.getMessage());
                        }
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.err_processing_file_title, AuthoringUIResources.err_processing_file_description, (Throwable)ex);
                    }
                }
                if (DescriptionFormPage.this.nodeImage != null) {
                    DescriptionFormPage.this.pane3.redraw();
                    DescriptionFormPage.this.ctrl_clear_nodeIcon_button.setEnabled(true);
                } else {
                    DescriptionFormPage.this.ctrl_clear_nodeIcon_button.setEnabled(false);
                }
            }
        });
        this.ctrl_clear_nodeIcon_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean status = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.methodElement, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_Nodeicon(), null, -1);
                if (!status) {
                    return;
                }
                DescriptionFormPage.this.pane3.redraw();
                DescriptionFormPage.this.ctrl_clear_nodeIcon_button.setEnabled(false);
                DescriptionFormPage.this.nodeIconPath.setText("");
            }
        });
    }

    protected String copyResourceToLib(Shell shell, String sFileName, String sFilePath, MethodElement methodElement) throws IOException {
        File newFile = LibraryUIUtil.copyResourceToLib((Shell)shell, (File)new File(sFilePath, sFileName), (MethodElement)methodElement);
        if (newFile != null) {
            return newFile.getAbsolutePath();
        }
        return null;
    }

    protected void loadIconSectionData() {
        this.pane1.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                String path;
                Rectangle clientRect = DescriptionFormPage.this.pane1.getClientArea();
                e.gc.setClipping(clientRect);
                e.gc.setBackground(Display.getCurrent().getSystemColor(15));
                e.gc.fillRectangle(clientRect);
                URI uri = DescriptionFormPage.this.contentElement.getShapeicon();
                if (uri != null && (path = NetUtil.decodedFileUrl((String)DescriptionFormPage.this.contentElement.getShapeicon().getPath())) != null) {
                    try {
                        File file = new File(path);
                        if (!file.exists()) {
                            if (!file.isAbsolute()) {
                                MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)DescriptionFormPage.this.methodElement);
                                path = path.indexOf(plugin.getName()) > -1 ? String.valueOf(LibraryService.getInstance().getCurrentMethodLibraryLocation()) + File.separator + path : String.valueOf(DescriptionFormPage.this.getPluginPath(DescriptionFormPage.this.methodElement)) + File.separator + path;
                            }
                            file = new File(path);
                        }
                        if (file.exists()) {
                            if (DescriptionFormPage.this.shapeImage == null) {
                                DescriptionFormPage.this.shapeImage = new Image((Device)Display.getCurrent(), path);
                            }
                            if (DescriptionFormPage.this.contentElement.getShapeicon() != null) {
                                DescriptionFormPage.this.shapeIconPath.setText(NetUtil.decodedFileUrl((String)DescriptionFormPage.this.contentElement.getShapeicon().getPath()));
                            }
                            clientRect = DescriptionFormPage.this.pane1.getClientArea();
                            e.gc.setClipping(clientRect);
                            e.gc.setBackground(Display.getCurrent().getSystemColor(1));
                            e.gc.fillRectangle(clientRect);
                            e.gc.drawImage(DescriptionFormPage.this.shapeImage, ((DescriptionFormPage)DescriptionFormPage.this).shapeImage.getBounds().x, ((DescriptionFormPage)DescriptionFormPage.this).shapeImage.getBounds().y, ((DescriptionFormPage)DescriptionFormPage.this).shapeImage.getBounds().width, ((DescriptionFormPage)DescriptionFormPage.this).shapeImage.getBounds().height, ((DescriptionFormPage)DescriptionFormPage.this).pane1.getClientArea().x, ((DescriptionFormPage)DescriptionFormPage.this).pane1.getClientArea().y, ((DescriptionFormPage)DescriptionFormPage.this).pane1.getClientArea().width, ((DescriptionFormPage)DescriptionFormPage.this).pane1.getClientArea().height);
                        } else if (DescriptionFormPage.this.warningCount == 1) {
                            DescriptionFormPage descriptionFormPage = DescriptionFormPage.this;
                            descriptionFormPage.warningCount = descriptionFormPage.warningCount + 1;
                            String msg = AuthoringUIResources.bind((String)AuthoringUIResources.DescriptionFormPage_LoadShapeIconWarning, (Object[])new Object[]{DescriptionFormPage.this.methodElement.getName(), path});
                            MsgBox.showWarning((String)msg);
                        }
                    }
                    catch (Exception ex) {
                        AuthoringUIPlugin.getDefault().getLogger().logError(AuthoringUIResources.bind((String)AuthoringUIResources.DescriptionFormPage_LoadShapeIconError, (Object[])new Object[]{ex.getMessage()}));
                    }
                }
            }
        });
        this.pane1.redraw();
        if (this.contentElement.getShapeicon() != null) {
            this.shapeIconPath.setText(NetUtil.decodedFileUrl((String)this.contentElement.getShapeicon().getPath()));
        }
        this.pane3.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                String path;
                Rectangle clientRect = DescriptionFormPage.this.pane3.getClientArea();
                e.gc.setClipping(clientRect);
                e.gc.setBackground(Display.getCurrent().getSystemColor(15));
                e.gc.fillRectangle(clientRect);
                URI uri = DescriptionFormPage.this.contentElement.getNodeicon();
                if (uri != null && (path = NetUtil.decodedFileUrl((String)DescriptionFormPage.this.contentElement.getNodeicon().getPath())) != null) {
                    try {
                        File file = new File(path);
                        if (!file.exists()) {
                            if (!file.isAbsolute()) {
                                MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)DescriptionFormPage.this.methodElement);
                                path = path.indexOf(plugin.getName()) > -1 ? String.valueOf(LibraryService.getInstance().getCurrentMethodLibraryLocation()) + File.separator + path : String.valueOf(DescriptionFormPage.this.getPluginPath(DescriptionFormPage.this.methodElement)) + File.separator + path;
                            }
                            file = new File(path);
                        }
                        if (file.exists()) {
                            if (DescriptionFormPage.this.nodeImage == null) {
                                DescriptionFormPage.this.nodeImage = new Image((Device)Display.getCurrent(), path);
                            }
                            if (DescriptionFormPage.this.contentElement.getNodeicon() != null) {
                                DescriptionFormPage.this.nodeIconPath.setText(NetUtil.decodedFileUrl((String)DescriptionFormPage.this.contentElement.getNodeicon().getPath()));
                            }
                            clientRect = DescriptionFormPage.this.pane3.getClientArea();
                            e.gc.setClipping(clientRect);
                            e.gc.setBackground(Display.getCurrent().getSystemColor(1));
                            e.gc.fillRectangle(clientRect);
                            e.gc.drawImage(DescriptionFormPage.this.nodeImage, ((DescriptionFormPage)DescriptionFormPage.this).nodeImage.getBounds().x, ((DescriptionFormPage)DescriptionFormPage.this).nodeImage.getBounds().y, ((DescriptionFormPage)DescriptionFormPage.this).nodeImage.getBounds().width, ((DescriptionFormPage)DescriptionFormPage.this).nodeImage.getBounds().height, ((DescriptionFormPage)DescriptionFormPage.this).pane3.getClientArea().x, ((DescriptionFormPage)DescriptionFormPage.this).pane3.getClientArea().y, ((DescriptionFormPage)DescriptionFormPage.this).pane3.getClientArea().width, ((DescriptionFormPage)DescriptionFormPage.this).pane3.getClientArea().height);
                        } else if (DescriptionFormPage.this.warningCount == 1) {
                            DescriptionFormPage descriptionFormPage = DescriptionFormPage.this;
                            descriptionFormPage.warningCount = descriptionFormPage.warningCount + 1;
                            String msg = AuthoringUIResources.bind((String)AuthoringUIResources.DescriptionFormPage_LoadNodeIconWarning, (Object[])new Object[]{DescriptionFormPage.this.methodElement.getName(), path});
                            MsgBox.showWarning((String)msg);
                        }
                    }
                    catch (Exception ex) {
                        AuthoringUIPlugin.getDefault().getLogger().logError(AuthoringUIResources.bind((String)AuthoringUIResources.DescriptionFormPage_LoadNodeIconError, (Object[])new Object[]{ex.getMessage()}));
                    }
                }
            }
        });
        this.pane3.redraw();
        if (this.contentElement.getNodeicon() != null) {
            this.nodeIconPath.setText(NetUtil.decodedFileUrl((String)this.contentElement.getNodeicon().getPath()));
        }
    }

    protected void enableSections(boolean enable) {
        if (this.generalSectionOn) {
            this.generalSection.setVisible(enable);
            if (enable) {
                this.generalSection.setExpanded(this.generalSectionExpandFlag);
            } else {
                this.generalSectionExpandFlag = this.generalSection.isExpanded();
                this.generalSection.setExpanded(enable);
            }
        }
        if (this.detailSectionOn) {
            this.detailSection.setVisible(enable);
            if (enable) {
                this.detailSection.setExpanded(this.detailSectionExpandFlag);
            } else {
                this.detailSectionExpandFlag = this.detailSection.isExpanded();
                this.detailSection.setExpanded(enable);
            }
        }
        if (this.notationSectionOn) {
            this.notationSection.setVisible(enable);
            if (enable) {
                this.notationSection.setExpanded(this.notationSectionExpandFlag);
            } else {
                this.notationSectionExpandFlag = this.notationSection.isExpanded();
                this.notationSection.setExpanded(enable);
            }
        }
        if (this.tailoringSectionOn) {
            this.tailoringSection.setVisible(enable);
            if (enable) {
                this.tailoringSection.setExpanded(this.tailoringSectionExpandFlag);
            } else {
                this.tailoringSectionExpandFlag = this.tailoringSection.isExpanded();
                this.tailoringSection.setExpanded(enable);
            }
        }
        if (this.versionSectionOn) {
            this.versionSection.setVisible(enable);
            if (enable) {
                this.versionSection.setExpanded(this.versionSectionExpandFlag);
            } else {
                this.versionSectionExpandFlag = this.versionSection.isExpanded();
                this.versionSection.setExpanded(enable);
            }
        }
        if (this.iconSectionOn) {
            this.iconSection.setVisible(enable);
            if (enable) {
                this.iconSection.setExpanded(this.iconSectionExpandFlag);
            } else {
                this.iconSectionExpandFlag = this.iconSection.isExpanded();
                this.iconSection.setExpanded(enable);
            }
        }
        if (this.variabilitySectionOn) {
            this.variabilitySection.setVisible(enable);
            if (enable) {
                this.variabilitySection.setExpanded(this.elementSectionExpandFlag);
            } else {
                this.elementSectionExpandFlag = this.variabilitySection.isExpanded();
                this.variabilitySection.setExpanded(enable);
            }
        }
    }

    public void dispose() {
        if (this.shapeImage != null) {
            this.shapeImage.dispose();
        }
        if (this.nodeImage != null) {
            this.nodeImage.dispose();
        }
        if (this.labelProviderVariability != null) {
            this.labelProviderVariability.dispose();
        }
        if (this.contentProviderVariability != null) {
            this.contentProviderVariability.dispose();
        }
        if (this.labelProviderBase != null) {
            this.labelProviderBase.dispose();
        }
        if (this.copyrightLabelProviderBase != null) {
            this.copyrightLabelProviderBase.dispose();
        }
        if (this.columnProvider != null) {
            this.columnProvider.dispose();
        }
        if (this.sectionProviders != null) {
            int i = 0;
            while (i < this.sectionProviders.size()) {
                ISectionProvider provider = this.sectionProviders.get(i);
                if (provider != null && provider instanceof ISectionProvider) {
                    provider.dispose();
                }
                ++i;
            }
        }
        super.dispose();
        this.disposed = true;
    }

    private void setCopyrightButtonDeselect() {
        if (this.methodUnit.getCopyrightStatement() != null) {
            this.copyright_button_deselect.setEnabled(this.methodUnit.getCopyrightStatement().getName() != null);
        } else {
            this.copyright_button_deselect.setEnabled(false);
        }
        if (TngUtil.isLocked((EObject)this.methodElement)) {
            this.copyright_button_deselect.setEnabled(false);
        }
    }

    protected void setContextHelp() {
        if (this.mainComposite != null) {
            EditorsContextHelper.setHelp((Control)this.mainComposite.getParent(), this.getContentElement());
        }
        if (this.expandedComposite != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.expandedComposite, AuthoringUIHelpContexts.RICH_TEXT_EDITOR_CONTEXT_ID);
        }
    }

    @Override
    public void refreshName(String newName) {
        if (newName != null && this.ctrl_name != null && !this.ctrl_name.isDisposed()) {
            if (this.nameModifyListener != null) {
                this.ctrl_name.removeModifyListener((ModifyListener)this.nameModifyListener);
                this.ctrl_name.setText(newName);
                this.ctrl_name.addModifyListener((ModifyListener)this.nameModifyListener);
            } else {
                this.ctrl_name.setText(newName);
            }
            this.setFormTextWithVariableInfo();
        }
    }

    public void loadSectionDescription() {
    }

    protected String getDetailSectionDescription() {
        if (this.detailSectionDescription != null) {
            return this.detailSectionDescription;
        }
        return AuthoringUIText.DETAIL_SECTION_DESC;
    }

    protected String getGeneralSectionDescription() {
        if (this.generalSectionDescription != null) {
            return this.generalSectionDescription;
        }
        return AuthoringUIText.GENERAL_INFO_SECTION_DESC;
    }

    protected String getTailoringSectionDescription() {
        if (this.tailoringSectionDescription != null) {
            return this.tailoringSectionDescription;
        }
        return AuthoringUIText.TAILORING_SECTION_DESC;
    }

    protected String getNotationSectionDescription() {
        if (this.notationSectionDescription != null) {
            return this.notationSectionDescription;
        }
        return AuthoringUIText.NOTATION_SECTION_DESC;
    }

    protected String getVariabilitySectionDescription() {
        if (this.variabilitySectionDescription != null) {
            return this.variabilitySectionDescription;
        }
        return AuthoringUIText.VARIABILITY_SECTION_DESC;
    }

    private String getIconSectionDescription() {
        if (this.iconSectionDescription != null) {
            return this.iconSectionDescription;
        }
        return AuthoringUIText.ICON_SECTION_DESC;
    }

    private String getVersionSectionDescription() {
        if (this.versionSectionDescription != null) {
            return this.versionSectionDescription;
        }
        return AuthoringUIText.VERSION_INFO_SECTION_DESC;
    }

    public Text getCtrl_brief_desc() {
        return this.ctrl_brief_desc;
    }

    public void setCtrl_brief_desc(Text ctrl_brief_desc) {
        this.ctrl_brief_desc = ctrl_brief_desc;
    }

    public IMethodRichText getCtrl_full_desc() {
        return this.ctrl_full_desc;
    }

    public void setCtrl_full_desc(IMethodRichText ctrl_full_desc) {
        this.ctrl_full_desc = ctrl_full_desc;
    }

    public Text getCtrl_presentation_name() {
        return this.ctrl_presentation_name;
    }

    public void setCtrl_presentation_name(Text ctrl_presentation_name) {
        this.ctrl_presentation_name = ctrl_presentation_name;
    }

    public IMethodRichTextEditor getCtrl_expanded() {
        return this.ctrl_expanded;
    }

    public void setCtrl_expanded(IMethodRichTextEditor ctrl_expanded) {
        this.ctrl_expanded = ctrl_expanded;
    }

    public IMethodRichText getCtrl_key() {
        return this.ctrl_key;
    }

    public void setCtrl_key(IMethodRichText ctrl_key) {
        this.ctrl_key = ctrl_key;
    }

    public String getPluginPath(MethodElement e) {
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)e);
        if (plugin != null) {
            return ResourceHelper.getFolderAbsolutePath((MethodElement)plugin);
        }
        return null;
    }

    private String generateName(String presentationName) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < presentationName.length()) {
            boolean toAdd;
            char c = presentationName.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c - 65);
                c = (char)(c + 97);
            } else if (c == ' ') {
                c = '_';
            }
            boolean bl = toAdd = c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == '-' || c == '_' || c == '.';
            if (toAdd) {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    protected void changeElementName() {
        String name = this.ctrl_name.getText();
        if (!name.equals(this.methodElement.getName())) {
            IValidator validator = this.getNameValidator();
            if (validator == null) {
                validator = IValidatorFactory.INSTANCE.createNameValidator((NamedElement)this.methodElement, (AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
            }
            String name0 = name;
            int i = 1;
            while (i < 1000) {
                String msg = validator.isValid(name);
                if (msg == null || msg.length() == 0) {
                    this.ctrl_name.setText(name);
                    break;
                }
                name = String.valueOf(name0) + "_" + i;
                ++i;
            }
            if (!name.equals(this.methodElement.getName())) {
                this.changeElementName(this.ctrl_name.getText());
            }
            LibraryUtil.removeNameTrackPresentationNameMark((MethodElement)this.methodElement);
        }
    }

    protected boolean isAutoGenName() {
        return this.autoGenName;
    }

    protected void setAutoGenName(boolean autoGenName) {
        this.autoGenName = autoGenName;
    }

    public static class DescriptionFormSectionExtender {
        protected DescriptionFormPage formPage;

        public DescriptionFormSectionExtender(DescriptionFormPage formPage) {
            this.formPage = formPage;
        }

        public void modifyGeneralSectionContent(FormToolkit toolkit, IActionManager actionMgr) {
        }

        protected Composite getGeneralComposite() {
            return this.formPage.generalComposite;
        }

        protected MethodElement getElement() {
            return this.formPage.methodElement;
        }

        protected void refresh(boolean editable) {
        }
    }

    private class VariabilityTypeContentProvider
    extends AdapterFactoryContentProvider {
        private VariabilityType[] types;

        public VariabilityTypeContentProvider(AdapterFactory adapterFactory, VariabilityType[] types) {
            super(adapterFactory);
            this.types = types;
        }

        public Object[] getElements(Object object) {
            return this.types;
        }

        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() == DescriptionFormPage.this.methodElement && notification.getEventType() == 1 && notification.getFeature() == UmaPackage.Literals.VARIABILITY_ELEMENT__VARIABILITY_TYPE) {
                this.viewer.setSelection((ISelection)new StructuredSelection(notification.getNewValue()));
            }
        }
    }
}

