/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.forms.GuidanceDescriptionPage;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.richtext.dialogs.AddLinkDialog;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.GuidanceDescription;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class GuidanceWithAttachmentsDescriptionPage
extends GuidanceDescriptionPage {
    private Button ctrl_attach;
    private Button ctrl_detach;
    private Button ctrl_attach_url;
    private org.eclipse.swt.widgets.List ctrl_attached_files;
    public static final String GUIDANCE_ATTACHMENT_LAST_DIRECTORY_BROWSED_PREF = "guidance_attachment_last_dir_browsed";

    public GuidanceWithAttachmentsDescriptionPage(FormEditor editor) {
        super(editor);
    }

    protected void createEditorContent(FormToolkit toolkit) {
        super.createEditorContent(toolkit);
        GuidanceWithAttachmentsDescriptionPage.createLabel(toolkit, this.generalComposite, AuthoringUIText.ATTACHED_FILE_TEXT, 2);
        this.ctrl_attached_files = new org.eclipse.swt.widgets.List(this.generalComposite, 772);
        GridData listGridData = new GridData(1, 1, true, true);
        listGridData.heightHint = 30;
        listGridData.widthHint = 300;
        this.ctrl_attached_files.setLayoutData((Object)listGridData);
        this.ctrl_attached_files.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        Composite buttonComposite = GuidanceWithAttachmentsDescriptionPage.createComposite(toolkit, this.generalComposite, 1);
        GridData gridData = new GridData(128);
        gridData.verticalSpan = 1;
        gridData.horizontalSpan = 3;
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setLayout((Layout)new GridLayout(3, false));
        this.ctrl_attach = GuidanceWithAttachmentsDescriptionPage.createButton(toolkit, buttonComposite, 7);
        this.ctrl_attach_url = GuidanceWithAttachmentsDescriptionPage.createButton(toolkit, buttonComposite, 9);
        this.ctrl_detach = GuidanceWithAttachmentsDescriptionPage.createButton(toolkit, buttonComposite, 8);
        this.label_base.setText(AuthoringUIText.BASE_ELEMENT_TEXT);
    }

    protected void addListeners() {
        super.addListeners();
        final IActionManager actionMgr = ((MethodElementEditor)this.getEditor()).getActionManager();
        this.ctrl_attach.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                dialog.setText(AuthoringUIResources.attachGuidanceFileDialog_title);
                String lastDir = AuthoringUIPlugin.getDefault().getPreferenceStore().getString(GuidanceWithAttachmentsDescriptionPage.GUIDANCE_ATTACHMENT_LAST_DIRECTORY_BROWSED_PREF);
                if (lastDir != null && lastDir.trim().length() > 0) {
                    dialog.setFilterPath(lastDir);
                } else {
                    dialog.setFilterPath(ResourceHelper.getFolderAbsolutePath((MethodElement)GuidanceWithAttachmentsDescriptionPage.this.guidance));
                }
                dialog.open();
                if (dialog.getFileName() != null && dialog.getFileName() != "") {
                    try {
                        File fileToAttach = new File(dialog.getFilterPath(), dialog.getFileName());
                        String fileUrl = LibraryUIUtil.getURLForAttachment((Shell)GuidanceWithAttachmentsDescriptionPage.this.ctrl_attach.getShell(), (File)fileToAttach, (MethodElement)GuidanceWithAttachmentsDescriptionPage.this.guidance, (boolean)true);
                        if (fileUrl == null) {
                            return;
                        }
                        if (GuidanceWithAttachmentsDescriptionPage.this.ctrl_attached_files.indexOf(fileUrl) != -1) {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(AuthoringUIResources.AttachmentDialogattachFile_text, AuthoringUIResources.forms_GuidanceWithAttachmentsDescriptionPage_alreadyAttached_msg);
                            return;
                        }
                        GuidanceWithAttachmentsDescriptionPage.this.ctrl_attached_files.add(fileUrl);
                        boolean status = actionMgr.doAction(1, (EObject)GuidanceWithAttachmentsDescriptionPage.this.guidance.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getGuidanceDescription_Attachments(), (Object)GuidanceWithAttachmentsDescriptionPage.this.getFilesFromListCtrl(), -1);
                        if (!status) {
                            return;
                        }
                        AuthoringUIPlugin.getDefault().getPreferenceStore().setValue(GuidanceWithAttachmentsDescriptionPage.GUIDANCE_ATTACHMENT_LAST_DIRECTORY_BROWSED_PREF, dialog.getFilterPath());
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.ctrl_attach_url.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddLinkDialog dialog = new AddLinkDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "");
                dialog.open();
                if (dialog.getReturnCode() == 0 && dialog.getLink() != null) {
                    try {
                        String linkName;
                        String linkUrl;
                        block9: {
                            linkUrl = dialog.getLink().getURL();
                            linkName = dialog.getLink().getName();
                            if (linkName == null || linkName.trim().length() == 0) {
                                linkName = FileUtil.getFileName((String)linkUrl);
                            }
                            try {
                                new URL(linkUrl);
                            }
                            catch (MalformedURLException mue) {
                                if (!mue.getMessage().startsWith("no protocol")) break block9;
                                linkUrl = "http://" + linkUrl;
                            }
                        }
                        String urlString = "<a href=\"";
                        urlString = Platform.getOS().equals("win32") ? String.valueOf(urlString) + NetUtil.encodeFileURL((String)linkUrl) : String.valueOf(urlString) + NetUtil.encodeFileURL((String)linkUrl);
                        linkUrl = urlString = String.valueOf(urlString) + "\">" + linkName + "</a>";
                        if (linkUrl == null) {
                            return;
                        }
                        if (GuidanceWithAttachmentsDescriptionPage.this.ctrl_attached_files.indexOf(linkUrl) != -1) {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(AuthoringUIResources.AttachmentDialogattachUrl_text, AuthoringUIResources.forms_GuidanceWithUrlAttachmentsDescriptionPage_alreadyAttached_msg);
                            return;
                        }
                        GuidanceWithAttachmentsDescriptionPage.this.ctrl_attached_files.add(linkUrl);
                        boolean status = actionMgr.doAction(1, (EObject)GuidanceWithAttachmentsDescriptionPage.this.guidance.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getGuidanceDescription_Attachments(), (Object)GuidanceWithAttachmentsDescriptionPage.this.getFilesFromListCtrl(), -1);
                        if (!status) {
                            return;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.ctrl_detach.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GuidanceWithAttachmentsDescriptionPage.this.ctrl_attached_files.remove(GuidanceWithAttachmentsDescriptionPage.this.ctrl_attached_files.getSelectionIndex());
                boolean status = actionMgr.doAction(1, (EObject)GuidanceWithAttachmentsDescriptionPage.this.guidance.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getGuidanceDescription_Attachments(), (Object)GuidanceWithAttachmentsDescriptionPage.this.getFilesFromListCtrl(), -1);
                if (!status) {
                    return;
                }
            }
        });
    }

    protected void refresh(boolean editable) {
        super.refresh(editable);
        this.ctrl_attach.setEnabled(editable);
        this.ctrl_attach_url.setEnabled(editable);
        this.ctrl_detach.setEnabled(editable);
    }

    protected void loadData() {
        super.loadData();
        if (this.guidance != null) {
            ContentDescription content = this.guidance.getPresentation();
            String thirdpartyformat = ((GuidanceDescription)content).getAttachments();
            this.setFilesToListCtrl(thirdpartyformat);
        }
    }

    protected Object getContentElement() {
        return this.contentElement;
    }

    private void setFilesToListCtrl(String fileString) {
        List attachmentList = TngUtil.convertGuidanceAttachmentsToList((String)fileString);
        this.ctrl_attached_files.removeAll();
        for (String attachment : attachmentList) {
            this.ctrl_attached_files.add(attachment);
        }
    }

    private String getFilesFromListCtrl() {
        String[] files = this.ctrl_attached_files.getItems();
        return TngUtil.convertGuidanceAttachmentsToString(Arrays.asList(files));
    }
}

