/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class MethodLibraryDescriptionFormPage
extends FormPage {
    private static final int DEFAULT_VERTICAL_INDENT = 2;
    private Text ctrl_name;
    private Text ctrl_brief_desc;
    private Section generalSection;
    private Composite generalComposite;
    private MethodLibrary library;
    private Text textAuthors;
    private Text ctrl_change_date;
    private Text ctrl_change_desc;
    private Text ctrl_version;
    private Text ctrl_copyright;

    public MethodLibraryDescriptionFormPage(FormEditor editor) {
        super(editor, AuthoringUIResources.descriptionPage_title, AuthoringUIResources.descriptionPage_title);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        MethodElementEditorInput methodElementInput = (MethodElementEditorInput)input;
        MethodElement obj = methodElementInput.getMethodElement();
        if (obj instanceof MethodLibrary) {
            this.library = (MethodLibrary)obj;
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText(this.getEditor().getPartName());
        TableWrapLayout layout = new TableWrapLayout();
        form.getBody().setLayout((Layout)layout);
        this.createEditorContent(toolkit, form.getBody());
    }

    private void createEditorContent(FormToolkit toolkit, Composite editorComposite) {
        this.generalSection = toolkit.createSection(editorComposite, 450);
        TableWrapData td = new TableWrapData(256);
        this.generalSection.setLayoutData((Object)td);
        this.generalSection.setText(AuthoringUIResources.MethodLibraryDescriptionFormPage_section_title);
        this.generalSection.setDescription(AuthoringUIResources.MethodLibraryDescriptionFormPage_section_description);
        this.generalSection.setLayout((Layout)new GridLayout());
        this.generalComposite = toolkit.createComposite((Composite)this.generalSection);
        this.generalComposite.setLayoutData((Object)new GridData(1808));
        this.generalComposite.setLayout((Layout)new GridLayout(2, false));
        this.generalSection.setClient((Control)this.generalComposite);
        Label l_name = toolkit.createLabel(this.generalComposite, AuthoringUIResources.name_text);
        GridData gridData = new GridData(1);
        gridData.verticalIndent = 2;
        l_name.setLayoutData((Object)gridData);
        this.ctrl_name = toolkit.createText(this.generalComposite, "", 4);
        gridData = new GridData(768);
        gridData.widthHint = 400;
        gridData.verticalIndent = 2;
        this.ctrl_name.setLayoutData((Object)gridData);
        Label l_brief_desc = toolkit.createLabel(this.generalComposite, AuthoringUIResources.description_text);
        GridData gridData2 = new GridData(1);
        gridData2.verticalIndent = 2;
        l_brief_desc.setLayoutData((Object)gridData2);
        this.ctrl_brief_desc = toolkit.createText(this.generalComposite, "", 66);
        gridData2 = new GridData(768);
        gridData2.heightHint = 40;
        gridData2.widthHint = 400;
        gridData2.verticalIndent = 2;
        this.ctrl_brief_desc.setLayoutData((Object)gridData2);
        Label label = toolkit.createLabel(this.generalComposite, AuthoringUIResources.authors_text);
        GridData gridData3 = new GridData(1);
        gridData3.verticalIndent = 2;
        label.setLayoutData((Object)gridData3);
        this.textAuthors = toolkit.createText(this.generalComposite, "", 66);
        gridData3 = new GridData(768);
        gridData3.heightHint = 40;
        gridData3.widthHint = 400;
        gridData3.verticalIndent = 2;
        this.textAuthors.setLayoutData((Object)gridData3);
        Label l_changedate = toolkit.createLabel(this.generalComposite, "");
        GridData gridData4 = new GridData(1);
        gridData4.verticalIndent = 2;
        l_changedate.setLayoutData((Object)gridData4);
        this.ctrl_change_date = toolkit.createText(this.generalComposite, "", 8);
        gridData4 = new GridData(768);
        gridData4.verticalIndent = 2;
        this.ctrl_change_date.setLayoutData((Object)gridData4);
        Label l_change_desc = toolkit.createLabel(this.generalComposite, AuthoringUIText.CHANGE_DESCRIPTION_TEXT);
        GridData gridData5 = new GridData(1);
        gridData5.verticalIndent = 2;
        l_change_desc.setLayoutData((Object)gridData5);
        this.ctrl_change_desc = toolkit.createText(this.generalComposite, "", 2);
        gridData5 = new GridData(768);
        gridData5.heightHint = 40;
        gridData5.verticalIndent = 2;
        this.ctrl_change_desc.setLayoutData((Object)gridData5);
        Label l_version = toolkit.createLabel(this.generalComposite, AuthoringUIText.VERSION_TEXT);
        GridData gridData6 = new GridData(1);
        gridData6.verticalIndent = 2;
        l_version.setLayoutData((Object)gridData6);
        this.ctrl_version = toolkit.createText(this.generalComposite, "", 2);
        gridData6 = new GridData(768);
        gridData6.verticalIndent = 2;
        this.ctrl_version.setLayoutData((Object)gridData6);
        Label l_copyright = toolkit.createLabel(this.generalComposite, AuthoringUIResources.copyright_text);
        GridData gridData7 = new GridData(1);
        gridData7.verticalIndent = 2;
        l_copyright.setLayoutData((Object)gridData7);
        this.ctrl_copyright = toolkit.createText(this.generalComposite, "");
        gridData7 = new GridData(768);
        gridData7.heightHint = 40;
        gridData7.widthHint = 400;
        gridData7.horizontalSpan = 1;
        gridData7.verticalIndent = 2;
        this.ctrl_copyright.setLayoutData((Object)gridData7);
        toolkit.paintBordersFor(this.generalComposite);
        this.addListeners();
        this.loadData();
        Display display = editorComposite.getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    MethodLibraryDescriptionFormPage.this.ctrl_name.setFocus();
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
    }

    private void loadData() {
        String name = this.library.getName();
        String brief_desc = this.library.getBriefDescription();
        this.ctrl_name.setText(TngUtil.checkNull((String)name));
        this.ctrl_brief_desc.setText(TngUtil.checkNull((String)brief_desc));
        this.textAuthors.setText(TngUtil.checkNull((String)this.library.getAuthors()));
        if (this.library.getChangeDate() != null) {
            this.ctrl_change_date.setText(TngUtil.checkNull((String)this.library.getChangeDate().toLocaleString()));
        }
        this.ctrl_change_desc.setText(TngUtil.checkNull((String)this.library.getChangeDescription()));
        this.ctrl_version.setText(TngUtil.checkNull((String)this.library.getVersion()));
    }

    private void addListeners() {
        this.ctrl_name.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                MethodLibraryDescriptionFormPage.this.library.setName(MethodLibraryDescriptionFormPage.this.ctrl_name.getText());
            }
        });
        this.ctrl_brief_desc.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                MethodLibraryDescriptionFormPage.this.library.setBriefDescription(MethodLibraryDescriptionFormPage.this.ctrl_brief_desc.getText());
            }
        });
        this.textAuthors.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                MethodLibraryDescriptionFormPage.this.library.setAuthors(MethodLibraryDescriptionFormPage.this.textAuthors.getText());
            }
        });
        this.ctrl_change_desc.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                MethodLibraryDescriptionFormPage.this.library.setChangeDescription(MethodLibraryDescriptionFormPage.this.ctrl_change_desc.getText());
            }
        });
        this.ctrl_version.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                MethodLibraryDescriptionFormPage.this.library.setVersion(MethodLibraryDescriptionFormPage.this.ctrl_version.getText());
            }
        });
        this.ctrl_copyright.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
            }
        });
    }
}

