/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.forms.GuidanceDescriptionPage;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.library.edit.util.PracticePropUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.PracticeDescription;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.UserDefinedTypeMeta;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PracticeDescriptionPage
extends GuidanceDescriptionPage {
    private IMethodRichText ctrl_additional_info;
    private IMethodRichText ctrl_problem;
    private IMethodRichText ctrl_background;
    private IMethodRichText ctrl_goals;
    private IMethodRichText ctrl_application;
    private IMethodRichText ctrl_levels_adoption;
    private Practice guidance;

    public PracticeDescriptionPage(FormEditor editor) {
        super(editor);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.guidance = (Practice)this.contentElement;
        this.publishPracticeOn = true;
        if (PracticePropUtil.getPracticePropUtil().isUdtType((MethodElement)this.guidance)) {
            this.publishPracticeOnForUDT = true;
        }
        this.setContentFieldHeight(200);
        this.setFullDescOn(true);
        this.contentOn = false;
    }

    protected void createEditorContent(FormToolkit toolkit) {
        super.createEditorContent(toolkit);
        this.label_base.setText(AuthoringUIText.BASE_ELEMENT_TEXT);
    }

    protected void createDetailSectionContent() {
        PracticeRTELabelProvider provider = new PracticeRTELabelProvider(this.guidance);
        this.ctrl_problem = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, provider.getProblemLabel(), 40, 400, 2);
        this.ctrl_goals = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, provider.getGoalsLabel(), 40, 400, 2);
        this.ctrl_background = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, provider.getBackgroundLabel(), 40, 400, 2);
        if (this.fullDescOn) {
            int width = 40;
            if (!PracticePropUtil.getPracticePropUtil().isUdtType((MethodElement)this.guidance)) {
                width = 100;
            }
            this.ctrl_full_desc = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, provider.getMainDescriptionLabel(), width, 400, 2);
        }
        this.ctrl_application = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, provider.getApplicationLabel(), 40, 400, 2);
        this.ctrl_levels_adoption = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, provider.getLevelsOfAdoptionLabel(), 40, 400, 2);
        this.ctrl_additional_info = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, provider.getAdditionalInfoLabel(), 40, 400, 2);
    }

    protected void addListeners() {
        super.addListeners();
        final MethodElementEditor editor = (MethodElementEditor)this.getEditor();
        MethodElementEditor.ModifyListener contentModifyListener = editor.createModifyListener((EObject)this.guidance.getPresentation());
        this.ctrl_additional_info.setModalObject((EObject)((PracticeDescription)this.guidance.getPresentation()));
        this.ctrl_additional_info.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getPracticeDescription_AdditionalInfo());
        this.ctrl_additional_info.addModifyListener(contentModifyListener);
        this.ctrl_additional_info.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                boolean success;
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = PracticeDescriptionPage.this.descExpandFlag ? PracticeDescriptionPage.this.ctrl_expanded : PracticeDescriptionPage.this.ctrl_additional_info;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = ((PracticeDescription)PracticeDescriptionPage.this.guidance.getPresentation()).getAdditionalInfo();
                if (((MethodElementEditor)PracticeDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent) && (success = editor.getActionManager().doAction(1, (EObject)((PracticeDescription)PracticeDescriptionPage.this.guidance.getPresentation()), (EStructuralFeature)UmaPackage.eINSTANCE.getPracticeDescription_AdditionalInfo(), (Object)newContent, -1)) && PracticeDescriptionPage.this.isVersionSectionOn()) {
                    PracticeDescriptionPage.this.updateChangeDate();
                }
            }
        });
        this.ctrl_application.setModalObject((EObject)((PracticeDescription)this.guidance.getPresentation()));
        this.ctrl_application.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getPracticeDescription_Application());
        this.ctrl_application.addModifyListener(contentModifyListener);
        this.ctrl_application.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                boolean success;
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = PracticeDescriptionPage.this.descExpandFlag ? PracticeDescriptionPage.this.ctrl_expanded : PracticeDescriptionPage.this.ctrl_application;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = ((PracticeDescription)PracticeDescriptionPage.this.guidance.getPresentation()).getApplication();
                if (((MethodElementEditor)PracticeDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent) && (success = editor.getActionManager().doAction(1, (EObject)((PracticeDescription)PracticeDescriptionPage.this.guidance.getPresentation()), (EStructuralFeature)UmaPackage.eINSTANCE.getPracticeDescription_Application(), (Object)newContent, -1)) && PracticeDescriptionPage.this.isVersionSectionOn()) {
                    PracticeDescriptionPage.this.updateChangeDate();
                }
            }
        });
        this.ctrl_goals.setModalObject((EObject)((PracticeDescription)this.guidance.getPresentation()));
        this.ctrl_goals.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getPracticeDescription_Goals());
        this.ctrl_goals.addModifyListener(contentModifyListener);
        this.ctrl_goals.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                boolean success;
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = PracticeDescriptionPage.this.descExpandFlag ? PracticeDescriptionPage.this.ctrl_expanded : PracticeDescriptionPage.this.ctrl_goals;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = ((PracticeDescription)PracticeDescriptionPage.this.guidance.getPresentation()).getGoals();
                if (((MethodElementEditor)PracticeDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent) && (success = editor.getActionManager().doAction(1, (EObject)((PracticeDescription)PracticeDescriptionPage.this.guidance.getPresentation()), (EStructuralFeature)UmaPackage.eINSTANCE.getPracticeDescription_Goals(), (Object)newContent, -1)) && PracticeDescriptionPage.this.isVersionSectionOn()) {
                    PracticeDescriptionPage.this.updateChangeDate();
                }
            }
        });
        this.ctrl_problem.setModalObject((EObject)((PracticeDescription)this.guidance.getPresentation()));
        this.ctrl_problem.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getPracticeDescription_Problem());
        this.ctrl_problem.addModifyListener(contentModifyListener);
        this.ctrl_problem.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                boolean success;
                IMethodRichText control = PracticeDescriptionPage.this.descExpandFlag ? PracticeDescriptionPage.this.ctrl_expanded : PracticeDescriptionPage.this.ctrl_problem;
                String oldContent = ((PracticeDescription)PracticeDescriptionPage.this.guidance.getPresentation()).getProblem();
                if (((MethodElementEditor)PracticeDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent) && (success = editor.getActionManager().doAction(1, (EObject)((PracticeDescription)PracticeDescriptionPage.this.guidance.getPresentation()), (EStructuralFeature)UmaPackage.eINSTANCE.getPracticeDescription_Problem(), (Object)newContent, -1)) && PracticeDescriptionPage.this.isVersionSectionOn()) {
                    PracticeDescriptionPage.this.updateChangeDate();
                }
            }
        });
        this.ctrl_background.setModalObject((EObject)((PracticeDescription)this.guidance.getPresentation()));
        this.ctrl_background.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getPracticeDescription_Background());
        this.ctrl_background.addModifyListener(contentModifyListener);
        this.ctrl_background.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                boolean success;
                IMethodRichText control = PracticeDescriptionPage.this.descExpandFlag ? PracticeDescriptionPage.this.ctrl_expanded : PracticeDescriptionPage.this.ctrl_background;
                String oldContent = ((PracticeDescription)PracticeDescriptionPage.this.guidance.getPresentation()).getBackground();
                if (((MethodElementEditor)PracticeDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent) && (success = editor.getActionManager().doAction(1, (EObject)((PracticeDescription)PracticeDescriptionPage.this.guidance.getPresentation()), (EStructuralFeature)UmaPackage.eINSTANCE.getPracticeDescription_Background(), (Object)newContent, -1)) && PracticeDescriptionPage.this.isVersionSectionOn()) {
                    PracticeDescriptionPage.this.updateChangeDate();
                }
            }
        });
        this.ctrl_levels_adoption.setModalObject((EObject)((PracticeDescription)this.guidance.getPresentation()));
        this.ctrl_levels_adoption.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getPracticeDescription_LevelsOfAdoption());
        this.ctrl_levels_adoption.addModifyListener(contentModifyListener);
        this.ctrl_levels_adoption.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                boolean success;
                String newContent;
                IMethodRichText control = PracticeDescriptionPage.this.descExpandFlag ? PracticeDescriptionPage.this.ctrl_expanded : PracticeDescriptionPage.this.ctrl_levels_adoption;
                String oldContent = ((PracticeDescription)PracticeDescriptionPage.this.guidance.getPresentation()).getLevelsOfAdoption();
                if (((MethodElementEditor)PracticeDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                    return;
                }
                String string = newContent = PracticeDescriptionPage.this.descExpandFlag ? PracticeDescriptionPage.this.ctrl_expanded.getText() : PracticeDescriptionPage.this.ctrl_levels_adoption.getText();
                if (!newContent.equals(oldContent) && (success = editor.getActionManager().doAction(1, (EObject)((PracticeDescription)PracticeDescriptionPage.this.guidance.getPresentation()), (EStructuralFeature)UmaPackage.eINSTANCE.getPracticeDescription_LevelsOfAdoption(), (Object)newContent, -1)) && PracticeDescriptionPage.this.isVersionSectionOn()) {
                    PracticeDescriptionPage.this.updateChangeDate();
                }
            }
        });
    }

    protected void refresh(boolean editable) {
        super.refresh(editable);
        this.ctrl_additional_info.setEditable(editable);
        this.ctrl_application.setEditable(editable);
        this.ctrl_goals.setEditable(editable);
        this.ctrl_levels_adoption.setEditable(editable);
        this.ctrl_background.setEditable(editable);
    }

    protected void loadData() {
        super.loadData();
        if (this.guidance != null) {
            PracticeDescription guidanceDescription = (PracticeDescription)this.guidance.getPresentation();
            this.ctrl_additional_info.setText(guidanceDescription.getAdditionalInfo() == null ? "" : guidanceDescription.getAdditionalInfo());
            this.ctrl_problem.setText(guidanceDescription.getProblem() == null ? "" : guidanceDescription.getProblem());
            this.ctrl_background.setText(guidanceDescription.getBackground() == null ? "" : guidanceDescription.getBackground());
            this.ctrl_application.setText(guidanceDescription.getApplication() == null ? "" : guidanceDescription.getApplication());
            this.ctrl_goals.setText(guidanceDescription.getGoals() == null ? "" : guidanceDescription.getGoals());
            this.ctrl_levels_adoption.setText(guidanceDescription.getLevelsOfAdoption() == null ? "" : guidanceDescription.getLevelsOfAdoption());
        }
        if (this.elementTypeOn && PracticePropUtil.getPracticePropUtil().isUdtType((MethodElement)this.guidance)) {
            try {
                String typeName = (String)PracticePropUtil.getPracticePropUtil().getUtdData(this.guidance).getRteNameMap().get("typeName");
                this.ctrl_type_label.setText(typeName);
            }
            catch (Exception e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
    }

    protected Object getContentElement() {
        return this.guidance;
    }

    private class PracticeRTELabelProvider {
        private String problemLabel;
        private String goalsLabel;
        private String backgroundLabel;
        private String mainDescriptionLabel;
        private String applicationLabel;
        private String levelsOfAdoptionLabel;
        private String additionalInfoLabel;

        public PracticeRTELabelProvider(Practice prac) {
            this.buildLables(prac);
        }

        private void buildLables(Practice prac) {
            try {
                UserDefinedTypeMeta udtMeta = PracticePropUtil.getPracticePropUtil().getUtdData(prac);
                if (udtMeta != null) {
                    Map rteNameMap = udtMeta.getRteNameMap();
                    this.problemLabel = String.valueOf((String)rteNameMap.get("problems")) + ":";
                    this.goalsLabel = String.valueOf((String)rteNameMap.get("goals")) + ":";
                    this.backgroundLabel = String.valueOf((String)rteNameMap.get("background")) + ":";
                    this.mainDescriptionLabel = String.valueOf((String)rteNameMap.get("mainDescription")) + ":";
                    this.applicationLabel = String.valueOf((String)rteNameMap.get("application")) + ":";
                    this.levelsOfAdoptionLabel = String.valueOf((String)rteNameMap.get("levelsOfAdoption")) + ":";
                    this.additionalInfoLabel = String.valueOf((String)rteNameMap.get("additionalInfo")) + ":";
                } else {
                    this.problemLabel = AuthoringUIText.PURPOSE_TEXT;
                    this.goalsLabel = AuthoringUIText.GOALS_TEXT;
                    this.backgroundLabel = AuthoringUIText.BACKGROUND_TEXT;
                    this.mainDescriptionLabel = AuthoringUIText.MAIN_DESCRIPTION_TEXT;
                    this.applicationLabel = AuthoringUIResources.practice_application_text;
                    this.levelsOfAdoptionLabel = AuthoringUIText.LEVEL_OF_ADOPTION_TEXT;
                    this.additionalInfoLabel = AuthoringUIText.ADDITIONAL_INFO_TEXT;
                }
            }
            catch (Exception e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }

        public String getProblemLabel() {
            return this.problemLabel;
        }

        public String getGoalsLabel() {
            return this.goalsLabel;
        }

        public String getBackgroundLabel() {
            return this.backgroundLabel;
        }

        public String getMainDescriptionLabel() {
            return this.mainDescriptionLabel;
        }

        public String getApplicationLabel() {
            return this.applicationLabel;
        }

        public String getLevelsOfAdoptionLabel() {
            return this.levelsOfAdoptionLabel;
        }

        public String getAdditionalInfoLabel() {
            return this.additionalInfoLabel;
        }
    }
}

