/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.filters.AllFilter;
import org.eclipse.epf.authoring.ui.forms.AssociationFormPage;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.ChangeQrCommand;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.MethodElementSetPropertyCommand;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.util.CategorySortHelper;
import org.eclipse.epf.library.edit.util.ContentElementOrderList;
import org.eclipse.epf.library.edit.util.MethodElementPropUtil;
import org.eclipse.epf.library.edit.util.PracticePropUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.util.UserDefinedTypeMeta;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PracticeReferencesPage
extends AssociationFormPage {
    private static final String FORM_PAGE_ID = "practiceReferencesPage";
    private Practice practice;
    private UserDefinedTypeMeta meta;
    private IActionManager actionMgr;
    private ContentElementOrderList contentElementOrderList;
    private ContentElementOrderList activityOrderList;
    private Button manualSortCheckButton;
    private Button typeSortButton;
    private Button assignQualifierButton;
    private Button unassignQualifierButton;

    public PracticeReferencesPage(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIText.REFERENCES_PAGE_TITLE);
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.practice = (Practice)this.contentElement;
        this.meta = PracticePropUtil.getPracticePropUtil().getUdtMeta(this.practice);
        this.actionMgr = ((MethodElementEditor)this.getEditor()).getActionManager();
        this.setIsUpAndDownButtonsRequired1(true);
        this.setUseCategory2(false);
        this.setUseCategory3(false);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.manualSortCheckButton = this.toolkit.createButton(this.category1pane2, AuthoringUIResources.practiceReferencesPage_sortOrderButton_text, 32);
        this.manualSortCheckButton.moveAbove((Control)this.ctrl_up1);
        this.manualSortCheckButton.setLayoutData((Object)new GridData(768));
        boolean isManual = CategorySortHelper.isManualCategorySort((MethodElement)this.contentElement);
        this.manualSortCheckButton.setSelection(isManual);
        this.manualSortCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isManual = PracticeReferencesPage.this.manualSortCheckButton.getSelection();
                String value = "Manual";
                if (!isManual) {
                    value = "MethodType";
                }
                PracticeReferencesPage.this.actionMgr.execute((IResourceAwareCommand)new MethodElementSetPropertyCommand((MethodElement)PracticeReferencesPage.this.practice, "CategoryElementsSortType", value));
                PracticeReferencesPage.this.enableUpDownButtons1();
            }
        });
        this.typeSortButton = this.toolkit.createButton(this.category1pane2, AuthoringUIResources.practiceReferencesPage_sortTypeButton_text, 8);
        this.typeSortButton.setLayoutData((Object)new GridData(768));
        this.typeSortButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(PracticeReferencesPage.this.practice.getContentReferences());
                Comparator comparator = PresentationContext.INSTANCE.getMethodElementTypeComparator();
                Collections.sort(list, comparator);
                PracticeReferencesPage.this.actionMgr.doAction(6, (EObject)PracticeReferencesPage.this.practice, (EStructuralFeature)UmaPackage.eINSTANCE.getPractice_ContentReferences(), (Object)PracticeReferencesPage.this.practice.getContentReferences(), -1);
                PracticeReferencesPage.this.actionMgr.doAction(5, (EObject)PracticeReferencesPage.this.practice, (EStructuralFeature)UmaPackage.eINSTANCE.getPractice_ContentReferences(), list, -1);
                PracticeReferencesPage.this.refreshViewers();
            }
        });
        if (PracticePropUtil.getPracticePropUtil().isUdtType((MethodElement)this.practice)) {
            this.assignQualifierButton = this.toolkit.createButton(this.category1pane2, AuthoringUIResources.practiceReferencesPage_assignQualifierButton_text, 8);
            this.assignQualifierButton.setLayoutData((Object)new GridData(768));
            this.assignQualifierButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ElementListSelectionDialog dialog = new ElementListSelectionDialog(PracticeReferencesPage.this.editor.getSite().getShell(), PracticeReferencesPage.this.getLabelProviderForSelectQualifierDialog());
                    dialog.setElements((Object[])PracticeReferencesPage.this.getInputForSelectQualifierDialog());
                    dialog.setMultipleSelection(true);
                    dialog.setTitle(AuthoringUIResources.practiceReferencesPage_selectQualifierDialog_title);
                    dialog.setMessage(AuthoringUIResources.practiceReferencesPage_selectQualifierDialog_msg);
                    dialog.setImage(null);
                    if (dialog.open() == 1) {
                        return;
                    }
                    Object[] objs = dialog.getResult();
                    ArrayList<String> selectedQualifiers = new ArrayList<String>();
                    Object[] objectArray = objs;
                    int n = objs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (obj instanceof String) {
                            selectedQualifiers.add((String)obj);
                        }
                        ++n2;
                    }
                    PracticeReferencesPage.this.assignQualifier(PracticeReferencesPage.this.getSelectedElement(), selectedQualifiers);
                    PracticeReferencesPage.this.refreshViewers();
                }
            });
            this.unassignQualifierButton = this.toolkit.createButton(this.category1pane2, AuthoringUIResources.practiceReferencesPage_unassignQualifierButton_text, 8);
            this.unassignQualifierButton.setLayoutData((Object)new GridData(768));
            this.unassignQualifierButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PracticeReferencesPage.this.unassignQualifier(PracticeReferencesPage.this.getSelectedElement());
                    PracticeReferencesPage.this.refreshViewers();
                }
            });
        }
    }

    private ILabelProvider getLabelProviderForSelectQualifierDialog() {
        LabelProvider provider = new LabelProvider();
        return provider;
    }

    private String[] getInputForSelectQualifierDialog() {
        return this.getAllQualifiersOfUDT();
    }

    private String[] getAllQualifiersOfUDT() {
        if (this.meta != null) {
            return this.meta.getReferenceQualifierNames();
        }
        return new String[0];
    }

    @Override
    protected void enableUpDownButtons1() {
        super.enableUpDownButtons1();
        if (this.typeSortButton != null) {
            if (this.isShouldEnableAlphaSort()) {
                this.typeSortButton.setEnabled(true);
            } else {
                this.typeSortButton.setEnabled(false);
            }
        }
    }

    protected boolean isShouldEnableAlphaSort() {
        return this.contentElement != null && !TngUtil.isLocked((EObject)this.contentElement) && CategorySortHelper.isManualCategorySort((MethodElement)this.contentElement);
    }

    @Override
    protected void initContentProviderSelected() {
        this.contentProviderSelected = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                if (PracticeReferencesPage.this.contentElementOrderList == null) {
                    PracticeReferencesPage.this.contentElementOrderList = new ContentElementOrderList((VariabilityElement)PracticeReferencesPage.this.contentElement, 1, PracticeReferencesPage.this.getContentElementOrderFeature());
                }
                if (PracticeReferencesPage.this.activityOrderList == null) {
                    PracticeReferencesPage.this.activityOrderList = new ContentElementOrderList((VariabilityElement)PracticeReferencesPage.this.contentElement, 1, PracticeReferencesPage.this.getActivityOrderFeature());
                }
                if (PracticeReferencesPage.this.getProviderExtender().useContentProviderAPIs()) {
                    return PracticeReferencesPage.this.getProviderExtender().getElements(object, 1);
                }
                ArrayList list = new ArrayList();
                list.addAll(PracticeReferencesPage.this.contentElementOrderList);
                list.addAll(PracticeReferencesPage.this.activityOrderList);
                return list.toArray();
            }
        };
        this.viewer_selected.setContentProvider((IContentProvider)this.contentProviderSelected);
    }

    @Override
    protected void addItemsToModel1(ArrayList addItems) {
        boolean ok = DependencyChecker.checkCircularForMovingVariabilityElement((VariabilityElement)this.practice, (Collection)addItems);
        if (!ok) {
            String title = AuthoringUIResources.circular_dependency_error_title;
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, LibraryEditResources.circular_dependency_error_msg);
            return;
        }
        if (!addItems.isEmpty()) {
            for (Object item : addItems) {
                if (item instanceof ContentElement) {
                    this.actionMgr.doAction(3, (EObject)this.practice, (EStructuralFeature)UmaPackage.eINSTANCE.getPractice_ContentReferences(), item, -1);
                    continue;
                }
                if (!(item instanceof Activity)) continue;
                this.actionMgr.doAction(3, (EObject)this.practice, (EStructuralFeature)UmaPackage.eINSTANCE.getPractice_ActivityReferences(), item, -1);
            }
        }
    }

    @Override
    protected void removeItemsFromModel1(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            for (Object item : rmItems) {
                if (item instanceof ContentElement) {
                    this.actionMgr.doAction(4, (EObject)this.practice, (EStructuralFeature)UmaPackage.eINSTANCE.getPractice_ContentReferences(), item, -1);
                    continue;
                }
                if (!(item instanceof Activity)) continue;
                this.actionMgr.doAction(4, (EObject)this.practice, (EStructuralFeature)UmaPackage.eINSTANCE.getPractice_ActivityReferences(), item, -1);
            }
        }
    }

    @Override
    protected EStructuralFeature getOrderFeature() {
        List<ContentElement> ceList = this.getSelectedContentElements();
        List<Activity> aList = this.getSelectedActivities();
        if (ceList.size() > 0 && aList.size() == 0) {
            return this.getContentElementOrderFeature();
        }
        if (aList.size() > 0 && ceList.size() == 0) {
            return this.getActivityOrderFeature();
        }
        return null;
    }

    private EStructuralFeature getContentElementOrderFeature() {
        return UmaPackage.eINSTANCE.getPractice_ContentReferences();
    }

    private EStructuralFeature getActivityOrderFeature() {
        return UmaPackage.eINSTANCE.getPractice_ActivityReferences();
    }

    @Override
    public ContentElementOrderList getContentElementOrderList() {
        List<ContentElement> ceList = this.getSelectedContentElements();
        List<Activity> aList = this.getSelectedActivities();
        if (ceList.size() > 0 && aList.size() == 0) {
            return this.contentElementOrderList;
        }
        if (aList.size() > 0 && ceList.size() == 0) {
            return this.activityOrderList;
        }
        return null;
    }

    private List<ContentElement> getSelectedContentElements() {
        ArrayList<ContentElement> result = new ArrayList<ContentElement>();
        IStructuredSelection selection = (IStructuredSelection)this.viewer_selected.getSelection();
        for (Object o : selection) {
            if (!(o instanceof ContentElement)) continue;
            result.add((ContentElement)o);
        }
        return result;
    }

    private List<Activity> getSelectedActivities() {
        ArrayList<Activity> result = new ArrayList<Activity>();
        IStructuredSelection selection = (IStructuredSelection)this.viewer_selected.getSelection();
        for (Object o : selection) {
            if (!(o instanceof Activity)) continue;
            result.add((Activity)o);
        }
        return result;
    }

    @Override
    protected Object getContentElement() {
        return this.practice;
    }

    @Override
    protected String getTabString() {
        return FilterConstants.ALL_ELEMENTS;
    }

    @Override
    protected IFilter getFilter() {
        this.filter = new AllFilter(){

            protected boolean childAccept(Object obj) {
                if (obj instanceof Milestone) {
                    return false;
                }
                return obj instanceof ContentElement || obj instanceof BreakdownElement || obj instanceof ProcessPackage;
            }
        };
        return this.filter;
    }

    @Override
    protected String getMultipleSelectDescription(int count) {
        return super.getMultipleSelectDescription(count, AuthoringUIResources.practiceReferencesPage_multipleSelectDescription);
    }

    @Override
    protected String getSectionDescription() {
        if (PracticePropUtil.getPracticePropUtil().isUdtType((MethodElement)this.practice)) {
            try {
                String typeName = ((String)PracticePropUtil.getPracticePropUtil().getUtdData(this.practice).getRteNameMap().get("typeName")).toLowerCase();
                return NLS.bind((String)AuthoringUIResources.practiceReferencesPage_sectionDescription_udt, (Object)typeName);
            }
            catch (Exception e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        return AuthoringUIResources.practiceReferencesPage_sectionDescription;
    }

    @Override
    protected String getSectionName() {
        return AuthoringUIResources.practiceReferencesPage_sectionName;
    }

    @Override
    protected String getSelectedLabel() {
        return AuthoringUIResources.practiceReferencesPage_selectedLabel;
    }

    @Override
    protected String getSelectedLabel2() {
        return AuthoringUIResources.practiceReferencesPage_selectedLabel;
    }

    @Override
    protected String getSelectedLabel3() {
        return AuthoringUIResources.practiceReferencesPage_selectedLabel;
    }

    @Override
    protected void enableControls(boolean editable) {
        super.enableControls(editable);
        if (PracticePropUtil.getPracticePropUtil().isUdtType((MethodElement)this.practice)) {
            if (editable && this.getSelectedElement().size() > 0) {
                this.assignQualifierButton.setEnabled(true);
                this.unassignQualifierButton.setEnabled(true);
            } else {
                this.assignQualifierButton.setEnabled(false);
                this.unassignQualifierButton.setEnabled(false);
            }
        }
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.viewer_selected.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (PracticePropUtil.getPracticePropUtil().isUdtType((MethodElement)PracticeReferencesPage.this.practice)) {
                    if (!TngUtil.isLocked((EObject)PracticeReferencesPage.this.contentElement) && PracticeReferencesPage.this.getSelectedElement().size() > 0) {
                        PracticeReferencesPage.this.assignQualifierButton.setEnabled(true);
                        PracticeReferencesPage.this.unassignQualifierButton.setEnabled(true);
                    } else {
                        PracticeReferencesPage.this.assignQualifierButton.setEnabled(false);
                        PracticeReferencesPage.this.unassignQualifierButton.setEnabled(false);
                    }
                }
            }
        });
    }

    private List<MethodElement> getSelectedElement() {
        ArrayList<MethodElement> result = new ArrayList<MethodElement>();
        IStructuredSelection selection = (IStructuredSelection)this.viewer_selected.getSelection();
        List elements = selection.toList();
        for (Object element : elements) {
            if (!(element instanceof MethodElement)) continue;
            result.add((MethodElement)element);
        }
        return result;
    }

    private List<String> getAllQualifierNames(MethodElement element) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.meta == null) {
            return result;
        }
        MethodElementPropUtil util = MethodElementPropUtil.getMethodElementPropUtil();
        for (EReference ref : this.meta.getQualifiedReferences()) {
            String qualifierId = ref.getName();
            List elementList = util.getQReferenceListById((MethodElement)this.practice, qualifierId, false);
            if (!elementList.contains(element)) continue;
            result.add(this.meta.getReferenceQualifierName(qualifierId));
        }
        Collections.sort(result);
        return result;
    }

    private void assignQualifier(List<MethodElement> elements, List<String> qualifiers) {
        for (String qualifier : qualifiers) {
            for (MethodElement element : elements) {
                List<String> allQualifiers = this.getAllQualifierNames(element);
                if (allQualifiers.contains(qualifier)) continue;
                ArrayList<MethodElement> targetList = new ArrayList<MethodElement>();
                targetList.add(element);
                ChangeQrCommand cmd = new ChangeQrCommand((MethodElement)this.practice, targetList, this.meta.getReferenceQualifierId(qualifier), false);
                this.editor.getActionManager().execute((IResourceAwareCommand)cmd);
            }
        }
    }

    private void unassignQualifier(List<MethodElement> elements) {
        for (MethodElement element : elements) {
            List<String> allQualifiers = this.getAllQualifierNames(element);
            if (allQualifiers.size() <= 0) continue;
            ArrayList<MethodElement> targetList = new ArrayList<MethodElement>();
            targetList.add(element);
            for (String qualifier : allQualifiers) {
                ChangeQrCommand cmd = new ChangeQrCommand((MethodElement)this.practice, targetList, this.meta.getReferenceQualifierId(qualifier), true);
                this.editor.getActionManager().execute((IResourceAwareCommand)cmd);
            }
        }
    }

    @Override
    public String getDecorator(Object object) {
        if (PracticePropUtil.getPracticePropUtil().isUdtType((MethodElement)this.practice)) {
            StringBuffer buf = new StringBuffer();
            List<String> allQualifiers = this.getAllQualifierNames((MethodElement)object);
            if (allQualifiers.size() > 0) {
                buf.append("[");
                buf.append(TngUtil.convertListToString(allQualifiers));
                buf.append("]  ");
            }
            return buf.toString();
        }
        return super.getDecorator(object);
    }
}

