/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.filters.CategoryFilter;
import org.eclipse.epf.authoring.ui.filters.CustomCategoryFilter;
import org.eclipse.epf.authoring.ui.forms.AssociationFormPage;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.util.LibraryManager;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductType;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;

public class WorkProductCategoriesPage
extends AssociationFormPage {
    private static final String FORM_PAGE_ID = "workProductCategoriesPage";
    private WorkProduct workProduct;

    public WorkProductCategoriesPage(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIText.CATEGORIES_PAGE_TITLE);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.workProduct = (WorkProduct)this.contentElement;
        this.setUseCategory3(true);
        this.setCategoryIsSingleSelection1(true);
    }

    protected void initContentProviderSelected() {
        this.contentProviderSelected = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return AssociationHelper.getDomains((WorkProduct)((WorkProduct)object)).toArray();
            }
        };
        this.viewer_selected.setContentProvider((IContentProvider)this.contentProviderSelected);
    }

    protected void addItemsToModel1(ArrayList addItems) {
        if (!addItems.isEmpty()) {
            Object domain = addItems.get(0);
            List domains = AssociationHelper.getDomains((WorkProduct)this.workProduct);
            if (domains != null && domains.size() > 0) {
                domains.get(0);
            }
            LibraryManager.getInstance().addToDomain(this.getActionManager(), (Domain)domain, this.workProduct, (List)this.usedCategories);
        }
    }

    protected void removeItemsFromModel1(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            for (Domain domain : rmItems) {
                LibraryManager.getInstance().removeFromDomain(this.getActionManager(), domain, this.workProduct, (List)this.usedCategories);
            }
        }
    }

    protected void initContentProviderSelected2() {
        this.contentProviderSelected2 = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return AssociationHelper.getWorkProductTypes((WorkProduct)((WorkProduct)object)).toArray();
            }
        };
        this.viewer_selected2.setContentProvider((IContentProvider)this.contentProviderSelected2);
    }

    protected void addItemsToModel2(ArrayList addItems) {
        if (!addItems.isEmpty()) {
            for (WorkProductType wpType : addItems) {
                LibraryManager.getInstance().addToWorkProductType(this.getActionManager(), wpType, this.workProduct, (List)this.usedCategories);
            }
        }
    }

    protected void removeItemsFromModel2(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            for (WorkProductType wpType : rmItems) {
                LibraryManager.getInstance().removeFromWorkProductType(this.getActionManager(), wpType, this.workProduct, (List)this.usedCategories);
            }
        }
    }

    protected void initContentProviderSelected3() {
        this.contentProviderSelected3 = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                if (WorkProductCategoriesPage.this.getProviderExtender().useContentProviderAPIs()) {
                    return WorkProductCategoriesPage.this.getProviderExtender().getElements(object, 1);
                }
                return AssociationHelper.getCustomCategories((DescribableElement)((WorkProduct)object)).toArray();
            }
        };
        this.viewer_selected3.setContentProvider((IContentProvider)this.contentProviderSelected3);
    }

    protected void addItemsToModel3(ArrayList addItems) {
        if (!addItems.isEmpty()) {
            for (CustomCategory customCategory : addItems) {
                LibraryManager.getInstance().addToCustomCategory(this.getActionManager(), customCategory, (MethodElement)this.workProduct, (List)this.usedCategories);
            }
        }
    }

    protected void removeItemsFromModel3(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            for (CustomCategory customCategory : rmItems) {
                LibraryManager.getInstance().removeFromCustomCategory(this.getActionManager(), customCategory, (MethodElement)this.workProduct, (List)this.usedCategories);
            }
        }
    }

    protected Object getContentElement() {
        return this.workProduct;
    }

    protected String getTabString() {
        return FilterConstants.DOMAINS;
    }

    protected String getTabString2() {
        return FilterConstants.WORKPRODUCTTYPES;
    }

    protected String getTabString3() {
        return FilterConstants.CUSTOM_CATEGORIES;
    }

    protected IFilter getFilter() {
        this.filter = new CategoryFilter(){

            protected boolean childAccept(Object obj) {
                return obj instanceof Domain;
            }
        };
        return this.filter;
    }

    protected IFilter getFilter2() {
        this.filter2 = new CategoryFilter(){

            protected boolean childAccept(Object obj) {
                return obj instanceof WorkProductType;
            }
        };
        return this.filter2;
    }

    protected IFilter getFilter3() {
        this.filter3 = new CustomCategoryFilter();
        return this.filter3;
    }

    protected String getSectionDescription() {
        return AuthoringUIResources.workProductCategoriesPage_sectionDescription;
    }

    protected String getSectionName() {
        return AuthoringUIResources.workProductCategoriesPage_sectionName;
    }

    protected String getSelectedLabel() {
        return AuthoringUIResources.workProductCategoriesPage_selectedLabel;
    }

    protected String getSelectedLabel2() {
        return AuthoringUIResources.workProductCategoriesPage_selectedLabel2;
    }

    protected String getSelectedLabel3() {
        return AuthoringUIResources.workProductCategoriesPage_selectedLabel3;
    }

    protected String getMultipleSelectDescriptionString() {
        return AuthoringUIResources.workProductCategoriesPage_multipleSelectDescription;
    }

    public OppositeFeature getOppositeFeature(int ix) {
        return ix == 1 ? AssociationHelper.WorkProduct_Domains : super.getOppositeFeature(ix);
    }
}

