/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.dialogs.ManageStateDialog;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.forms.BaseFormPage;
import org.eclipse.epf.authoring.ui.util.UIHelper;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.util.MethodPluginPropUtil;
import org.eclipse.epf.library.edit.util.WorkProductPropUtil;
import org.eclipse.epf.uma.Constraint;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class WorkProductStatesPage
extends BaseFormPage {
    private static final String FORM_PAGE_ID = "workProductStatesPage";
    private WorkProductStatesPage page = this;
    private Shell shell;
    private WorkProduct workProduct;
    private MethodPlugin activePlugin;
    private IActionManager actionMgr;
    private Section statesSection;
    private Composite statesComposite;
    private Table ctrl_wp_states;
    private TableViewer wpStatesViewer;
    private IStructuredContentProvider wpStatesViewerContentProvider;
    private ITableLabelProvider wpStatesViewerLabelProvider;
    private Button ctrl_assign;
    private Button ctrl_unassign;
    private Table ctrl_global_states;
    private TableViewer globalStatesViewer;
    private IStructuredContentProvider globalStatesViewerContentProvider;
    private ITableLabelProvider globalStatesViewerLabelProvider;
    private Button ctrl_manage_state;
    private Text des;

    public WorkProductStatesPage(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIText.WORK_PRODUCT_STATES_PAGE_TITLE);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.shell = site.getShell();
        this.workProduct = (WorkProduct)this.contentElement;
        this.activePlugin = UmaUtil.getMethodPlugin((EObject)this.workProduct);
        this.actionMgr = ((MethodElementEditor)this.getEditor()).getActionManager();
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        UIHelper.setFormText(this.form, (MethodElement)this.contentElement);
        this.statesSection = this.toolkit.createSection(this.form.getBody(), 450);
        this.statesSection.setLayoutData((Object)new TableWrapData(256));
        this.statesSection.setText(AuthoringUIText.STATES_SECTION_NAME);
        this.statesSection.setDescription(AuthoringUIText.STATES_SECTION_DESC);
        this.statesSection.setLayout((Layout)new GridLayout());
        this.statesComposite = this.toolkit.createComposite((Composite)this.statesSection);
        this.statesComposite.setLayoutData((Object)new GridData(1808));
        this.statesComposite.setLayout((Layout)new GridLayout(4, false));
        this.statesSection.setClient((Control)this.statesComposite);
        this.createStatesArea(this.statesComposite);
        this.toolkit.paintBordersFor(this.statesComposite);
        this.addListeners();
        this.loadData();
        this.updateControls();
    }

    protected void createStatesArea(Composite parent) {
        Composite wpStateComposite = this.toolkit.createComposite(parent);
        wpStateComposite.setLayoutData((Object)new GridData(1808));
        wpStateComposite.setLayout((Layout)new GridLayout());
        this.toolkit.createLabel(wpStateComposite, AuthoringUIText.STATES_WP_STATE_TEXT);
        this.ctrl_wp_states = this.toolkit.createTable(wpStateComposite, 2);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 300;
        gridData.heightHint = 150;
        this.ctrl_wp_states.setLayoutData((Object)gridData);
        Composite btnComposite1 = this.toolkit.createComposite(parent);
        btnComposite1.setLayoutData((Object)new GridData(1808));
        btnComposite1.setLayout((Layout)new GridLayout());
        this.toolkit.createLabel(btnComposite1, null);
        this.toolkit.createLabel(btnComposite1, null);
        this.toolkit.createLabel(btnComposite1, null);
        this.toolkit.createLabel(btnComposite1, null);
        this.ctrl_assign = this.toolkit.createButton(btnComposite1, AuthoringUIText.STATES_ASSIGN_TEXT, 0);
        GridData gridData2 = new GridData(768);
        this.ctrl_assign.setLayoutData((Object)gridData2);
        this.ctrl_unassign = this.toolkit.createButton(btnComposite1, AuthoringUIText.STATES_UNASSIGN_TEXT, 0);
        gridData2 = new GridData(768);
        this.ctrl_unassign.setLayoutData((Object)gridData2);
        Composite globalStateComposite = this.toolkit.createComposite(parent);
        globalStateComposite.setLayoutData((Object)new GridData(1808));
        globalStateComposite.setLayout((Layout)new GridLayout());
        this.toolkit.createLabel(globalStateComposite, AuthoringUIText.STATES_GLOBAL_STATE_TEXT);
        this.ctrl_global_states = this.toolkit.createTable(globalStateComposite, 2);
        GridData gridData3 = new GridData(1808);
        gridData3.widthHint = 300;
        gridData3.heightHint = 150;
        this.ctrl_global_states.setLayoutData((Object)gridData3);
        Composite btnComposite2 = this.toolkit.createComposite(parent);
        btnComposite2.setLayoutData((Object)new GridData(1808));
        btnComposite2.setLayout((Layout)new GridLayout());
        this.toolkit.createLabel(btnComposite2, null);
        this.ctrl_manage_state = this.toolkit.createButton(btnComposite2, AuthoringUIText.STATES_MANAGE_TEXT, 0);
        GridData gridData4 = new GridData(768);
        this.ctrl_manage_state.setLayoutData((Object)gridData4);
        this.toolkit.createLabel(btnComposite2, null);
        Label comment = this.toolkit.createLabel(btnComposite2, AuthoringUIText.STATES_GLOBAL_NOTES_TEXT, 64);
        GridData gridData5 = new GridData();
        gridData5.widthHint = 120;
        comment.setLayoutData((Object)gridData5);
        Label desLabel = this.toolkit.createLabel(parent, AuthoringUIText.STATES_DES_TEXT);
        GridData gridData6 = new GridData();
        gridData6.horizontalSpan = 4;
        desLabel.setLayoutData((Object)gridData6);
        this.des = this.toolkit.createText(parent, "", 2626);
        gridData6 = new GridData(1808);
        gridData6.heightHint = 100;
        gridData6.horizontalSpan = 3;
        this.des.setLayoutData((Object)gridData6);
        this.des.setEditable(false);
        this.initProviders();
        this.wpStatesViewer = new TableViewer(this.ctrl_wp_states);
        this.wpStatesViewer.setContentProvider((IContentProvider)this.wpStatesViewerContentProvider);
        this.wpStatesViewer.setLabelProvider((IBaseLabelProvider)this.wpStatesViewerLabelProvider);
        this.wpStatesViewer.setComparator((ViewerComparator)new StateViewerComparator());
        this.globalStatesViewer = new TableViewer(this.ctrl_global_states);
        this.globalStatesViewer.setContentProvider((IContentProvider)this.globalStatesViewerContentProvider);
        this.globalStatesViewer.setLabelProvider((IBaseLabelProvider)this.globalStatesViewerLabelProvider);
        this.globalStatesViewer.setComparator((ViewerComparator)new StateViewerComparator());
        this.toolkit.paintBordersFor(wpStateComposite);
        this.toolkit.paintBordersFor(btnComposite1);
        this.toolkit.paintBordersFor(globalStateComposite);
        this.toolkit.paintBordersFor(btnComposite2);
    }

    private void initProviders() {
        this.wpStatesViewerContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                if (object instanceof WorkProduct) {
                    WorkProduct wp = (WorkProduct)object;
                    Set states = WorkProductPropUtil.getWorkProductPropUtil((IActionManager)WorkProductStatesPage.this.actionMgr).getAllStates(wp);
                    return states.toArray();
                }
                return new Object[0];
            }
        };
        this.wpStatesViewerLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof Constraint) {
                    return ((Constraint)element).getBody();
                }
                return null;
            }
        };
        this.globalStatesViewerContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                if (object instanceof WorkProduct) {
                    List globalStates = MethodPluginPropUtil.getMethodPluginPropUtil((IActionManager)WorkProductStatesPage.this.actionMgr).getWorkProductStatesInLibrary(WorkProductStatesPage.this.activePlugin);
                    return globalStates.toArray();
                }
                return new Object[0];
            }
        };
        this.globalStatesViewerLabelProvider = new GlobalStatesLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
    }

    private void addListeners() {
        this.wpStatesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WorkProductStatesPage.this.updateControls();
                WorkProductStatesPage.this.updateDescription(WorkProductStatesPage.this.wpStatesViewer);
            }
        });
        this.ctrl_assign.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkProductStatesPage.this.assignState();
                WorkProductStatesPage.this.updateControls();
            }
        });
        this.ctrl_unassign.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkProductStatesPage.this.unassignState();
                WorkProductStatesPage.this.updateControls();
            }
        });
        this.globalStatesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WorkProductStatesPage.this.updateControls();
                WorkProductStatesPage.this.updateDescription(WorkProductStatesPage.this.globalStatesViewer);
            }
        });
        this.ctrl_manage_state.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageStateDialog dialog = new ManageStateDialog(WorkProductStatesPage.this.shell, WorkProductStatesPage.this.activePlugin, WorkProductStatesPage.this.actionMgr, WorkProductStatesPage.this.page);
                dialog.open();
            }
        });
    }

    private void assignState() {
        IStructuredSelection selection = (IStructuredSelection)this.globalStatesViewer.getSelection();
        for (Object obj : selection.toList()) {
            if (!(obj instanceof Constraint)) continue;
            WorkProductPropUtil.getWorkProductPropUtil((IActionManager)this.actionMgr).addWorkProductState(this.workProduct, (Constraint)obj);
        }
    }

    private void unassignState() {
        IStructuredSelection selection = (IStructuredSelection)this.wpStatesViewer.getSelection();
        for (Object obj : selection.toList()) {
            if (!(obj instanceof Constraint)) continue;
            WorkProductPropUtil.getWorkProductPropUtil((IActionManager)this.actionMgr).removeWorkProductState(this.workProduct, ((Constraint)obj).getBody());
        }
    }

    private void loadData() {
        this.wpStatesViewer.setInput((Object)this.workProduct);
        this.globalStatesViewer.setInput((Object)this.workProduct);
    }

    public void updateControls() {
        IStructuredSelection globalSelection = (IStructuredSelection)this.globalStatesViewer.getSelection();
        if (globalSelection.size() > 0) {
            this.ctrl_assign.setEnabled(true);
        } else {
            this.ctrl_assign.setEnabled(false);
        }
        IStructuredSelection wpSelection = (IStructuredSelection)this.wpStatesViewer.getSelection();
        if (wpSelection.size() > 0) {
            this.ctrl_unassign.setEnabled(true);
        } else {
            this.ctrl_unassign.setEnabled(false);
        }
        this.wpStatesViewer.refresh();
        this.globalStatesViewer.refresh();
    }

    private void updateDescription(TableViewer viewer) {
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        if (selection.size() > 0) {
            Constraint state = (Constraint)selection.getFirstElement();
            this.des.setText(state.getBriefDescription());
        }
    }

    private boolean isLocalState(Constraint state) {
        List allLocalStates = MethodPluginPropUtil.getMethodPluginPropUtil((IActionManager)this.actionMgr).getWorkProductStatesInPlugin(this.activePlugin);
        return allLocalStates.contains(state);
    }

    private class GlobalStatesLabelProvider
    extends AdapterFactoryLabelProvider
    implements ITableFontProvider {
        private FontRegistry registry;
        private Font systemFont;

        public GlobalStatesLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
            this.registry = new FontRegistry();
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Constraint) {
                return ((Constraint)element).getBody();
            }
            return null;
        }

        public Font getFont(Object element, int columnIndex) {
            if (this.systemFont == null) {
                this.systemFont = Display.getCurrent().getSystemFont();
            }
            if (element instanceof Constraint && WorkProductStatesPage.this.isLocalState((Constraint)element)) {
                return this.registry.getBold(this.systemFont.getFontData()[0].getName());
            }
            return this.systemFont;
        }
    }

    public class StateViewerComparator
    extends ViewerComparator {
        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof Constraint && e2 instanceof Constraint) {
                String name1 = ((Constraint)e1).getBody();
                String name2 = ((Constraint)e2).getBody();
                return this.getComparator().compare(name1, name2);
            }
            return 0;
        }
    }
}

