/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.preferences.AuthoringUIPreferences;
import org.eclipse.epf.authoring.ui.util.AuthoringAccessibleListener;
import org.eclipse.epf.common.ui.util.CommonPreferences;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.preferences.LibraryPreferences;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.ui.preferences.BasePreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthoringPreferencePage
extends BasePreferencePage
implements ModifyListener {
    private static int MIN_PREFERENCE_HISTORY_SIZE;
    private static int MAX_PREFERENCE_HISTORY_SIZE;
    private Composite composite;
    private Text defaultLibraryPathText;
    private Button browseButton;
    private Button discardUnresolvedReferencesCheckbox;
    private Button useNewExtendsSemanticsCheckbox;
    private Button enableLibraryValidationCheckbox;
    private Text preferenceHistorySizeText;
    private Button enableUIFieldsCheckbox;
    private Button enableAutoNameGenCheckbox;
    private Button skipAllCheckbox;
    private Button skipSelectedChebox;
    private TableViewer selectedHexByteViewer;
    private Map<String, String> selectedHexByteStrMap;
    private Button addOneButton;
    private Button addButton;
    private Button removeButton;
    private Text addOneButtonText;
    private static Set<String> skipableSet;

    static {
        String[] hexStrs;
        MIN_PREFERENCE_HISTORY_SIZE = 5;
        MAX_PREFERENCE_HISTORY_SIZE = 20;
        skipableSet = new HashSet<String>();
        String[] stringArray = hexStrs = new String[]{AuthoringUIResources.hex_24, AuthoringUIResources.hex_26, AuthoringUIResources.hex_2B, AuthoringUIResources.hex_2C, AuthoringUIResources.hex_2F, AuthoringUIResources.hex_3A, AuthoringUIResources.hex_3B, AuthoringUIResources.hex_3D, AuthoringUIResources.hex_3F, AuthoringUIResources.hex_40, AuthoringUIResources.hex_20, AuthoringUIResources.hex_22, AuthoringUIResources.hex_3C, AuthoringUIResources.hex_3E, AuthoringUIResources.hex_23, AuthoringUIResources.hex_25, AuthoringUIResources.hex_7B, AuthoringUIResources.hex_7D, AuthoringUIResources.hex_7C, AuthoringUIResources.hex_5C, AuthoringUIResources.hex_5E, AuthoringUIResources.hex_7E, AuthoringUIResources.hex_5B, AuthoringUIResources.hex_5D, AuthoringUIResources.hex_60};
        int n = hexStrs.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            skipableSet.add("%" + s);
            ++n2;
        }
    }

    protected Control createContents(Composite parent) {
        this.composite = AuthoringPreferencePage.createGridLayoutComposite((Composite)parent, (int)1);
        Group libraryGroup = AuthoringPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)AuthoringUIResources.methodLibraryGroup_text, (int)3);
        AuthoringPreferencePage.createLabel((Composite)libraryGroup, (String)AuthoringUIResources.defaultPathLabel_text);
        this.defaultLibraryPathText = AuthoringPreferencePage.createEditableText((Composite)libraryGroup);
        this.browseButton = AuthoringPreferencePage.createButton((Composite)libraryGroup, (String)AuthoringUIText.BROWSE_BUTTON_TEXT);
        this.discardUnresolvedReferencesCheckbox = AuthoringPreferencePage.createCheckbox((Composite)libraryGroup, (String)AuthoringUIResources.discardunresolvedref, (int)3);
        Group modelingGroup = AuthoringPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)AuthoringUIResources.modelingGroup_text, (int)1);
        this.useNewExtendsSemanticsCheckbox = AuthoringPreferencePage.createCheckbox((Composite)modelingGroup, (String)AuthoringUIResources.extend_semantics_button_text);
        Group userInterfaceGroup = AuthoringPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)AuthoringUIResources.userInterfaceGroup_text, (int)2);
        AuthoringPreferencePage.createLabel((Composite)userInterfaceGroup, (String)AuthoringUIResources.default_list_length_label);
        this.preferenceHistorySizeText = AuthoringPreferencePage.createEditableText((Composite)userInterfaceGroup, (String)"", (int)25);
        Group debugGroup = AuthoringPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)AuthoringUIResources.debugGroup_text, (int)2);
        this.enableLibraryValidationCheckbox = AuthoringPreferencePage.createCheckbox((Composite)debugGroup, (String)AuthoringUIResources.enableLibraryValidationCheckbox_text);
        Group editorGroup = AuthoringPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)AuthoringUIResources.editorGroup_text, (int)1);
        this.enableUIFieldsCheckbox = AuthoringPreferencePage.createCheckbox((Composite)editorGroup, (String)AuthoringUIResources.enableUIFieldsCheckbox_text);
        this.enableAutoNameGenCheckbox = AuthoringPreferencePage.createCheckbox((Composite)editorGroup, (String)AuthoringUIResources.enableAutoNameGenCheckbox_text);
        Group rteGroup = AuthoringPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)AuthoringUIResources.rteGroup_text, (int)3);
        this.skipAllCheckbox = AuthoringPreferencePage.createCheckbox((Composite)rteGroup, (String)AuthoringUIResources.skipAllCheckbox_text, (int)3);
        this.skipSelectedChebox = AuthoringPreferencePage.createCheckbox((Composite)rteGroup, (String)AuthoringUIResources.skipSelectedChebox_text, (int)3);
        this.selectedHexByteViewer = new TableViewer((Composite)rteGroup);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 100;
        this.selectedHexByteViewer.getTable().setLayoutData((Object)gridData);
        this.selectedHexByteViewer.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Map) {
                    ArrayList list = new ArrayList(((Map)inputElement).values());
                    Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
                    return list.toArray();
                }
                return super.getElements(inputElement);
            }
        });
        this.createAddRemoveButtons((Composite)rteGroup);
        this.initControls();
        this.addListeners();
        this.selectedHexByteViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.selectedHexByteViewer.setInput(this.getSelectedHexByteStrMap());
        return this.composite;
    }

    protected void initControls() {
        this.defaultLibraryPathText.setText(LibraryUIPreferences.getDefaultLibraryPath());
        this.discardUnresolvedReferencesCheckbox.setSelection(LibraryPreferences.getDiscardUnresolvedReferences());
        this.useNewExtendsSemanticsCheckbox.setSelection(LibraryPreferences.getUseNewExtendsSemantics());
        this.preferenceHistorySizeText.setText("" + CommonPreferences.getPreferenceHistorySize());
        this.enableLibraryValidationCheckbox.setSelection(AuthoringUIPreferences.getEnableLibraryValidation());
        this.enableUIFieldsCheckbox.setSelection(AuthoringUIPreferences.getEnableUIFields());
        this.enableAutoNameGenCheckbox.setSelection(AuthoringUIPreferences.getEnableAutoNameGen());
        for (Map.Entry<String, String> entry : AuthoringUIPreferences.getRteUrlDecodingHexMap().entrySet()) {
            this.getSelectedHexByteStrMap().put(entry.getKey(), entry.getValue());
        }
        int ix = AuthoringUIPreferences.getRteUrlDecodingOption();
        this.skipAllCheckbox.setSelection(ix == 1);
        this.skipSelectedChebox.setSelection(ix == 2);
    }

    protected void addListeners() {
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthoringPreferencePage.this.openDirectoryDialog();
            }
        });
        this.preferenceHistorySizeText.addModifyListener((ModifyListener)this);
        this.enableUIFieldsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = Display.getCurrent().getActiveShell();
                if (AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(shell.getText(), AuthoringUIResources.enableUIFieldsChange_message)) {
                    EditorChooser.getInstance().closeAllMethodEditorsWithSaving();
                } else {
                    AuthoringPreferencePage.this.enableUIFieldsCheckbox.setSelection(!AuthoringPreferencePage.this.enableUIFieldsCheckbox.getSelection());
                }
            }
        });
        this.skipAllCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AuthoringPreferencePage.this.skipAllCheckbox.getSelection()) {
                    AuthoringPreferencePage.this.skipSelectedChebox.setSelection(false);
                }
            }
        });
        this.skipSelectedChebox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AuthoringPreferencePage.this.skipSelectedChebox.getSelection()) {
                    AuthoringPreferencePage.this.skipAllCheckbox.setSelection(false);
                }
            }
        });
    }

    public void modifyText(ModifyEvent e) {
        this.setErrorMessage(null);
        this.setValid(true);
        int value = 0;
        if (e.widget == this.preferenceHistorySizeText && ((value = this.getPreferenceHistorySize()) < MIN_PREFERENCE_HISTORY_SIZE || value > MAX_PREFERENCE_HISTORY_SIZE)) {
            this.setErrorMessage(AuthoringUIResources.bind((String)AuthoringUIResources.invalidPreferenceHistorySizeError_msg, (Object[])new Object[]{new Integer(MIN_PREFERENCE_HISTORY_SIZE), new Integer(MAX_PREFERENCE_HISTORY_SIZE)}));
            this.setValid(false);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        String defaultLibraryPath = LibraryUIPreferences.getInitialDefaultLibraryPath();
        LibraryUIPreferences.setDefaultLibraryPath((String)defaultLibraryPath);
        this.defaultLibraryPathText.setText(defaultLibraryPath);
        boolean discardUnresolvedReferences = LibraryPreferences.getDefaultDiscardUnresolvedReferences();
        LibraryPreferences.setDiscardUnresolvedReferences((boolean)discardUnresolvedReferences);
        this.discardUnresolvedReferencesCheckbox.setSelection(discardUnresolvedReferences);
        boolean useNewExtendsSemantics = LibraryPreferences.getDefaultUseNewExtendsSemantics();
        LibraryPreferences.setUseNewExtendsSemantics((boolean)useNewExtendsSemantics);
        this.useNewExtendsSemanticsCheckbox.setSelection(useNewExtendsSemantics);
        int preferenceHistorySize = CommonPreferences.getDefaultPreferenceHistorySize();
        CommonPreferences.setPreferenceHistorySize((int)preferenceHistorySize);
        this.preferenceHistorySizeText.setText("" + preferenceHistorySize);
        boolean enableLibraryValidation = AuthoringUIPreferences.getDefaultEnableLibraryValidation();
        AuthoringUIPreferences.setEnableLibraryValidation(enableLibraryValidation);
        this.enableLibraryValidationCheckbox.setSelection(enableLibraryValidation);
        boolean enableUIFields = AuthoringUIPreferences.getDefaultEnableUIFields();
        AuthoringUIPreferences.setEnableUIFields(enableUIFields);
        this.enableUIFieldsCheckbox.setSelection(enableUIFields);
        boolean enableAutoNameGen = AuthoringUIPreferences.getDefaultEnableAutoNameGen();
        AuthoringUIPreferences.setEnableAutoNameGen(enableAutoNameGen);
        this.enableAutoNameGenCheckbox.setSelection(enableAutoNameGen);
    }

    public boolean performOk() {
        LibraryUIPreferences.setDefaultLibraryPath((String)this.getDefaultLibraryPath());
        LibraryPreferences.setDiscardUnresolvedReferences((boolean)this.getDiscardUnresolvedReferences());
        LibraryPreferences.setUseNewExtendsSemantics((boolean)this.getUseNewExtendsSemantics());
        CommonPreferences.setPreferenceHistorySize((int)this.getPreferenceHistorySize());
        AuthoringUIPreferences.setEnableLibraryValidation(this.getEnableLibraryValidation());
        AuthoringUIPreferences.setEnableUIFields(this.getEnableUIFields());
        AuthoringUIPreferences.setEnableAutoNameGen(this.getEnableAutoNameGen());
        LibraryUIPlugin.getDefault().updateLayoutSettings();
        int ix = 0;
        if (this.skipAllCheckbox.getSelection()) {
            ix = 1;
        } else if (this.skipSelectedChebox.getSelection()) {
            ix = 2;
        }
        AuthoringUIPreferences.setgetRteUrlDecodingOption(ix);
        String toSaveStr = "";
        for (String str : this.getSelectedHexByteStrMap().values()) {
            if (toSaveStr.length() > 0) {
                toSaveStr = String.valueOf(toSaveStr) + "\n";
            }
            toSaveStr = String.valueOf(toSaveStr) + str;
        }
        AuthoringUIPreferences.setRteUrlDecodingHexNumbers(toSaveStr);
        return true;
    }

    protected String getDefaultLibraryPath() {
        return this.defaultLibraryPathText.getText().trim();
    }

    protected boolean getDiscardUnresolvedReferences() {
        return this.discardUnresolvedReferencesCheckbox.getSelection();
    }

    protected boolean getUseNewExtendsSemantics() {
        return this.useNewExtendsSemanticsCheckbox.getSelection();
    }

    protected int getPreferenceHistorySize() {
        return StrUtil.getIntValue((String)this.preferenceHistorySizeText.getText().trim(), (int)0);
    }

    protected boolean getEnableLibraryValidation() {
        return this.enableLibraryValidationCheckbox.getSelection();
    }

    protected boolean getEnableUIFields() {
        return this.enableUIFieldsCheckbox.getSelection();
    }

    protected boolean getEnableAutoNameGen() {
        return this.enableAutoNameGenCheckbox.getSelection();
    }

    private void openDirectoryDialog() {
        try {
            DirectoryDialog dd = new DirectoryDialog(this.composite.getShell(), 0);
            String path = dd.open();
            if (path != null) {
                this.defaultLibraryPathText.setText(path);
            }
        }
        catch (Exception e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    protected void createAddRemoveButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(4, -1, true, false);
        buttonComposite.setLayoutData((Object)data);
        Group addOneButtonGroup = AuthoringPreferencePage.createGridLayoutGroup((Composite)buttonComposite, (String)AuthoringUIResources.rteAddOneButtonGroup_title, (int)2);
        this.addOneButton = new Button((Composite)addOneButtonGroup, 8);
        data = new GridData(4, -1, false, false);
        this.addOneButton.setLayoutData((Object)data);
        this.addOneButton.setText(AuthoringUIResources.rteAddOneButton_text);
        this.addOneButton.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIResources.rteAddOneButton_text));
        this.addOneButton.addSelectionListener(this.newAddOneButtonListener());
        this.addOneButton.setEnabled(false);
        this.addOneButtonText = AuthoringPreferencePage.createEditableText((Composite)addOneButtonGroup, (String)"", (int)30);
        this.addOneButtonText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AuthoringPreferencePage.this.addOneButton.setEnabled(true);
                String text = AuthoringPreferencePage.this.addOneButtonText.getText();
                if (StrUtil.getHexStr((String)text) == null) {
                    AuthoringPreferencePage.this.addOneButton.setEnabled(false);
                    return;
                }
            }
        });
        this.addButton = new Button(buttonComposite, 8);
        data = new GridData(-1, -1, false, false);
        this.addButton.setLayoutData((Object)data);
        this.addButton.setText(AuthoringUIResources.rteAddButton_text);
        this.addButton.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIText.ADD_BUTTON_TEXT));
        this.addButton.addSelectionListener(this.newAddButtonListener());
        this.removeButton = new Button(buttonComposite, 8);
        data = new GridData(-1, -1, false, false);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.setText(AuthoringUIText.REMOVE_BUTTON_TEXT);
        this.removeButton.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIText.REMOVE_BUTTON_TEXT));
        this.removeButton.addSelectionListener(this.newRemoveButtonListener());
    }

    private SelectionListener newAddOneButtonListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String text = AuthoringPreferencePage.this.addOneButtonText.getText();
                String key = StrUtil.getHexStr((String)text);
                if (key == null) {
                    return;
                }
                AuthoringPreferencePage.this.getSelectedHexByteStrMap().put(key, text);
                AuthoringPreferencePage.this.selectedHexByteViewer.refresh();
                AuthoringPreferencePage.this.addOneButtonText.setText("");
            }
        };
    }

    private SelectionListener newAddButtonListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(MsgBox.getDefaultShell(), (ILabelProvider)new LabelProvider());
                ArrayList<String> selectableList = new ArrayList<String>();
                for (String str : skipableSet) {
                    String key = StrUtil.getHexStr((String)str);
                    if (AuthoringPreferencePage.this.getSelectedHexByteStrMap().containsKey(key)) continue;
                    selectableList.add(str);
                }
                Collections.sort(selectableList);
                dialog.setElements(selectableList.toArray());
                dialog.setMultipleSelection(true);
                dialog.setMessage(AuthoringUIResources.rteGroupAddDialog_msg);
                dialog.setTitle(AuthoringUIResources.rteGroupAddDialog_title);
                if (dialog.open() == 1) {
                    return;
                }
                Object[] objs = dialog.getResult();
                if (objs == null || objs.length == 0) {
                    return;
                }
                Object[] objectArray = objs;
                int n = objs.length;
                int n2 = 0;
                while (n2 < n) {
                    String value;
                    String key;
                    Object obj = objectArray[n2];
                    if (obj instanceof String && (key = StrUtil.getHexStr((String)(value = (String)obj))) != null) {
                        AuthoringPreferencePage.this.getSelectedHexByteStrMap().put(key, value);
                    }
                    ++n2;
                }
                AuthoringPreferencePage.this.selectedHexByteViewer.refresh();
            }
        };
    }

    private SelectionListener newRemoveButtonListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ISelection s = AuthoringPreferencePage.this.selectedHexByteViewer.getSelection();
                if (s instanceof IStructuredSelection) {
                    for (Object obj : (IStructuredSelection)s) {
                        String key;
                        if (!(obj instanceof String) || (key = StrUtil.getHexStr((String)((String)obj))) == null) continue;
                        AuthoringPreferencePage.this.getSelectedHexByteStrMap().remove(key);
                    }
                }
                AuthoringPreferencePage.this.selectedHexByteViewer.refresh();
            }
        };
    }

    private Map<String, String> getSelectedHexByteStrMap() {
        if (this.selectedHexByteStrMap == null) {
            this.selectedHexByteStrMap = new HashMap<String, String>();
        }
        return this.selectedHexByteStrMap;
    }
}

