/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.preferences;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthoringUIPreferences {
    public static final String ENABLE_LIBRARY_VALIDATION = "enabledLibraryValidation";
    public static final String ENABLE_UI_FIELDS = "enableUIFields";
    public static final String ENABLE_AUTO_NAME_GEN = "autoNameGen";
    public static final String RTE_URL_DECODING_OPTION = "rteUrlDecodingOption";
    public static final String RTE_URL_DECODING_HEX_NUMBERS = "rteUrlDecodingHexNumbers";
    public static final String ADD_TASKS_PER_ROW = "ACTIVITY_DETAIL_DIAGRAM_TASKS_PER_ROW";
    private static final int DEFAULT_ADD_TASKS_PER_ROW = 10;
    private static final boolean DEFAULT_ENABLE_LIBRARY_VALIDATION = false;
    private static final boolean DEFAULT_ENABLE_UI_FIELDS = false;
    private static final boolean DEFAULT_ENABLE_AUTO_NAME_GEN = true;
    private static final int DEFAULT_RTE_URL_DECODING_OPTION = 2;
    private static final String DEFAULT_RTE_URL_DECODING_HEX_NUMBERS = "%" + AuthoringUIResources.hex_20;
    private static IPreferenceStore prefStore = AuthoringUIPlugin.getDefault().getPreferenceStore();
    private static boolean toClearStrUtilOptionsCache = false;

    static {
        prefStore.setDefault(ENABLE_LIBRARY_VALIDATION, false);
        prefStore.setDefault(ENABLE_UI_FIELDS, false);
        prefStore.setDefault(ENABLE_AUTO_NAME_GEN, true);
        prefStore.setDefault(ADD_TASKS_PER_ROW, 10);
        prefStore.setDefault(RTE_URL_DECODING_OPTION, 2);
        prefStore.setDefault(RTE_URL_DECODING_HEX_NUMBERS, DEFAULT_RTE_URL_DECODING_HEX_NUMBERS);
        StrUtil.StrUtilOptions strUtilOptions = new StrUtil.StrUtilOptions(){
            private Map<String, String> cachedMap;

            public int getRteUrlDecodingOption() {
                return AuthoringUIPreferences.getRteUrlDecodingOption();
            }

            public Map<String, String> getRteUrlDecodingHexMap() {
                if (this.cachedMap == null || toClearStrUtilOptionsCache) {
                    toClearStrUtilOptionsCache = false;
                    this.cachedMap = AuthoringUIPreferences.getRteUrlDecodingHexMap();
                }
                return this.cachedMap;
            }
        };
        StrUtil.setOptions((StrUtil.StrUtilOptions)strUtilOptions);
    }

    public static boolean getDefaultEnableLibraryValidation() {
        return false;
    }

    public static boolean getEnableLibraryValidation() {
        return prefStore.getBoolean(ENABLE_LIBRARY_VALIDATION);
    }

    public static void setEnableLibraryValidation(boolean value) {
        prefStore.setValue(ENABLE_LIBRARY_VALIDATION, value);
    }

    public static boolean getDefaultEnableUIFields() {
        return false;
    }

    public static boolean getEnableUIFields() {
        return prefStore.getBoolean(ENABLE_UI_FIELDS);
    }

    public static void setEnableUIFields(boolean value) {
        prefStore.setValue(ENABLE_UI_FIELDS, value);
    }

    public static boolean getDefaultEnableAutoNameGen() {
        return true;
    }

    public static boolean getEnableAutoNameGen() {
        return prefStore.getBoolean(ENABLE_AUTO_NAME_GEN);
    }

    public static void setEnableAutoNameGen(boolean value) {
        prefStore.setValue(ENABLE_AUTO_NAME_GEN, value);
    }

    public static int getDefaultRteUrlDecodingOption() {
        return 2;
    }

    public static int getRteUrlDecodingOption() {
        return prefStore.getInt(RTE_URL_DECODING_OPTION);
    }

    public static void setgetRteUrlDecodingOption(int value) {
        prefStore.setValue(RTE_URL_DECODING_OPTION, value);
    }

    public static String getDefaultRteUrlDecodingHexNumbers() {
        return DEFAULT_RTE_URL_DECODING_HEX_NUMBERS;
    }

    public static String getRteUrlDecodingHexNumbers() {
        return prefStore.getString(RTE_URL_DECODING_HEX_NUMBERS);
    }

    public static void setRteUrlDecodingHexNumbers(String value) {
        toClearStrUtilOptionsCache = true;
        prefStore.setValue(RTE_URL_DECODING_HEX_NUMBERS, value);
    }

    public static Map<String, String> getRteUrlDecodingHexMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        String str = AuthoringUIPreferences.getRteUrlDecodingHexNumbers();
        List strValues = TngUtil.convertStringsToList((String)str, (String)"\n");
        for (String strValue : strValues) {
            String key = StrUtil.getHexStr((String)strValue);
            if (key == null) continue;
            map.put(key, strValue);
        }
        return map;
    }

    public static int getADD_TasksPerRow() {
        int value = prefStore.getInt(ADD_TASKS_PER_ROW);
        return value > 0 ? value : 10;
    }

    public static void setADDTasksPerRow(int value) {
        prefStore.setValue(ADD_TASKS_PER_ROW, value);
    }

    public static int getDefaultADDTasksPerRow() {
        return 10;
    }
}

