/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.preferences;

import java.io.File;
import org.eclipse.epf.common.preferences.IPreferenceStoreWrapper;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;

public class LibraryLocationData {
    private String parentFolder;
    private String libName;
    private String libBriefDescription;
    private boolean isSingleLibFile;
    private boolean defLibDirChecked;
    protected static final String libraryFile = "library.xmi";
    private boolean isOkPressed;

    public boolean isOkPressed() {
        return this.isOkPressed;
    }

    public void setOkPressed(boolean isOkPressed) {
        this.isOkPressed = isOkPressed;
    }

    public boolean isSingleLibFile() {
        return this.isSingleLibFile;
    }

    public void setSingleLibFile(boolean isSingleLibFile) {
        this.isSingleLibFile = isSingleLibFile;
    }

    public String getLibName() {
        return this.libName;
    }

    public String getLibraryFile() {
        return String.valueOf(this.getParentFolder()) + File.separator + libraryFile;
    }

    public void setLibName(String libName) {
        this.libName = libName;
    }

    public String getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(String parentFolder) {
        this.parentFolder = parentFolder;
    }

    public String getLibBriefDescription() {
        return this.libBriefDescription;
    }

    public void setLibBriefDescription(String libBriefDescription) {
        this.libBriefDescription = libBriefDescription;
    }

    public boolean isDefLibDirChecked() {
        return this.defLibDirChecked;
    }

    public void setDefLibDirChecked(boolean defLibDirChecked) {
        this.defLibDirChecked = defLibDirChecked;
    }

    public void loadFromPreferenceStore() {
        IPreferenceStoreWrapper store = LibraryPlugin.getDefault().getPreferenceStore();
        String lastDir = store.getString("org.eclipse.epf.library.pref.last_library__parent_directory");
        this.setParentFolder(lastDir);
        boolean lastChecked = store.getBoolean("org.eclipse.epf.library.pref.last_default_directory_checked");
        if (lastDir == null || lastDir.trim().length() == 0) {
            this.setDefLibDirChecked(true);
        } else {
            this.setDefLibDirChecked(lastChecked);
        }
    }

    public void saveToPreferenceStore() {
        IPreferenceStoreWrapper store = LibraryPlugin.getDefault().getPreferenceStore();
        File file = new File(this.getParentFolder());
        LibraryUIPreferences.setSavedLibraryPath((String)file.getAbsolutePath());
        store.setValue("org.eclipse.epf.library.pref.last_library__parent_directory", file.getParent());
        store.setValue("org.eclipse.epf.library.pref.last_default_directory_checked", this.isDefLibDirChecked());
        LibraryPlugin.getDefault().savePluginPreferences();
    }
}

