/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.filters.ActivityVariabilityFilter;
import org.eclipse.epf.authoring.ui.forms.ProcessBreakdownStructureFormPage;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.authoring.ui.properties.PropertiesUtil;
import org.eclipse.epf.authoring.ui.properties.WorkBreakdownElementGeneralSection;
import org.eclipse.epf.authoring.ui.views.ProcessViewer;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.diagram.core.part.AbstractDiagramEditor;
import org.eclipse.epf.diagram.core.part.DiagramEditorInput;
import org.eclipse.epf.diagram.core.part.DiagramEditorInputProxy;
import org.eclipse.epf.diagram.core.providers.SharedResourceDiagramDocumentProvider;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ProcessVariabilityConfigurator;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.command.ActivityVariabilityCommand;
import org.eclipse.epf.library.edit.util.PropUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.library.ui.dialogs.ConvertActivityDialog;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.Iteration;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Phase;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.util.Scope;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityGeneralSection
extends WorkBreakdownElementGeneralSection {
    protected Activity element;
    private static final String NOT_APPLICABLE_TEXT = AuthoringUIResources.notApplicable_text;
    private static final String CONTRIBUTES_TEXT = AuthoringUIResources.contributes_text;
    private static final String EXTENDS_TEXT = AuthoringUIResources.extends_text;
    private static final String REPLACES_TEXT = AuthoringUIResources.replaces_text;
    private Text modelInfoText;
    private Label activityTypeLabel;
    private Text ctrl_type_text;
    private Button ctrl_type_button;
    private Combo ctrl_variability;
    private ComboViewer viewer_variability;
    private Text baseText;
    private Button selectButton;
    private Text orderText;
    protected ILabelProvider variabilityLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public String getText(Object object) {
            VariabilityType varObject = (VariabilityType)object;
            if (varObject == VariabilityType.NA) {
                return NOT_APPLICABLE_TEXT;
            }
            if (varObject == VariabilityType.CONTRIBUTES) {
                return CONTRIBUTES_TEXT;
            }
            if (varObject == VariabilityType.EXTENDS) {
                return EXTENDS_TEXT;
            }
            if (varObject == VariabilityType.REPLACES) {
                return REPLACES_TEXT;
            }
            return null;
        }
    };
    private IContentProvider variabilityContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public Object[] getElements(Object object) {
            ArrayList<VariabilityType> variabilityTypesList = new ArrayList<VariabilityType>();
            variabilityTypesList.add(VariabilityType.NA);
            variabilityTypesList.add(VariabilityType.CONTRIBUTES);
            variabilityTypesList.add(VariabilityType.EXTENDS);
            variabilityTypesList.add(VariabilityType.REPLACES);
            return variabilityTypesList.toArray();
        }
    };

    @Override
    protected void init() {
        super.init();
        this.element = (Activity)this.getElement();
    }

    @Override
    protected void createGeneralSection(Composite composite) {
        super.createGeneralSection(composite);
        FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.Activity_ModelInfo);
        this.modelInfoText = FormUI.createText(this.toolkit, this.generalComposite, -1, this.horizontalSpan);
        this.modelInfoText.setEditable(false);
        this.modelInfoText.setText(this.getModelInfo());
        this.modelInfoText.setForeground(ColorConstants.gray);
        this.activityTypeLabel = FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.Activity_Type);
        this.ctrl_type_text = this.toolkit.createText(this.generalComposite, "", 8);
        GridData gridData = new GridData(769);
        gridData.horizontalSpan = 1;
        this.ctrl_type_text.setLayoutData((Object)gridData);
        this.ctrl_type_button = this.toolkit.createButton(this.generalComposite, AuthoringUIText.CHANGE_TYPE_BUTTON_TEXT, 8);
        gridData = new GridData(1);
        gridData.horizontalSpan = 1;
        this.ctrl_type_button.setLayoutData((Object)gridData);
        if (ConvertActivityDialog.getValidNewActivityTypes((Activity)this.element) == null) {
            this.ctrl_type_button.setVisible(false);
        }
        FormUI.createLabel(this.toolkit, this.generalComposite, "");
        FormUI.createLabel(this.toolkit, this.generalComposite, AuthoringUIText.VARIABILITY_TYPE_TEXT);
        this.ctrl_variability = FormUI.createCombo(this.toolkit, this.generalComposite, 2);
        gridData = new GridData(1);
        gridData.horizontalSpan = 1;
        this.ctrl_variability.setLayoutData((Object)gridData);
        this.viewer_variability = new ComboViewer(this.ctrl_variability);
        this.viewer_variability.getCombo().setLayoutData((Object)new GridData(1));
        this.viewer_variability.setContentProvider(this.variabilityContentProvider);
        this.viewer_variability.setLabelProvider((IBaseLabelProvider)this.variabilityLabelProvider);
        this.viewer_variability.setInput((Object)this.element);
        Label blankLabel = FormUI.createLabel(this.toolkit, this.generalComposite, "");
        GridData gridData2 = new GridData(1);
        gridData2.horizontalSpan = 2;
        blankLabel.setLayoutData((Object)gridData2);
        FormUI.createLabel(this.toolkit, this.generalComposite, AuthoringUIText.BASE_ELEMENT_TEXT);
        this.baseText = FormUI.createText(this.toolkit, this.generalComposite);
        GridData gd = new GridData(769);
        gd.horizontalSpan = 2;
        this.baseText.setLayoutData((Object)gd);
        this.baseText.setEnabled(false);
        this.selectButton = FormUI.createButton(this.toolkit, this.generalComposite, AuthoringUIText.SELECT_BUTTON_TEXT);
        FormUI.createLabel(this.toolkit, this.generalComposite, AuthoringUIResources.contribution_order_text);
        this.orderText = FormUI.createText(this.toolkit, this.generalComposite);
        if (this.getElement() instanceof Activity) {
            String text = PropUtil.getPropUtil().getContributionOrder((MethodElement)((Activity)this.getElement()));
            if (text == null) {
                text = "";
            }
            this.orderText.setText(text);
        }
        this.orderText.addModifyListener(this.getOrderTextModifyListener());
        Label blankLabel1 = FormUI.createLabel(this.toolkit, this.generalComposite, "");
        GridData gridData3 = new GridData(1);
        gridData3.horizontalSpan = 1;
        blankLabel1.setLayoutData((Object)gridData3);
    }

    private ModifyListener getOrderTextModifyListener() {
        final PropUtil propUtil = PropUtil.getPropUtil((IActionManager)this.actionMgr);
        ModifyListener orderTextModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newText = ActivityGeneralSection.this.orderText.getText().trim();
                String oldText = propUtil.getContributionOrder((MethodElement)ActivityGeneralSection.this.getElement());
                if (oldText == null) {
                    oldText = "";
                }
                if (!newText.equals(oldText)) {
                    propUtil.setContributionOrder((MethodElement)((Activity)ActivityGeneralSection.this.getElement()), newText);
                }
            }
        };
        return orderTextModifyListener;
    }

    private List<AbstractDiagramEditor> getDirtyDiagramEditors() {
        IWorkbenchPage workbenchPage = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
        Process process = TngUtil.getOwningProcess((BreakdownElement)this.element);
        ArrayList<AbstractDiagramEditor> dirtyEditors = new ArrayList<AbstractDiagramEditor>();
        int i = 0;
        while (i < editorReferences.length) {
            MethodElement element;
            DiagramEditorInput diagramInput;
            IEditorInput input;
            IEditorReference reference = editorReferences[i];
            IEditorPart editor = reference.getEditor(true);
            if (editor instanceof AbstractDiagramEditor && editor.isDirty() && (input = editor.getEditorInput()) instanceof DiagramEditorInputProxy && (diagramInput = ((DiagramEditorInputProxy)input).getDiagramEditorInput()) != null && (element = diagramInput.getMethodElement()) instanceof BreakdownElement && process == TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)element))) {
                dirtyEditors.add((AbstractDiagramEditor)editor);
            }
            ++i;
        }
        return dirtyEditors;
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.ctrl_type_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessEditor editor = ActivityGeneralSection.this.getEditor();
                if (editor.isDirty() || !ActivityGeneralSection.this.getDirtyDiagramEditors().isEmpty()) {
                    String title = AuthoringUIResources.changeActivityTypeWarningDialog_title;
                    String message = AuthoringUIResources.descriptionTabGuidanceWarningDialog_message1;
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(title, message);
                } else {
                    ActivityGeneralSection.this.nameText.removeListener(27, ActivityGeneralSection.this.nameDeactivateListener);
                    ActivityGeneralSection.this.presentationNameText.removeListener(27, ActivityGeneralSection.this.presentationNameDeactivateListener);
                    Activity newActivity = ConvertActivityDialog.queryUserAndConvert((Activity)ActivityGeneralSection.this.element, null, null);
                    if (newActivity != null) {
                        StructuredSelection sel = new StructuredSelection((Object)newActivity);
                        ActivityGeneralSection.this.getPropertySheetPage().selectionChanged(ActivityGeneralSection.this.getPart(), (ISelection)sel);
                        ActivityGeneralSection.this.refresh();
                        ((ProcessViewer)((ProcessBreakdownStructureFormPage)ActivityGeneralSection.this.getEditor().getActivePageInstance()).getViewer()).expandToLevel(newActivity, 3);
                    }
                    ActivityGeneralSection.this.nameText.addListener(27, ActivityGeneralSection.this.nameDeactivateListener);
                    ActivityGeneralSection.this.presentationNameText.addListener(27, ActivityGeneralSection.this.presentationNameDeactivateListener);
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            List dirtyDiagramEditors = ActivityGeneralSection.this.getDirtyDiagramEditors();
                            for (AbstractDiagramEditor diagramEditor : dirtyDiagramEditors) {
                                diagramEditor.refresh();
                                IDocumentProvider docProvider = diagramEditor.getDocumentProvider();
                                if (!(docProvider instanceof SharedResourceDiagramDocumentProvider)) continue;
                                ((SharedResourceDiagramDocumentProvider)docProvider).markDocumentAsSaved((IFileEditorInput)diagramEditor.getEditorInput());
                            }
                        }
                    });
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.ctrl_variability.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean status;
                IStructuredSelection selection = (IStructuredSelection)ActivityGeneralSection.this.viewer_variability.getSelection();
                VariabilityElement ve = ActivityGeneralSection.this.element.getVariabilityBasedOnElement();
                VariabilityType type = (VariabilityType)selection.getFirstElement();
                if (ve != null & ve instanceof Activity) {
                    IStatus state;
                    if (type != VariabilityType.NA && !(state = DependencyChecker.checkCircularDependencyAfterFilterSelection((Activity)ActivityGeneralSection.this.element, (Activity)((Activity)ve), (VariabilityType)type)).isOK()) {
                        String title = AuthoringUIResources.activity_variability_error_title;
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, state.getMessage());
                        VariabilityType variabilityType = ActivityGeneralSection.this.element.getVariabilityType();
                        StructuredSelection newVariabilitySelection = new StructuredSelection((Object)variabilityType);
                        ActivityGeneralSection.this.viewer_variability.setSelection((ISelection)newVariabilitySelection, true);
                        return;
                    }
                    status = ActivityGeneralSection.this.actionMgr.doAction(1, (EObject)ActivityGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getVariabilityElement_VariabilityType(), (Object)type, -1);
                    if (!status) {
                        if ((ActivityGeneralSection.this.element.getPresentationName() == null || ActivityGeneralSection.this.element.getPresentationName().equals("")) && type.equals((Object)VariabilityType.NA)) {
                            ActivityGeneralSection.this.element.setPresentationName(ActivityGeneralSection.this.element.getName());
                        }
                        return;
                    }
                    if ((ActivityGeneralSection.this.element.getPresentationName() == null || ActivityGeneralSection.this.element.getPresentationName().equals("")) && (type.equals((Object)VariabilityType.CONTRIBUTES) || type.equals((Object)VariabilityType.REPLACES) || type.equals((Object)VariabilityType.NA))) {
                        ActivityGeneralSection.this.element.setPresentationName(ActivityGeneralSection.this.element.getName());
                    }
                }
                if (type == VariabilityType.NA) {
                    if (ve != null && !(status = ActivityGeneralSection.this.actionMgr.doAction(1, (EObject)ActivityGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getVariabilityElement_VariabilityBasedOnElement(), null, -1))) {
                        return;
                    }
                    ActivityGeneralSection.this.selectButton.setEnabled(false);
                    ActivityGeneralSection.this.baseText.setText("");
                } else {
                    ArrayList<VariabilityElement> selectionBaseList = new ArrayList<VariabilityElement>();
                    VariabilityElement base = ActivityGeneralSection.this.element.getVariabilityBasedOnElement();
                    selectionBaseList.add(base);
                    ActivityGeneralSection.this.selectButton.setEnabled(true);
                }
            }
        });
        this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodConfiguration config = ActivityGeneralSection.this.getConfiguration();
                if (config instanceof Scope) {
                    config = LibraryService.getInstance().getCurrentMethodConfiguration();
                }
                String tabName = FilterConstants.ACTIVITIES;
                VariabilityType type = (VariabilityType)((IStructuredSelection)ActivityGeneralSection.this.viewer_variability.getSelection()).getFirstElement();
                ActivityVariabilityFilter filter = new ActivityVariabilityFilter(config, null, tabName, ActivityGeneralSection.this.element);
                ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)filter, tabName, null, config);
                fd.setBlockOnOpen(true);
                fd.setViewerSelectionSingle(true);
                fd.setTitle(tabName);
                fd.open();
                ArrayList selectedItems = fd.getSelectedItems();
                if (selectedItems != null && !selectedItems.isEmpty()) {
                    IStatus status;
                    Object o = selectedItems.get(0);
                    if (o instanceof Activity && !(status = DependencyChecker.checkCircularDependencyAfterFilterSelection((Activity)ActivityGeneralSection.this.element, (Activity)((Activity)o), (VariabilityType)type)).isOK()) {
                        String title = AuthoringUIResources.activity_variability_error_title;
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, status.getMessage());
                        return;
                    }
                    if (o instanceof VariabilityElement) {
                        VariabilityElement ve = (VariabilityElement)o;
                        ProcessVariabilityConfigurator configurator = new ProcessVariabilityConfigurator(ActivityGeneralSection.this.getDefaultConfiguration());
                        ActivityVariabilityCommand cmd = new ActivityVariabilityCommand(ActivityGeneralSection.this.element, ve, type, (IConfigurator)configurator);
                        boolean status2 = ActivityGeneralSection.this.actionMgr.execute((IResourceAwareCommand)cmd);
                        if (!status2) {
                            return;
                        }
                        ActivityGeneralSection.this.baseText.setText(TngUtil.getLabelWithPath((Object)ve));
                    }
                }
            }
        });
    }

    private String getModelInfo() {
        String info = null;
        try {
            ItemProviderAdapter o = this.getAdapter();
            if (o instanceof IBSItemProvider) {
                IBSItemProvider adapter = (IBSItemProvider)o;
                info = adapter.getAttribute((Object)this.element, "model_info");
            }
        }
        catch (Exception exception) {}
        if (!StrUtil.isBlank(info)) {
            return info;
        }
        return PropertiesResources.Process_None;
    }

    @Override
    protected void updateControls() {
        super.updateControls();
        this.ctrl_type_button.setEnabled(this.editable);
        this.ctrl_variability.setEnabled(this.editable);
        this.selectButton.setEnabled(this.editable);
        this.ctrl_variability.setEnabled(this.editable);
        if (((IStructuredSelection)this.viewer_variability.getSelection()).getFirstElement() == VariabilityType.NA) {
            this.selectButton.setEnabled(false);
        }
    }

    @Override
    public void refresh() {
        try {
            if (this.getElement() instanceof Activity) {
                super.refresh();
                this.element = (Activity)this.getElement();
                String text = PropUtil.getPropUtil().getContributionOrder((MethodElement)this.element);
                if (text == null) {
                    text = "";
                }
                if (!text.equals(this.orderText.getText())) {
                    this.orderText.setText(text);
                }
                this.modelInfoText.setText(this.getModelInfo());
                this.ctrl_type_text.setText(PropertiesUtil.getType(this.element));
                if (this.element instanceof Process && (this.element.getSuperActivities() == null || this.element.getSuperActivities() == null)) {
                    this.activityTypeLabel.setVisible(false);
                    this.ctrl_type_text.setVisible(false);
                    this.ctrl_type_button.setVisible(false);
                } else {
                    this.activityTypeLabel.setVisible(true);
                    this.ctrl_type_text.setVisible(true);
                    this.ctrl_type_button.setVisible(true);
                }
                VariabilityType variabilityType = this.element.getVariabilityType();
                StructuredSelection newVariabilitySelection = new StructuredSelection((Object)variabilityType);
                this.viewer_variability.setSelection((ISelection)newVariabilitySelection, true);
                if (this.element.getVariabilityBasedOnElement() != null) {
                    this.baseText.setText(TngUtil.getLabelWithPath((Object)this.element.getVariabilityBasedOnElement()));
                } else {
                    this.baseText.setText("");
                }
                if (variabilityType.equals((Object)VariabilityType.LOCAL_CONTRIBUTION) || variabilityType.equals((Object)VariabilityType.LOCAL_REPLACEMENT)) {
                    StructuredSelection selection = new StructuredSelection((Object)VariabilityType.NA);
                    this.viewer_variability.setSelection((ISelection)selection);
                    this.ctrl_variability.setEnabled(false);
                } else {
                    this.ctrl_variability.setEnabled(this.editable);
                }
            }
        }
        catch (Exception ex) {
            this.logger.logError("Error refreshing Activity general section : " + this.element, (Throwable)ex);
        }
    }

    @Override
    public String getNamePrefix() {
        if (this.element instanceof CapabilityPattern) {
            return String.valueOf(LibraryUIText.TEXT_CAPABILITY_PATTERN) + ": ";
        }
        if (this.element instanceof DeliveryProcess) {
            return String.valueOf(LibraryUIText.TEXT_DELIVERY_PROCESS) + ": ";
        }
        if (this.element instanceof Phase) {
            return String.valueOf(LibraryUIText.TEXT_PHASE) + ": ";
        }
        if (this.element instanceof Iteration) {
            return String.valueOf(LibraryUIText.TEXT_ITERATION) + ": ";
        }
        return String.valueOf(LibraryUIText.TEXT_ACTIVITY) + ": ";
    }
}

