/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIExtensionManager;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.properties.AbstractSection;
import org.eclipse.epf.authoring.ui.properties.EPFPropertySheetPage;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.authoring.ui.properties.PropertiesUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.DescriptorPropUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyComposite;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyTitle;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class BreakdownElementGeneralSection
extends AbstractSection {
    protected FormToolkit toolkit;
    protected Section generalSection;
    protected Composite generalComposite;
    protected Composite checkBoxComposite;
    protected Text nameText;
    protected Text presentationNameText;
    protected Button nameRestoreBtn;
    protected Button presentationNameRestoreBtn;
    protected Composite buttonComposite_1;
    protected Composite buttonComposite_2;
    private DescriptorPropUtil descriptorPropUtil;
    private ModifyListener syncFreeNameModifyListener;
    private ModifyListener syncFreePresentationNameModifyListener;
    private boolean isNameReplace = false;
    private boolean isPresentationNameReplace = false;
    private Button multipleButton;
    private Button optionalButton;
    private Button plannedButton;
    private Button supressedButton;
    protected int numOfColumns = 4;
    protected int horizontalSpan = 3;
    protected BreakdownElement element;
    protected IActionManager actionMgr;
    protected ModifyListener modelModifyListener;
    protected ModifyListener nameModifyListener;
    private ILabelProvider labelProvider;
    final boolean ignoreSuppressed = true;
    private BeGeneralSectionExtender extender;
    protected Listener nameDeactivateListener = new Listener(){

        /*
         * Enabled aggressive block sorting
         */
        public void handleEvent(Event e) {
            AdapterFactory adapterFactory = EPFPropertySheetPage.getAdapterFactory();
            BreakdownElementGeneralSection.this.element = BreakdownElementGeneralSection.this.getElement();
            String oldContent = BreakdownElementGeneralSection.this.element.getName();
            if (BreakdownElementGeneralSection.this.getEditor().mustRestoreValue(BreakdownElementGeneralSection.this.nameText, oldContent)) {
                return;
            }
            String message = null;
            if (!StrUtil.isBlank((String)BreakdownElementGeneralSection.this.element.getName())) {
                Suppression suppression = EPFPropertySheetPage.getEditor().getSuppression();
                message = ProcessUtil.checkBreakdownElementName((AdapterFactory)adapterFactory, (BreakdownElement)BreakdownElementGeneralSection.this.element, (String)BreakdownElementGeneralSection.this.nameText.getText(), (Suppression)suppression, (boolean)true);
            }
            if (message != null) {
                BreakdownElementGeneralSection.this.nameText.setText(oldContent);
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(PropertiesResources.Process_InvalidNameTitle, message);
                e.doit = false;
                BreakdownElementGeneralSection.this.nameText.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        (this).BreakdownElementGeneralSection.this.nameText.setFocus();
                        (this).BreakdownElementGeneralSection.this.nameText.selectAll();
                    }
                });
                return;
            }
            if (BreakdownElementGeneralSection.this.nameText.getText().equals(oldContent)) return;
            if (BreakdownElementGeneralSection.this.element instanceof Activity && BreakdownElementGeneralSection.this.element.eContainer() instanceof ProcessComponent) {
                ProcessComponent procComp = (ProcessComponent)BreakdownElementGeneralSection.this.element.eContainer();
                IValidator validator = IValidatorFactory.INSTANCE.createNameValidator((NamedElement)procComp, (AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
                String msg = validator.isValid(BreakdownElementGeneralSection.this.nameText.getText());
                if (msg != null) {
                    BreakdownElementGeneralSection.this.nameText.setText(oldContent);
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(PropertiesResources.Process_InvalidNameTitle, msg);
                    e.doit = false;
                    BreakdownElementGeneralSection.this.nameText.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            (this).BreakdownElementGeneralSection.this.nameText.setFocus();
                            (this).BreakdownElementGeneralSection.this.nameText.selectAll();
                        }
                    });
                    return;
                }
                msg = PropertiesResources.Process_Rename_Message;
                if (!AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(PropertiesResources.Process_Rename_Title, msg)) {
                    BreakdownElementGeneralSection.this.nameText.setText(oldContent);
                    return;
                }
                e.doit = true;
                boolean status = BreakdownElementGeneralSection.this.actionMgr.doAction(1, (EObject)BreakdownElementGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)BreakdownElementGeneralSection.this.nameText.getText(), -1);
                if (!status) {
                    return;
                }
                BreakdownElementGeneralSection.this.actionMgr.doAction(1, (EObject)procComp, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)BreakdownElementGeneralSection.this.nameText.getText(), -1);
                BreakdownElementGeneralSection.this.getEditor().setPartName();
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    public void run() {
                        DiagramManager mgr;
                        ProcessEditor editor = BreakdownElementGeneralSection.this.getEditor();
                        ((MethodElementEditor)editor).doSave((IProgressMonitor)new NullProgressMonitor());
                        ILibraryPersister.FailSafeMethodLibraryPersister persister = editor.getPersister();
                        try {
                            persister.adjustLocation((this).BreakdownElementGeneralSection.this.element.eResource());
                            persister.commit();
                        }
                        catch (RuntimeException e) {
                            persister.rollback();
                            throw e;
                        }
                        if ((this).BreakdownElementGeneralSection.this.element instanceof Process && (mgr = DiagramManager.getInstance((Process)((Process)(this).BreakdownElementGeneralSection.this.element), (Object)this)) != null) {
                            try {
                                try {
                                    mgr.updateResourceURI();
                                }
                                catch (Exception e) {
                                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                                    mgr.removeConsumer((Object)this);
                                }
                            }
                            finally {
                                mgr.removeConsumer((Object)this);
                            }
                        }
                    }
                });
                return;
            }
            e.doit = true;
            boolean status = BreakdownElementGeneralSection.this.actionMgr.doAction(1, (EObject)BreakdownElementGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)BreakdownElementGeneralSection.this.nameText.getText(), -1);
            if (status) return;
        }
    };
    protected Listener presentationNameDeactivateListener = new Listener(){

        public void handleEvent(Event e) {
            VariabilityElement ve;
            AdapterFactory adapterFactory = EPFPropertySheetPage.getAdapterFactory();
            BreakdownElementGeneralSection.this.element = BreakdownElementGeneralSection.this.getElement();
            String oldContent = BreakdownElementGeneralSection.this.element.getPresentationName();
            if (BreakdownElementGeneralSection.this.getEditor().mustRestoreValue(BreakdownElementGeneralSection.this.presentationNameText, oldContent)) {
                return;
            }
            String message = null;
            if (StrUtil.isBlank((String)BreakdownElementGeneralSection.this.presentationNameText.getText()) && BreakdownElementGeneralSection.this.element instanceof VariabilityElement && (ve = (VariabilityElement)BreakdownElementGeneralSection.this.element).getVariabilityBasedOnElement() != null && ve.getVariabilityType().equals((Object)VariabilityType.EXTENDS)) {
                boolean status;
                e.doit = true;
                if (!BreakdownElementGeneralSection.this.presentationNameText.getText().equals(oldContent) && !(status = BreakdownElementGeneralSection.this.actionMgr.doAction(1, (EObject)BreakdownElementGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_PresentationName(), (Object)BreakdownElementGeneralSection.this.presentationNameText.getText(), -1))) {
                    return;
                }
            }
            if (!StrUtil.isBlank((String)BreakdownElementGeneralSection.this.element.getPresentationName())) {
                Suppression suppression = EPFPropertySheetPage.getEditor().getSuppression();
                message = ProcessUtil.checkBreakdownElementPresentationName((AdapterFactory)adapterFactory, (BreakdownElement)BreakdownElementGeneralSection.this.element, (String)BreakdownElementGeneralSection.this.presentationNameText.getText(), (Suppression)suppression, (boolean)true);
            }
            if (message == null) {
                boolean status;
                e.doit = true;
                if (!BreakdownElementGeneralSection.this.presentationNameText.getText().equals(oldContent) && !(status = BreakdownElementGeneralSection.this.actionMgr.doAction(1, (EObject)BreakdownElementGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_PresentationName(), (Object)BreakdownElementGeneralSection.this.presentationNameText.getText(), -1))) {
                    return;
                }
            } else {
                BreakdownElementGeneralSection.this.presentationNameText.setText(BreakdownElementGeneralSection.this.element.getPresentationName());
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(PropertiesResources.Process_InvalidNameTitle, message);
                e.doit = false;
                BreakdownElementGeneralSection.this.presentationNameText.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        (this).BreakdownElementGeneralSection.this.presentationNameText.setFocus();
                    }
                });
            }
        }
    };

    protected void init() {
        this.extender = AuthoringUIExtensionManager.getInstance().createBeGeneralSectionExtender(this);
        this.element = this.getElement();
        this.toolkit = this.getWidgetFactory();
        this.actionMgr = EPFPropertySheetPage.getActionManager();
        this.descriptorPropUtil = DescriptorPropUtil.getDesciptorPropUtil((IActionManager)this.actionMgr);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.init();
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(1808));
        this.createGeneralSection(parent);
        this.extender.modifyGeneralSectionContent(this.toolkit, this.actionMgr);
        this.addListeners();
        this.updateControls();
    }

    protected void addListeners() {
        this.nameText.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                BreakdownElementGeneralSection.this.getEditor().setCurrentFeatureEditor(event.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            }
        });
        this.nameText.addListener(27, this.nameDeactivateListener);
        this.presentationNameText.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                BreakdownElementGeneralSection.this.getEditor().setCurrentFeatureEditor(event.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_PresentationName());
            }
        });
        this.presentationNameText.addListener(27, this.presentationNameDeactivateListener);
        this.presentationNameText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                BreakdownElementGeneralSection.this.presentationNameText.selectAll();
            }

            public void focusLost(FocusEvent e) {
                if (BreakdownElementGeneralSection.this.presentationNameText.getSelectionCount() > 0) {
                    BreakdownElementGeneralSection.this.presentationNameText.clearSelection();
                }
            }
        });
        this.multipleButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BreakdownElementGeneralSection.this.element = BreakdownElementGeneralSection.this.getElement();
                boolean status = BreakdownElementGeneralSection.this.actionMgr.doAction(1, (EObject)BreakdownElementGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_HasMultipleOccurrences(), (Object)BreakdownElementGeneralSection.this.multipleButton.getSelection(), -1);
                if (!status) {
                    BreakdownElementGeneralSection.this.multipleButton.setSelection(BreakdownElementGeneralSection.this.element.getHasMultipleOccurrences().booleanValue());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.optionalButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BreakdownElementGeneralSection.this.element = BreakdownElementGeneralSection.this.getElement();
                boolean status = BreakdownElementGeneralSection.this.actionMgr.doAction(1, (EObject)BreakdownElementGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_IsOptional(), (Object)BreakdownElementGeneralSection.this.optionalButton.getSelection(), -1);
                if (!status) {
                    BreakdownElementGeneralSection.this.optionalButton.setSelection(BreakdownElementGeneralSection.this.element.getIsOptional().booleanValue());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.plannedButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BreakdownElementGeneralSection.this.element = BreakdownElementGeneralSection.this.getElement();
                boolean status = BreakdownElementGeneralSection.this.actionMgr.doAction(1, (EObject)BreakdownElementGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_IsPlanned(), (Object)BreakdownElementGeneralSection.this.plannedButton.getSelection(), -1);
                if (!status) {
                    BreakdownElementGeneralSection.this.plannedButton.setSelection(BreakdownElementGeneralSection.this.element.getIsPlanned().booleanValue());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.supressedButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean status;
                BreakdownElementGeneralSection.this.element = BreakdownElementGeneralSection.this.getElement();
                if (BreakdownElementGeneralSection.this.element.getSuppressed().booleanValue()) {
                    ProcessEditor editor = BreakdownElementGeneralSection.this.getEditor();
                    Suppression suppression = editor.getSuppression();
                    boolean canReveal = ProcessEditor.canReveal(Arrays.asList(BreakdownElementGeneralSection.this.element), EPFPropertySheetPage.getAdapterFactory(), suppression);
                    if (!canReveal) {
                        BreakdownElementGeneralSection.this.supressedButton.setSelection(true);
                    } else {
                        BreakdownElementGeneralSection.this.supressedButton.setSelection(false);
                    }
                }
                if (!(status = BreakdownElementGeneralSection.this.actionMgr.doAction(1, (EObject)BreakdownElementGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_Suppressed(), (Object)BreakdownElementGeneralSection.this.supressedButton.getSelection(), -1))) {
                    BreakdownElementGeneralSection.this.supressedButton.setSelection(BreakdownElementGeneralSection.this.element.getSuppressed().booleanValue());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.nameRestoreBtn != null) {
            this.nameRestoreBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BreakdownElementGeneralSection.this.descriptorPropUtil.setNameRepalce((Descriptor)BreakdownElementGeneralSection.this.element, false);
                    BreakdownElementGeneralSection.this.isNameReplace = false;
                    BreakdownElementGeneralSection.this.updateNameRestoreBtn();
                    Descriptor greenParent = BreakdownElementGeneralSection.this.descriptorPropUtil.getGreenParentDescriptor((Descriptor)BreakdownElementGeneralSection.this.element);
                    if (greenParent != null) {
                        BreakdownElementGeneralSection.this.element.setName(greenParent.getName());
                    } else {
                        MethodElement reference = BreakdownElementGeneralSection.this.getReferenceMethodElement(BreakdownElementGeneralSection.this.element);
                        BreakdownElementGeneralSection.this.element.setName(reference.getName());
                    }
                }
            });
        }
        if (this.presentationNameRestoreBtn != null) {
            this.presentationNameRestoreBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BreakdownElementGeneralSection.this.descriptorPropUtil.setPresentationNameRepalce((Descriptor)BreakdownElementGeneralSection.this.element, false);
                    BreakdownElementGeneralSection.this.isPresentationNameReplace = false;
                    BreakdownElementGeneralSection.this.updatePresentationNameRestoreBtn();
                    Descriptor greenParent = BreakdownElementGeneralSection.this.descriptorPropUtil.getGreenParentDescriptor((Descriptor)BreakdownElementGeneralSection.this.element);
                    if (greenParent != null) {
                        BreakdownElementGeneralSection.this.element.setPresentationName(greenParent.getPresentationName());
                    } else {
                        MethodElement reference = BreakdownElementGeneralSection.this.getReferenceMethodElement(BreakdownElementGeneralSection.this.element);
                        BreakdownElementGeneralSection.this.element.setPresentationName(reference.getPresentationName());
                    }
                }
            });
        }
    }

    private MethodElement getReferenceMethodElement(BreakdownElement element) {
        Task e = null;
        if (element instanceof TaskDescriptor) {
            e = ((TaskDescriptor)element).getTask();
        } else if (element instanceof RoleDescriptor) {
            e = ((RoleDescriptor)element).getRole();
        } else if (element instanceof WorkProductDescriptor) {
            e = ((WorkProductDescriptor)element).getWorkProduct();
        }
        if (e != null) {
            e = ConfigurationHelper.getCalculatedElement((MethodElement)e, (MethodConfiguration)this.getConfiguration());
        }
        return e;
    }

    protected void createGeneralSection(Composite composite) {
        this.generalSection = FormUI.createSection(this.toolkit, composite, PropertiesResources.Process_generalInformationTitle, PropertiesResources.bind(PropertiesResources.Process_generalInformationDescription, PropertiesUtil.getTypeLower(this.element)));
        this.generalComposite = FormUI.createComposite(this.toolkit, this.generalSection, this.numOfColumns, false);
        FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.Process_name);
        if (this.isSyncFree()) {
            this.nameText = FormUI.createText(this.toolkit, this.generalComposite, -1, 1);
            this.buttonComposite_1 = FormUI.createComposite(this.toolkit, this.generalComposite, 0, 2, true);
            this.nameRestoreBtn = FormUI.createButton(this.toolkit, this.buttonComposite_1, PropertiesResources.Process_name_restore);
            this.nameRestoreBtn.setEnabled(false);
            this.updateNameRestoreBtn();
        } else {
            this.nameText = FormUI.createText(this.toolkit, this.generalComposite, -1, this.horizontalSpan);
        }
        FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.Activity_presentationName);
        if (this.isSyncFree()) {
            this.presentationNameText = FormUI.createText(this.toolkit, this.generalComposite, -1, 1);
            this.buttonComposite_2 = FormUI.createComposite(this.toolkit, this.generalComposite, 0, 2, true);
            this.presentationNameRestoreBtn = FormUI.createButton(this.toolkit, this.buttonComposite_2, PropertiesResources.Process_PresentationName_restore);
            this.presentationNameRestoreBtn.setEnabled(false);
            this.updatePresentationNameRestoreBtn();
        } else {
            this.presentationNameText = FormUI.createText(this.toolkit, this.generalComposite, -1, this.horizontalSpan);
        }
        this.checkBoxComposite = FormUI.createComposite(this.toolkit, this.generalComposite, 768, this.numOfColumns, true);
        this.optionalButton = FormUI.createCheckButton(this.toolkit, this.checkBoxComposite, 1);
        this.optionalButton.setText(PropertiesResources.BreakdownElement_Option_Optional);
        this.multipleButton = FormUI.createCheckButton(this.toolkit, this.checkBoxComposite, 1);
        this.multipleButton.setText(PropertiesResources.BreakdownElement_Option_MultipleOcurrance);
        this.plannedButton = FormUI.createCheckButton(this.toolkit, this.checkBoxComposite, 1);
        this.plannedButton.setText(PropertiesResources.BreakdownElement_Option_Planned);
        this.supressedButton = FormUI.createCheckButton(this.toolkit, this.checkBoxComposite, 1);
        this.supressedButton.setText(PropertiesResources.BreakdownElement_Option_Supressed);
        this.supressedButton.setEnabled(false);
        this.toolkit.paintBordersFor(this.generalComposite);
        this.toolkit.paintBordersFor(this.checkBoxComposite);
        if (this.isSyncFree()) {
            this.toolkit.paintBordersFor(this.buttonComposite_1);
            this.toolkit.paintBordersFor(this.buttonComposite_2);
        }
    }

    private void updateNameRestoreBtn() {
        if (this.getReferenceMethodElement(this.element) != null) {
            this.nameRestoreBtn.setEnabled(this.descriptorPropUtil.isNameRepalce((Descriptor)this.element) && this.editable);
        }
    }

    private void updatePresentationNameRestoreBtn() {
        if (this.getReferenceMethodElement(this.element) != null) {
            this.presentationNameRestoreBtn.setEnabled(this.descriptorPropUtil.isPresentationNameRepalce((Descriptor)this.element) && this.editable);
        }
    }

    public ModifyListener createNameModifyListener(EObject eObj) {
        return this.createNameModifyListener(eObj, false);
    }

    public ModifyListener createNameModifyListener(EObject eObj, boolean checkContainer) {
        return new NameModifyListener(eObj, checkContainer);
    }

    public void updateTitle(String txt) {
        String name = String.valueOf(this.getNamePrefix()) + txt;
        TabbedPropertyComposite comp = (TabbedPropertyComposite)this.page.getControl();
        TabbedPropertyTitle title = comp.getTitle();
        title.setTitle(name, this.getImage(this.element));
    }

    private Image getImage(Object obj) {
        if (this.labelProvider == null) {
            this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngUtil.umaItemProviderAdapterFactory);
        }
        Image titleImage = this.labelProvider.getImage(obj);
        return titleImage;
    }

    public void dispose() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof BreakdownElement) {
                this.element = this.getElement();
                this.generalSection.setDescription(PropertiesResources.bind(PropertiesResources.Process_generalInformationDescription, PropertiesUtil.getTypeLower(this.element)));
                if (this.modelModifyListener != null) {
                    this.presentationNameText.removeModifyListener(this.modelModifyListener);
                }
                this.modelModifyListener = this.getEditor().createModifyListener((EObject)this.element);
                if (this.syncFreePresentationNameModifyListener != null) {
                    this.presentationNameText.removeModifyListener(this.syncFreePresentationNameModifyListener);
                }
                this.syncFreePresentationNameModifyListener = this.createSyncFreePresentationNameModifyListener();
                if (this.nameModifyListener != null) {
                    this.nameText.removeModifyListener(this.nameModifyListener);
                }
                this.nameModifyListener = this.element instanceof Process ? this.createNameModifyListener(((Process)this.element).eContainer(), true) : this.createNameModifyListener((EObject)this.element);
                if (this.syncFreeNameModifyListener != null) {
                    this.nameText.removeModifyListener(this.syncFreeNameModifyListener);
                }
                this.syncFreeNameModifyListener = this.createSyncFreeNameModifyListener();
                if (this.modelModifyListener instanceof MethodElementEditor.ModifyListener) {
                    ((MethodElementEditor.ModifyListener)this.modelModifyListener).setElement((EObject)this.element);
                    ((MethodElementEditor.ModifyListener)this.modelModifyListener).setDisable(true);
                }
                if (this.nameModifyListener instanceof MethodElementEditor.ModifyListener) {
                    ((MethodElementEditor.ModifyListener)this.nameModifyListener).setDisable(true);
                }
                if (!this.isNameReplace || !this.descriptorPropUtil.isNameRepalce((Descriptor)this.element)) {
                    this.nameText.setText(this.element.getName());
                    if (this.isSyncFree()) {
                        this.updateNameRestoreBtn();
                    }
                }
                if (!this.isPresentationNameReplace || !this.descriptorPropUtil.isPresentationNameRepalce((Descriptor)this.element)) {
                    this.presentationNameText.setText(this.element.getPresentationName());
                    if (this.isSyncFree()) {
                        this.updatePresentationNameRestoreBtn();
                    }
                }
                if (this.modelModifyListener instanceof MethodElementEditor.ModifyListener) {
                    ((MethodElementEditor.ModifyListener)this.modelModifyListener).setDisable(false);
                }
                if (this.nameModifyListener instanceof MethodElementEditor.ModifyListener) {
                    ((MethodElementEditor.ModifyListener)this.nameModifyListener).setDisable(false);
                }
                this.nameText.addModifyListener(this.nameModifyListener);
                this.presentationNameText.addModifyListener(this.modelModifyListener);
                if (this.syncFreeNameModifyListener != null) {
                    this.nameText.addModifyListener(this.syncFreeNameModifyListener);
                }
                if (this.syncFreePresentationNameModifyListener != null) {
                    this.presentationNameText.addModifyListener(this.syncFreePresentationNameModifyListener);
                }
                this.multipleButton.setSelection(this.element.getHasMultipleOccurrences().booleanValue());
                this.optionalButton.setSelection(this.element.getIsOptional().booleanValue());
                this.plannedButton.setSelection(this.element.getIsPlanned().booleanValue());
                Object input = this.getInput();
                if (input instanceof BreakdownElementWrapperItemProvider) {
                    if (this.getEditor().getSuppression().isInSuppressedList((BreakdownElementWrapperItemProvider)input)) {
                        this.supressedButton.setSelection(true);
                    } else {
                        this.supressedButton.setSelection(false);
                    }
                } else {
                    this.supressedButton.setSelection(this.element.getSuppressed().booleanValue());
                }
                this.extender.refresh();
                this.updateControls();
            }
        }
        catch (Exception ex) {
            this.logger.logError("Error refreshing breakdown element general section" + this.element, (Throwable)ex);
        }
    }

    protected void updateControls() {
        this.nameText.setEditable(this.editable);
        this.presentationNameText.setEditable(this.editable);
        this.multipleButton.setEnabled(this.editable);
        this.optionalButton.setEnabled(this.editable);
        this.plannedButton.setEnabled(this.editable);
        this.extender.updateControls(this.editable);
    }

    private ModifyListener createSyncFreeNameModifyListener() {
        if (this.isSyncFree()) {
            return new SyncFreeNameModifyListener();
        }
        return null;
    }

    private ModifyListener createSyncFreePresentationNameModifyListener() {
        if (this.isSyncFree()) {
            return new SyncFreePresentationNameModifyListener();
        }
        return null;
    }

    public static class BeGeneralSectionExtender {
        protected BreakdownElementGeneralSection section;

        public BeGeneralSectionExtender(BreakdownElementGeneralSection section) {
            this.section = section;
        }

        public void modifyGeneralSectionContent(FormToolkit toolkit, IActionManager actionMgr) {
        }

        public void dispose() {
        }

        public void refresh() {
        }

        public void updateControls(boolean editable) {
        }

        protected Composite getComposite() {
            return this.section.generalComposite;
        }
    }

    public class NameModifyListener
    extends MethodElementEditor.ModifyListener {
        public NameModifyListener(EObject element, boolean checkContainer) {
            ProcessEditor processEditor = BreakdownElementGeneralSection.this.getEditor();
            ((Object)((Object)processEditor)).getClass();
            super(element, checkContainer);
        }

        public void modifyText(ModifyEvent e) {
            super.modifyText(e);
            BreakdownElementGeneralSection.this.updateTitle(BreakdownElementGeneralSection.this.nameText.getText());
        }
    }

    private class SyncFreeNameModifyListener
    implements ModifyListener {
        private SyncFreeNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (BreakdownElementGeneralSection.this.getReferenceMethodElement(BreakdownElementGeneralSection.this.element) != null) {
                BreakdownElementGeneralSection.this.descriptorPropUtil.setNameRepalce((Descriptor)BreakdownElementGeneralSection.this.element, true);
                BreakdownElementGeneralSection.this.isNameReplace = true;
                BreakdownElementGeneralSection.this.updateNameRestoreBtn();
            }
        }
    }

    private class SyncFreePresentationNameModifyListener
    implements ModifyListener {
        private SyncFreePresentationNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (BreakdownElementGeneralSection.this.getReferenceMethodElement(BreakdownElementGeneralSection.this.element) != null) {
                BreakdownElementGeneralSection.this.descriptorPropUtil.setPresentationNameRepalce((Descriptor)BreakdownElementGeneralSection.this.element, true);
                BreakdownElementGeneralSection.this.isPresentationNameReplace = true;
                BreakdownElementGeneralSection.this.updatePresentationNameRestoreBtn();
            }
        }
    }
}

