/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.filters.ProcessGuidanceFilter;
import org.eclipse.epf.authoring.ui.properties.AbstractSection;
import org.eclipse.epf.authoring.ui.properties.EPFPropertySheetPage;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.ChangeUdtCommand;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.configuration.GuidanceItemProvider;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.itemsfilter.FilterInitializer;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.command.AddGuidanceToBreakdownElementCommand;
import org.eclipse.epf.library.edit.util.DescriptorPropUtil;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.PracticePropUtil;
import org.eclipse.epf.library.edit.util.ProcessScopeUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Checklist;
import org.eclipse.epf.uma.Concept;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.EstimationConsiderations;
import org.eclipse.epf.uma.Example;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.Guideline;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Report;
import org.eclipse.epf.uma.ReusableAsset;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.Template;
import org.eclipse.epf.uma.ToolMentor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreakdownElementGuidanceSection
extends AbstractSection {
    private FormToolkit toolkit;
    private Button ctrl_add_1;
    private Button ctrl_remove_1;
    private Table ctrl_table_1;
    private TableViewer viewer_1;
    private BreakdownElement element;
    private IActionManager actionMgr;
    public final String tabName = FilterConstants.GUIDANCE;
    private IFilter generalGuidanceFilter = null;
    private DescriptorPropUtil propUtil;

    public IFilter getGeneralGuidanceFilter() {
        if (this.generalGuidanceFilter == null) {
            this.generalGuidanceFilter = new ProcessGuidanceFilter(this.getConfiguration(), null, this.tabName){

                public boolean childAccept(Object obj) {
                    if (super.childAccept(obj)) {
                        return true;
                    }
                    if (obj instanceof GuidanceItemProvider) {
                        return !((GuidanceItemProvider)obj).getChildren(obj).isEmpty();
                    }
                    Class cls = FilterInitializer.getInstance().getClassForType(this.helper.getFilterTypeStr());
                    if (cls != null) {
                        return cls.isInstance(obj);
                    }
                    if (obj instanceof Checklist || obj instanceof Concept || obj instanceof Example || obj instanceof Guideline || obj instanceof ReusableAsset || obj instanceof SupportingMaterial || obj instanceof Template || obj instanceof Report || obj instanceof ToolMentor || obj instanceof EstimationConsiderations) {
                        return true;
                    }
                    return obj instanceof Practice && PracticePropUtil.getPracticePropUtil().isUdtType((MethodElement)((Practice)obj));
                }
            };
        } else {
            ((ProcessGuidanceFilter)this.generalGuidanceFilter).setMethodConfiguration(this.getConfiguration());
        }
        return this.generalGuidanceFilter;
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.init();
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(1808));
        this.createGuidanceSection(parent);
        this.addListeners();
        this.updateControls();
    }

    private void init() {
        this.element = this.getElement();
        this.toolkit = this.getWidgetFactory();
        this.actionMgr = EPFPropertySheetPage.getActionManager();
        this.propUtil = DescriptorPropUtil.getDesciptorPropUtil((IActionManager)this.actionMgr);
    }

    public void updateControls() {
        this.ctrl_add_1.setEnabled(this.editable);
        IStructuredSelection selection = (IStructuredSelection)this.viewer_1.getSelection();
        if (selection.size() > 0 && this.editable) {
            this.ctrl_remove_1.setEnabled(true);
        } else {
            this.ctrl_remove_1.setEnabled(false);
        }
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof BreakdownElement) {
                this.element = this.getElement();
                this.initContentProvider();
                this.initLabelProvider();
                this.viewer_1.refresh();
                this.updateControls();
            }
        }
        catch (Exception ex) {
            this.logger.logError("Error refreshing activity guidance section: ", (Throwable)ex);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private void createGuidanceSection(Composite composite) {
        int tableHeight = 50;
        String sectionTitle = null;
        String sectionDesc = null;
        String tableTitle = null;
        sectionTitle = PropertiesResources.Activity_GeneralGuidanceTitle;
        sectionDesc = PropertiesResources.Activity_GeneralGuidanceDescription;
        tableTitle = PropertiesResources.Activity_Selected_GeneralGuidance;
        if (this.isSyncFree()) {
            sectionDesc = String.valueOf(sectionDesc) + " " + PropertiesResources.Process_SyncFree_FontStyle;
        }
        Section section = FormUI.createSection(this.toolkit, composite, sectionTitle, sectionDesc);
        Composite sectionComposite = FormUI.createComposite(this.toolkit, section, 2, false);
        Composite pane1 = FormUI.createComposite(this.toolkit, sectionComposite, 1808);
        FormUI.createLabel(this.toolkit, pane1, tableTitle);
        this.ctrl_table_1 = FormUI.createTable(this.toolkit, pane1, tableHeight);
        this.viewer_1 = new TableViewer(this.ctrl_table_1);
        this.initContentProvider();
        this.initLabelProvider();
        this.viewer_1.setInput((Object)this.element);
        Composite pane2 = FormUI.createComposite(this.toolkit, sectionComposite, 68);
        this.ctrl_add_1 = FormUI.createButton(this.toolkit, pane2, PropertiesResources.Process_Add);
        this.ctrl_remove_1 = FormUI.createButton(this.toolkit, pane2, PropertiesResources.Process_Remove);
        this.toolkit.paintBordersFor(pane1);
    }

    protected void initContentProvider() {
        AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider(this.getAdapterFactory()){

            public Object[] getElements(Object object) {
                ArrayList elements = new ArrayList();
                elements.addAll(BreakdownElementGuidanceSection.this.getSelectedGuidances());
                if (BreakdownElementGuidanceSection.this.element instanceof Descriptor) {
                    MethodElement linkedElement;
                    Descriptor des = (Descriptor)BreakdownElementGuidanceSection.this.element;
                    if (BreakdownElementGuidanceSection.this.isSyncFree() && !BreakdownElementGuidanceSection.this.propUtil.isNoAutoSyn(des)) {
                        elements.addAll(des.getGuidanceExclude());
                    }
                    if ((linkedElement = ProcessUtil.getAssociatedElement((Descriptor)des)) != null) {
                        Process process = ProcessUtil.getProcess((Activity)des.getSuperActivities());
                        if (ProcessScopeUtil.getInstance().isConfigFree(process)) {
                            Map refMap = LibraryEditUtil.getInstance().getGuidanceRefMap(linkedElement.eClass());
                            HashSet set = new HashSet();
                            if (refMap != null) {
                                for (EReference ref : refMap.keySet()) {
                                    List locals;
                                    Object value = BreakdownElementGuidanceSection.this.propUtil.eGet((EObject)linkedElement, (EStructuralFeature)ref, false);
                                    if (value instanceof List) {
                                        set.addAll((List)value);
                                    }
                                    if ((locals = des.getGuidanceAdditional()) == null || locals.isEmpty()) continue;
                                    set.addAll(locals);
                                }
                            }
                            elements.retainAll(set);
                        }
                    }
                }
                return BreakdownElementGuidanceSection.this.getFilteredList(elements).toArray();
            }
        };
        this.viewer_1.setContentProvider((IContentProvider)contentProvider);
    }

    protected void initLabelProvider() {
        AdapterFactoryLabelProvider labelProvider = null;
        labelProvider = this.isSyncFree() ? new GuidanceSyncFreeLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory(), (Descriptor)this.element, this.getConfiguration()) : new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
        this.viewer_1.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    private void addListeners() {
        ItemProviderAdapter adapter = this.getAdapter();
        if (!(adapter instanceof IBSItemProvider)) {
            this.logger.logError("ActivityGuidanceSection::addListeners - IBSItemProvider is null");
            return;
        }
        IBSItemProvider bsItemProvider = (IBSItemProvider)adapter;
        bsItemProvider.getTopItem();
        this.ctrl_table_1.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                IStructuredSelection selection = (IStructuredSelection)BreakdownElementGuidanceSection.this.viewer_1.getSelection();
                if (selection.size() > 0 && BreakdownElementGuidanceSection.this.editable) {
                    BreakdownElementGuidanceSection.this.ctrl_remove_1.setEnabled(true);
                }
            }
        });
        this.viewer_1.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)BreakdownElementGuidanceSection.this.viewer_1.getSelection();
                if (selection.size() > 0 && BreakdownElementGuidanceSection.this.editable) {
                    if (BreakdownElementGuidanceSection.this.isSyncFree()) {
                        BreakdownElementGuidanceSection.this.syncFreeUpdateBtnStatus(selection);
                    } else {
                        BreakdownElementGuidanceSection.this.ctrl_remove_1.setEnabled(true);
                    }
                }
            }
        });
        this.ctrl_add_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                if (BreakdownElementGuidanceSection.this.isSyncFree() && BreakdownElementGuidanceSection.this.syncFreeAdd(selection = (IStructuredSelection)BreakdownElementGuidanceSection.this.viewer_1.getSelection())) {
                    BreakdownElementGuidanceSection.this.viewer_1.refresh();
                    return;
                }
                IFilter filter = BreakdownElementGuidanceSection.this.getGeneralGuidanceFilter();
                List existingElements = null;
                if (BreakdownElementGuidanceSection.this.isSyncFree()) {
                    existingElements = BreakdownElementGuidanceSection.this.getSelectedGuidances();
                    if (!BreakdownElementGuidanceSection.this.propUtil.isNoAutoSyn((Descriptor)BreakdownElementGuidanceSection.this.element)) {
                        existingElements.addAll(((Descriptor)BreakdownElementGuidanceSection.this.element).getGuidanceExclude());
                    }
                } else {
                    existingElements = BreakdownElementGuidanceSection.this.getSelectedGuidances();
                }
                ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), filter, BreakdownElementGuidanceSection.this.element, FilterConstants.GUIDANCE, existingElements);
                fd.setTitle(FilterConstants.GUIDANCE);
                fd.setInput(UmaUtil.getMethodLibrary((EObject)BreakdownElementGuidanceSection.this.element));
                fd.setBlockOnOpen(true);
                fd.setTypes(BreakdownElementGuidanceSection.this.getFilterTypes());
                fd.setEnableProcessScope(true);
                fd.setSection(BreakdownElementGuidanceSection.this.getSection());
                fd.open();
                BreakdownElementGuidanceSection.this.addGuidances(fd.getSelectedItems());
                BreakdownElementGuidanceSection.this.viewer_1.refresh();
            }
        });
        this.ctrl_remove_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                if (BreakdownElementGuidanceSection.this.isSyncFree() && BreakdownElementGuidanceSection.this.syncFreeRemove(selection = (IStructuredSelection)BreakdownElementGuidanceSection.this.viewer_1.getSelection())) {
                    BreakdownElementGuidanceSection.this.viewer_1.refresh();
                    BreakdownElementGuidanceSection.this.ctrl_remove_1.setEnabled(false);
                    return;
                }
                selection = (IStructuredSelection)BreakdownElementGuidanceSection.this.viewer_1.getSelection();
                if (selection.size() > 0) {
                    ArrayList rmItems = new ArrayList();
                    rmItems.addAll(selection.toList());
                    BreakdownElementGuidanceSection.this.removeGuidances(rmItems);
                    BreakdownElementGuidanceSection.this.viewer_1.refresh();
                    BreakdownElementGuidanceSection.this.viewer_1.setSelection(null, true);
                }
                BreakdownElementGuidanceSection.this.ctrl_remove_1.setEnabled(false);
            }
        });
    }

    private void addGuidances(List<Guidance> addItems) {
        this.addGuidances(addItems, false);
    }

    private void addGuidances(List<Guidance> addItems, boolean calledForExculded) {
        AddGuidanceToBreakdownElementCommand command = new AddGuidanceToBreakdownElementCommand(this.element, addItems, calledForExculded);
        this.actionMgr.execute((IResourceAwareCommand)command);
    }

    private void removeGuidances(List<Guidance> rmItems) {
        this.removeGuidances(rmItems, true);
    }

    private void removeGuidances(List<Guidance> rmItems, boolean localUse) {
        ArrayList<Practice> utdItems = new ArrayList<Practice>();
        if (!rmItems.isEmpty()) {
            for (Guidance item : rmItems) {
                TaskDescriptor greenParent;
                if (item instanceof Checklist) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Checklists(), (Object)item, -1);
                } else if (item instanceof Concept) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Concepts(), (Object)item, -1);
                } else if (item instanceof Example) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Examples(), (Object)item, -1);
                } else if (item instanceof SupportingMaterial) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_SupportingMaterials(), (Object)item, -1);
                } else if (item instanceof Guideline) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Guidelines(), (Object)item, -1);
                } else if (item instanceof ReusableAsset) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_ReusableAssets(), (Object)item, -1);
                } else if (item instanceof Template) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Templates(), (Object)item, -1);
                } else if (item instanceof Report) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Reports(), (Object)item, -1);
                } else if (item instanceof ToolMentor) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Toolmentor(), (Object)item, -1);
                } else if (item instanceof EstimationConsiderations) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Estimationconsiderations(), (Object)item, -1);
                } else if (item instanceof Practice) {
                    if (PracticePropUtil.getPracticePropUtil().isUdtType((MethodElement)((Practice)item))) {
                        utdItems.add((Practice)item);
                    }
                } else {
                    this.logger.logError("Can't remove Guidance: " + item.getType().getName() + ":" + item.getName());
                }
                if (!utdItems.isEmpty()) {
                    this.actionMgr.execute((IResourceAwareCommand)new ChangeUdtCommand((MethodElement)this.element, utdItems, true));
                }
                if (!this.isSyncFree()) continue;
                if (localUse) {
                    TaskDescriptor td;
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getDescriptor_GuidanceAdditional(), (Object)item, -1);
                    if (!(this.element instanceof TaskDescriptor) || (greenParent = (TaskDescriptor)this.propUtil.getGreenParentDescriptor((Descriptor)(td = (TaskDescriptor)this.element))) == null) continue;
                    EReference aRef = UmaPackage.eINSTANCE.getDescriptor_GuidanceAdditional();
                    List parentAdditionalList = (List)greenParent.eGet((EStructuralFeature)aRef);
                    this.propUtil.removeGreenRefDelta((Descriptor)td, (MethodElement)item, aRef, true);
                    if (parentAdditionalList == null || !parentAdditionalList.contains(item)) continue;
                    this.propUtil.addGreenRefDelta((Descriptor)td, (MethodElement)item, aRef, false);
                    continue;
                }
                this.actionMgr.doAction(3, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getDescriptor_GuidanceExclude(), (Object)item, -1);
                Descriptor parent = this.propUtil.getGreenParentDescriptor((Descriptor)this.element);
                if (parent == null || !(parent instanceof TaskDescriptor)) continue;
                greenParent = (TaskDescriptor)parent;
                EReference ref = this.propUtil.getGuidanceEReference(item);
                EReference eRef = LibraryEditUtil.getInstance().getExcludeFeature(ref);
                List parentExecludeList = (List)greenParent.eGet((EStructuralFeature)eRef);
                this.propUtil.removeGreenRefDelta((Descriptor)this.element, (MethodElement)item, eRef, false);
                if (parentExecludeList == null || parentExecludeList.contains(item)) continue;
                this.propUtil.addGreenRefDelta((Descriptor)this.element, (MethodElement)item, eRef, true);
            }
        }
    }

    private List<Guidance> getSelectedGuidances() {
        ArrayList<Guidance> itemList = new ArrayList<Guidance>();
        itemList.addAll(this.element.getChecklists());
        itemList.addAll(this.element.getConcepts());
        itemList.addAll(this.element.getExamples());
        itemList.addAll(this.element.getGuidelines());
        itemList.addAll(this.element.getReusableAssets());
        itemList.addAll(this.element.getSupportingMaterials());
        itemList.addAll(this.element.getTemplates());
        itemList.addAll(this.element.getReports());
        itemList.addAll(this.element.getEstimationconsiderations());
        itemList.addAll(this.element.getToolmentor());
        if (this.propUtil.hasUdtList((MethodElement)this.element)) {
            itemList.addAll(this.propUtil.getUdtList((MethodElement)this.element, false));
        }
        return itemList;
    }

    protected String[] getFilterTypes() {
        String[] str = new String[12];
        int i = 0;
        str[i++] = FilterConstants.GUIDANCE;
        str[i++] = "-" + FilterConstants.CHECKLISTS;
        str[i++] = "-" + FilterConstants.CONCEPTS;
        str[i++] = "-" + FilterConstants.ESTIMATE_CONSIDERATIONS;
        str[i++] = "-" + FilterConstants.EXAMPLES;
        str[i++] = "-" + FilterConstants.GUIDELINES;
        str[i++] = "-" + FilterConstants.REPORTS;
        str[i++] = "-" + FilterConstants.REUSABLE_ASSETS;
        str[i++] = "-" + FilterConstants.SUPPORTING_MATERIALS;
        str[i++] = "-" + FilterConstants.TEMPLATES;
        str[i++] = "-" + FilterConstants.TOOL_MENTORS;
        str[i++] = "-" + FilterConstants.WHITE_PAPERS;
        return str;
    }

    @Override
    protected boolean isSyncFree() {
        return this.propUtil.isDescriptor(this.element) && ProcessUtil.isSynFree();
    }

    protected boolean syncFreeAdd(IStructuredSelection selection) {
        EReference ref;
        if (selection.size() == 0) {
            return false;
        }
        boolean result = this.propUtil.CheckSelectionForGuidance(selection.toList(), (Descriptor)this.element, this.getConfiguration());
        if (!result) {
            return true;
        }
        Object testObj = selection.getFirstElement();
        if (this.propUtil.isDynamicAndExclude(testObj, (Descriptor)this.element, ref = this.propUtil.getGuidanceEReference((Guidance)testObj), this.getConfiguration())) {
            this.addGuidances(selection.toList(), true);
            return true;
        }
        return false;
    }

    protected boolean syncFreeRemove(IStructuredSelection selection) {
        EReference ref;
        if (selection.size() == 0) {
            return true;
        }
        boolean result = this.propUtil.CheckSelectionForGuidance(selection.toList(), (Descriptor)this.element, this.getConfiguration());
        if (!result) {
            return true;
        }
        Object testObj = selection.getFirstElement();
        if (this.propUtil.isDynamicAndExclude(testObj, (Descriptor)this.element, ref = this.propUtil.getGuidanceEReference((Guidance)testObj), this.getConfiguration())) {
            return true;
        }
        if (this.propUtil.isGuidanceDynamic(testObj, (Descriptor)this.element, this.getConfiguration())) {
            this.removeGuidances(selection.toList(), false);
            return true;
        }
        return false;
    }

    protected void syncFreeUpdateBtnStatus(IStructuredSelection selection) {
        boolean result = this.propUtil.CheckSelectionForGuidance(selection.toList(), (Descriptor)this.element, this.getConfiguration());
        if (!result) {
            this.ctrl_add_1.setEnabled(false);
            this.ctrl_remove_1.setEnabled(false);
        } else {
            EReference ref;
            Object testObj = selection.getFirstElement();
            if (this.propUtil.isDynamicAndExclude(testObj, (Descriptor)this.element, ref = this.propUtil.getGuidanceEReference((Guidance)testObj), this.getConfiguration())) {
                this.ctrl_add_1.setEnabled(true);
                this.ctrl_remove_1.setEnabled(false);
            } else {
                this.ctrl_add_1.setEnabled(true);
                this.ctrl_remove_1.setEnabled(true);
            }
        }
    }

    public class GuidanceSyncFreeLabelProvider
    extends AdapterFactoryLabelProvider
    implements ITableFontProvider {
        private DescriptorPropUtil propUtil;
        private Font systemFont;
        private Font boldFont;
        private Font boldAndItalicFont;
        private Descriptor desc;
        private MethodConfiguration config;

        public GuidanceSyncFreeLabelProvider(AdapterFactory adapterFactory, Descriptor desc, MethodConfiguration config) {
            super(adapterFactory);
            this.propUtil = DescriptorPropUtil.getDesciptorPropUtil();
            this.systemFont = Display.getCurrent().getSystemFont();
            this.boldFont = null;
            this.boldAndItalicFont = null;
            this.desc = desc;
            this.config = config;
            this.boldFont = this.createFont(1);
            this.boldAndItalicFont = this.createFont(3);
        }

        public Font getFont(Object obj, int columnIndex) {
            if (this.propUtil.isGuidanceFromGreenParentLocalList(obj, this.desc, this.config)) {
                return this.boldAndItalicFont;
            }
            if (!this.propUtil.isGuidanceDynamic(obj, this.desc, this.config)) {
                return this.boldFont;
            }
            return this.systemFont;
        }

        public String getColumnText(Object obj, int columnIndex) {
            String original = super.getColumnText(obj, columnIndex);
            EReference ref = this.propUtil.getGuidanceEReference((Guidance)obj);
            if (this.propUtil.isDynamicAndExclude(obj, this.desc, ref, this.config)) {
                return "--<" + original + ">";
            }
            return original;
        }

        public void dispose() {
            super.dispose();
            if (this.boldFont != null) {
                this.boldFont.dispose();
            }
            if (this.boldAndItalicFont != null) {
                this.boldAndItalicFont.dispose();
            }
        }

        private Font createFont(int style) {
            FontData[] fontdata;
            FontData[] fontDataArray = fontdata = this.systemFont.getFontData();
            int n = fontdata.length;
            int n2 = 0;
            while (n2 < n) {
                FontData data = fontDataArray[n2];
                data.setStyle(style);
                ++n2;
            }
            return new Font((Device)Display.getCurrent(), fontdata);
        }
    }
}

