/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.filters.DescriptorProcessFilter;
import org.eclipse.epf.authoring.ui.properties.OBSRelationSection;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CompositeRole;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class CompositeRoleRoleSection
extends OBSRelationSection {
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
    }

    protected void initContentProvider() {
        this.contentProvider = new AdapterFactoryContentProvider(this.getAdapterFactory()){

            public Object[] getElements(Object object) {
                CompositeRoleRoleSection.this.element = CompositeRoleRoleSection.this.getElement();
                return CompositeRoleRoleSection.this.getFilteredList(((CompositeRole)CompositeRoleRoleSection.this.element).getAggregatedRoles()).toArray();
            }
        };
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
    }

    protected void init() {
        super.init();
        this.element = (CompositeRole)this.element;
        String title = PropertiesResources.CompositeRole_Role_SectionTitle;
        String desc = PropertiesResources.CompositeRole_Role_SectionDescription;
        String table1 = PropertiesResources.CompositeRole_Role_Table1;
        this.setTabData(title, desc, table1);
        this.showAddFromProcessButton = true;
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof CompositeRole) {
                super.refresh();
                this.element = (CompositeRole)this.getElement();
                this.viewer.refresh();
            }
        }
        catch (Exception ex) {
            this.logger.logError("Error refreshing Composite role - role sectin ", (Throwable)ex);
        }
    }

    private void add(List items) {
        if (items != null) {
            for (Object obj : items) {
                if (obj instanceof Role) {
                    this.actionMgr.doAction(3, (EObject)((CompositeRole)this.element), (EStructuralFeature)UmaPackage.eINSTANCE.getCompositeRole_AggregatedRoles(), (Object)((Role)obj), -1);
                    continue;
                }
                if (!(obj instanceof RoleDescriptor)) continue;
                Role role = ((RoleDescriptor)obj).getRole();
                if (role != null) {
                    this.actionMgr.doAction(3, (EObject)((CompositeRole)this.element), (EStructuralFeature)UmaPackage.eINSTANCE.getCompositeRole_AggregatedRoles(), (Object)role, -1);
                    continue;
                }
                MessageFormat mf = new MessageFormat(PropertiesResources.Process_CompositeRoleAssignError);
                Object[] args = new Object[]{((RoleDescriptor)obj).getName(), ((CompositeRole)this.element).getName()};
                AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(PropertiesResources.Process_AssignmentInfoTitle, mf.format(args));
            }
        }
    }

    protected void remove(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            for (Role role : rmItems) {
                this.actionMgr.doAction(4, (EObject)((CompositeRole)this.element), (EStructuralFeature)UmaPackage.eINSTANCE.getCompositeRole_AggregatedRoles(), (Object)role, -1);
            }
        }
    }

    protected void openAddDialog() {
        List existingElements = ((CompositeRole)this.element).getAggregatedRoles();
        ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.getFilter(), this.element, FilterConstants.ROLES, existingElements);
        fd.setBlockOnOpen(true);
        fd.setTitle(FilterConstants.ROLES);
        fd.open();
        this.add(fd.getSelectedItems());
    }

    private List getExistingElements() {
        return null;
    }

    protected void openAddFromProcessDialog() {
        String tabName = FilterConstants.ROLE_DESCRIPTORS;
        List existingElements = this.getExistingElements();
        Process process = (Process)this.getProcess(this.element);
        IFilter descriptorFilter = this.getDescriptorFilter();
        if (descriptorFilter != null && process != null) {
            ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), descriptorFilter, process, tabName, existingElements);
            fd.setBlockOnOpen(true);
            fd.setTitle(FilterConstants.ROLE_DESCRIPTORS);
            fd.open();
            this.add(fd.getSelectedItems());
        }
    }

    protected Object getProcess(BreakdownElement element) {
        ComposedAdapterFactory aFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        ItemProviderAdapter adapter = (ItemProviderAdapter)aFactory.adapt((Notifier)element, ITreeItemContentProvider.class);
        Object parent = adapter.getParent((Object)element);
        if (parent instanceof Process) {
            return parent;
        }
        return this.getProcess((BreakdownElement)parent);
    }

    protected IFilter getDescriptorFilter() {
        return new DescriptorProcessFilter(this.getConfiguration()){

            protected boolean childAccept(Object obj) {
                if (obj instanceof Activity) {
                    ArrayList list = new ArrayList();
                    this.getActivitiesInScope((AdapterFactory)TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory(), CompositeRoleRoleSection.this.element, list);
                    return list.contains(obj);
                }
                if (obj instanceof CompositeRole && obj.equals(CompositeRoleRoleSection.this.element)) {
                    return false;
                }
                return obj instanceof RoleDescriptor;
            }
        };
    }
}

