/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.filters.DescriptorConfigurationFilter;
import org.eclipse.epf.authoring.ui.filters.DescriptorProcessFilter;
import org.eclipse.epf.authoring.ui.filters.ProcessWorkProductFilter;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.authoring.ui.properties.RelationSection;
import org.eclipse.epf.authoring.ui.properties.TaskDescriptorWorkProductSection;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.process.ActivityWrapperItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.WorkProductDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.AssignWPToMilestone;
import org.eclipse.epf.library.edit.util.MilestonePropUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.util.WorkProductPropUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Constraint;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class MilestoneWorkProductSection
extends RelationSection {
    private IFilter filter = null;
    private Milestone milestone;
    private Button ctrl_state_1;

    public IFilter getFilter() {
        if (this.filter == null) {
            this.filter = new ProcessWorkProductFilter(this.getConfiguration(), null, FilterConstants.WORKPRODUCTS);
        } else if (this.filter instanceof DescriptorConfigurationFilter) {
            ((DescriptorConfigurationFilter)this.filter).setMethodConfiguration(this.getConfiguration());
        }
        return this.filter;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
    }

    protected void initContentProvider1() {
        this.contentProvider = new AdapterFactoryContentProvider(this.getAdapterFactory()){

            public Object[] getElements(Object object) {
                return MilestoneWorkProductSection.this.getFilteredList(MilestoneWorkProductSection.this.milestone.getRequiredResults()).toArray();
            }
        };
        this.tableViewer1.setContentProvider((IContentProvider)this.contentProvider);
    }

    protected void initLabelProvider1() {
        AdapterFactoryLabelProvider provider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory()){

            public String getColumnText(Object obj, int columnIndex) {
                String label = super.getColumnText(obj, columnIndex);
                if (obj instanceof WorkProductDescriptor) {
                    label = MilestoneWorkProductSection.this.getLabelForWpd((WorkProductDescriptor)obj, label, UmaPackage.eINSTANCE.getMilestone_RequiredResults());
                }
                return label;
            }
        };
        this.tableViewer1.setLabelProvider((IBaseLabelProvider)provider);
    }

    protected void init() {
        if (this.getElement() instanceof Milestone) {
            this.milestone = (Milestone)this.getElement();
        }
        super.init();
        int numOfTables = 1;
        this.setTabData(PropertiesResources.RoleDescriptor_WorkProducts_SectionTitle, PropertiesResources.Milestone_WorkProducts_SectionDescription, PropertiesResources.Milestone_WorkProducts_Table1, null, null, null, FilterConstants.WORKPRODUCTS);
        boolean[] changesAllowed = new boolean[]{true};
        this.setTableData(numOfTables, changesAllowed);
    }

    public void refresh() {
        if (this.getElement() instanceof Milestone) {
            this.milestone = (Milestone)this.getElement();
        }
        super.refresh();
    }

    protected List getDescriptorsFromProcess() {
        ArrayList items = new ArrayList();
        return ProcessUtil.getElementsInScope((AdapterFactory)this.getAdapterFactory(), (BreakdownElement)this.milestone, WorkProductDescriptor.class, items);
    }

    protected void addItems1(List items) {
        if (!items.isEmpty()) {
            AssignWPToMilestone cmd = new AssignWPToMilestone((Milestone)this.element, items, 8, this.getConfiguration());
            this.actionMgr.execute((IResourceAwareCommand)cmd);
        }
    }

    protected void removeItems1(List items) {
        if (!items.isEmpty()) {
            this.actionMgr.doAction(6, (EObject)this.milestone, (EStructuralFeature)UmaPackage.eINSTANCE.getMilestone_RequiredResults(), (Object)items, -1);
        }
    }

    private List getWorkProducts(List items) {
        ArrayList<WorkProduct> wpList = new ArrayList<WorkProduct>();
        if (!items.isEmpty()) {
            int i = 0;
            while (i < items.size()) {
                wpList.add(((WorkProductDescriptor)items.get(i)).getWorkProduct());
                ++i;
            }
        }
        return wpList;
    }

    protected List getExistingElements1() {
        return this.getWorkProducts(this.milestone.getRequiredResults());
    }

    protected Process getProcess() {
        ComposedAdapterFactory aFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        ItemProviderAdapter adapter = (ItemProviderAdapter)aFactory.adapt((Notifier)this.milestone, ITreeItemContentProvider.class);
        Object obj = ProcessUtil.getRootProcess((AdapterFactory)aFactory, (ItemProviderAdapter)adapter, (Object)this.milestone);
        return (Process)obj;
    }

    protected IFilter getFilterForDescriptors() {
        return new DescriptorProcessFilter(this.getConfiguration()){

            protected boolean childAccept(Object obj) {
                if (obj instanceof Activity) {
                    ArrayList list = new ArrayList();
                    this.getActivitiesInScope((AdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), (BreakdownElement)MilestoneWorkProductSection.this.milestone, list);
                    return list.contains(obj);
                }
                if (obj instanceof ActivityWrapperItemProvider || obj instanceof WorkProductDescriptorWrapperItemProvider) {
                    Object object = ((BreakdownElementWrapperItemProvider)obj).getParent(obj);
                    ArrayList list = new ArrayList();
                    this.getActivitiesInScope((AdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), MilestoneWorkProductSection.this.element, list);
                    if (list.contains(object)) {
                        return true;
                    }
                }
                return obj instanceof WorkProductDescriptor;
            }

            protected void getActivitiesInScope(AdapterFactory adapterFactory, BreakdownElement element, List activityList) {
                this.getParentActivitiesInScope(adapterFactory, element, activityList);
                ItemProviderAdapter adapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)element, ITreeItemContentProvider.class);
                Object parent = adapter.getParent((Object)element);
                this.getChildrenActivitiesInScope(adapterFactory, (BreakdownElement)parent, activityList);
            }

            private void getParentActivitiesInScope(AdapterFactory adapterFactory, BreakdownElement element, List activityList) {
                ItemProviderAdapter adapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)element, ITreeItemContentProvider.class);
                Object parent = adapter.getParent((Object)element);
                if (parent instanceof Activity && !activityList.contains(parent)) {
                    activityList.add(parent);
                    this.getParentActivitiesInScope(adapterFactory, (BreakdownElement)parent, activityList);
                }
            }

            private void getChildrenActivitiesInScope(AdapterFactory adapterFactory, BreakdownElement element, List activityList) {
                ItemProviderAdapter adapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)element, ITreeItemContentProvider.class);
                List children = (List)adapter.getChildren((Object)element);
                if (!children.isEmpty() && children.size() > 0) {
                    int i = 0;
                    while (i < children.size()) {
                        Object child = children.get(i);
                        if (child instanceof Activity && !activityList.contains(child)) {
                            activityList.add(child);
                            this.getChildrenActivitiesInScope(adapterFactory, (BreakdownElement)child, activityList);
                        }
                        if (child instanceof ActivityWrapperItemProvider) {
                            activityList.add(TngUtil.unwrap(child));
                            this.getChildrenActivitiesInScope(adapterFactory, (ActivityWrapperItemProvider)child, activityList);
                        }
                        ++i;
                    }
                }
            }

            private void getChildrenActivitiesInScope(AdapterFactory adapterFactory, ActivityWrapperItemProvider provider, List activityList) {
                List children = (List)provider.getChildren((Object)MilestoneWorkProductSection.this.element);
                if (!children.isEmpty() && children.size() > 0) {
                    int i = 0;
                    while (i < children.size()) {
                        Object child = children.get(i);
                        if (child instanceof Activity && !activityList.contains(child)) {
                            activityList.add(child);
                            this.getChildrenActivitiesInScope(adapterFactory, (BreakdownElement)child, activityList);
                        }
                        if (child instanceof ActivityWrapperItemProvider) {
                            activityList.add(TngUtil.unwrap(child));
                            this.getChildrenActivitiesInScope(adapterFactory, (ActivityWrapperItemProvider)child, activityList);
                        }
                        ++i;
                    }
                }
            }
        };
    }

    protected String getDescriptorTabName() {
        return FilterConstants.WORK_PRODUCT_DESCRIPTORS;
    }

    protected void addFromProcessItems1(List items) {
        if (!items.isEmpty()) {
            this.actionMgr.doAction(5, (EObject)this.milestone, (EStructuralFeature)UmaPackage.eINSTANCE.getMilestone_RequiredResults(), (Object)items, -1);
        }
    }

    private String getLabelForWpd(WorkProductDescriptor wpd, String orginalLabel, EReference ref) {
        List states = MilestonePropUtil.getMilestonePropUtil((IActionManager)this.actionMgr).getWpStates((Milestone)this.element, wpd, ref);
        if (states.size() > 0) {
            String stateName = ((Constraint)states.get(0)).getBody();
            return String.valueOf(orginalLabel) + " [" + stateName + "]";
        }
        return orginalLabel;
    }

    protected void createAddtionalButton1(Composite parent) {
        this.ctrl_state_1 = FormUI.createButton(this.toolkit, parent, PropertiesResources.Process_AssignState);
        this.ctrl_state_1.setEnabled(false);
        final EReference ref = UmaPackage.eINSTANCE.getMilestone_RequiredResults();
        this.ctrl_state_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MilestoneWorkProductSection.this.assignState(MilestoneWorkProductSection.this.tableViewer1, ref);
            }
        });
        this.tableViewer1.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)MilestoneWorkProductSection.this.tableViewer1.getSelection();
                if (selection.size() == 1 && MilestoneWorkProductSection.this.editable) {
                    MilestoneWorkProductSection.this.ctrl_state_1.setEnabled(true);
                } else {
                    MilestoneWorkProductSection.this.ctrl_state_1.setEnabled(false);
                }
            }
        });
    }

    private void assignState(TableViewer viewer, EReference ref) {
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        if (selection.size() == 1 && selection.getFirstElement() instanceof WorkProductDescriptor) {
            WorkProductDescriptor wpd = (WorkProductDescriptor)selection.getFirstElement();
            TaskDescriptorWorkProductSection.StateSelectionDialog dialog = new TaskDescriptorWorkProductSection.StateSelectionDialog(viewer.getTable().getShell(), this.getLabelProviderForStateSelectionDialog());
            dialog.setElements(this.getInputForStateSelectionDialog(wpd, ref).toArray());
            dialog.setMultipleSelection(false);
            dialog.setMessage(PropertiesResources.Process_SelectStateDialog_Message);
            dialog.setTitle(PropertiesResources.Process_SelectStateDialog_Title);
            dialog.setImage(null);
            if (dialog.open() == 1) {
                return;
            }
            Object[] objs = dialog.getResult();
            Constraint newState = (Constraint)objs[0];
            List oldStates = MilestonePropUtil.getMilestonePropUtil((IActionManager)this.actionMgr).getWpStates((Milestone)this.element, wpd, ref);
            for (Constraint oldState : oldStates) {
                MilestonePropUtil.getMilestonePropUtil((IActionManager)this.actionMgr).removeWpState((Milestone)this.element, wpd, oldState, ref);
            }
            if (!newState.getName().equals("UnassignState")) {
                MilestonePropUtil.getMilestonePropUtil((IActionManager)this.actionMgr).addWpState((Milestone)this.element, wpd, newState, ref);
            }
            viewer.refresh();
        }
    }

    private ILabelProvider getLabelProviderForStateSelectionDialog() {
        AdapterFactoryLabelProvider provider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.createLibraryComposedAdapterFactory()){

            public String getText(Object element) {
                if (element instanceof Constraint) {
                    return ((Constraint)element).getBody();
                }
                return super.getText(element);
            }
        };
        return provider;
    }

    private List getInputForStateSelectionDialog(WorkProductDescriptor wpd, EReference ref) {
        ArrayList<Constraint> elements = new ArrayList<Constraint>();
        List oldStates = MilestonePropUtil.getMilestonePropUtil((IActionManager)this.actionMgr).getWpStates((Milestone)this.element, wpd, ref);
        WorkProduct wp = (WorkProduct)this.propUtil.getLinkedElement((Descriptor)wpd);
        if (wp != null) {
            Set states = WorkProductPropUtil.getWorkProductPropUtil((IActionManager)this.actionMgr).getAllStates(wp);
            states.removeAll(oldStates);
            elements.addAll(states);
        }
        elements.add(TaskDescriptorWorkProductSection.createUnassignState());
        return elements;
    }
}

