/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.util.List;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.properties.RemoveDescriptorCommand;
import org.eclipse.epf.library.edit.util.DescriptorPropUtil;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.TaskDescriptor;

public class MoveDescriptorCommand
extends RemoveDescriptorCommand {
    private Descriptor desc;
    private List items;
    private List methodElements;
    private int toFeature;
    private DescriptorPropUtil propUtil = DescriptorPropUtil.getDesciptorPropUtil();

    public MoveDescriptorCommand(Descriptor desc, List items, int fromFeature, int toFeature) {
        super(desc, items, fromFeature, false);
        this.desc = desc;
        this.items = items;
        this.methodElements = ProcessUtil.getAssociatedElementList((List)items);
        this.toFeature = toFeature;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        Descriptor parent;
        super.redo();
        EStructuralFeature feature = this.desc.eClass().getEStructuralFeature(this.toFeature);
        Object value = this.desc.eGet(feature);
        if (value instanceof List) {
            List listValue = (List)value;
            listValue.addAll(this.methodElements);
        }
        if ((parent = this.propUtil.getGreenParentDescriptor(this.desc)) != null && parent instanceof TaskDescriptor) {
            TaskDescriptor greenParent = (TaskDescriptor)parent;
            EReference ref = (EReference)greenParent.eClass().getEStructuralFeature(this.getFeatureID());
            EReference eRef = LibraryEditUtil.getInstance().getExcludeFeature(ref);
            List parentExecludeList = (List)greenParent.eGet((EStructuralFeature)eRef);
            for (MethodElement elem : this.methodElements) {
                this.propUtil.removeGreenRefDelta(this.desc, elem, eRef, false);
                if (parentExecludeList == null || parentExecludeList.contains(elem)) continue;
                this.propUtil.addGreenRefDelta(this.desc, elem, eRef, true);
            }
        }
    }

    public void undo() {
        Descriptor parent;
        super.undo();
        EStructuralFeature feature = this.desc.eClass().getEStructuralFeature(this.toFeature);
        Object value = this.desc.eGet(feature);
        if (value instanceof List) {
            List listValue = (List)value;
            listValue.removeAll(this.methodElements);
        }
        if ((parent = this.propUtil.getGreenParentDescriptor(this.desc)) != null && parent instanceof TaskDescriptor) {
            TaskDescriptor greenParent = (TaskDescriptor)parent;
            EReference ref = (EReference)greenParent.eClass().getEStructuralFeature(this.getFeatureID());
            EReference eRef = LibraryEditUtil.getInstance().getExcludeFeature(ref);
            List parentExecludeList = (List)greenParent.eGet((EStructuralFeature)eRef);
            for (MethodElement elem : this.methodElements) {
                this.propUtil.addGreenRefDelta(this.desc, elem, eRef, false);
                if (parentExecludeList == null || parentExecludeList.contains(elem)) continue;
                this.propUtil.removeGreenRefDelta(this.desc, elem, eRef, true);
            }
        }
    }
}

