/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.properties.PredecessorMap;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkOrderType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PredecessorDialog
extends Dialog {
    private Text predIdText;
    private Text presentationName;
    private Combo dependency;
    private static final String FINISH_TO_START = PropertiesResources.WorkOrderType_FINISH_TO_START;
    private static final String FINISH_TO_FINISH = PropertiesResources.WorkOrderType_FINISH_TO_FINISH;
    private static final String START_TO_START = PropertiesResources.WorkOrderType_START_TO_START;
    private static final String START_TO_FINISH = PropertiesResources.WorkOrderType_START_TO_FINISH;
    private String[] dependencyList = new String[]{FINISH_TO_START, FINISH_TO_FINISH, START_TO_START, START_TO_FINISH};
    private WorkBreakdownElement element;
    private Object process;
    private AdapterFactory adapterFactory;
    private List predecessors = new ArrayList();
    private List predMapList;
    private IActionManager actionMgr;
    private PredecessorMap predMap;

    public PredecessorDialog(Shell parentShell, WorkBreakdownElement element, Object process, AdapterFactory adapterFactory, PredecessorMap predMap, List predMapList, IActionManager actionMgr) {
        super(parentShell);
        this.element = element;
        this.process = process;
        this.adapterFactory = adapterFactory;
        this.predMap = predMap;
        this.predMapList = predMapList;
        this.actionMgr = actionMgr;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        Label label = new Label(composite, 0);
        label.setText(PropertiesResources.PredecessorDialog_HeaderMessage);
        gridData = new GridData(1);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData(1);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText(PropertiesResources.PredecessorDialog_Index);
        gridData = new GridData(1);
        label.setLayoutData((Object)gridData);
        this.predIdText = new Text(composite, 2048);
        gridData = new GridData(512);
        gridData.widthHint = 100;
        this.predIdText.setLayoutData((Object)gridData);
        this.predIdText.setText(new Integer(this.predMap.getId()).toString());
        label = new Label(composite, 0);
        label.setText(PropertiesResources.PredecessorDialog_PresentationName);
        gridData = new GridData(1);
        label.setLayoutData((Object)gridData);
        this.presentationName = new Text(composite, 2048);
        gridData = new GridData(512);
        gridData.widthHint = 400;
        this.presentationName.setEditable(false);
        this.presentationName.setLayoutData((Object)gridData);
        WorkOrder wo = this.predMap.getWorkOrder();
        this.presentationName.setText(ProcessUtil.getPresentationName((BreakdownElement)wo.getPred()));
        label = new Label(composite, 0);
        label.setText(PropertiesResources.PredecessorDialog_Dependency);
        gridData = new GridData(1);
        label.setLayoutData((Object)gridData);
        this.dependency = new Combo(composite, 12);
        gridData = new GridData(1);
        this.dependency.setLayoutData((Object)gridData);
        this.dependency.setItems(this.dependencyList);
        String depedencyName = wo.getLinkType().getName();
        if (wo.getLinkType() == WorkOrderType.FINISH_TO_FINISH) {
            depedencyName = FINISH_TO_FINISH;
        } else if (wo.getLinkType() == WorkOrderType.FINISH_TO_START) {
            depedencyName = FINISH_TO_START;
        } else if (wo.getLinkType() == WorkOrderType.START_TO_FINISH) {
            depedencyName = START_TO_FINISH;
        } else if (wo.getLinkType() == WorkOrderType.START_TO_START) {
            depedencyName = START_TO_START;
        }
        this.dependency.setText(depedencyName);
        Label line = new Label(composite, 259);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        line.setLayoutData((Object)gridData);
        this.predIdText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                int newId;
                try {
                    newId = new Integer(PredecessorDialog.this.predIdText.getText());
                    if (newId < 0) {
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(PropertiesResources.Process_predecessors_validNumberTitle, PropertiesResources.Process_predecessors_validNumberMessage);
                    PredecessorDialog.this.predIdText.setText(new Integer(PredecessorDialog.this.predMap.getId()).toString());
                    PredecessorDialog.this.predIdText.setFocus();
                    PredecessorDialog.this.predIdText.selectAll();
                    return;
                }
                if (PredecessorDialog.this.alreadyExists(newId)) {
                    PredecessorDialog.this.predIdText.setText(new Integer(PredecessorDialog.this.predMap.getId()).toString());
                    PredecessorDialog.this.predIdText.selectAll();
                    return;
                }
                String predIDList = PredecessorDialog.this.getPredId(newId);
                if (predIDList == null) {
                    return;
                }
                String str = ProcessUtil.checkPredecessorList((WorkBreakdownElement)PredecessorDialog.this.element, (String)predIDList, (AdapterFactory)PredecessorDialog.this.adapterFactory, (Object)PredecessorDialog.this.process, (List)PredecessorDialog.this.predecessors);
                if (str != null) {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(PropertiesResources.PredecessorDialog_PredecessorErrorDialogTitle, str);
                    PredecessorDialog.this.predIdText.setText(new Integer(PredecessorDialog.this.predMap.getId()).toString());
                    return;
                }
                PredecessorDialog.this.presentationName.setText(PredecessorDialog.this.getName(newId));
            }
        });
        return composite;
    }

    private String getName(int newId) {
        String name = null;
        AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator(this.adapterFactory, this.process);
        while (iter.hasNext()) {
            Object obj = iter.next();
            IBSItemProvider itemProvider = (IBSItemProvider)this.adapterFactory.adapt(obj, ITreeItemContentProvider.class);
            Integer id = new Integer(itemProvider.getId());
            obj = TngUtil.unwrap(obj);
            if (newId != id || !StrUtil.isBlank((String)(name = ((BreakdownElement)obj).getPresentationName()))) continue;
            name = ((BreakdownElement)obj).getName();
        }
        return name;
    }

    private boolean alreadyExists(int newId) {
        for (PredecessorMap map : this.predMapList) {
            if (map.getId() != newId || this.predMap.getId() == newId) continue;
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(PropertiesResources.PredecessorDialog_PredecessorErrorDialogTitle, PropertiesResources.PredecessorDialog_PredecessorErrorMessage);
            return true;
        }
        return false;
    }

    private String getPredId(int newId) {
        StringBuffer buf = new StringBuffer();
        for (PredecessorMap map : this.predMapList) {
            if (this.predMap.getId() == map.getId()) {
                buf.append(newId);
            } else {
                buf.append(map.getId());
            }
            buf.append(",");
        }
        return buf.toString();
    }

    protected void configureShell(Shell parent) {
        super.configureShell(parent);
        parent.setText(PropertiesResources.PredecessorDialog_Title);
    }

    protected void okPressed() {
        int newId = new Integer(this.predIdText.getText());
        WorkOrderType workOrderType = this.getWorkOrderType();
        if (newId != this.predMap.getId() || !workOrderType.equals((Object)this.predMap.getWorkOrder().getLinkType())) {
            boolean status;
            String predIDList = this.getPredId(newId);
            if (predIDList == null) {
                return;
            }
            String str = ProcessUtil.checkPredecessorList((WorkBreakdownElement)this.element, (String)predIDList, (AdapterFactory)this.adapterFactory, (Object)this.process, (List)this.predecessors);
            if (str != null) {
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(PropertiesResources.PredecessorDialog_PredecessorErrorDialogTitle, str);
                this.predIdText.setText(new Integer(this.predMap.getId()).toString());
            }
            if (!(status = this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_LinkToPredecessor(), (Object)this.predMap.getWorkOrder(), -1))) {
                this.close();
                return;
            }
            this.predMapList.remove(this.predMap);
            int size = this.predecessors.size();
            int i = 0;
            while (i < size) {
                WorkBreakdownElement e = (WorkBreakdownElement)this.predecessors.get(i);
                boolean found = false;
                for (WorkOrder wo : this.element.getLinkToPredecessor()) {
                    if (wo.getPred() != e) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    WorkOrder wo = UmaFactory.eINSTANCE.createWorkOrder();
                    wo.setPred(e);
                    wo.setLinkType(workOrderType);
                    boolean stat = this.actionMgr.doAction(3, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_LinkToPredecessor(), (Object)wo, -1);
                    if (!stat) {
                        return;
                    }
                    this.predMap.setId(newId);
                    this.predMap.setWorkOrder(wo);
                    this.predMapList.add(this.predMap);
                }
                ++i;
            }
        }
        super.okPressed();
    }

    private WorkOrderType getWorkOrderType() {
        int index = this.dependency.getSelectionIndex();
        WorkOrderType type = index == 0 ? WorkOrderType.FINISH_TO_START : (index == 1 ? WorkOrderType.FINISH_TO_FINISH : (index == 2 ? WorkOrderType.START_TO_START : WorkOrderType.START_TO_FINISH));
        return type;
    }

    public boolean close() {
        return super.close();
    }
}

