/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.library.edit.util.DescriptorPropUtil;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class SyncFreeLabelProvider
extends AdapterFactoryLabelProvider
implements ITableFontProvider {
    private DescriptorPropUtil propUtil = DescriptorPropUtil.getDesciptorPropUtil();
    private Font systemFont = Display.getCurrent().getSystemFont();
    private Font boldFont = null;
    private Font boldAndItalicFont = null;
    private Descriptor desc;
    private EReference ref;
    private MethodConfiguration config;

    public SyncFreeLabelProvider(AdapterFactory adapterFactory, Descriptor desc, EReference ref, MethodConfiguration config) {
        super(adapterFactory);
        this.desc = desc;
        this.ref = ref;
        this.config = config;
        this.boldFont = this.createFont(1);
        this.boldAndItalicFont = this.createFont(3);
    }

    public Font getFont(Object obj, int columnIndex) {
        if (this.propUtil.isFromGreenParentLocalList(obj, this.desc, this.ref)) {
            return this.boldAndItalicFont;
        }
        if (!this.propUtil.isDynamic(obj, this.desc, this.ref)) {
            return this.boldFont;
        }
        return this.systemFont;
    }

    public String getColumnText(Object obj, int columnIndex) {
        String original = super.getColumnText(obj, columnIndex);
        if (this.propUtil.isDynamicAndExclude(obj, this.desc, this.ref, this.config)) {
            return "--<" + original + ">";
        }
        return original;
    }

    public void dispose() {
        super.dispose();
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        if (this.boldAndItalicFont != null) {
            this.boldAndItalicFont.dispose();
        }
    }

    private Font createFont(int style) {
        FontData[] fontdata;
        FontData[] fontDataArray = fontdata = this.systemFont.getFontData();
        int n = fontdata.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setStyle(style);
            ++n2;
        }
        return new Font((Device)Display.getCurrent(), fontdata);
    }
}

