/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.providers;

import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.providers.ConfigPackageContentProvider;
import org.eclipse.epf.library.configuration.closure.ConfigurationClosure;
import org.eclipse.epf.library.configuration.closure.ElementDependencyError;
import org.eclipse.epf.library.edit.navigator.ConfigContentPackageItemProvider;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ConfigPackageLabelProvider
extends LabelProvider {
    private ConfigurationClosure closure = null;
    private ConfigPackageContentProvider contentProvider;
    private AdapterFactoryLabelProvider afProvider;

    public ConfigPackageLabelProvider(ConfigPackageContentProvider contentProvider) {
        this.contentProvider = contentProvider;
        this.afProvider = new AdapterFactoryLabelProvider(contentProvider.getAdapterFactory());
    }

    private ElementDependencyError getFirstChildError(Object e) {
        ElementDependencyError error = null;
        Object[] children = this.contentProvider.getChildren(e);
        if (children == null || children.length == 0) {
            return null;
        }
        int i = 0;
        while (i < children.length) {
            Object object = children[i];
            if (object instanceof ItemProviderAdapter) {
                return this.getFirstChildError(object);
            }
            error = this.closure.getError(object);
            if (error != null) {
                return error;
            }
            ++i;
        }
        return error;
    }

    public Image getImage(Object object) {
        if (this.closure != null) {
            ElementDependencyError error = null;
            error = object instanceof ItemProviderAdapter ? this.getFirstChildError(object) : this.closure.getError(object);
            if (error != null) {
                if (error.isError() || error.isChildError()) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                }
                if (error.isWarning() || error.isChildWarning()) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                }
            }
        }
        return this.afProvider.getImage(object);
    }

    protected Image getImageFromObject(Object object) {
        return ExtendedImageRegistry.getInstance().getImage(object);
    }

    public String getText(Object object) {
        if (object instanceof ConfigContentPackageItemProvider.LeafElementsItemProvider) {
            return AuthoringUIResources.LeafElementsNode_text;
        }
        if (object instanceof ProcessComponent) {
            Process proc = ((ProcessComponent)object).getProcess();
            if (proc != null) {
                return proc.getPresentationName();
            }
            return ((ProcessComponent)object).getName();
        }
        return this.afProvider.getText(object);
    }

    public void dispose() {
        super.dispose();
        this.contentProvider = null;
        this.afProvider = null;
    }

    public void setClosure(ConfigurationClosure closure) {
        this.closure = closure;
    }
}

