/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.providers;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.epf.authoring.ui.providers.ConfigurationLabelProvider;
import org.eclipse.epf.authoring.ui.providers.MethodElementLabelDecorator;
import org.eclipse.epf.library.configuration.ConfigurationData;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class ConfigurationDecoratingLabelProvider
extends DecoratingLabelProvider {
    private MethodConfiguration config;
    private Font italicFont = null;

    public ConfigurationDecoratingLabelProvider(MethodConfiguration config, AdapterFactory adapterFactory) {
        super((ILabelProvider)new ConfigurationLabelProvider(config, adapterFactory), (ILabelDecorator)new MethodElementLabelDecorator());
        this.config = config;
    }

    public Font getFont(Object element) {
        ConfigurationData configData;
        if (element instanceof IWrapperItemProvider) {
            element = TngUtil.unwrap((Object)element);
        }
        if (element instanceof ContentElement && (configData = ConfigurationHelper.getDelegate().getConfigurationData(this.config)).isSuppressed((MethodElement)((ContentElement)element))) {
            return this.getItalicFont();
        }
        return super.getFont(element);
    }

    private Font getItalicFont() {
        if (this.italicFont == null) {
            this.italicFont = this.createFont(2);
        }
        return this.italicFont;
    }

    private Font createFont(int style) {
        FontData[] fontdata;
        FontData[] fontDataArray = fontdata = Display.getCurrent().getSystemFont().getFontData();
        int n = fontdata.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setStyle(style);
            ++n2;
        }
        return new Font((Device)Display.getCurrent(), fontdata);
    }

    public void dispose() {
        super.dispose();
        if (this.italicFont != null) {
            this.italicFont.dispose();
        }
    }
}

