/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.providers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.providers.ColumnElement;
import org.osgi.framework.Bundle;

public class DescriptionPageColumnProvider {
    public static final String COLUMN_PROVIDERS_EXTENSION_NAMESPACE = "org.eclipse.epf.authoring.ui";
    public static final String COLUMN_PROVIDERS_EXTENSION_NAME = "descriptionPageColumnProvider";
    public static final String COLUMN_PROVIDER_EXTENSION_ATTR_ID = "id";
    public static final String COLUMN_PROVIDER_EXTENSION_ATTR_WIDTH = "width";
    public static final String COLUMN_PROVIDER_EXTENSION_ATTR_ALIGNMENT = "align";
    public static final String COLUMN_PROVIDER_EXTENSION_ATTR_CLASS = "class";
    private static final int COLUMN_DEFAULT_WIDTH = 20;
    private ArrayList columnProviders = new ArrayList();
    private static DescriptionPageColumnProvider instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DescriptionPageColumnProvider getInstance() {
        if (instance != null) return instance;
        Class<DescriptionPageColumnProvider> clazz = DescriptionPageColumnProvider.class;
        synchronized (DescriptionPageColumnProvider.class) {
            if (instance != null) return instance;
            instance = new DescriptionPageColumnProvider();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private DescriptionPageColumnProvider() {
    }

    public List getColumnProviders() {
        return this.columnProviders;
    }

    public void loadProviders() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(COLUMN_PROVIDERS_EXTENSION_NAMESPACE, COLUMN_PROVIDERS_EXTENSION_NAME);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                String pluginId = extension.getNamespaceIdentifier();
                Bundle bundle = Platform.getBundle((String)pluginId);
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    try {
                        String id = configElement.getAttribute(COLUMN_PROVIDER_EXTENSION_ATTR_ID);
                        String widthStr = configElement.getAttribute(COLUMN_PROVIDER_EXTENSION_ATTR_WIDTH);
                        int width = DescriptionPageColumnProvider.parseWidth(widthStr);
                        String alignment = configElement.getAttribute(COLUMN_PROVIDER_EXTENSION_ATTR_ALIGNMENT);
                        String contributorClass = configElement.getAttribute(COLUMN_PROVIDER_EXTENSION_ATTR_CLASS);
                        ColumnElement element = new ColumnElement(bundle, id, width, alignment, contributorClass);
                        this.columnProviders.add(element);
                    }
                    catch (Exception e) {
                        AuthoringUIPlugin.getDefault().getLogger().logError("Failed to load Editor column Provider", (Throwable)e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static int parseWidth(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            return 20;
        }
    }
}

