/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.providers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.internal.IProblemChangedListener;
import org.eclipse.epf.authoring.ui.internal.ImageDescriptorRegistry;
import org.eclipse.epf.authoring.ui.internal.ImageImageDescriptor;
import org.eclipse.epf.authoring.ui.internal.MethodElementImageDescriptor;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ProblemsLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private static final int ERRORTICK_ERROR = 64;
    private ImageDescriptorRegistry fRegistry;
    private boolean fUseNewRegistry = false;
    private IProblemChangedListener fProblemChangedListener;
    private ListenerList fListeners;

    public ProblemsLabelDecorator() {
        this(null);
        this.fUseNewRegistry = true;
    }

    public ProblemsLabelDecorator(ImageDescriptorRegistry registry) {
        this.fRegistry = registry;
        this.fProblemChangedListener = null;
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = this.fUseNewRegistry ? new ImageDescriptorRegistry() : AuthoringUIPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public Image decorateImage(Image image, Object obj) {
        int adornmentFlags = this.computeAdornmentFlags(obj);
        if (adornmentFlags != 0) {
            ImageImageDescriptor baseImage = new ImageImageDescriptor(image);
            Rectangle bounds = image.getBounds();
            return this.getRegistry().get((ImageDescriptor)new MethodElementImageDescriptor(baseImage, adornmentFlags, new Point(bounds.width, bounds.height)));
        }
        return image;
    }

    protected int computeAdornmentFlags(Object obj) {
        try {
            if (obj instanceof MethodElement) {
                return this.getErrorTicksFromMarkers((MethodElement)obj, PersistenceUtil.getWorkspaceResource((Object)obj), 2);
            }
            if (obj instanceof IResource) {
                return this.getErrorTicksFromMarkers(null, (IResource)obj, 2);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 376) {
                return 0;
            }
            AuthoringUIPlugin.log(e);
        }
        return 0;
    }

    private int getErrorTicksFromMarkers(MethodElement e, IResource res, int depth) throws CoreException {
        if (res == null || !res.isAccessible()) {
            return 0;
        }
        int info = 0;
        IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, depth);
        if (markers != null) {
            int i = 0;
            while (i < markers.length && info != 64) {
                IMarker curr = markers[i];
                int priority = curr.getAttribute("severity", -1);
                if (priority == 2 && (e == null || e.getGuid().equals(curr.getAttribute("guid")))) {
                    info = 64;
                }
                ++i;
            }
        }
        return info;
    }

    public void dispose() {
        if (this.fProblemChangedListener != null) {
            AuthoringUIPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
            this.fProblemChangedListener = null;
        }
        if (this.fRegistry != null && this.fUseNewRegistry) {
            this.fRegistry.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
        if (this.fProblemChangedListener == null) {
            this.fProblemChangedListener = new IProblemChangedListener(){

                public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
                    ProblemsLabelDecorator.this.fireProblemsChanged(changedResources, isMarkerChange);
                }
            };
            AuthoringUIPlugin.getDefault().getProblemMarkerManager().addListener(this.fProblemChangedListener);
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
            if (this.fListeners.isEmpty() && this.fProblemChangedListener != null) {
                AuthoringUIPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
                this.fProblemChangedListener = null;
            }
        }
    }

    private void fireProblemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            ProblemsLabelChangedEvent event = new ProblemsLabelChangedEvent((IBaseLabelProvider)this, changedResources, isMarkerChange);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ILabelProviderListener)listeners[i]).labelProviderChanged((LabelProviderChangedEvent)event);
                ++i;
            }
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        int adornmentFlags = this.computeAdornmentFlags(element);
        if (adornmentFlags == 64) {
            decoration.addOverlay(AuthoringUIImages.IMG_DESC_OVR_ERROR);
        }
    }

    public static class ProblemsLabelChangedEvent
    extends LabelProviderChangedEvent {
        private static final long serialVersionUID = 1L;
        private boolean fMarkerChange;

        public ProblemsLabelChangedEvent(IBaseLabelProvider eventSource, IResource[] changedResource, boolean isMarkerChange) {
            super(eventSource, (Object[])changedResource);
            this.fMarkerChange = isMarkerChange;
        }

        public boolean isMarkerChange() {
            return this.fMarkerChange;
        }
    }
}

