/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.richtext;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Shell;

public class AttributeRichTextBox
implements ModifyListener {
    protected EObject object;
    protected EAttribute attribute;
    private boolean checkEditOnContainer;
    private IActionManager actionMgr;
    protected IMethodRichText richText;

    public static final AttributeRichTextBox createAttributeRichTextBox(IMethodRichText richText, EObject object, EAttribute attr, boolean checkEditOnContainer, IActionManager actionMgr) {
        return new AttributeRichTextBox(richText, object, attr, checkEditOnContainer, actionMgr);
    }

    protected AttributeRichTextBox(IMethodRichText richText, EObject object, EAttribute attr, boolean checkEditOnContainer, IActionManager actionMgr) {
        assert (attr != null && attr.getEAttributeType().getInstanceClass().isAssignableFrom(String.class));
        this.object = object;
        this.attribute = attr;
        this.checkEditOnContainer = checkEditOnContainer;
        this.actionMgr = actionMgr;
        this.richText = richText;
        richText.addModifyListener(this);
    }

    public void setElement(EObject object) {
        if (object != this.object) {
            this.object = object;
            this.setAttribute();
        }
    }

    protected void setAttribute() {
        this.setText(this.getAttribute());
    }

    protected void setText(String text) {
        this.richText.removeModifyListener(this);
        try {
            this.richText.setText(text);
        }
        finally {
            this.richText.addModifyListener(this);
        }
    }

    protected String getAttribute() {
        Object val = this.object.eGet((EStructuralFeature)this.attribute);
        return val == null ? "" : val.toString();
    }

    public IMethodRichText getRichText() {
        return this.richText;
    }

    public void modifyText(ModifyEvent e) {
        Shell shell = this.richText.getControl().getShell();
        IStatus status = TngUtil.checkEdit((EObject)this.object, (Object)shell);
        if (status.isOK() && this.checkEditOnContainer && this.object.eContainer() != null) {
            status = TngUtil.checkEdit((EObject)this.object.eContainer(), (Object)shell);
        }
        if (status.isOK()) {
            this.actionMgr.doAction(1, this.object, (EStructuralFeature)this.attribute, (Object)this.richText.getText(), -1);
        } else {
            this.setAttribute();
            this.richText.setEditable(true);
        }
    }
}

