/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditor;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;

public class ConfigurationMarkerResolution
implements IMarkerResolution {
    protected MethodConfiguration config;
    protected MethodElement errorElement;
    protected MethodElement causeElement;

    public ConfigurationMarkerResolution(MethodConfiguration config, MethodElement errorElement, MethodElement causeElement) {
        this.config = config;
        this.errorElement = errorElement;
        this.causeElement = causeElement;
    }

    public String getLabel() {
        return AuthoringUIResources.ConfigurationMarkerResolutionGenerator_resolveMissingReference;
    }

    public void run(IMarker marker) {
        try {
            if (marker.getResource() instanceof IFile) {
                IFile file = (IFile)marker.getResource();
                ResourceSet resourceSet = LibraryService.getInstance().getCurrentMethodLibrary().eResource().getResourceSet();
                MethodElement config = PersistenceUtil.getMethodElement((IResource)file, (ResourceSet)resourceSet);
                IEditorPart editor = EditorChooser.getInstance().findEditor(config);
                if (editor instanceof ConfigurationEditor) {
                    ((ConfigurationEditor)editor).doQuickFix(marker);
                }
            }
        }
        catch (Exception ex) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)ex);
        }
    }
}

