/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceListener;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TransientGroupItemProvider;
import org.eclipse.epf.library.edit.element.TransientContentPackageItemProvider;
import org.eclipse.epf.library.edit.navigator.ContentItemProvider;
import org.eclipse.epf.library.edit.navigator.MethodPackagesItemProvider;
import org.eclipse.epf.library.edit.navigator.ProcessesItemProvider;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.UmaUtil;

public class LibraryValidationMarkerHelper
extends ValidateAction.EclipseResourcesUtil {
    public static final LibraryValidationMarkerHelper INSTANCE = new LibraryValidationMarkerHelper();
    public static final String GUID = "guid";
    private static ErrorCalculator errorCalculator = new ErrorCalculator();

    protected String getMarkerID() {
        return "org.eclipse.epf.library.validation";
    }

    public void createMarkers(Resource resource, Diagnostic diagnostic) {
        if (diagnostic.getSeverity() == 2) {
            return;
        }
        super.createMarkers(resource, diagnostic);
    }

    protected IFile getFile(URI uri) {
        if (uri.isFile()) {
            return (IFile)FileManager.getResourceForLocation((String)uri.toFileString());
        }
        return super.getFile(uri);
    }

    protected boolean adjustMarker(IMarker marker, Diagnostic diagnostic) throws CoreException {
        Object o;
        boolean ret = super.adjustMarker(marker, diagnostic);
        if (!diagnostic.getData().isEmpty() && (o = diagnostic.getData().get(0)) instanceof MethodElement) {
            marker.setAttribute(GUID, (Object)((MethodElement)o).getGuid());
            marker.setAttribute("location", (Object)TngUtil.getLabelWithPath(o));
            marker.setAttribute("org.eclipse.ui.editorID", (Object)"org.eclipse.epf.authoring.ui.editors.MethodElementEditor");
            errorCalculator.addError((MethodElement)o);
        }
        return ret;
    }

    public static boolean isInvalid(Object object) {
        if (object instanceof ProcessesItemProvider) {
            ProcessesItemProvider ip = (ProcessesItemProvider)object;
            ProcessPackage o = ip.getCapabilityPatternPackage();
            return o != null && errorCalculator.hasErrors((MethodElement)o) || (o = ip.getDeliveryProcessPackage()) != null && errorCalculator.hasErrors((MethodElement)o);
        }
        if (object instanceof MethodPackagesItemProvider) {
            object = ((ItemProviderAdapter)object).getTarget();
        } else if (object instanceof ContentItemProvider) {
            ContentPackage coreContentPkg = ((ContentItemProvider)object).getCoreContentPackage();
            if (coreContentPkg != null) {
                object = coreContentPkg.eContainer();
            }
        } else {
            if (object instanceof TransientContentPackageItemProvider) {
                Collection children = ((TransientContentPackageItemProvider)object).getChildren(object);
                Iterator iter = children.iterator();
                while (iter.hasNext()) {
                    Object child = TngUtil.unwrap(iter.next());
                    if (!(child instanceof MethodElement) || !errorCalculator.hasErrors((MethodElement)child)) continue;
                    return true;
                }
                return false;
            }
            if (object instanceof TransientGroupItemProvider) {
                object = ((TransientGroupItemProvider)object).getTarget();
            }
        }
        object = TngUtil.unwrap((Object)object);
        return object instanceof MethodElement && errorCalculator.hasErrors((MethodElement)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasMarkers(Object object) {
        if (!(object instanceof MethodElement)) return super.hasMarkers(object);
        IFile resource = this.getFile(object);
        if (resource == null) return false;
        if (!resource.exists()) return false;
        try {
            String guid = ((MethodElement)object).getGuid();
            IMarker[] markers = resource.findMarkers(this.getMarkerID(), false, 0);
            int i = 0;
            while (true) {
                if (i >= markers.length) {
                    return false;
                }
                IMarker marker = markers[i];
                if (guid.equals(marker.getAttribute(GUID))) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    protected IFile getFile(Object datum) {
        try {
            return super.getFile(datum);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void deleteMarkers(Object object) {
        if (object instanceof MethodElement) {
            IFile resource = this.getFile(object);
            if (resource != null && resource.exists()) {
                try {
                    MethodElement e = (MethodElement)object;
                    String guid = e.getGuid();
                    IMarker[] markers = resource.findMarkers(this.getMarkerID(), false, 0);
                    int i = 0;
                    while (i < markers.length) {
                        IMarker marker = markers[i];
                        if (guid.equals(marker.getAttribute(GUID))) {
                            marker.delete();
                            errorCalculator.removeError(e);
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {}
            }
            return;
        }
        super.deleteMarkers(object);
    }

    protected void deleteMarkers(IResource resource, boolean includeSubtypes, int depth) {
        if (resource != null && resource.exists()) {
            try {
                IMarker[] markers = resource.findMarkers(this.getMarkerID(), false, 0);
                int i = 0;
                while (i < markers.length) {
                    MethodElement e;
                    IMarker marker = markers[i];
                    String guid = (String)marker.getAttribute(GUID);
                    if (guid != null && (e = LibraryService.getInstance().getCurrentLibraryManager().getMethodElement(guid)) != null) {
                        errorCalculator.removeError(e);
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
        super.deleteMarkers(resource, includeSubtypes, depth);
    }

    protected String composeMessage(Diagnostic diagnostic, Diagnostic parentDiagnostic) {
        int ix = diagnostic.getMessage().indexOf(LibraryEditResources.duplicateElementNameError_msg2);
        if (ix > 0) {
            return diagnostic.getMessage().substring(0, ix);
        }
        return super.composeMessage(diagnostic, parentDiagnostic);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ErrorCalculator
    extends HashMap<MethodPlugin, Set<MethodElement>> {
        private static final long serialVersionUID = 1L;

        public ErrorCalculator() {
            this.initialize();
            LibraryService.getInstance().addListener((ILibraryServiceListener)new LibraryServiceListener(){

                public void libraryOpened(MethodLibrary library) {
                    ErrorCalculator.this.initialize();
                }

                public void libraryClosed(MethodLibrary library) {
                    ErrorCalculator.this.clear();
                }

                public void libraryReopened(MethodLibrary library) {
                    ErrorCalculator.this.initialize();
                }
            });
        }

        private void initialize() {
            this.clear();
            MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
            if (lib != null) {
                IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                try {
                    IMarker[] markers = wsRoot.findMarkers(INSTANCE.getMarkerID(), false, 2);
                    int i = 0;
                    while (i < markers.length) {
                        IMarker marker = markers[i];
                        String guid = (String)marker.getAttribute(LibraryValidationMarkerHelper.GUID);
                        MethodElement e = LibraryService.getInstance().getCurrentLibraryManager().getMethodElement(guid);
                        if (e != null) {
                            if (e.eIsProxy()) {
                                e = (MethodElement)PersistenceUtil.resolve((EObject)e, (ResourceSet)LibraryService.getInstance().getCurrentMethodLibrary().eResource().getResourceSet());
                            }
                            this.addError(e);
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {}
            }
        }

        public void addError(MethodElement e) {
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)e);
            if (plugin != null) {
                HashSet<MethodElement> elements = (HashSet<MethodElement>)this.get(plugin);
                if (elements == null) {
                    elements = new HashSet<MethodElement>();
                    this.put(plugin, elements);
                }
                elements.add(e);
            }
        }

        public void removeError(MethodElement e) {
            Set elements;
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)e);
            if (plugin != null && (elements = (Set)this.get(plugin)) != null) {
                elements.remove(e);
                if (elements.isEmpty()) {
                    this.remove(plugin);
                }
            }
        }

        public boolean hasErrors(MethodElement e) {
            Set elements;
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)e);
            if (plugin != null && (elements = (Set)this.get(plugin)) != null) {
                if (elements.contains(e)) {
                    return true;
                }
                HashSet<Object> processedChildren = null;
                for (MethodElement me : elements) {
                    if (UmaUtil.isContainedBy((EObject)me, (Object)e)) {
                        return true;
                    }
                    if (me instanceof CustomCategory) {
                        if (processedChildren == null) {
                            processedChildren = new HashSet<Object>();
                        } else {
                            processedChildren.clear();
                        }
                        if (!ErrorCalculator.isParentOf(me, e, IParentProvider.parentCustomCategoryProvider, processedChildren)) continue;
                        return true;
                    }
                    if (!(me instanceof ContentCategory)) continue;
                    if (e instanceof ContentPackage && e == UmaUtil.findContentPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.standardCategoryPath)) {
                        return true;
                    }
                    if (processedChildren == null) {
                        processedChildren = new HashSet();
                    } else {
                        processedChildren.clear();
                    }
                    if (!ErrorCalculator.isParentOf(me, e, IParentProvider.parentStandardCategoryProvider, processedChildren)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isParentOf(Object child, Object parent, IParentProvider parentProvider, Set<Object> processedChildren) {
            processedChildren.add(child);
            for (Object myParent : parentProvider.getParents(child)) {
                if (myParent == parent) {
                    return true;
                }
                if (processedChildren.contains(myParent) || !ErrorCalculator.isParentOf(myParent, parent, parentProvider, processedChildren)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface IParentProvider {
        public static final IParentProvider containerProvider = new IParentProvider(){

            @Override
            public Collection<?> getParents(Object object) {
                if (object instanceof EObject) {
                    return Collections.singleton(((EObject)object).eContainer());
                }
                return Collections.emptyList();
            }
        };
        public static final IParentProvider parentCustomCategoryProvider = new IParentProvider(){

            @Override
            public Collection<?> getParents(Object object) {
                if (object instanceof CustomCategory) {
                    return AssociationHelper.getCustomCategories((DescribableElement)((CustomCategory)object));
                }
                return Collections.emptyList();
            }
        };
        public static final IParentProvider parentStandardCategoryProvider = new IParentProvider(){

            @Override
            public Collection<?> getParents(Object object) {
                if (object instanceof Discipline) {
                    Discipline discipline = (Discipline)object;
                    List parentDisciplines = AssociationHelper.getDiscipline((Discipline)discipline);
                    List disciplineGroupings = AssociationHelper.getDisciplineGroups((Discipline)discipline);
                    if (!parentDisciplines.isEmpty() && !disciplineGroupings.isEmpty()) {
                        ArrayList parents = new ArrayList(disciplineGroupings);
                        parents.addAll(parentDisciplines);
                        return parents;
                    }
                    return parentDisciplines.isEmpty() ? disciplineGroupings : parentDisciplines;
                }
                if (object instanceof RoleSet) {
                    return AssociationHelper.getRoleSetGroups((RoleSet)((RoleSet)object));
                }
                return Collections.emptyList();
            }
        };

        public Collection<?> getParents(Object var1);
    }
}

