/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.persistence.util.UnresolvedProxyMarkerManager;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class MarkerResolutionGenerator
implements IMarkerResolutionGenerator {
    private static final IMarkerResolution[] EMPTY_RESOLUTIONS = new IMarkerResolution[0];

    private static ReferenceInfo getReferenceInfo(IMarker marker) {
        block7: {
            try {
                EObject owner;
                Resource resource;
                String proxyURI = (String)marker.getAttribute("proxyURI");
                String ownerGUID = (String)marker.getAttribute("ownerGUID");
                if (proxyURI == null || ownerGUID == null || (resource = RefreshJob.getInstance().getResource(marker.getResource())) == null || (owner = resource.getEObject(ownerGUID)) == null) break block7;
                URI uri = URI.createURI((String)proxyURI);
                int index = -1;
                EReference reference = null;
                block2: for (EReference ref : owner.eClass().getEAllReferences()) {
                    if (!ref.isChangeable() || ref.isDerived()) continue;
                    if (ref.isMany()) {
                        InternalEList list = (InternalEList)owner.eGet((EStructuralFeature)ref);
                        int id = 0;
                        Iterator iterator = list.basicIterator();
                        while (iterator.hasNext()) {
                            InternalEObject o = (InternalEObject)iterator.next();
                            if (o.eIsProxy() && uri.equals((Object)o.eProxyURI())) {
                                index = id;
                                reference = ref;
                                break block2;
                            }
                            ++id;
                        }
                        continue;
                    }
                    InternalEObject o = (InternalEObject)owner.eGet((EStructuralFeature)ref, false);
                    if (o == null || !o.eIsProxy() || !uri.equals((Object)o.eProxyURI())) continue;
                    reference = ref;
                    break;
                }
                if (reference != null) {
                    return new ReferenceInfo(owner, reference, index);
                }
            }
            catch (Exception e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        return null;
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        ReferenceInfo refInfo = MarkerResolutionGenerator.getReferenceInfo(marker);
        if (refInfo != null) {
            Object selectableOwner = MarkerResolutionGenerator.getSelectableObject(refInfo.owner);
            MarkerResolution markerResolution = new MarkerResolution(marker, refInfo);
            if (selectableOwner != null) {
                return new IMarkerResolution[]{markerResolution, new ShowOwnerInLibraryView(selectableOwner)};
            }
            return new IMarkerResolution[]{markerResolution};
        }
        return EMPTY_RESOLUTIONS;
    }

    private static Object getSelectableObject(EObject owner) {
        ProcessComponent procComp;
        if (owner instanceof MethodPlugin || owner instanceof ContentElement || owner instanceof ContentPackage || owner instanceof ProcessComponent) {
            return owner;
        }
        if (owner instanceof MethodElement && (procComp = UmaUtil.getProcessComponent((MethodElement)((MethodElement)owner))) != null) {
            return procComp;
        }
        if (owner instanceof ProcessPackage) {
            return owner;
        }
        if (owner instanceof ContentDescription && owner.eContainer() instanceof ContentElement) {
            return owner.eContainer();
        }
        Resource resource = owner.eResource();
        MethodElement e = PersistenceUtil.getMethodElement((Resource)resource);
        if (e != owner) {
            return MarkerResolutionGenerator.getSelectableObject((EObject)e);
        }
        return null;
    }

    private static class MarkerResolution
    extends WorkbenchMarkerResolution {
        private IMarker currentMarker;
        private ReferenceInfo referenceInfo;

        public MarkerResolution(IMarker currentMarker, ReferenceInfo referenceInfo) {
            this.currentMarker = currentMarker;
            this.referenceInfo = referenceInfo;
        }

        public String getLabel() {
            return AuthoringUIResources.MarkerResolutionGenerator_removeUnresolvedReference;
        }

        public void run(IMarker marker) {
            ReferenceInfo refInfo;
            ReferenceInfo referenceInfo = refInfo = this.currentMarker.equals((Object)marker) ? this.referenceInfo : MarkerResolutionGenerator.getReferenceInfo(marker);
            if (refInfo == null) {
                return;
            }
            UnresolvedProxyMarkerManager mgr = null;
            Resource resource = refInfo.owner.eResource();
            ResourceSet resourceSet = resource.getResourceSet();
            if (resourceSet instanceof MultiFileResourceSetImpl) {
                mgr = ((MultiFileResourceSetImpl)resourceSet).getMarkerMananger();
                mgr.setIgnoreNewException(true);
            }
            try {
                if (refInfo.reference.isMany()) {
                    ((List)refInfo.owner.eGet((EStructuralFeature)refInfo.reference)).remove(refInfo.index);
                } else {
                    refInfo.owner.eSet((EStructuralFeature)refInfo.reference, null);
                }
                boolean validate = false;
                ILibraryPersister.FailSafeMethodLibraryPersister persister = LibraryServiceUtil.getPersisterFor((Resource)resource).getFailSafePersister();
                try {
                    persister.save(resource);
                    persister.commit();
                    validate = true;
                }
                catch (Exception e) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                    persister.rollback();
                }
                if (validate && mgr != null) {
                    mgr.removeMarker(marker);
                }
            }
            finally {
                if (mgr != null) {
                    mgr.setIgnoreNewException(false);
                }
            }
        }

        public IMarker[] findOtherMarkers(IMarker[] markers) {
            ArrayList<IMarker> similarMarkerList = new ArrayList<IMarker>();
            int i = 0;
            while (i < markers.length) {
                IMarker marker = markers[i];
                if (!this.currentMarker.equals((Object)marker)) {
                    try {
                        if (UnresolvedProxyMarkerManager.MARKER_ID.equals(marker.getType())) {
                            similarMarkerList.add(marker);
                        }
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
            IMarker[] similarMarkers = new IMarker[similarMarkerList.size()];
            similarMarkerList.toArray(similarMarkers);
            return similarMarkers;
        }

        public String getDescription() {
            return null;
        }

        public Image getImage() {
            return null;
        }
    }

    private static class ReferenceInfo {
        private EObject owner;
        private EReference reference;
        private int index;

        public ReferenceInfo(EObject owner, EReference reference, int index) {
            this.owner = owner;
            this.reference = reference;
            this.index = index;
        }
    }

    private static class ShowOwnerInLibraryView
    implements IMarkerResolution {
        private Object owner;

        private ShowOwnerInLibraryView(Object owner) {
            this.owner = owner;
        }

        public String getLabel() {
            return AuthoringUIResources.MarkerResolutionGenerator_showOwnerInLibraryView;
        }

        public void run(IMarker marker) {
            LibraryView.getView().setSelectionToViewer(this.owner);
        }
    }
}

