/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceListener;
import org.eclipse.epf.library.edit.element.TransientContentPackageItemProvider;
import org.eclipse.epf.library.edit.navigator.ContentItemProvider;
import org.eclipse.epf.library.edit.navigator.MethodPackagesItemProvider;
import org.eclipse.epf.library.edit.navigator.ProcessesItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.ProcessPackage;

public class MethodRichTextMarkerHelper
extends ValidateAction.EclipseResourcesUtil {
    public static final MethodRichTextMarkerHelper INSTANCE = new MethodRichTextMarkerHelper();
    public static final String GUID = "guid";
    public static final String MARKER_ID = "org.eclipse.epf.authoring.ui.methodRichText";
    private static String METHOD_FIELDNAME = "MethodFieldName";
    private static ContainerMap containersOfMarkedObjects = new ContainerMap();

    private MethodRichTextMarkerHelper() {
    }

    protected String getMarkerID() {
        return MARKER_ID;
    }

    protected IFile getFile(URI uri) {
        if (uri.isFile()) {
            return (IFile)FileManager.getResourceForLocation((String)uri.toFileString());
        }
        return super.getFile(uri);
    }

    protected boolean adjustMarker(IMarker marker, Diagnostic diagnostic) throws CoreException {
        boolean ret = super.adjustMarker(marker, diagnostic);
        if (!diagnostic.getData().isEmpty()) {
            Object o = diagnostic.getData().get(0);
            Object str = diagnostic.getData().get(1);
            if (o instanceof MethodElement) {
                marker.setAttribute(GUID, (Object)((MethodElement)o).getGuid());
                marker.setAttribute("location", (Object)(String.valueOf(TngUtil.getLabel(o)) + ", " + str));
                marker.setAttribute("org.eclipse.ui.editorID", (Object)"org.eclipse.epf.authoring.ui.editors.MethodElementEditor");
            }
            if (str instanceof String) {
                marker.setAttribute(METHOD_FIELDNAME, (Object)((String)str));
            }
        }
        return ret;
    }

    public static boolean isInvalid(Object object) {
        if (object instanceof ProcessesItemProvider) {
            ProcessesItemProvider ip = (ProcessesItemProvider)object;
            ProcessPackage o = ip.getCapabilityPatternPackage();
            return o != null && containersOfMarkedObjects.containsKey(o) || (o = ip.getDeliveryProcessPackage()) != null && containersOfMarkedObjects.containsKey(o);
        }
        if (object instanceof MethodPackagesItemProvider || object instanceof ContentItemProvider) {
            object = ((ItemProviderAdapter)object).getTarget();
        } else if (object instanceof TransientContentPackageItemProvider) {
            Collection children = ((TransientContentPackageItemProvider)object).getChildren(object);
            for (Object obj : children) {
                if (!containersOfMarkedObjects.containsKey(obj) && !INSTANCE.hasMarkers(obj)) continue;
                return true;
            }
            return false;
        }
        return containersOfMarkedObjects.containsKey(object) || INSTANCE.hasMarkers(object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasMarkers(Object object) {
        if (!(object instanceof MethodElement)) return super.hasMarkers(object);
        IFile resource = this.getFile(object);
        if (resource == null) return false;
        if (!resource.exists()) return false;
        try {
            String guid = ((MethodElement)object).getGuid();
            IMarker[] markers = resource.findMarkers(this.getMarkerID(), false, 0);
            int i = 0;
            while (true) {
                if (i >= markers.length) {
                    return false;
                }
                IMarker marker = markers[i];
                if (guid.equals(marker.getAttribute(GUID))) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    protected IFile getFile(Object datum) {
        try {
            return super.getFile(datum);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void deleteMarkers(Object object, String fieldName) {
        if (object instanceof MethodElement) {
            IFile resource = this.getFile(object);
            if (resource != null) {
                try {
                    String guid = ((MethodElement)object).getGuid();
                    IMarker[] markers = resource.findMarkers(this.getMarkerID(), false, 0);
                    int i = 0;
                    while (i < markers.length) {
                        IMarker marker = markers[i];
                        if (guid.equals(marker.getAttribute(GUID)) && (fieldName == null || fieldName.equals(marker.getAttribute(METHOD_FIELDNAME)))) {
                            marker.delete();
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {}
            }
            return;
        }
        super.deleteMarkers(object);
    }

    protected void deleteMarkers(IResource resource, boolean includeSubtypes, int depth) {
        super.deleteMarkers(resource, includeSubtypes, depth);
    }

    protected void createMarkers(IResource resource, Diagnostic diagnostic, Diagnostic parentDiagnostic) throws CoreException {
        super.createMarkers(resource, diagnostic, parentDiagnostic);
    }

    protected String composeMessage(Diagnostic diagnostic, Diagnostic parentDiagnostic) {
        String parentMessage;
        String message = diagnostic.getMessage();
        if (parentDiagnostic != null && (parentMessage = parentDiagnostic.getMessage()) != null) {
            message = message != null ? String.valueOf(parentMessage) + " " + message : parentMessage;
        }
        return message;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContainerMap
    extends HashMap<Object, Integer> {
        private static final long serialVersionUID = 1L;

        public ContainerMap() {
            this.initMap();
            LibraryService.getInstance().addListener((ILibraryServiceListener)new LibraryServiceListener(){

                public void libraryOpened(MethodLibrary library) {
                    ContainerMap.this.initMap();
                }

                public void libraryClosed(MethodLibrary library) {
                    ContainerMap.this.clear();
                }

                public void libraryReopened(MethodLibrary library) {
                    ContainerMap.this.initMap();
                }
            });
        }

        private void initMap() {
            this.clear();
        }

        private void increment(Object object) {
            Integer count = this.containsKey(object) ? (Integer)this.get(object) : new Integer(0);
            count = count + 1;
            this.put(object, count);
        }

        private void decrement(Object object) {
            if (this.containsKey(object)) {
                Integer count = (Integer)this.get(object);
                if (count == 1) {
                    this.remove(object);
                } else {
                    count = count - 1;
                    this.put(object, count);
                }
            }
        }

        private void markContainers(MethodElement e) {
            EObject container = e.eContainer();
            while (container != null) {
                this.increment(container);
                container = container.eContainer();
            }
        }

        private void unmarkContainers(MethodElement e) {
            EObject container = e.eContainer();
            while (container != null) {
                this.decrement(container);
                container = container.eContainer();
            }
        }
    }
}

