/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.ui.BusyIndicatorHelper;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.refresh.IRefreshHandler;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshHandler
implements IRefreshHandler {
    private ViewPart view;

    public RefreshHandler(ViewPart view) {
        this.view = view;
    }

    private Control getControl() {
        Viewer viewer;
        if (this.view instanceof IViewerProvider && (viewer = ((IViewerProvider)this.view).getViewer()) != null) {
            return viewer.getControl();
        }
        return null;
    }

    public void refresh(IProgressMonitor monitor) {
        Control ctrl = this.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        this.doRefresh(monitor);
    }

    private void doRefresh(IProgressMonitor monitor) {
        boolean refreshViews = !RefreshJob.getInstance().getReloadedBeforeRefreshResources().isEmpty() || !RefreshJob.getInstance().getAddedResources().isEmpty();
        ArrayList<Resource> removedResources = new ArrayList<Resource>(RefreshJob.getInstance().getRemovedResources());
        ArrayList<Resource> changedResources = new ArrayList<Resource>(RefreshJob.getInstance().getChangedResources());
        ArrayList<IResource> addedWsResources = new ArrayList<IResource>(RefreshJob.getInstance().getAddedWorkspaceResources());
        if (!removedResources.isEmpty() || !changedResources.isEmpty() || !addedWsResources.isEmpty() || refreshViews) {
            this.doRefresh(removedResources, changedResources, addedWsResources, refreshViews, monitor);
        }
        if (!removedResources.isEmpty()) {
            RefreshJob.getInstance().getRemovedResources().removeAll(removedResources);
        }
        if (!changedResources.isEmpty()) {
            RefreshJob.getInstance().getChangedResources().removeAll(changedResources);
        }
        if (!addedWsResources.isEmpty()) {
            RefreshJob.getInstance().getAddedWorkspaceResources().removeAll(addedWsResources);
        }
        if (refreshViews) {
            RefreshJob.getInstance().getReloadedBeforeRefreshResources().clear();
            RefreshJob.getInstance().getAddedResources().clear();
        }
    }

    public synchronized void doRefresh(final Collection<Resource> removedResources, final Collection<Resource> changedResources, final Collection<IResource> addedWorkspaceResources, final boolean refreshViews, IProgressMonitor monitor) {
        final boolean[] refreshViewsHolder = new boolean[1];
        final HashSet editorsToRefresh = new HashSet();
        final ArrayList changedResourcesToRefresh = new ArrayList();
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                if (!removedResources.isEmpty()) {
                    RefreshHandler.this.collectEditorsToRefreshForRemovedResources(editorsToRefresh, removedResources);
                    refreshViewsHolder[0] = true;
                }
                if (!changedResources.isEmpty()) {
                    changedResourcesToRefresh.addAll(RefreshHandler.this.prepareChangedResources(editorsToRefresh, changedResources, null));
                }
            }
        });
        final boolean[] validateMarkersHolder = new boolean[1];
        final WorkspaceJob refreshJob = new WorkspaceJob("Refresh Resources"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("Refresh resources", -1);
                try {
                    ResourceSet resourceSet;
                    ILibraryManager mgr;
                    ILibraryManager manager;
                    if (!removedResources.isEmpty()) {
                        monitor.subTask("Unloading resources...");
                        PersistenceUtil.unload((Collection)removedResources);
                    }
                    if (changedResourcesToRefresh != null && !changedResourcesToRefresh.isEmpty() && (manager = LibraryService.getInstance().getCurrentLibraryManager()) != null) {
                        monitor.subTask("Reloading resources...");
                        Collection reloadedResources = manager.reloadResources(changedResourcesToRefresh);
                        refreshViewsHolder[0] = !reloadedResources.isEmpty();
                    }
                    MultiFileResourceSetImpl libResourceSet = null;
                    if (addedWorkspaceResources != null && !addedWorkspaceResources.isEmpty() && (mgr = LibraryService.getInstance().getCurrentLibraryManager()) != null && (resourceSet = mgr.getEditingDomain().getResourceSet()) instanceof MultiFileResourceSetImpl) {
                        monitor.subTask("Loading new resources...");
                        libResourceSet = (MultiFileResourceSetImpl)resourceSet;
                        libResourceSet.loadNewResources(addedWorkspaceResources);
                    }
                    validateMarkersHolder[0] = libResourceSet != null;
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                PlatformUI.getWorkbench().getProgressService().showInDialog(Display.getDefault().getActiveShell(), (Job)refreshJob);
            }
        });
        refreshJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                SafeUpdateController.asyncExec((Runnable)new Runnable(){

                    public void run() {
                        RefreshHandler.this.collectionEditorsToRefreshAfterUnload(editorsToRefresh, removedResources);
                        Integer busyId = null;
                        try {
                            busyId = BusyIndicatorHelper.showWhile((Display)Display.getCurrent());
                            if (refreshViews || refreshViewsHolder[0]) {
                                RefreshHandler.this.refreshViews();
                            }
                            if (!editorsToRefresh.isEmpty()) {
                                for (Object editor : editorsToRefresh) {
                                    if (!(editor instanceof MethodElementEditor)) continue;
                                    ((MethodElementEditor)((Object)editor)).refresh();
                                }
                            }
                        }
                        finally {
                            if (busyId != null) {
                                BusyIndicatorHelper.hideWhile((Display)Display.getCurrent(), (Integer)busyId);
                            }
                        }
                    }
                });
            }
        });
        refreshJob.setSystem(true);
        refreshJob.schedule();
        if (validateMarkersHolder[0]) {
            WorkspaceJob job = new WorkspaceJob("Validate unresolved reference errors"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    ResourceSet resourceSet;
                    ILibraryManager mgr = LibraryService.getInstance().getCurrentLibraryManager();
                    if (mgr != null && (resourceSet = mgr.getEditingDomain().getResourceSet()) instanceof MultiFileResourceSetImpl) {
                        ((MultiFileResourceSetImpl)resourceSet).getUnresolvedProxyMarkerManager().validateAllMarkers();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    private void collectionEditorsToRefreshAfterUnload(Set<IEditorPart> editorsToRefresh, Collection<Resource> removedResources) {
        IEditorReference[] editorReferences = this.view.getSite().getPage().getEditorReferences();
        ArrayList<Resource> removedResourceList = new ArrayList<Resource>(removedResources);
        int i = 0;
        while (i < editorReferences.length) {
            IEditorReference reference = editorReferences[i];
            IEditorPart editor = reference.getEditor(true);
            if (editor instanceof MethodElementEditor && !editor.isDirty()) {
                Collection<Resource> usedResources = ((MethodElementEditor)editor).getUsedResources();
                int j = 0;
                while (j < removedResourceList.size()) {
                    Resource resource = removedResourceList.get(j);
                    if (usedResources.contains(resource)) {
                        editorsToRefresh.add(editor);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected Collection<Resource> prepareChangedResources(Set<IEditorPart> editorsToRefresh, Collection<Resource> changedResources, Set<IEditorPart> editorsNotToRefresh) {
        Resource resource;
        int j;
        Collection<Resource> usedResources;
        Object editor;
        IEditorReference reference;
        Control ctrl = this.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return Collections.emptyList();
        }
        IWorkbenchPage workbenchPage = this.view.getSite().getPage();
        IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
        ArrayList<IEditorPart> dirtyEditorsWithConflict = new ArrayList<IEditorPart>();
        ArrayList<Resource> changedResourceList = new ArrayList<Resource>(changedResources);
        int i = 0;
        while (i < editorReferences.length) {
            reference = editorReferences[i];
            editor = reference.getEditor(true);
            if (editor instanceof MethodElementEditor && editor.isDirty()) {
                usedResources = ((MethodElementEditor)((Object)editor)).getUsedResources();
                j = 0;
                while (j < changedResourceList.size()) {
                    resource = changedResourceList.get(j);
                    if (usedResources.contains(resource)) {
                        dirtyEditorsWithConflict.add((IEditorPart)editor);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (!dirtyEditorsWithConflict.isEmpty()) {
            Object[] result = this.selectDirtyEditors(dirtyEditorsWithConflict);
            if (result != null) {
                int i2 = 0;
                while (i2 < result.length) {
                    editor = result[i2];
                    if (!(!(editor instanceof IEditorPart) || editorsNotToRefresh != null && editorsNotToRefresh.contains(editor) || editorsToRefresh != null && editorsToRefresh.contains(editor))) {
                        editorsToRefresh.add((IEditorPart)editor);
                        dirtyEditorsWithConflict.remove(editor);
                    }
                    ++i2;
                }
            }
            int i3 = 0;
            while (i3 < dirtyEditorsWithConflict.size()) {
                editor = (MethodElementEditor)dirtyEditorsWithConflict.get(i3);
                usedResources = ((MethodElementEditor)((Object)editor)).getUsedResources();
                usedResources.retainAll(changedResourceList);
                ((MethodElementEditor)((Object)editor)).updateResourceInfos(usedResources);
                ((MethodElementEditor)((Object)editor)).ovewriteResources(usedResources);
                changedResourceList.removeAll(usedResources);
                ++i3;
            }
        }
        if (!changedResourceList.isEmpty()) {
            i = 0;
            while (i < editorReferences.length) {
                reference = editorReferences[i];
                editor = reference.getEditor(true);
                if (editor instanceof MethodElementEditor && !editor.isDirty()) {
                    usedResources = ((MethodElementEditor)((Object)editor)).getUsedResources();
                    j = 0;
                    while (j < changedResourceList.size()) {
                        resource = changedResourceList.get(j);
                        if (usedResources.contains(resource)) {
                            editorsToRefresh.add((IEditorPart)editor);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return changedResourceList;
    }

    private void collectEditorsToRefreshForRemovedResources(Set<IEditorPart> editorsToRefresh, Collection<Resource> removedResources) {
        IWorkbenchPage workbenchPage = this.view.getSite().getPage();
        IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
        ArrayList<IEditorPart> dirtyEditorsWithConflict = new ArrayList<IEditorPart>();
        ArrayList<Resource> removedResourceList = new ArrayList<Resource>(removedResources);
        if (editorsToRefresh == null) {
            editorsToRefresh = new HashSet<IEditorPart>();
        }
        int i = 0;
        while (i < editorReferences.length) {
            IEditorReference reference = editorReferences[i];
            IEditorPart editor = reference.getEditor(true);
            if (editor instanceof MethodElementEditor && editor.isDirty()) {
                Resource resource;
                MethodElementEditorInput input = (MethodElementEditorInput)editor.getEditorInput();
                Resource resource2 = resource = input.getMethodElement() != null ? input.getMethodElement().eResource() : null;
                if (!removedResources.contains(resource)) {
                    Collection<Resource> usedResources = ((MethodElementEditor)editor).getUsedResources();
                    int j = 0;
                    while (j < removedResourceList.size()) {
                        resource = removedResourceList.get(j);
                        if (usedResources.contains(resource)) {
                            dirtyEditorsWithConflict.add(editor);
                            break;
                        }
                        ++j;
                    }
                } else {
                    editorsToRefresh.add(editor);
                }
            }
            ++i;
        }
        if (!dirtyEditorsWithConflict.isEmpty()) {
            Object[] selected = this.selectDirtyEditors(dirtyEditorsWithConflict);
            int i2 = 0;
            while (i2 < selected.length) {
                editorsToRefresh.add((IEditorPart)selected[i2]);
                ++i2;
            }
        }
    }

    protected void refreshViews() {
    }

    private Object[] selectDirtyEditors(ArrayList<IEditorPart> dirtyEditorsWithConflict) {
        return RefreshHandler.selectDirtyEditors(dirtyEditorsWithConflict, this.view.getSite().getShell());
    }

    public static Object[] selectDirtyEditors(List<?> dirtyEditors, Shell shell) {
        String title = AuthoringUIResources._UI_FileConflict_label;
        String msg = AuthoringUIResources.selectEditorsToDiscardConflictChanges;
        return RefreshHandler.selectEditors(dirtyEditors, title, msg, shell);
    }

    private static Object[] selectEditors(List<?> editors, String title, String msg, Shell shell) {
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){
            List<?> fContents;

            public Object[] getElements(Object inputElement) {
                if (this.fContents != null && this.fContents == inputElement) {
                    return this.fContents.toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.fContents = newInput instanceof List ? (List)newInput : null;
            }
        };
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IEditorPart) {
                    return ((IEditorPart)element).getTitle();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof IEditorPart) {
                    return ((IEditorPart)element).getTitleImage();
                }
                return super.getImage(element);
            }
        };
        ListSelectionDialog dlg = new ListSelectionDialog(shell, editors, contentProvider, (ILabelProvider)labelProvider, msg);
        dlg.setTitle(title);
        dlg.setBlockOnOpen(true);
        dlg.open();
        return dlg.getResult();
    }
}

