/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.BreakdownElementEditorInput;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.diagram.core.part.AbstractDiagramEditor;
import org.eclipse.epf.diagram.core.part.DiagramEditorInput;
import org.eclipse.epf.diagram.core.part.DiagramEditorInputProxy;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.IModifyChecker;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.PracticePropUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.internal.ContentElementNameValidator;
import org.eclipse.epf.library.edit.validation.internal.ValidatorFactory;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class UIHelper {
    public static void setItems(Table table, ArrayList items) {
        table.removeAll();
        int i = 0;
        while (i < items.size()) {
            TableItem item = new TableItem(table, 0);
            item.setText((String)items.get(i));
            ++i;
        }
    }

    public static org.eclipse.swt.widgets.List createList(FormToolkit toolkit, Composite parent, int style) {
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(parent, style);
        toolkit.adapt((Control)list, true, true);
        return list;
    }

    public static Object[] getSelectedGuidances(ContentElement contentElement) {
        List list = MethodElementUtil.getSelectedGuidances((EObject)contentElement);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof Practice)) continue;
            it.remove();
        }
        return list.toArray();
    }

    private static String getFormPageTitlePrefixFor(MethodElement methodElement) {
        String elementLabel = LibraryUIText.getUIText((MethodElement)methodElement);
        if (methodElement instanceof WorkProduct) {
            return String.valueOf(LibraryUIText.TEXT_WORK_PRODUCT) + " (" + elementLabel + ")";
        }
        if (methodElement instanceof Guidance) {
            if (methodElement instanceof Practice) {
                Practice prac = (Practice)methodElement;
                if (PracticePropUtil.getPracticePropUtil().isUdtType((MethodElement)prac)) {
                    elementLabel = UIHelper.getNameForUtd(prac);
                    return elementLabel;
                }
            }
            return String.valueOf(LibraryUIText.TEXT_GUIDANCE) + " (" + elementLabel + ")";
        }
        return elementLabel;
    }

    private static String getNameForUtd(Practice prac) {
        try {
            String typeName = (String)PracticePropUtil.getPracticePropUtil().getUtdData(prac).getRteNameMap().get("typeName");
            return typeName;
        }
        catch (Exception e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            return null;
        }
    }

    public static void setFormText(ScrolledForm form, MethodElement element) {
        String delimiter = ". ,  ;  ! ? ~ @ # $ % ^ & *  ( ) { } [ ]   < > \\ / \" ' `  | ";
        if (form != null && !form.isDisposed()) {
            StringBuffer str = new StringBuffer();
            str.append(UIHelper.getFormPageTitlePrefixFor(element));
            str.append(AuthoringUIResources.editor_title_colon_with_spaces);
            if (element instanceof VariabilityElement) {
                str.append(TngUtil.getLabel((VariabilityElement)((VariabilityElement)element), (String)"", (boolean)true));
            } else if (element.getName() != null) {
                str.append(element.getName());
            }
            form.setText(TextProcessor.process((String)str.toString(), (String)delimiter));
        }
    }

    public static boolean checkCircularDeliverables(Deliverable toBePart, Deliverable deliverable) {
        return DependencyChecker.checkCircularDeliverables((Deliverable)toBePart, (Deliverable)deliverable);
    }

    public static void deliverablePartsChain(Deliverable e, List roots) {
        List list = e.getDeliveredWorkProducts();
        if (list != null && list.size() > 0) {
            for (Object obj : list) {
                if (!(obj instanceof Deliverable)) continue;
                roots.add(obj);
                UIHelper.deliverablePartsChain((Deliverable)obj, roots);
            }
        }
    }

    public static String resolveContentElementNameConflict(EObject container, MethodElement element, EReference reference) {
        ContentElementNameValidator validator = new ContentElementNameValidator(container, (EStructuralFeature)reference, (ContentElement)element, (IFilter)new ValidatorFactory.TypeFilter((EObject)element));
        String msg = validator.isValid(element.getName());
        if (msg != null) {
            String featureTxt = TngUtil.getFeatureText((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            String title = LibraryEditResources.resolveNameConflictDialog_title;
            String dlgMsg = NLS.bind((String)LibraryEditResources.resolveNameConflictDialog_text, (Object)StrUtil.toLower((String)featureTxt), (Object)element.getName());
            String currentValue = (String)element.eGet((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            IInputValidator inputValidator = new IInputValidator((IValidator)validator){
                private final /* synthetic */ IValidator val$validator;
                {
                    this.val$validator = iValidator;
                }

                public String isValid(String newText) {
                    return this.val$validator.isValid(newText);
                }
            };
            InputDialog inputDlg = new InputDialog(MsgBox.getDefaultShell(), title, dlgMsg, currentValue, inputValidator);
            if (inputDlg.open() == 1) {
                throw new OperationCanceledException();
            }
            return inputDlg.getValue();
        }
        return null;
    }

    public static void refreshOpenDiagramEditorsOfParent(Object refreshElement, List openEditorRefs) {
        openEditorRefs = new ArrayList<IEditorReference>();
        IWorkbenchPage workbenchPage = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
        int i = 0;
        while (i < editorReferences.length) {
            IEditorReference reference = editorReferences[i];
            IEditorPart editor = reference.getEditor(true);
            if (editor != null) {
                DiagramEditorInput diagramInput;
                IEditorInput input = editor.getEditorInput();
                BreakdownElementWrapperItemProvider element = null;
                if (input instanceof BreakdownElementEditorInput) {
                    BreakdownElementEditorInput binput = (BreakdownElementEditorInput)input;
                    if (binput.getWrapper() != null) {
                        Object parent;
                        element = binput.getWrapper();
                        if (element instanceof BreakdownElementWrapperItemProvider && (parent = element.getParent(null)) instanceof BreakdownElementWrapperItemProvider && element.equals(refreshElement)) {
                            UIHelper.refreshOpenDiagramEditorsOfParent(parent, openEditorRefs);
                        }
                    } else {
                        element = binput.getMethodElement();
                    }
                } else if (input instanceof DiagramEditorInputProxy && (diagramInput = ((DiagramEditorInputProxy)input).getDiagramEditorInput()) != null) {
                    element = diagramInput.getMethodElement();
                }
                if (element != null) {
                    Collection c;
                    if (element instanceof Activity) {
                        if (((Activity)element).getBreakdownElements().contains(refreshElement)) {
                            openEditorRefs.add(reference);
                        } else if (refreshElement instanceof BreakdownElementWrapperItemProvider) {
                            Object localRefreshElement = refreshElement;
                            while (localRefreshElement instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)localRefreshElement).getOwner() != null) {
                                if (((BreakdownElementWrapperItemProvider)localRefreshElement).getOwner().equals(element)) {
                                    openEditorRefs.add(reference);
                                }
                                localRefreshElement = ((BreakdownElementWrapperItemProvider)localRefreshElement).getOwner();
                            }
                        }
                    } else if (element instanceof BreakdownElementWrapperItemProvider && (c = element.getChildren((Object)element)) != null && c.contains(refreshElement)) {
                        openEditorRefs.add(reference);
                    }
                }
            }
            ++i;
        }
        int size = openEditorRefs.size();
        int i2 = 0;
        while (i2 < size) {
            IEditorReference reference = (IEditorReference)openEditorRefs.get(i2);
            IEditorPart editor = reference.getEditor(true);
            if (editor instanceof AbstractDiagramEditor) {
                ((AbstractDiagramEditor)editor).refreshDiagram();
            }
            ++i2;
        }
    }

    public static void closeDiagramEditorsIncludingParent(Object closeElement, List closeEditorRefs) {
        closeEditorRefs = new ArrayList<IEditorReference>();
        IWorkbenchPage workbenchPage = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
        int i = 0;
        while (i < editorReferences.length) {
            IEditorReference reference = editorReferences[i];
            IEditorPart editor = reference.getEditor(true);
            if (editor != null) {
                DiagramEditorInput diagramInput;
                IEditorInput input = editor.getEditorInput();
                BreakdownElementWrapperItemProvider element = null;
                if (input instanceof BreakdownElementEditorInput) {
                    BreakdownElementEditorInput binput = (BreakdownElementEditorInput)input;
                    if (binput.getWrapper() != null) {
                        Object parent;
                        element = binput.getWrapper();
                        if (element instanceof BreakdownElementWrapperItemProvider && (parent = element.getParent(null)) instanceof BreakdownElementWrapperItemProvider && element.equals(closeElement)) {
                            UIHelper.closeDiagramEditorsIncludingParent(parent, closeEditorRefs);
                        }
                    } else {
                        element = binput.getMethodElement();
                    }
                } else if (input instanceof DiagramEditorInputProxy && (diagramInput = ((DiagramEditorInputProxy)input).getDiagramEditorInput()) != null) {
                    element = diagramInput.getMethodElement();
                }
                if (element != null) {
                    Collection c;
                    if (element instanceof Activity) {
                        if (element.equals(closeElement)) {
                            closeEditorRefs.add(reference);
                        }
                        if (((Activity)element).getBreakdownElements().contains(closeElement)) {
                            closeEditorRefs.add(reference);
                        } else if (closeElement instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)closeElement).getOwner() != null && ((BreakdownElementWrapperItemProvider)closeElement).getOwner().equals(element)) {
                            closeEditorRefs.add(reference);
                            if (((BreakdownElementWrapperItemProvider)closeElement).getOwner() instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)((BreakdownElementWrapperItemProvider)closeElement).getOwner()).getOwner().equals(element)) {
                                closeEditorRefs.add(reference);
                            }
                        }
                    } else if (element instanceof BreakdownElementWrapperItemProvider && (c = element.getChildren((Object)element)) != null && c.contains(closeElement)) {
                        closeEditorRefs.add(reference);
                    }
                }
            }
            ++i;
        }
        int size = closeEditorRefs.size();
        IEditorReference[] references = new IEditorReference[size];
        int i2 = 0;
        while (i2 < size) {
            references[i2] = (IEditorReference)closeEditorRefs.get(i2);
            ++i2;
        }
        workbenchPage.closeEditors(references, false);
    }

    public static VariabilityElement getBaseActivity(Activity activity) {
        while (!activity.getVariabilityType().equals((Object)VariabilityType.NA)) {
            VariabilityElement ve = activity.getVariabilityBasedOnElement();
            if (ve == null || !(ve instanceof Activity)) break;
            activity = (Activity)ve;
        }
        return activity;
    }

    public static void closeDiagramEditors(Object closeElement, List closeEditorRefs) {
        closeEditorRefs = new ArrayList<IEditorReference>();
        IWorkbenchPage workbenchPage = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
        int i = 0;
        while (i < editorReferences.length) {
            IEditorReference reference = editorReferences[i];
            IEditorPart editor = reference.getEditor(true);
            if (editor != null) {
                DiagramEditorInput diagramInput;
                IEditorInput input = editor.getEditorInput();
                Object element = null;
                if (input instanceof BreakdownElementEditorInput) {
                    BreakdownElementEditorInput binput = (BreakdownElementEditorInput)input;
                    if (binput.getWrapper() != null) {
                        Object parent;
                        element = binput.getWrapper();
                        if (element instanceof BreakdownElementWrapperItemProvider && (parent = ((BreakdownElementWrapperItemProvider)element).getParent(element)) instanceof BreakdownElementWrapperItemProvider && element.equals(closeElement)) {
                            UIHelper.closeDiagramEditors(parent, closeEditorRefs);
                        }
                    } else {
                        element = binput.getMethodElement();
                    }
                } else if (input instanceof DiagramEditorInputProxy && (diagramInput = ((DiagramEditorInputProxy)input).getDiagramEditorInput()) != null) {
                    element = diagramInput.getMethodElement();
                }
                if (element != null) {
                    if (element.equals(closeElement)) {
                        closeEditorRefs.add(reference);
                    } else if (closeElement instanceof Activity) {
                        ArrayList collection = new ArrayList();
                        ProcessUtil.getChildElements((Activity)((Activity)closeElement), Activity.class, collection);
                        if (collection.contains(element)) {
                            closeEditorRefs.add(reference);
                        }
                    }
                }
            }
            ++i;
        }
        int size = closeEditorRefs.size();
        IEditorReference[] references = new IEditorReference[size];
        int i2 = 0;
        while (i2 < size) {
            references[i2] = (IEditorReference)closeEditorRefs.get(i2);
            ++i2;
        }
        workbenchPage.closeEditors(references, false);
        references = null;
    }

    public static void syncDiagramEditors(Object object) {
        ArrayList<IEditorReference> closeEditors = new ArrayList<IEditorReference>();
        ArrayList<IEditorReference> refreshEditors = new ArrayList<IEditorReference>();
        IWorkbenchPage workbenchPage = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
        int i = 0;
        while (i < editorReferences.length) {
            IEditorReference reference = editorReferences[i];
            IEditorPart editor = reference.getEditor(true);
            if (editor != null) {
                DiagramEditorInput diagramInput;
                IEditorInput input = editor.getEditorInput();
                Object editorElement = null;
                if (input instanceof BreakdownElementEditorInput) {
                    BreakdownElementEditorInput binput = (BreakdownElementEditorInput)input;
                    editorElement = binput.getWrapper() != null ? binput.getWrapper() : binput.getMethodElement();
                } else if (input instanceof DiagramEditorInputProxy && (diagramInput = ((DiagramEditorInputProxy)input).getDiagramEditorInput()) != null) {
                    editorElement = diagramInput.getMethodElement();
                }
                if (editorElement != null) {
                    Collection c;
                    if (editorElement.equals(object)) {
                        closeEditors.add(reference);
                    } else if (editorElement instanceof Activity) {
                        if (((Activity)editorElement).getBreakdownElements().contains(object)) {
                            refreshEditors.add(reference);
                        } else if (object instanceof BreakdownElementWrapperItemProvider) {
                            Object local = object;
                            while (local instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)local).getOwner() != null) {
                                if (((BreakdownElementWrapperItemProvider)local).getOwner().equals(editorElement)) {
                                    refreshEditors.add(reference);
                                }
                                local = ((BreakdownElementWrapperItemProvider)local).getOwner();
                            }
                        }
                    } else if (editorElement instanceof BreakdownElementWrapperItemProvider && (c = ((BreakdownElementWrapperItemProvider)editorElement).getChildren(editorElement)) != null && c.contains(object)) {
                        refreshEditors.add(reference);
                    }
                }
            }
            ++i;
        }
        int size = closeEditors.size();
        IEditorReference[] references = new IEditorReference[size];
        int i2 = 0;
        while (i2 < size) {
            references[i2] = (IEditorReference)closeEditors.get(i2);
            ++i2;
        }
        workbenchPage.closeEditors(references, false);
        references = null;
        size = refreshEditors.size();
        i2 = 0;
        while (i2 < size) {
            IEditorReference reference = (IEditorReference)refreshEditors.get(i2);
            IEditorPart editor = reference.getEditor(true);
            if (editor instanceof AbstractDiagramEditor) {
                ((AbstractDiagramEditor)editor).refreshDiagram();
            }
            ++i2;
        }
    }

    public static void showProblemsView() {
        SafeUpdateController.asyncExec((Runnable)new Runnable(){

            public void run() {
                try {
                    IWorkbenchPage page;
                    IViewPart view;
                    if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null && (view = (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).findView("org.eclipse.ui.views.ProblemView")) == null) {
                        page.showView("org.eclipse.ui.views.ProblemView", null, 2);
                    }
                }
                catch (Exception e) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        });
    }

    public static boolean checkModify(Resource res, Shell shell) {
        return UIHelper.checkModify(Collections.singleton(res), shell);
    }

    public static boolean checkModify(Collection modifiedResources, Shell shell) {
        IStatus status;
        Display display;
        if (shell == null && (display = Display.getCurrent()) != null) {
            shell = display.getActiveShell();
        }
        if (!(status = UserInteractionHelper.checkModify((Collection)modifiedResources, (Object)shell)).isOK()) {
            UIHelper.handleError(status);
            return false;
        }
        return true;
    }

    private static void handleError(IStatus status) {
        AuthoringUIPlugin.getDefault().getMsgDialog().display(AuthoringUIResources.errorDialog_title, AuthoringUIResources.editDialog_msgCannotEdit, status);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ModifyChecker
    implements IModifyChecker {
        private Shell shell;

        public ModifyChecker(Shell shell) {
            this.shell = shell;
        }

        public boolean checkModify(Resource res) {
            return UIHelper.checkModify(res, this.shell);
        }

        public boolean checkModify(Collection<Resource> modifiedResources) {
            return UIHelper.checkModify(modifiedResources, this.shell);
        }
    }
}

