/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.library.edit.util.LibraryEditUtil;
import org.eclipse.epf.library.edit.validation.IValidationManager;
import org.eclipse.epf.library.validation.ValidationManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class ValidationMarkerResolutionGenerator
implements IMarkerResolutionGenerator {
    private static final IMarkerResolution[] EMPTY_RESOLUTIONS = new IMarkerResolution[0];

    private static boolean acceptedType(IMarker marker) {
        boolean ret = false;
        try {
            ret = "org.eclipse.epf.library.validation".equals(marker.getType());
            if (ret) {
                Object typeValue = marker.getAttribute("validationType");
                ret = "undeclaredDependancyCheck".equals(typeValue);
            }
        }
        catch (CoreException e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return ret;
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            if (ValidationMarkerResolutionGenerator.acceptedType(marker)) {
                return new IMarkerResolution[]{new AddPluginResolution(marker), new RemoveUndeclaredResolution(marker)};
            }
        }
        catch (Exception e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return EMPTY_RESOLUTIONS;
    }

    private static class AddPluginResolution
    extends ValidationMarkerResolution {
        public AddPluginResolution(IMarker currentMarker) {
            super(currentMarker);
        }

        public String getLabel() {
            return AuthoringUIResources.ValidationMarkerResolutionGenerator_0;
        }

        public void run(IMarker marker) {
            try {
                IValidationManager mgr = LibraryEditUtil.getInstance().getValidationManager();
                String msg = ((ValidationManager)mgr).UndeclaredDependencyCheckAddPluginFix(marker);
                if (msg != null && msg.length() > 0) {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(AuthoringUIResources.ValidationMarkerResolutionGenerator_0, msg);
                }
            }
            catch (Throwable e) {
                AuthoringUIPlugin.getDefault().getLogger().logError(e);
            }
        }
    }

    private static class RemoveUndeclaredResolution
    extends ValidationMarkerResolution {
        public RemoveUndeclaredResolution(IMarker currentMarker) {
            super(currentMarker);
        }

        public String getLabel() {
            return AuthoringUIResources.ValidationMarkerResolutionGenerator_1;
        }

        public void run(IMarker marker) {
            try {
                IValidationManager mgr = LibraryEditUtil.getInstance().getValidationManager();
                ((ValidationManager)mgr).UndeclaredDependencyCheckRemoveReferenceFix(marker);
            }
            catch (Throwable e) {
                AuthoringUIPlugin.getDefault().getLogger().logError(e);
            }
        }
    }

    public static abstract class ValidationMarkerResolution
    extends WorkbenchMarkerResolution {
        private IMarker currentMarker;

        public ValidationMarkerResolution(IMarker currentMarker) {
            this.currentMarker = currentMarker;
        }

        public IMarker[] findOtherMarkers(IMarker[] markers) {
            ArrayList similarMarkerList = new ArrayList();
            IMarker[] similarMarkers = new IMarker[similarMarkerList.size()];
            similarMarkerList.toArray(similarMarkers);
            return similarMarkers;
        }

        public String getDescription() {
            return null;
        }

        public Image getImage() {
            return null;
        }
    }
}

