/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.providers.ConfigPackageContentProvider;
import org.eclipse.epf.library.configuration.ConfigurationData;
import org.eclipse.epf.library.edit.navigator.ConfigContentPackageItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodContainerCheckedTreeViewer
extends ContainerCheckedTreeViewer {
    protected boolean expandWhenChecking = false;
    protected boolean initializingTreeCheckState = false;
    private ConfigurationData configData;
    private boolean disableHandleLeafCrayChecks = false;
    protected ListenerList childrenCheckStateListeners = new ListenerList();

    public MethodContainerCheckedTreeViewer(Composite parent) {
        super(parent);
        this.initViewer();
    }

    public MethodContainerCheckedTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.initViewer();
    }

    public MethodContainerCheckedTreeViewer(Tree tree) {
        super(tree);
        this.initViewer();
    }

    protected void initViewer() {
        this.setUseHashlookup(true);
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                MethodContainerCheckedTreeViewer.this.updateWrappers(event.getElement());
                MethodContainerCheckedTreeViewer.this.doCheckStateChanged(event.getElement());
            }
        });
        this.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Widget item = MethodContainerCheckedTreeViewer.this.findItem(event.getElement());
                if (item instanceof TreeItem) {
                    MethodContainerCheckedTreeViewer.this.initializeItem((TreeItem)item);
                }
            }
        });
    }

    protected void initializeItem(TreeItem item) {
        if (item.getChecked() && !item.getGrayed()) {
            this.updateChildrenItems(item);
        }
    }

    protected void updateChildrenItems(TreeItem parent) {
        Item[] children = this.getChildren((Widget)parent);
        boolean state = parent.getChecked();
        int i = 0;
        while (i < children.length) {
            TreeItem curr = (TreeItem)children[i];
            if (curr.getData() != null && (curr.getChecked() != state || curr.getGrayed())) {
                curr.setChecked(state);
                curr.setGrayed(false);
                this.notifyChildrenCheckStateListeners(new CheckStateChangedEvent((ICheckable)this, curr.getData(), state));
                this.updateChildrenItems(curr);
            }
            ++i;
        }
    }

    protected void doCheckStateChanged(Object element) {
        if (this.initializingTreeCheckState) {
            Widget item = this.findItem(element);
            if (item instanceof TreeItem) {
                TreeItem treeItem = (TreeItem)item;
                treeItem.setGrayed(false);
                this.updateParentItems(treeItem.getParentItem());
            }
        } else {
            super.doCheckStateChanged(element);
        }
    }

    private void handleLeafCrayChecks(Object element) {
        TreeItem treeItem;
        if (this.getConfigData() == null || this.disableHandleLeafCrayChecks) {
            return;
        }
        Widget item = this.findItem(element);
        TreeItem treeItem2 = treeItem = item instanceof TreeItem ? (TreeItem)item : null;
        if (treeItem == null) {
            return;
        }
        HashSet<ConfigContentPackageItemProvider.LeafElementsItemProvider> uncheckedLeafs = new HashSet<ConfigContentPackageItemProvider.LeafElementsItemProvider>();
        this.collectUncheckedLeafs(treeItem, uncheckedLeafs);
        this.handleLeafCrayChecks(uncheckedLeafs);
    }

    private void collectUncheckedLeafs(TreeItem treeItem, Set<ConfigContentPackageItemProvider.LeafElementsItemProvider> uncheckedLeafs) {
        if (treeItem.getData() instanceof ConfigContentPackageItemProvider.LeafElementsItemProvider) {
            if (!treeItem.getChecked()) {
                uncheckedLeafs.add((ConfigContentPackageItemProvider.LeafElementsItemProvider)treeItem.getData());
            }
            return;
        }
        Item[] children = this.getChildren((Widget)treeItem);
        int i = 0;
        while (i < children.length) {
            TreeItem curr = (TreeItem)children[i];
            this.collectUncheckedLeafs(curr, uncheckedLeafs);
            ++i;
        }
    }

    public void handleLeafCrayChecks(Collection<ConfigContentPackageItemProvider.LeafElementsItemProvider> uncheckedLeafs) {
        if (uncheckedLeafs == null || uncheckedLeafs.isEmpty()) {
            return;
        }
        HashSet<TreeItem> grayCheckedSet = new HashSet<TreeItem>();
        for (ConfigContentPackageItemProvider.LeafElementsItemProvider leaf : uncheckedLeafs) {
            Widget item;
            MethodPackage leafParent = leaf.getParentPackage();
            if (!this.getConfigData().hasAddedElements(leafParent) || !((item = this.findItem(leaf)) instanceof TreeItem)) continue;
            TreeItem treeItem = (TreeItem)item;
            while (treeItem != null) {
                if (!grayCheckedSet.contains(treeItem)) {
                    treeItem.setChecked(true);
                    treeItem.setGrayed(true);
                    grayCheckedSet.add(treeItem);
                }
                treeItem = treeItem.getParentItem();
            }
        }
    }

    public void updateParents(Object element) {
        Widget item = this.findItem(element);
        if (item instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)item;
            this.updateParentItems(treeItem.getParentItem());
        }
    }

    protected void updateParentItems(TreeItem item) {
        if (item != null) {
            Item[] children = this.getChildren((Widget)item);
            boolean containsChecked = false;
            boolean containsUnchecked = false;
            int i = 0;
            while (i < children.length) {
                TreeItem curr = (TreeItem)children[i];
                containsChecked |= curr.getChecked();
                containsUnchecked |= !curr.getChecked() || curr.getGrayed();
                ++i;
            }
            item.setChecked(containsChecked);
            item.setGrayed(containsChecked && containsUnchecked);
            if (this.expandWhenChecking && item.getChecked()) {
                item.setExpanded(true);
            }
            this.updateParentItems(item.getParentItem());
        }
    }

    private void updateWrappers(Object object) {
        Collection wrappers;
        boolean state = this.getChecked(object);
        Object element = TngUtil.unwrap((Object)object);
        if (object != element) {
            this.setChecked(element, state);
        }
        AdapterFactory adapterFactory = null;
        if (this.getContentProvider() instanceof AdapterFactoryContentProvider) {
            adapterFactory = ((AdapterFactoryContentProvider)this.getContentProvider()).getAdapterFactory();
        }
        if (adapterFactory != null && !(wrappers = TngUtil.getWrappers((AdapterFactory)adapterFactory, (Object)element)).isEmpty()) {
            for (Object wrapper : wrappers) {
                this.setChecked(wrapper, state);
            }
        }
    }

    public void setCheckedElements(Object[] elements) {
        ArrayList<Object> treeElements = new ArrayList<Object>();
        AdapterFactory adapterFactory = null;
        if (this.getContentProvider() instanceof AdapterFactoryContentProvider) {
            adapterFactory = ((AdapterFactoryContentProvider)this.getContentProvider()).getAdapterFactory();
        }
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (adapterFactory != null) {
                treeElements.addAll(TngUtil.getWrappers((AdapterFactory)adapterFactory, (Object)element));
            }
            if (!(element instanceof CustomCategory)) {
                treeElements.add(element);
            }
            ++i;
        }
        this.initializingTreeCheckState = true;
        super.setCheckedElements(treeElements.toArray());
        this.initializingTreeCheckState = false;
    }

    public Object[] getTopCheckedElements() {
        ArrayList v = new ArrayList();
        Control tree = this.getControl();
        this.internalCollectTopChecked(v, (Widget)tree);
        return v.toArray();
    }

    private void internalCollectTopChecked(List result, Widget widget) {
        Item[] items = this.getChildren(widget);
        int i = 0;
        while (i < items.length) {
            Object data;
            Item item = items[i];
            if (item instanceof TreeItem && ((TreeItem)item).getChecked() && !((TreeItem)item).getGrayed() && (data = item.getData()) != null) {
                result.add(data);
            }
            if (item instanceof TreeItem && (!((TreeItem)item).getChecked() || ((TreeItem)item).getGrayed())) {
                this.internalCollectTopChecked(result, (Widget)item);
            }
            ++i;
        }
    }

    public boolean isExpandWhenChecking() {
        return this.expandWhenChecking;
    }

    public void setExpandWhenChecking(boolean expandWhenChecking) {
        this.expandWhenChecking = expandWhenChecking;
    }

    public void addChildrenCheckStateListener(ICheckStateListener listener) {
        this.childrenCheckStateListeners.add((Object)listener);
    }

    public void removeChildrenCheckStateListener(ICheckStateListener listener) {
        this.childrenCheckStateListeners.remove((Object)listener);
    }

    protected void notifyChildrenCheckStateListeners(final CheckStateChangedEvent event) {
        Object[] objectArray = this.childrenCheckStateListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    ((ICheckStateListener)listener).checkStateChanged(event);
                }
            });
            ++n2;
        }
    }

    public Set<MethodPackage> getElementsUnslectedPkgs(Collection<MethodPackage> pkgsInConfig, ConfigPackageContentProvider provider) {
        HashSet<MethodPackage> elementsUnslectedPkgs = new HashSet<MethodPackage>();
        for (MethodPackage pkg : pkgsInConfig) {
            TreeItem treeItem;
            ConfigContentPackageItemProvider.LeafElementsItemProvider leaf;
            Widget item;
            if (!(pkg instanceof ContentPackage) || !((item = this.findItem(leaf = provider.getLeafElementsNode(pkg))) instanceof TreeItem) || (treeItem = (TreeItem)item).getChecked() && !treeItem.getGrayed()) continue;
            elementsUnslectedPkgs.add((MethodPackage)((ContentPackage)pkg));
        }
        return elementsUnslectedPkgs;
    }

    public void debugDump(Collection items, String msg) {
        System.out.println("LD> msg : " + msg);
        for (Object item : items) {
            System.out.println("LD> item : " + item);
            System.out.println("LD> found: " + this.findItem(item));
        }
        System.out.println("");
    }

    public ConfigurationData getConfigData() {
        return this.configData;
    }

    public void setConfigData(ConfigurationData configData) {
        this.configData = configData;
    }

    public boolean setChecked(Object element, boolean state) {
        try {
            this.disableHandleLeafCrayChecks = true;
            boolean bl = super.setChecked(element, state);
            return bl;
        }
        finally {
            this.disableHandleLeafCrayChecks = false;
        }
    }

    public void debugTree() {
        Object root = this.getRoot();
        Tree tree = (Tree)this.findItem(root);
        this.debugItem(tree.getItem(0), "LD>");
    }

    private void debugItem(Object objItem, String indent) {
        if (objItem instanceof TreeItem) {
            TreeItem item = (TreeItem)objItem;
            System.out.println(String.valueOf(indent) + "item : " + item + ", hash: " + item.hashCode());
            System.out.println(String.valueOf(indent) + "data : " + item.getData());
            System.out.println("");
            TreeItem[] treeItemArray = item.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem cItem = treeItemArray[n2];
                this.debugItem(cItem, String.valueOf(indent) + "     ");
                ++n2;
            }
        } else {
            System.out.println(String.valueOf(indent) + "objItem : " + objItem);
            System.out.println("");
        }
    }
}

